<?php
error_reporting(E_ALL ^ E_NOTICE);
define('ENGINE_DIR', dirname (__FILE__));
define('DATALIFEENGINE', true);

@session_start();

if(file_exists(ENGINE_DIR.'/classes/mysql.php'))
	require ENGINE_DIR.'/classes/mysql.php';
else require ENGINE_DIR.'/inc/mysql.php';

require_once ENGINE_DIR.'/data/dbconfig.php';
require_once ENGINE_DIR.'/data/config.php';
require_once ENGINE_DIR.'/data/dlelinks.php';
require_once ENGINE_DIR.'/classes/templates.class.php';
require_once ENGINE_DIR.'/classes/dlelinks.class.php';
require_once ENGINE_DIR.'/modules/functions.php';
require_once ENGINE_DIR.'/../language/'.$config['langs'].'/dlelinks.lng';
require_once ENGINE_DIR.'/../language/'.$config['langs'].'/website.lng';

$tpl = new dle_template();
$tpl->dir = ENGINE_DIR.'/inc/dlelinks';

function msg($title, $text)
{
	global $tpl;
	$tpl->load_template('info.tpl');
	$tpl->set('{title}', $title);
	$tpl->set('{text}',  $text);
	$tpl->compile('info');
	$tpl->clear();
	echo $tpl->result['info'];
	exit();
}

$act  = isset($_REQUEST['action']) ? $_REQUEST['action'] : false;
$type = ((isset($_REQUEST['type']) && ($_REQUEST['type'] == 'friends' || $_REQUEST['type'] == 'top')) ? $_REQUEST['type'] : msg($dl_lang['err_title'], $dl_lang['err_13']));
$check = $db->super_query('SELECT COUNT(*) as count FROM `'.PREFIX.'_dlelinks_'.$type.'` WHERE `confirm`=\'1\'');

$dlelinks_class = new dlelinks();

if($act == 'doadd' && $dlelinks[$type]['stop'] == false && $check['count'] < $dlelinks[$type]['max'])
{
	if($_POST['sitename'] == '' || $_POST['url'] == '')
	{
		msg($dl_lang['err_title'], $dl_lang['err_1'].'<br /><br /><a href="javascript:history.go(-1)">'.$lang['all_prev'].'</a>');
	}
	elseif($dlelinks['contacts'] == true && ($_POST['admin_name'] == '' || $_POST['admin_email'] == ''))
	{
		msg($dl_lang['err_title'], $dl_lang['err_5'].'<br /><br /><a href="javascript:history.go(-1)">'.$lang['all_prev'].'</a>');
	}
	elseif($_POST['sec_code'] != $_SESSION['sec_code_session'] OR !$_SESSION['sec_code_session'])
	{
		msg($dl_lang['err_title'], $dl_lang['err_4'].'<br /><br /><a href="javascript:history.go(-1)">'.$lang['all_prev'].'</a>');
	}
	elseif(strlen($_POST['sitename']) > $dlelinks['maxlength_title'])
	{
		msg($dl_lang['err_title'], $dl_lang['err_2'].'<br /><br /><a href="javascript:history.go(-1)">'.$lang['all_prev'].'</a>');
	}
	elseif(strlen($_POST['descr']) > $dlelinks['maxlength_descr'])
	{
		msg($dl_lang['err_title'], $dl_lang['err_3'].'<br /><br /><a href="javascript:history.go(-1)">'.$lang['all_prev'].'</a>');
	}
	else
	{
		$site['url'] = $_POST['url'];
		$site['sitename']  = htmlspecialchars($_POST['sitename']);
		$site['descr']     = htmlspecialchars($_POST['descr']);
		$site['added']     = time();
		$site['user_code'] = ((isset($_POST['user_code']) && $_POST['user_code'] != '') ? base64_encode(stripslashes($_POST['user_code'])) : false);
		$site['admin']['name']  = ($dlelinks['contacts'] == true && $_POST['admin_name'] != '') ? htmlspecialchars($_POST['admin_name']) : false;
		$site['admin']['email'] = ($dlelinks['contacts'] == true && $_POST['admin_email'] != '') ? $_POST['admin_email'] : false;
		$site['admin']['icq']   = ($dlelinks['contacts'] == true && $_POST['admin_icq'] != '') ? intval(str_replace('-', '', $_POST['admin_icq'])) : false;

		$errors = array();
		$confirm = '0';

		$status = $dlelinks_class->check_url($site['url']);
		if($status == false OR $status == true) {
			if($status == false) {
				$errors[] = $dl_lang['err_6'];
			}
		} else {
			$errors[] = ($status != '' ? $status : 'URL: '.$dl_lang['unerr']);
		}

		if($site['admin']['email'] != false) {
			$status = $dlelinks_class->check_email($site['admin']['email']);
			if($status == true OR $status == false) {
				if($status == false) {
					$errors[] = $dl_lang['err_7'];
				}
			} else {
				$errors[] = ($status != '' ? $status : 'Email: '.$dl_lang['unerr']);
			}
		}


		if($site['admin']['icq'] != false) {
			$status = $dlelinks_class->check_icq($site['admin']['icq']);
			if($status == false OR $status == true) {
				if($status == false){
					$errors[] = $dl_lang['err_8'];
				}
			} else {
				$errors[] = $status != '' ? $status : 'ICQ: '.$dl_lang['unerr'];
			}
		}

		if($dlelinks['check_code'] == true && $_POST['later'] != 'yes' && !sizeof($errors))
		{
			$status = $dlelinks_class->check_code($site['url'], stripslashes(base64_decode($dlelinks['code'])));
			if($status === true || $status === false) {
				if($status == false) {
					$errors[] = $dl_lang['err_9'];
				} else {
					$confirm = '1';
				}
			} else {
				$errors[] = ($status != '' ? $status : $dl_lang['err_check_code'].': '.$dl_lang['unerr']);
			}
		}

		if(sizeof($errors) > 0)
		{
			msg($dl_lang['err_title'], join('<br />', $errors).'<br /><br /><a href="javascript:history.go(-1)">'.$lang['all_prev'].'</a>');
		}
		else
		{
			$names = '`url`, `sitename`, `added`, `confirm`';
			$vals  = "'{$site['url']}', '{$site['sitename']}', '{$site['added']}', '$confirm'";

			if($site['descr']) {
				$names .= ', `descr`';
				$vals  .= ", '{$site['descr']}'";
			}
			if($type == 'friends' && $site['user_code']) {
				$names .= ', `user_code`';
				$vals  .= ", '{$site['user_code']}'";
			}
			if($site['admin']['email']) {
				$names .= ', `admin_email`';
				$vals  .= ", '{$site['admin']['email']}'";
			}
			if($site['admin']['name']) {
				$names .= ', `admin_name`';
				$vals  .= ", '{$site['admin']['name']}'";
			}
			if($site['admin']['icq'] != '') {
				$names .= ', `admin_icq`';
				$vals  .= ", '{$site['admin']['icq']}'";
			}
			if($type == 'friends') {
				$sort = $db->super_query("SELECT MAX(sort) as max FROM `".PREFIX."_dlelinks_friends`");
				$sort['max'] = $sort['max']+1;
				$names .= ', `sort`';
				$vals  .= ", '$sort[max]'";
			}

			$db->query("INSERT INTO `".PREFIX."_dlelinks_$type` ($names) VALUES ($vals)");

			if($dlelinks['mail'])
			{
				require_once ENGINE_DIR.'/../language/'.$config['langs'].'/dlelinks_mail.lng';
				$message = str_replace('{sitename}', $site['sitename'], $message);
				$message = str_replace('{url}', $site['url'], $message);
				$message = str_replace('{descr}', $site['descr'], $message);
				$message = str_replace('{date}', date('d.m.Y H:i', $site['added']), $message);
				$message = str_replace('{result}', ($confirm == '1' ? $result_ok : $result_wait), $message);

				include_once ENGINE_DIR.'/classes/mail.class.php';
				$mail = new dle_mail($config);
				$mail->send($config['admin_mail'], $theme, $message);
			}

			clear_cache('dlelinks_'.$type);
			if($confirm == '1')
			{
				msg($dl_lang['title_info'], $dl_lang['link_added']);
			}
			else
			{
				msg($dl_lang['title_info'], str_replace('{code}', htmlspecialchars(base64_decode($dlelinks['code'])), $dl_lang['link_added_2']));
			}
		}

	}

} else {

	if($check['count'] < $dlelinks[$type]['max'] && $dlelinks[$type]['stop'] == false) {

		$path = parse_url($config['http_home_url']);
		$tpl->load_template('addform.tpl');
		$tpl->set('{type}', $type);
		$tpl->set('{maxlength_title}', $dlelinks['maxlength_title']);
		$tpl->set('{maxlength_descr}', $dlelinks['maxlength_descr']);
		$tpl->set('{code}', htmlspecialchars(base64_decode($dlelinks['code'])));
		$tpl->set('{sec_image}', $lang['sec_image']);
		$tpl->set('{reload_code}', $lang['reload_code']);
		$tpl->set('{sec_code}',"<span id=\"dle-captcha\"><img src=\"/engine/modules/antibot.php\" alt=\"$lang[sec_image]\" border=\"0\"><br /><a onclick=\"reload(); return false;\" href=\"#\"><div class=\"text\">$lang[reload_code]</div></a></span>");


		if($dlelinks['contacts'] == true) {
			$tpl->set('[contacts]',"");
			$tpl->set('[/contacts]',"");
		} else {
			$tpl->set_block("'\\[contacts\\](.*?)\\[/contacts\\]'si","");
		}

		if($type == 'friends' AND $dlelinks['friends']['user_code'] == true) {
			$tpl->set('[user_code]',"");
			$tpl->set('[/user_code]',"");
		} else {
			$tpl->set_block("'\\[user_code\\](.*?)\\[/user_code\\]'si","");
		}

		if($dlelinks['check_code'] == true) {
			$tpl->set('[check_code]',"");
			$tpl->set('[/check_code]',"");
		} else {
			$tpl->set_block("'\\[check_code\\](.*?)\\[/check_code\\]'si","");
		}

		$tpl->compile('dlelinks');
		echo $tpl->result['dlelinks'];
	}
	else
	{
  		msg($dl_lang['err_title'], $dl_lang['stoped']);
	}

}
?>