<?php
/**
*
* acp_board [Russian]
*
* @package language
* @version $Id: board.php 9037 2008-10-26 10:52:43Z acydburn $
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
exit;
}

if (empty($lang) || !is_array($lang))
{
$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Board Settings
$lang = array_merge($lang, array(
	'ACP_BOARD_SETTINGS_EXPLAIN'		=> 'Здесь Вы можете устанавливать основные настройки форума, от имени сайта и регистрации пользователей до личных сообщений.',
	'CUSTOM_DATEFORMAT'					=> 'Другой…',
	'DEFAULT_DATE_FORMAT'				=> 'Формат даты',
	'DEFAULT_DATE_FORMAT_EXPLAIN'		=> 'Совпадает с форматом даты функции <code>date</code> языка PHP.',
	'DEFAULT_LANGUAGE'					=> 'Язык по умолчанию',
	'DEFAULT_STYLE'						=> 'Стиль по умолчанию',
	'DISABLE_BOARD'						=> 'Отключить форум',
	'DISABLE_BOARD_EXPLAIN'				=> 'Форум станет недоступен для пользователей. Вы также можете ввести короткое (до 255 сомволов) сообщение для посетителей.',
	'OVERRIDE_STYLE'					=> 'Заменять стиль пользователя',
	'OVERRIDE_STYLE_EXPLAIN'			=> 'Стиль, выбранный пользователем, будет заменен на стиль по умолчанию.',
	'SITE_DESC'							=> 'Описание сайта',
	'SITE_NAME'							=> 'Имя сайта',
	'SYSTEM_DST'						=> 'Сейчас действует летнее время (<abbr title="Летнее время">DST</abbr>)',
	'SYSTEM_TIMEZONE'					=> 'Часовой пояс форума',
	'WARNINGS_EXPIRE'					=> 'Длительность предупреждения',
	'WARNINGS_EXPIRE_EXPLAIN'			=> 'Количество дней, которое должно пройти до того, как предупреждение будет автоматически снято с пользователя',
));

// Board Features
$lang = array_merge($lang, array(
	'ACP_BOARD_FEATURES_EXPLAIN'		=> 'Здесь Вы можете включать и выключать некоторые функции форума',

	'ALLOW_ATTACHMENTS'				=> 'Разрешить вложения',
	'ALLOW_BIRTHDAYS'				=> 'Разрешить дни рождения',
	'ALLOW_BIRTHDAYS_EXPLAIN'		=> 'Разрешить указывать дни рождения и отображения возраста в профиле. Учтите, что список дней рождения на странице списка форумов включается отдельно в настройках нагрузки на сервер.',
	'ALLOW_BOOKMARKS'				=> 'Разрешить закладки',
	'ALLOW_BOOKMARKS_EXPLAIN'		=> 'Пользователь сможет сохранять персональные закладки',
	'ALLOW_BBCODE'					=> 'Разрешить BBCode',
	'ALLOW_FORUM_NOTIFY'			=> 'Разрешить подписку на форумы',
	'ALLOW_NAME_CHANGE'				=> 'Разрешить смену имени пользователя',
	'ALLOW_NO_CENSORS'				=> 'Разрешить отключение автоцензора',
	'ALLOW_NO_CENSORS_EXPLAIN'		=> 'Пользователи смогут по выбору отключать автоцензор в обычных и личных сообщениях.',
	'ALLOW_PM_ATTACHMENTS'			=> 'Разрешить вложения в личных сообщениях',
	'ALLOW_PM_REPORT'				=> 'Разрешить пользователям подавать жалобы на личные сообщения',
	'ALLOW_PM_REPORT_EXPLAIN'		=> 'Если данная функция включена, пользователи получат возможность отправлять модераторам жалобы на личные сообщения. Эти личные сообщения будут отображаться в Центре модератора.',
	'ALLOW_QUICK_REPLY'				=> 'Включить быстрый ответ',
	'ALLOW_QUICK_REPLY_EXPLAIN'		=> 'Данная настройка позволяет включать/выключать функцию быстрого ответа для всего форума. При включении данной функции необходимо также активировать быстрый ответ в настройках каждого конкретного форума.',
	'ALLOW_QUICK_REPLY_BUTTON'		=> 'Включить функцию быстрого ответа на всех форумах',
	'ALLOW_SIG'						=> 'Разрешить подписи',
	'ALLOW_SIG_BBCODE'				=> 'Разрешить BBCode в подписях пользователей',
	'ALLOW_SIG_FLASH'				=> 'Разрешить использование тега BBCode <code>[FLASH]</code> в подписях пользователей',
	'ALLOW_SIG_IMG'					=> 'Разрешить использование тега BBCode <code>[IMG]</code> в подписях пользователей',
	'ALLOW_SIG_LINKS'				=> 'Разрешить ссылки в подписях пользователей',
	'ALLOW_SIG_LINKS_EXPLAIN'		=> 'В случае запрета тег BBCode <code>[URL]</code> и автоматическое преобразование текста в ссылки будут отключены.',
	'ALLOW_SIG_SMILIES'				=> 'Разрешить смайлики в подписях пользователей',
	'ALLOW_SMILIES'					=> 'Разрешить смайлики',
	'ALLOW_TOPIC_NOTIFY'			=> 'Разрешить подписку на темы',
	'BOARD_PM'						=> 'Личные сообщения',
	'BOARD_PM_EXPLAIN'				=> 'Включение или отключение личных сообщений для всех пользователей.',
));

// Avatar Settings
$lang = array_merge($lang, array(
	'ACP_AVATAR_SETTINGS_EXPLAIN'		=> 'Аватары - это небольшие индивидуальные изображения, которые пользователи могут ассоциировать со своими аккаунтами. В зависимости от выбранного стиля, аватары обычно отображаются под именем пользователя при просмотре тем. Здесь Вы можете настроить применение аватар пользователями. Пожалуйста, учтите, что для загрузки аватар необходимо создать папку, имя которой задается ниже, и удостовериться в том, что web-сервер имеет права на запись в эту папку. Учтите также, что ограничение на размер файлов накладываются только на загружаемые на сервер аватары, и не распространяются на удаленные изображения.',
	'ALLOW_AVATARS'						=> 'Разрешить использование аватаров',
	'ALLOW_AVATARS_EXPLAIN'				=> 'Глобальное управление аватарами на форуме;<br />Если Вы запретите использование аватаров, они не будут отображаться на форуме, но пользователи смогут загружать аватары в Центре пользователя.',

	'ALLOW_LOCAL'						=> 'Разрешить галерею аватаров',
	'ALLOW_REMOTE'						=> 'Разрешить удаленные аватары',
	'ALLOW_REMOTE_EXPLAIN'				=> 'Ссылки на аватары, находящиеся на других сайтах',
	'ALLOW_REMOTE_UPLOAD'			=> 'Разрешить удаленную загрузку аватаров',
	'ALLOW_REMOTE_UPLOAD_EXPLAIN'	=> 'Разрешает загрузку аватар с другого сайта.',
	'ALLOW_UPLOAD'						=> 'Разрешить загрузку аватаров',
	'AVATAR_GALLERY_PATH'				=> 'Путь к галерее аватаров',
	'AVATAR_GALLERY_PATH_EXPLAIN'		=> 'Путь относительно корневой папки phpBB для предустановленных изображений, например <samp>images/avatars/gallery</samp>',
	'AVATAR_STORAGE_PATH'				=> 'Путь к аватарам',
	'AVATAR_STORAGE_PATH_EXPLAIN'		=> 'Путь относительно корневой папки phpBB, например  <samp>images/avatars/upload</samp>',
	'MAX_AVATAR_SIZE'					=> 'Максимальные размеры аватара',
	'MAX_AVATAR_SIZE_EXPLAIN'			=> '(высота x ширина в пикселах)',
	'MAX_FILESIZE'						=> 'Максимальный размер файла аватар',
	'MAX_FILESIZE_EXPLAIN'				=> 'Для загружаемых файлов аватар',
	'MIN_AVATAR_SIZE'					=> 'Минимальные размеры аватар',
	'MIN_AVATAR_SIZE_EXPLAIN'			=> '(высота x ширина в пикселах)',
));

// Message Settings
$lang = array_merge($lang, array(
	'ACP_MESSAGE_SETTINGS_EXPLAIN'			=> 'Здесь Вы можете задать все настройки по умолчанию для личных сообщений (ЛС)',

	'ALLOW_BBCODE_PM'				=> 'Разрешить BBCode в ЛС',
	'ALLOW_FLASH_PM'				=> 'Разрешить тег BBCode <code>[FLASH]</code>',
	'ALLOW_FLASH_PM_EXPLAIN'		=> 'Учтите, что возможность использования flash, если она включена здесь, зависит также от установленных прав доступа.',
	'ALLOW_FORWARD_PM'				=> 'Разрешить пересылку ЛС',
	'ALLOW_IMG_PM'					=> 'Разрешить тег BBCode <code>[IMG]</code>',
	'ALLOW_MASS_PM'					=> 'Разрешить отправку ЛС нескольким пользователям или группам пользователей',
	'ALLOW_MASS_PM_EXPLAIN'			=> 'Рассылкой сообщений для групп могут пользоваться группы. Она настраивается на странице настройки параметров группы.',
	'ALLOW_PRINT_PM'				=> 'Разрешить печатный вид в ЛС',
	'ALLOW_QUOTE_PM'				=> 'Разрешить цитаты в ЛС',
	'ALLOW_SIG_PM'					=> 'Разрешить подписи в ЛС',
	'ALLOW_SMILIES_PM'				=> 'Разрешить смайлики в ЛС',
	'BOXES_LIMIT'					=> 'Максимальное количество ЛС в папке',
	'BOXES_LIMIT_EXPLAIN'			=> 'Пользователи не смогут сохранять больше, чем указанное количество сообщений, в каждой из папок для ЛС. Установите 0 для снятия ограничений.',
	'BOXES_MAX'						=> 'Максимальное количество папок для ЛС',
	'BOXES_MAX_EXPLAIN'				=> 'По умолчанию пользователи не смогут создавать больше указанного количества папок для ЛС.',
	'ENABLE_PM_ICONS'				=> 'Разрешить использование значков тем в ЛС',
	'FULL_FOLDER_ACTION'			=> 'Операция по умолчанию для переполненной папки',
	'FULL_FOLDER_ACTION_EXPLAIN'=> 'Операция по умолчанию, выполняемое для переполненной папки пользователя, в случае, если выбранная пользователем операция для папки неприменимо. Единственным исключением является папка «Отправленные», для которой операцией по умолчанию всегда является удаление старых сообщений.',
	'HOLD_NEW_MESSAGES'				=> 'Отложить новые сообщения',
	'PM_EDIT_TIME'					=> 'Ограничить время редактирования',
	'PM_EDIT_TIME_EXPLAIN'			=> 'Ограничить время, в течение которого доступно редактирование отправленного, но еще не полученного адресатом личного сообщения. Установите 0 для снятия ограничений.',
	'PM_MAX_RECIPIENTS'				=> 'Максимальное разрешенное количество получателей',
	'PM_MAX_RECIPIENTS_EXPLAIN'		=> 'Максимальное разрешенное количество получателей личного сообщения. Если использовать "0", их число будет неограничено. Это ограничение может устанавливаться для каждой группы на странице настройки параметров группы.',
));

// Post Settings
$lang = array_merge($lang, array(
	'ACP_POST_SETTINGS_EXPLAIN'				=> 'Здесь Вы можете задать все настройки по умолчанию для сообщений',
	'ALLOW_POST_LINKS'						=> 'Разрешить ссылки в обычных/личных сообщениях',
	'ALLOW_POST_LINKS_EXPLAIN'				=> 'В случае запрета тег BBCode <code>[URL]</code> и автоматическое преобразование текста в ссылки будут отключены.',
	'ALLOW_POST_FLASH'						=> 'Разрешить тег BBCode <code>[FLASH]</code> в сообщениях. ',
	'ALLOW_POST_FLASH_EXPLAIN'				=> 'Если тег BBCode <code>[FLASH]</code> запрещен, он будет отключен в сообщениях. Определить пользователей, имеющих право использовать тег BBCode <code>[FLASH]</code>, можно с помощью системы управления правами доступа.',


	'BUMP_INTERVAL'						=> 'Задержка поднятия темы',
	'BUMP_INTERVAL_EXPLAIN'				=> 'Количество минут, часов или дней с последнего сообщения, по прошествию которых можно поднимать тему. Введите 0 для отключения данной функции.',
	'CHAR_LIMIT'						=> 'Максимальное количество символов в сообщении',
	'CHAR_LIMIT_EXPLAIN'				=> 'Количество символов, разрешенное в сообщении. Установите 0 для снятия ограничений.',
	'DELETE_TIME'						=> 'Ограничение времени на удаление',
	'DELETE_TIME_EXPLAIN'				=> 'Ограничение периода времени, втечение которого доступно удаление новых сообщений. Введите 0 для снятия этого ограничения.',
	'DISPLAY_LAST_EDITED'				=> 'Отображать сведения о последнем редактировании',
	'DISPLAY_LAST_EDITED_EXPLAIN'		=> 'Выберите для отображения информации о последнем редактировании сообщения',
	'EDIT_TIME'							=> 'Ограничить время редактирования',
	'EDIT_TIME_EXPLAIN'					=> 'Ограничить время, в течение которого доступно редактирование нового сообщения. Установите 0 для отключения этой функции.',
	'FLOOD_INTERVAL'					=> 'Задержка флуда',
	'FLOOD_INTERVAL_EXPLAIN'			=> 'Количество секунд, которое должно пройти между двумя сообщениями пользователя. Чтобы разрешить пользователям игнорировать это ограничение, установите им соответствующие права.',
	'HOT_THRESHOLD'						=> 'Сообщений в популярной теме',
	'HOT_THRESHOLD_EXPLAIN'				=> 'Необходимое количество сообщений в теме для того, чтобы она приобрела статус популярной. Установите 0 для отключения популярных тем.',
	'MAX_POLL_OPTIONS'					=> 'Максимальное количество вариантов ответа в голосованиях',
	'MAX_POST_FONT_SIZE'				=> 'Максимальный размер шрифта в сообщении',
	'MAX_POST_FONT_SIZE_EXPLAIN'		=> 'Максимальный размер шрифта, разрешенный в сообщении. Установите 0 для снятия ограничений.',
	'MAX_POST_IMG_HEIGHT'				=> 'Максимальная высота изображения в сообщении',
	'MAX_POST_IMG_HEIGHT_EXPLAIN'		=> 'Максимальная высота изображений/flash в сообщениях. Установите 0 для снятия ограничений.',
	'MAX_POST_IMG_WIDTH'				=> 'Максимальная ширина изображения в сообщении',
	'MAX_POST_IMG_WIDTH_EXPLAIN'		=> 'Максимальная ширина изображений/flash в сообщениях. Установите 0 для снятия ограничений.',
	'MAX_POST_URLS'						=> 'Максимальное количество ссылок в сообщении',
	'MAX_POST_URLS_EXPLAIN'				=> 'Максимальное количесво ссылок URL в сообщении. Установите 0 для снятия ограничений.',
	'MIN_CHAR_LIMIT'					=> 'Минимальное количество символов в сообщении.',
	'MIN_CHAR_LIMIT_EXPLAIN'			=> 'Минимальное количество символов, которые должен ввести пользователь в тексте, чтобы написать сообщение в теме, или отправить ЛС.',
	'POSTING'							=> 'Сообщений',
	'POSTS_PER_PAGE'					=> 'Сообщений на страницу',
	'QUOTE_DEPTH_LIMIT'					=> 'Максимальное количество вложенных цитат в сообщении',
	'QUOTE_DEPTH_LIMIT_EXPLAIN'			=> 'Максимальное количество вложенных цитат в сообщении. Установите 0 для снятия ограничений.',
	'SMILIES_LIMIT'						=> 'Максимальное количество смайликов в сообщении',
	'SMILIES_LIMIT_EXPLAIN'				=> 'Максимальное количество смайликов в сообщении. Установите 0 для снятия ограничений.',
	'SMILIES_PER_PAGE'					=> 'Смайликов на странице',
	'TOPICS_PER_PAGE'					=> 'Тем на страницу',
));

// Signature Settings
$lang = array_merge($lang, array(
	'ACP_SIGNATURE_SETTINGS_EXPLAIN'		=> 'Здесь Вы можете задать все настройки по умолчанию для подписей',

	'MAX_SIG_FONT_SIZE'					=> 'Максимальный размер шрифта в подписи',
	'MAX_SIG_FONT_SIZE_EXPLAIN'			=> 'Максимальный размер шрифта, разрешенный в подписях пользователей. Установите 0 для снятия ограничений',
	'MAX_SIG_IMG_HEIGHT'				=> 'Максимальная высота изображения в подписи',
	'MAX_SIG_IMG_HEIGHT_EXPLAIN'		=> 'Максимальная высота изображения/flash в подписях пользователей. Установите 0 для снятия ограничений.',
	'MAX_SIG_IMG_WIDTH'					=> 'Максимальная ширина изображения в подписи',
	'MAX_SIG_IMG_WIDTH_EXPLAIN'			=> 'Максимальная ширина изображения/flash в подписях пользователей. Установите 0 для снятия ограничений.',
	'MAX_SIG_LENGTH'					=> 'Максимальная длина подписи',
	'MAX_SIG_LENGTH_EXPLAIN'			=> 'Максимальное количество символов в подписях пользователей.',
	'MAX_SIG_SMILIES'					=> 'Максимум смайликов в подписи',
	'MAX_SIG_SMILIES_EXPLAIN'			=> 'Максимальное количество смайликов, разрешенное в подписях пользователей. Установите 0 для снятия ограничений.',
	'MAX_SIG_URLS'						=> 'Максимум ссылок в подписи',
	'MAX_SIG_URLS_EXPLAIN'				=> 'Максимальное количество ссылок в подписях пользователей. Установите 0 для снятия ограничений.',
));

// Registration Settings
$lang = array_merge($lang, array(
	'ACP_REGISTER_SETTINGS_EXPLAIN'			=> 'Здесь Вы можете задать настройки, связанные с регистрацией и профилями пользователей',

	'ACC_ACTIVATION'				=> 'Активация аккаунта',
	'ACC_ACTIVATION_EXPLAIN'		=> 'Определить, должен ли пользователь получить немедленный доступ к форуму, или для этого требуется подтверждение регистрации. Вы можете также полностью отключить регистрацию новых пользователей.',
	'NEW_MEMBER_POST_LIMIT'			=> 'Лимит сообщений для нового пользователя',
	'NEW_MEMBER_POST_LIMIT_EXPLAIN'	=> 'Новые пользователи будут находиться в группе «Новые пользователи» до тех пор, пока они не опубликуют указанного здесь количества сообщений. Вы можете использовать эту группу, чтобы запретить новым пользователям отправку ЛС, или для предварительного просмотра их сообщений. <strong>Введите 0, если хотите отключить эту возможность</strong>.',
	'NEW_MEMBER_GROUP_DEFAULT'		=> 'Сделать группу «Новые пользователи» группой по умолчанию',
	'NEW_MEMBER_GROUP_DEFAULT_EXPLAIN'	=> 'При включении данной опции и при указании лимита сообщений все новые пользователи будут не только входить в группу «Новые пользователи», но эта группа также будет назначена им в качестве группы по умолчанию. Это может быть удобно, например, если Вы хотите использовать для этой группы определённое звание или аватар, которые будут применяться к новым пользователям.',
	'ACC_ADMIN'						=> 'Администратором',
	'ACC_DISABLE'					=> 'Отключено',
	'ACC_NONE'						=> 'Нет',
	'ACC_USER'						=> 'Пользователем',
//        'ACC_USER_ADMIN'				=> 'User + Admin',
	'ALLOW_EMAIL_REUSE'				=> 'Разрешить повторное использование e-mail адреса',
	'ALLOW_EMAIL_REUSE_EXPLAIN'		=> 'Разные пользователи смогут регистрироваться с одинаковым e-mail адресом.',
	'COPPA'							=> 'COPPA',
	'COPPA_FAX'						=> 'Номер факса для COPPA',
	'COPPA_MAIL'					=> 'Почтовый адрес для COPPA',
	'COPPA_MAIL_EXPLAIN'			=> 'Почтовый адрес, на который родители должны отправлять формы регистрации COPPA',
	'ENABLE_COPPA'					=> 'Включить COPPA',
	'ENABLE_COPPA_EXPLAIN'			=> 'От пользователя потребуется подтвердить, достиг ли он возраста 13 лет или старше, для соответствия требованиям U.S. COPPA Act. Если отключено, специальные группы COPPA больше не будут отображены.',
	'MAX_CHARS'						=> 'макс.',
	'MIN_CHARS'						=> 'мин.',
	'NO_AUTH_PLUGIN'				=> 'Не найдено подходящего модуля авторизации.',
	'PASSWORD_LENGTH'				=> 'Длина пароля',
	'PASSWORD_LENGTH_EXPLAIN'		=> 'Минимальное и максимальное количество символов в паролях.',
	'REG_LIMIT'						=> 'Попытки регистрации',
	'REG_LIMIT_EXPLAIN'				=> 'Количество попыток регистрации с кодом подтверждения, которое могут сделать пользователи в течение одной сессии.',
	'USERNAME_ALPHA_ONLY'			=> 'Только буквенно-цифровые',
	'USERNAME_ALPHA_SPACERS'		=> 'Буквенно-цифровые и разделители',
	'USERNAME_ASCII'				=> 'ASCII (без международного юникода)',
	'USERNAME_LETTER_NUM'			=> 'Любые буквы и цифры',
	'USERNAME_LETTER_NUM_SPACERS'		=> 'Любые буквы, цифры и разделители',
	'USERNAME_CHARS'				=> 'Ограничения на символы в имени пользователя',
	'USERNAME_CHARS_ANY'			=> 'Любые символы',
	'USERNAME_CHARS_EXPLAIN'		=> 'Символы, которые могут быть использованы в именах пользователей. Разделителями считаются символы пробела, -, +, _, [ и ]',
	'USERNAME_LENGTH'				=> 'Длина имени пользователя',
	'USERNAME_LENGTH_EXPLAIN'		=> 'Минимальное и максимальное количество символов в именах пользователей.',
));

// Feeds
$lang = array_merge($lang, array(
	'ACP_FEED_MANAGEMENT'				=> 'Общие параметры каналов новостей',
	'ACP_FEED_MANAGEMENT_EXPLAIN'		=> 'Данный модуль предназначен для предоставления различных каналов новостей в формате ATOM, преобразуя BBCode в сообщениях в читабельный для программ формат.',

	'ACP_FEED_GENERAL'					=> 'Настройки основных каналов новостей',
	'ACP_FEED_POST_BASED'				=> 'Настройки каналов новостей для сообщений',
	'ACP_FEED_TOPIC_BASED'				=> 'Настройки каналов новостей для тем',
	'ACP_FEED_SETTINGS_OTHER'			=> 'Прочие каналы новостей и настройки',

	'ACP_FEED_ENABLE'					=> 'Включить каналы новостей',
	'ACP_FEED_ENABLE_EXPLAIN'			=> 'Позволяет включать/выключать на форуме каналы новостей в формата ATOM.<br />При отключении этой настройки будут отключены все каналы новостей, независимо от указанных ниже параметров.',
	'ACP_FEED_LIMIT'					=> 'Количество элементов',
	'ACP_FEED_LIMIT_EXPLAIN'			=> 'Максимальное количество элементов, которые будут отображаться.',

	'ACP_FEED_OVERALL'					=> 'Активировать общий канал новостей',
	'ACP_FEED_OVERALL_EXPLAIN'			=> 'Новые сообщения на форуме.',
	'ACP_FEED_FORUM'					=> 'Включить каналы новостей для форума',
	'ACP_FEED_FORUM_EXPLAIN'			=> 'Новые сообщения на отдельных форумах.',
	'ACP_FEED_TOPIC'					=> 'Включить каналы тем',
	'ACP_FEED_TOPIC_EXPLAIN'			=> 'Новые сообщения отдельных тем.',

	'ACP_FEED_TOPICS_NEW'				=> 'Включить канал новых тем',
	'ACP_FEED_TOPICS_NEW_EXPLAIN'		=> 'Включает канал «Новые темы», который позволяет получать информацию о созданных темах, содержащую текст первого сообщения.',
	'ACP_FEED_TOPICS_ACTIVE'			=> 'Включить канал активных тем',
	'ACP_FEED_TOPICS_ACTIVE_EXPLAIN'	=> 'Включает канал Активные темы», который позволяет получать информацию об активных темах, содержащую текст первого сообщения.',
	'ACP_FEED_NEWS'						=> 'Канал новостей',
	'ACP_FEED_NEWS_EXPLAIN'				=> 'Первые сообщения новых тем из указанных форумов. Для отключения канала новостей не указывайте ни одного форума.<br />Чтобы выбрать несколько форумов, необходимо кликать мышью, удерживая клавишу <samp>CTRL</samp>.',

	'ACP_FEED_OVERALL_FORUMS'			=> 'Включить общий канал для форумов',
	'ACP_FEED_OVERALL_FORUMS_EXPLAIN'	=> 'Этот канал позволяет отображать последние сообщения со всех тем форума.',

	'ACP_FEED_HTTP_AUTH'				=> 'Разрешить HTTP аутентификацию',
	'ACP_FEED_HTTP_AUTH_EXPLAIN'		=> 'Включает аутентификацию по HTTP, что позволяет пользователям получать информацию, недоступную для гостей, с добавлением параметра <samp>auth=http</samp> в адресную строку канала новостей. Для работы данной функции на некоторых серверах может потребоваться внесение дополнительных изменений в файл .htaccess.',
	'ACP_FEED_ITEM_STATISTICS'			=> 'Статистика по элементам',
	'ACP_FEED_ITEM_STATISTICS_EXPLAIN'	=> 'Отображает индивидуальную статистику под элементами канала (автор сообщения, дата и время публикации, количество ответов и просмотров).',
	'ACP_FEED_EXCLUDE_ID'				=> 'Исключить эти форумы',
	'ACP_FEED_EXCLUDE_ID_EXPLAIN'		=> 'Содержимое выбранных форумов не будет включаться в каналы новостей. Не выбирайте форумов, если хотите получать данные со всех форумов.<br />Выберите несколько форумов, удерживая клавишу <samp>CTRL</samp> и кликая мышью.',
));

// Visual Confirmation Settings
$lang = array_merge($lang, array(
	'ACP_VC_SETTINGS_EXPLAIN'					=> 'Здесь Вы можете выбрать и настроить плагины CAPTCHA, которые реализуют различные способы защиты от автоматических регистраций.',
	'AVAILABLE_CAPTCHAS'						=> 'Доступные плагины',
	'CAPTCHA_UNAVAILABLE'						=> 'Данный плагин CAPTCHA не может быть испольован, поскольку не выполнены требования, позволяющие его использование.',
	'CAPTCHA_GD'								=> 'GD CAPTCHA',
	'CAPTCHA_GD_3D'								=> 'GD 3D Captcha',
	'CAPTCHA_GD_FOREGROUND_NOISE'				=> 'GD CAPTCHA с шумом на переднем плане',
	'CAPTCHA_GD_EXPLAIN'						=> 'Использовать библиотеку GD для создания усовершенствованной CAPTCHA.',
	'CAPTCHA_GD_FOREGROUND_NOISE_EXPLAIN'		=> 'Использовать шум для создания усложненной CAPTCHA.',
	'CAPTCHA_GD_X_GRID'							=> 'Фоновой шум CAPTCHA по оси X',
	'CAPTCHA_GD_X_GRID_EXPLAIN'					=> 'Используйте меньшее значение для создания более сложной CAPTCHA. Введите 0 для отключения создания шума по оси X.',
	'CAPTCHA_GD_Y_GRID'							=> 'Фоновой шум CAPTCHA по оси Y',
	'CAPTCHA_GD_Y_GRID_EXPLAIN'					=> 'Используйте меньшее значение для создания более сложной CAPTCHA. Введите 0 для отключения создания шума по оси Y.',
    'CAPTCHA_GD_WAVE'                        	=> 'Использовать искажение волны для создания более сложной CAPTCHA',
    'CAPTCHA_GD_WAVE_EXPLAIN'                	=> 'Данная функция активирует искажение волны к CAPTCHA.',
    'CAPTCHA_GD_3D_NOISE'                    	=> 'Добавить 3D-шум',
    'CAPTCHA_GD_3D_NOISE_EXPLAIN'            	=> 'Данная функция добавляет дополнительные объекты к CAPTCHA, по символам.',
    'CAPTCHA_GD_FONTS'                        	=> 'Использовать разные шрифты',
    'CAPTCHA_GD_FONTS_EXPLAIN'                	=> 'Эта настройка управляет количеством шрифтов, которые используются. Вы можете использовать настройки по умолчанию, или задать собственные. Также возможно добавление строчных букв.',
    'CAPTCHA_FONT_DEFAULT'                    	=> 'По умолчанию',
    'CAPTCHA_FONT_NEW'                        	=> 'Новые формы',
    'CAPTCHA_FONT_LOWER'                    	=> 'Также использовать строчные буквы',

	'CAPTCHA_NO_GD'							=> 'CAPTCHA без GD',
	'CAPTCHA_PREVIEW_MSG'					=> 'Изменения в настройках CAPTCHA ещё не сохранены. Это просто предварительный просмотр.',
	'CAPTCHA_PREVIEW_EXPLAIN'				=> 'Здесь Вы можоте увидеть, как будет выглядеть CAPTCHA при использовании текущих настроек.',

	'CAPTCHA_SELECT'						=> 'Установленные плагины CAPTCHA',
	'CAPTCHA_SELECT_EXPLAIN'				=> 'В этом списке содержатся плагины CAPTCHA, распознанные форумом. Плагины, помеченные серым цветом могут нуждаться в предварительной настройке, и поэтому в данный момент недоступны.',
	'CAPTCHA_CONFIGURE'						=> 'Настройка CAPTCHA',
	'CAPTCHA_CONFIGURE_EXPLAIN'				=> 'Изменить настройки для выбранных плагинов CAPTCHA.',
	'CONFIGURE'								=> 'Настроить',
	'CAPTCHA_NO_OPTIONS'					=> 'Данный плагин CAPTCHA не имеет параметров для настройки.',

	'VISUAL_CONFIRM_POST'					=> 'Включить визуальное подтверждение при отправке сообщений гостями',
	'VISUAL_CONFIRM_POST_EXPLAIN'			=> 'Для предотвращения массовой публикации сообщений анонимные пользователи при публикации сообщений должны будут ввести код подтверждения.',
	'VISUAL_CONFIRM_REG'					=> 'Включить визуальное подтверждение при регистрации',
	'VISUAL_CONFIRM_REG_EXPLAIN'			=> 'Для предотвращения автоматических регистраций новые пользователи при регистрации должны будут ввести код подтверждения.',
	'VISUAL_CONFIRM_REFRESH'				=> 'Разрешить пользователям обновлять код визуального подтверждения',
	'VISUAL_CONFIRM_REFRESH_EXPLAIN'		=> 'Даёт пользователям возможность обновлять код визуального подтверждения, если они не могут его распознать. Некоторые плагины CAPTCHA могут не поддерживать данную функцию.',
	));

// Cookie Settings
$lang = array_merge($lang, array(
	'ACP_COOKIE_SETTINGS_EXPLAIN'			=> 'Здесь производится настрока куков (cookies), отправляемых браузерам пользователей. В большинстве случаев достаточно значений по умолчанию. Если вам нужно изменить что-либо, делайте это с осторожностью, неверные установки могут сделать невозможным вход пользователей на форум.',

	'COOKIE_DOMAIN'					=> 'Домен куки',
	'COOKIE_NAME'					=> 'Имя куки',
	'COOKIE_PATH'					=> 'Путь куки',
	'COOKIE_SECURE'					=> 'Безопасные куки [ https ]',
	'COOKIE_SECURE_EXPLAIN'			=> 'Если ваш сервер работает через SSL, включите этот параметр, в противном случае оставьте выключенным. Включение этого параметра, если сервер работает не через SSL, приведет к ошибкам при переходах на страницы форума и при переадресации.',
	'ONLINE_LENGTH'					=> 'Временной диапазон онлайн статистики',
	'ONLINE_LENGTH_EXPLAIN'			=> 'Количество минут, по прошествию которых неактивные пользователи перестанут быть видимыми в списке «Кто сейчас на форуме». Увеличение этого значения повышает расход ресурсов сервера на создание списка.',
	'SESSION_LENGTH'				=> 'Длительность сессии',
	'SESSION_LENGTH_EXPLAIN'		=> 'Сессия будет завершена по прошествию указанного времени, в секундах.',
));

// Load Settings
$lang = array_merge($lang, array(
	'ACP_LOAD_SETTINGS_EXPLAIN'		=> 'Здесь Вы можете включать и отключать некоторые функции форума для снижения нагрузки на сервер. Для большинства серверов не требуется отключать какие-либо функции. Однако, на некоторых системах или коллективных хостингах может быть полезным отключение возможностей, которые Вам не требуются. Вы можете также задать ограничения для нагрузки на сервер и активных сессий, при превышении которых форум будет отключен.',

	'CUSTOM_PROFILE_FIELDS'				=> 'Дополнительные поля профиля',
	'LIMIT_LOAD'						=> 'Ограничить нагрузку на сервер',
	'LIMIT_LOAD_EXPLAIN'				=> 'Если средняя ежеминутная нагрузка на сервер превышает заданное значение, форум будет автоматически отключен. Значение, равное 1.0, означает ~100% использование ресурсов одного процессора. Эта возможность применима только для серверов на основе UNIX.',
	'LIMIT_SESSIONS'					=> 'Ограничить сессии',
	'LIMIT_SESSIONS_EXPLAIN'			=> 'Если количество сессий превышает заданное значение в течение одной минуты, форум будет автоматически отключен. Установите 0 для снятия ограничений.',
	'LOAD_CPF_MEMBERLIST'				=> 'Разрешить отображение дополнительных полей профиля в списке пользователей',
	'LOAD_CPF_VIEWPROFILE'				=> 'Показывать дополнительные поля в профилях пользователей',
	'LOAD_CPF_VIEWTOPIC'				=> 'Показывать дополнительные поля профиля при просмотре тем',
	'LOAD_USER_ACTIVITY'				=> 'Показать активность пользователя',
	'LOAD_USER_ACTIVITY_EXPLAIN'		=> 'Отображение темы/форума, в которых пользователь наиболее активен, в его профиле и центре пользователя. Рекомендуется отключить эту функцию на форумах с более чем одним миллионом сообщений.',
	'RECOMPILE_STYLES'					=> 'Перекомпилировать старые шаблоны',
	'RECOMPILE_STYLES_EXPLAIN'			=> 'Проверять обновление файлов шаблонов на сервере и перекомпилировать их.',
	'YES_ANON_READ_MARKING'				=> 'Включить маркировку тем для гостей',
	'YES_ANON_READ_MARKING_EXPLAIN'		=> 'Сохранять информацию о статусе «прочитано/не прочитано» для гостей. Если отключено, сообщения для гостей всегда помечены как прочитанные.',
	'YES_BIRTHDAYS'						=> 'Включить список дней рождения',
	'YES_BIRTHDAYS_EXPLAIN'				=> 'Если список Дней рождения отключен, он не будет отображаться. Для того, чтобы эта настройка работала, должна быть также активированиа функция Дней рождения.',
	'YES_JUMPBOX'						=> 'Включить отображение быстрого перехода',
	'YES_MODERATORS'					=> 'Включить отображение модераторов',
	'YES_ONLINE'						=> 'Включить информацию об активных пользователях',
	'YES_ONLINE_EXPLAIN'				=> 'Отображать информацию об активных пользователях на главной странице, при просмотре форумов и тем.',
	'YES_ONLINE_GUESTS'					=> 'Включить отображение гостей в списках активных пользователей',
	'YES_ONLINE_GUESTS_EXPLAIN'			=> 'Разрешить отображение информации о гостях при просмотре «Кто сейчас на форуме».',
	'YES_ONLINE_TRACK'					=> 'Включить отображение информации о пользователе «в сети/не в сети»',
	'YES_ONLINE_TRACK_EXPLAIN'			=> 'Отображать информацию о нахождении пользователя в сети в профилях и при просмотре тем.',
	'YES_POST_MARKING'					=> 'Включить свои темы',
	'YES_POST_MARKING_EXPLAIN'			=> 'Указывать, оставлял ли пользователь сообщения в теме.',
	'YES_READ_MARKING'					=> 'Включить маркировку тем на сервере',
	'YES_READ_MARKING_EXPLAIN'			=> 'Сохранять информацию о статусе «прочитано/не прочитано» в базе данных, а не в куках (cookies).',
));

// Auth settings
$lang = array_merge($lang, array(
	'ACP_AUTH_SETTINGS_EXPLAIN'		=> 'phpBB поддерживает расширения аутентификации, или модули. Они позволяют вам установить способ аутентификации пользователей при их входе на форум. По умолчанию доступны три модуля: DB, LDAP and Apache. Не все методы требуют дополнительной информации, поэтому заполняйте только те поля, которые необходимы для выбранного метода.',

	'AUTH_METHOD'					=> 'Выбрать метод аутентификации',

	'APACHE_SETUP_BEFORE_USE'		=> 'Вы должны настроить аутентификацию apache при переключении phpBB на этот метод. Помните, что имя пользователя для аутентификации в Apache должно совпадать с Вашим именем пользователя в phpBB.',

	'LDAP_DN'							=> 'Основное имя LDAP [ <var>dn</var> ]',
	'LDAP_DN_EXPLAIN'					=> 'Уникальное имя (Distinguished Name), определяющее информацию о пользователе, например <samp>o=My Company,c=US</samp>',
	'LDAP_EMAIL'						=> 'E-mail атрибут LDAP',
	'LDAP_EMAIL_EXPLAIN'				=> 'Задайте имя атрибута e-mail пользователя (если он существует), для автоматического присвоения e-mail адресов новым пользователям. Если это поле оставлено пустым, e-mail адреса пользователей, которые впервые вошли на форум, также будут пустыми.',
	'LDAP_INCORRECT_USER_PASSWORD'		=> 'Попытка связи с сервером LDAP с указанным именем/паролем не удалась.',
	'LDAP_NO_EMAIL'						=> 'Указанный атрибут e-mail не существует.',
	'LDAP_NO_IDENTITY'					=> 'Не удалось найти идендтификатор входа в систему для %s',
	'LDAP_PASSWORD'						=> 'Пароль LDAP',
	'LDAP_PASSWORD_EXPLAIN'				=> 'Оставьте поле пустым для анонимного соединения. В противном случае введите пароль для указанного выше пользователя. Требуется для серверов Active Directory. <strong>ВНИМАНИЕ:</strong> Этот пароль будет сохранен в незашифрованном виде в базе данных, и будет виден всем, кто имеет доступ к ней или к этой странице конфигурации.',
	'LDAP_PORT'							=> 'Порт сервера LDAP',
	'LDAP_PORT_EXPLAIN'					=> 'Вы можете указать порт, который должен использоваться для соединения с сервером LDAP вместо порта по умолчанию 389.',
	'LDAP_SERVER'						=> 'Имя сервера LDAP',
	'LDAP_SERVER_EXPLAIN'				=> 'Если используется LDAP, укажите хост или IP-адрес сервера LDAP. Вы можете указать ссылку, например ldap://hostname:port/',
	'LDAP_UID'							=> 'Идентификационный номер LDAP [ <var>uid</var> ]',
	'LDAP_UID_EXPLAIN'					=> 'Это ключ, с помощью которого производится поиск заданного идентификатора входа в систему, например <var>uid</var>, <var>sn</var>, и т.п.',
	'LDAP_USER'							=> 'Пользователь LDAP [ <var>dn</var> ]',
	'LDAP_USER_EXPLAIN'					=> 'Оставьте пустым для анонимного соединения. Если поле заполнено, phpBB использует указанное имя при соединении с сервером LDAP для поиска правильного пользователя, например, например <samp>uid=Username,ou=MyUnit,o=MyCompany,c=US</samp>. Требуется для серверов Active Directory.',
	'LDAP_USER_FILTER'					=> 'Фильтр имени пользователя LDAP',
	'LDAP_USER_FILTER_EXPLAIN'			=> 'Вы можете в дальнейшем ограничить диапазон искомых объектов с помощью дополнительных фильтров. Например, результатом <samp>objectClass=posixGroup</samp> будет <samp>(&(uid=$username)(objectClass=posixGroup))</samp>',
));

// Server Settings
$lang = array_merge($lang, array(
	'ACP_SERVER_SETTINGS_EXPLAIN'		=> 'Здесь задаются настройки, связанные с сервером и доменом. Удостоверьтесь в точности указанных Вами данных, ошибки приведут к рассылке e-mail сообщений, содержащих неверную информацию. Задавая имя домена, помните, что оно должно включать  http:// или префикс другого протокола. Изменяйте номер порта только в случае, если Вам точно известно, что сервер использует другое значение, порт 80 подходит в большинстве случаев.',

	'ENABLE_GZIP'					=> 'Включить сжатие GZip',
	'ENABLE_GZIP_EXPLAIN'			=> 'Генерируемое содержимое будет сжиматься с помощью GZip перед отправкой пользователю. Включение этой опции помогает уменьшить расход сетевого трафика, но в то же время увеличивает использование центрального процессора, как на стороне клиента, так и на сервере. Требуется расширение PHP zlib.',
	'FORCE_SERVER_VARS'				=> 'Принудительные настройки URL сервера',
	'FORCE_SERVER_VARS_EXPLAIN'		=> 'Если выбрано, то указанные здесь настройки будут использованы вместо автоматически определенных значений',
	'ICONS_PATH'					=> 'Путь к значкам сообщений',
	'ICONS_PATH_EXPLAIN'			=> 'Путь относительно корневой папки phpBB, например <samp>images/icons</samp>',
	'PATH_SETTINGS'					=> 'Настройки путей',
	'RANKS_PATH'					=> 'Путь к картинкам званий',
	'RANKS_PATH_EXPLAIN'			=> 'Путь относительно корневой папки phpBB, например <samp>images/ranks</samp>',
	'SCRIPT_PATH'					=> 'Путь к форуму',
	'SCRIPT_PATH_EXPLAIN'			=> 'Путь к папке, содержащей  phpBB, относительно имени домена, например, <samp>/phpBB3</samp>',
	'SERVER_NAME'					=> 'Имя домена',
	'SERVER_NAME_EXPLAIN'			=> 'Имя домена, на котором работает этот форум (например: <samp>www.foo.bar</samp>)',
	'SERVER_PORT'					=> 'Порт сервера',
	'SERVER_PORT_EXPLAIN'			=> 'Порт, на котором запущен сервер, обычно это порт 80, изменяйте тольно в случае, если сервер использует другой порт',
	'SERVER_PROTOCOL'				=> 'Протокол сервера',
	'SERVER_PROTOCOL_EXPLAIN'		=> 'Используется в качестве протокола сервера, если эти настройки включены принудительно. Если не задано или не включено принудительно, протокол будет определен по настройкам безопасных куков (<samp>http://</samp> или <samp>https://</samp>)',
	'SERVER_URL_SETTINGS'			=> 'Настройки URL сервера',
	'SMILIES_PATH'					=> 'Путь к смайликам',
	'SMILIES_PATH_EXPLAIN'			=> 'Путь относительно корневой папки phpBB, например <samp>images/smilies</samp>',
	'UPLOAD_ICONS_PATH'				=> 'Путь к значкам групп расширений',
	'UPLOAD_ICONS_PATH_EXPLAIN'		=> 'Путь относительно корневой папки phpBB, например <samp>images/upload_icons</samp>',
));

// Security Settings
$lang = array_merge($lang, array(
	'ACP_SECURITY_SETTINGS_EXPLAIN'			=> 'Здесь Вы можете задать установки, связанные с сессией и входом на форум',

	'ALL'								=> 'Полная',
	'ALLOW_AUTOLOGIN'					=> 'Разрешить автоматический вход на форум',
	'ALLOW_AUTOLOGIN_EXPLAIN'			=> 'Определяет, могут ли пользователи автоматически входить на форум при его посещении.',
	'AUTOLOGIN_LENGTH'					=> 'Время операции автоматического входа (дней)',
	'AUTOLOGIN_LENGTH_EXPLAIN'			=> 'Количество дней, в течение которого пользователь может автоматически входить на форум. Установите 0 для снятия ограничений.',
	'BROWSER_VALID'						=> 'Проверка браузера',
	'BROWSER_VALID_EXPLAIN'				=> 'Включает проверку браузера при каждой сессии для повышения безопасности.',
	'CHECK_DNSBL'						=> 'Проверить IP-адрес по черному списку DNS (DNS Blackhole List)',
	'CHECK_DNSBL_EXPLAIN'				=> 'Если опция включена, то IP-адрес пользователя будет проверяться при регистрации или отправке сообщений с помощью следующих служб  DNSBL: <a href="http://spamcop.net">spamcop.net</a> и <a href="http://www.spamhaus.org">www.spamhaus.org</a>. Эта процедура может занять некоторое время, в зависимости от конфигурации сервера. В случае повышения нагрузки на сервер и получении недостоверных результатов рекомендуем отключить данную проверку.',
	'CLASS_B'							=> 'A.B',
	'CLASS_C'							=> 'A.B.C',
	'EMAIL_CHECK_MX'					=> 'Проверить правильность почтовой записи в DNS (MX Record) домена e-mail адреса',
	'EMAIL_CHECK_MX_EXPLAIN'			=> 'Если включено, домен e-mail адреса, указанный при регистрации или изменении профиля, проверяется на правильность  почтовой записи в DNS (MX Record).',
	'FORCE_PASS_CHANGE'					=> 'Принудительная смена пароля',
	'FORCE_PASS_CHANGE_EXPLAIN'			=> 'Пользователь должен будет сменить свой пароль по прошествии заданного количества дней. Установите 0 для отключения этой функции.',
	'FORM_TIME_MAX'						=> 'Максимальное время для отправки формы',
	'FORM_TIME_MAX_EXPLAIN'				=> 'Время, за которое пользователь должен отправить форму. Установите -1 для отключения этой функции. Учтите, что форма может устареть по истечении сессии, независимо от данной настройки.',
	'FORM_SID_GUESTS'					=> 'Привязать формы к гостевым сессиям',
	'FORM_SID_GUESTS_EXPLAIN'			=> 'Если включено, формы, отправляемые гостями, будут привязаны к конкретным сессиям. Это может вызвать проблемы с некоторыми Интернет-провайдерами.',
	'FORWARDED_FOR_VALID'				=> 'Проверка заголовка <var>X_FORWARDED_FOR</var>',
	'FORWARDED_FOR_VALID_EXPLAIN'		=> 'Сессия будет продолжена только в случае, если отправленный заголовок <var>X_FORWARDED_FOR</var> соответствует отправленному в предыдущем запросе. Блокировка доступа по IP-адресу будет осуществляться по IP-адресам из заголовка <var>X_FORWARDED_FOR</var>.',
	'IP_VALID'							=> 'Проверка IP-адреса сессии',
	'IP_VALID_EXPLAIN'					=> 'Определяет, какая часть IP-адреса пользователя используется для проверки сессии. <samp>Полная</samp> означает проверку всего адреса, <samp>A.B.C</samp> - первых трех чисел (x.x.x), <samp>A.B</samp> - первых двух чисел (x.x), <samp>Нет</samp> отключает проверку.',
	'MAX_LOGIN_ATTEMPTS'				=> 'Максимальное количество попыток входа',
	'MAX_LOGIN_ATTEMPTS_EXPLAIN'		=> 'После указанного количества неудачных попыток входа на форум пользователь должен будет дополнительно подтвердить свой вход (визуальное подтверждение)',
	'NO_IP_VALIDATION'					=> 'Нет',
	'NO_REF_VALIDATION'					=> 'Нет',
	'PASSWORD_TYPE'						=> 'Сложность пароля',
	'PASSWORD_TYPE_EXPLAIN'				=> 'Определяет, насколько сложным должен быть пароль при его установке или изменении. Каждый следующий вариант ограничения включает в себя предыдущие.',
	'PASS_TYPE_ALPHA'					=> 'Должен содержать буквенно-цифровые символы',
	'PASS_TYPE_ANY'						=> 'Требования отсутствуют',
	'PASS_TYPE_CASE'					=> 'Должен содержать символы разного регистра',
	'PASS_TYPE_SYMBOL'					=> 'Должен содержать символы',
	'REF_HOST'							=> 'Проверять только хост',
	'REF_PATH'							=> 'Проверять также путь',
	'REFERER_VALID'						=> 'Проверять рефёрер',
	'REFERER_VALID_EXPLAIN'				=> 'Если включено, рефёрер для запросов типа POST будет проверен на параметры хоста/пути к скрипту. Это может вызвать проблемы с форумами, использующими несколько доменов или внешние аутентификации.',

	'TPL_ALLOW_PHP'						=> 'Разрешить php в шаблонах',
	'TPL_ALLOW_PHP_EXPLAIN'				=> 'Если эта функция включена, команды <code>PHP</code> и <code>INCLUDEPHP</code> будут распознаваться и выполняться в шаблонах.',
));

// Email Settings
$lang = array_merge($lang, array(
	'ACP_EMAIL_SETTINGS_EXPLAIN'		=> 'Эта информация используется для отправки форумом e-mail сообщений пользователям. Удостоверьтесь в правильности указанных e-mail адресов, все возвращенные или не доставленные сообщения будут, вероятно, отправлены на них. Если Ваш сервер не обеспечивает использование встроенной (в PHP) службы e-mail, Вы можете отправлять сообщения напрямую с использованием SMTP. Для этого необходим адрес подходящего сервера (если нужно, спросите об этом у провайдера). Если сервер требует аутентификации (и только в этом случае), введите необходимые имя, пароль и метод аутентификации.',

	'ADMIN_EMAIL'						=> 'Обратный e-mail адрес',
	'ADMIN_EMAIL_EXPLAIN'				=> 'Этот адрес будет использован для возврата всех e-mail сообщений, как e-mail адрес для технических контактов. Он всегда будет использоватся в качестве адресов <samp>Return-Path</samp> и <samp>Sender</samp> в e-mail сообщениях.',
	'BOARD_EMAIL_FORM'					=> 'Рассылка e-mail сообщений через форум',
	'BOARD_EMAIL_FORM_EXPLAIN'			=> 'Пользователи смогут отправлять e-mail сообщения через форум вместо их обычной отправки.',
	'BOARD_HIDE_EMAILS'					=> 'Скрывать e-mail адреса',
	'BOARD_HIDE_EMAILS_EXPLAIN'			=> 'Эта функция полностью сохраняет в тайне e-mail адреса.',
	'CONTACT_EMAIL'						=> 'Контактный e-mail адрес',
	'CONTACT_EMAIL_EXPLAIN'				=> 'Этот адрес будет использоваться при каждой необходимости контакта, например, в случае спама, ошибок и т.п. Он всегда будет использоваться в качестве адресов <samp>From</samp> и <samp>Reply-To</samp> в e-mail сообщениях.',
	'EMAIL_FUNCTION_NAME'				=> 'Имя функции e-mail',
	'EMAIL_FUNCTION_NAME_EXPLAIN'		=> 'Функция e-mail, используемая для отправки сообщений через PHP.',
	'EMAIL_PACKAGE_SIZE'				=> 'Размер пакета e-mail',
	'EMAIL_PACKAGE_SIZE_EXPLAIN'		=> 'Маскимальное количество сообщений по e-mail, которое можно отправить за один раз. Эта настройка применяется для внутренней очереди сообщений; установите 0 при возникновении проблем, связанных с неотправленными по e-mail уведомлениями.',
	'EMAIL_SIG'							=> 'Подпись в e-mail сообщении',
	'EMAIL_SIG_EXPLAIN'					=> 'Этот текст будет добавлен во все e-mail сообщения, отправляемые форумом.',
	'ENABLE_EMAIL'						=> 'Включить e-mail сообщения',
	'ENABLE_EMAIL_EXPLAIN'				=> 'Если выключено, отправка любых e-mail сообщений с форума производится не будет. <em>Примечание: данная опция должна быть включена, если вы хотите задействовать активацию аккаунта администратором или пользователем. При отключении данной опции варианты активации аккаунта пользователем или администратором станут недоступны.</em>',
	'SMTP_AUTH_METHOD'					=> 'Метод аутентификации для SMTP',
	'SMTP_AUTH_METHOD_EXPLAIN'			=> 'Используется только в случае, если заданы имя/пароль. Спросите у своего провайдера, еслы не уверены, какой метод аутентификации использовать.',
	'SMTP_CRAM_MD5'						=> 'CRAM-MD5',
	'SMTP_DIGEST_MD5'					=> 'DIGEST-MD5',
	'SMTP_LOGIN'						=> 'LOGIN',
	'SMTP_PASSWORD'						=> 'Пароль SMTP',
	'SMTP_PASSWORD_EXPLAIN'				=> 'Вводите пароль только в случае, если сервер SMTP требует этого.<br /><em><strong>Внимание:</strong> пароль будет сохранён в базе данных в открытом виде, и будет виден всем, кто имеет к ней доступ.</em>',
	'SMTP_PLAIN'						=> 'PLAIN',
	'SMTP_POP_BEFORE_SMTP'				=> 'POP-BEFORE-SMTP',
	'SMTP_PORT'							=> 'Порт сервера SMTP',
	'SMTP_PORT_EXPLAIN'					=> 'Изменяйте только в случае, если Вам точно известно, что сервер использует другой порт.',
	'SMTP_SERVER'						=> 'Адрес сервера SMTP',
	'SMTP_SETTINGS'						=> 'Настройки SMTP',
	'SMTP_USERNAME'						=> 'Имя пользователя SMTP',
	'SMTP_USERNAME_EXPLAIN'				=> 'Вводите имя только в случае, если сервер SMTP требует этого.',
	'USE_SMTP'							=> 'Использовать SMTP для отправки e-mail сообщений',
	'USE_SMTP_EXPLAIN'					=> 'Выберите «Да», если Вы хотите или должны отправлять e-mail сообщения через сервер вместо локальной функции mail.',
));

// Jabber settings
$lang = array_merge($lang, array(
	'ACP_JABBER_SETTINGS_EXPLAIN'		=> 'Здесь Вы можете включать и управлять использованием Jabber для мгновенных сообщений и уведомлений с форума. Jabber - это протокол с открытым исходным кодом и, следовательно, доступный для использования всеми желающими. Некоторые серверы Jabber имеют шлюзы или протоколы передачи, позволяющие связываться с пользователями в других сетях. Не все серверы предлагают все виды протоколов передачи, а изменения в протоколах могут не позволить им правильно работать. Удостоверьтесь, что указаны данные уже существующей аккаунту - phpBB будет использовать их в том виде, в котором они заданы.',

	'ERR_JAB_AUTH'				=> 'Не удалось войти на сервер Jabber.',
	'ERR_JAB_CONNECT'			=> 'Не удалось соединиться с сервером Jabber.',
	'JAB_GTALK_NOTE'				=> 'GTalk не будет работать, поскольку функция <samp>dns_get_record</samp> не найдена. Данная функция недоступна в PHP4 и не реализована на платформах Windows. В настоящее время функция также не работает на системах BSD, включая Mac OS.',
	'JAB_ENABLE'					=> 'Включить Jabber',
	'JAB_ENABLE_EXPLAIN'			=> 'Включение позволяет использовать Jabber для отправки мгновенных сообщений и уведомлений',
	'JAB_PACKAGE_SIZE'				=> 'Размер пакета Jabber',
	'JAB_PACKAGE_SIZE_EXPLAIN'		=> 'Количество сообщений, отправляемых в одном пакете. Если установлен 0, сообщение отправляется немедленно, без постановки в очередь для последующей отправки.',
	'JAB_PASSWORD'					=> 'Пароль Jabber',
	'JAB_PASSWORD_EXPLAIN'			=> '<em><strong>Внимание:</strong> пароль будет сохранён в базе данных в открытом виде, и будет виден всем, кто имеет к ней доступ.</em>',
	'JAB_PORT'						=> 'Порт Jabber',
	'JAB_PORT_EXPLAIN'				=> 'Оставьте пустым, если Вам известно, что используется порт, отличный от 5222',
	'JAB_SERVER'					=> 'Сервер Jabber',
	'JAB_SERVER_EXPLAIN'			=> 'Посетите %sjabber.org%s для получения списка серверов',
	'JAB_SETTINGS_CHANGED'			=> 'Настройки Jabber успешно изменены.',
	'JAB_USE_SSL'					=> 'Использовать SSL для соединения',
	'JAB_USE_SSL_EXPLAIN'			=> 'Если включено, будет произведена попытка установить безопасное соединение. Порт Jabber будет изменен на 5223, если ранее был указан порт 5222.',
	'JAB_USERNAME'					=> 'Имя пользователя Jabber или JID',
	'JAB_USERNAME_EXPLAIN'			=> 'Укажите имя зарегистрированного пользователя, или достоверный JID. Заданное имя не будет проверяться на достоверность. Если Вы введете только имя пользователя, Ваш JID будет именем пользователя и сервером, который Вы указали выше. Чтобы такого не произошло, указывайте достоверный JID, например user@jabber.org.',
));

?>
