<?php
/**
* Блок мониторинга
* 
* @author Igor Ognichenko
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @filesource blocks/block-monitoring.php
* @version 2.0
*/
if (!defined('BLOCK_FILE')) {
    Header("Location: ../index.php");
    exit;
}
global $main, $img, $adminfile;
$result = $main->db->sql_query("SELECT s.sid, s.uname, s.is_admin, s.ip, s.time, s.module, s.url, s.user_agent, s.country, u.uid, u.user_id, u.user_name, u.user_group, g.id, g.title, g.color FROM ".SESSIONS." AS s LEFT JOIN ".USERS." AS u ON(s.uname=u.user_name) LEFT JOIN ".GROUPS." AS g ON(u.user_group=g.id)");
$admin = array();
$users = array();
$bots = array();
$guest = array();
while(list($sid, $uname, $is_admin, $ip, $time, $module, $url, $user_agent, $country, $uid, $user_id, $user_name, $user_group, $gid, $gtitle, $color) = $main->db->sql_fetchrow($result)){
    $url = str_replace("&", "&amp;", $url);
    if(($is_admin==1 OR $is_admin==2) AND !is_ip($uname)) $admin[] = "<tr><td>".get_flag($country)."<a style='color:#{$color};' href='".$main->url(array('module' => 'account', 'do' => 'user', 'id' => case_id($user_id, $uid)))."' id='info_{$uname}' onmouseover=\"show_userinfo(this, '{$uid}')\">{$uname}</a></td><td align='right'>".((!empty($url))?"<a href='{$url}'>{$module}</a>":"&nbsp;")."</td></tr>\n";    
    elseif(!is_ip($uname) AND !is_bot($uname)) $users[] = "<tr><td>".get_flag($country)."".(!empty($user_name)?"<a style='color:#{$color};' href='".$main->url(array('module' => 'account', 'do' => 'user', 'id' => case_id($user_id, $uid)))."' id='info_{$uname}' onmouseover=\"show_userinfo(this, '{$uid}')\">{$uname}</a>":$uname)."</td><td align='right'>".((!empty($url))?"<a href='{$url}'>{$module}</a>":"&nbsp;")."</td></tr>\n";
    elseif(is_bot($uname)) $bots[] = "<tr><td>".get_flag($country)."{$uname}</td><td align='right'>".(!empty($url)?"<a href='{$url}'>{$module}</a>":$module)."</td></tr>\n";
    elseif(is_ip($uname)) $guest[] = "<tr><td>".get_flag($country)."<a href='{$main->config['whois']}{$ip}' title='".htmlspecialchars($user_agent, ENT_QUOTES)."'>{$uname}</a></td><td align='right'>".((!empty($url))?"<a href='{$url}'>{$module}</a>":"&nbsp;")."</td></tr>\n";
}
echo "&#187; <a href='{$adminfile}' title='{$main->lang['adminpanel']}'>{$main->lang['adminpanel']}</a><br />
&#187; <a href='{$adminfile}?module=logout'>{$main->lang['logout']}</a><br />
<hr /><div class='monitoring'>
<table cellspacing='2' cellpadding='0' width='100%'>
<tr class='pointer' onclick=\"switcher('admin_online');\"><td>{$img['plus']}{$img['admin']}{$main->lang['admin_mon']}<span> (".count($admin).") </span></td></tr>
<tr id='admin_online' style='display:none;'><td>".((count($admin)>0) ? "<table cellspacing='0' cellpadding='2' width='100%'>".implode("", $admin)."</table><hr />": "")."</td></tr>
</table>
<table cellspacing='2' cellpadding='0' width='100%'>
<tr class='pointer' onclick=\"switcher('user_online');\"><td>{$img['plus']}{$img['user']}{$main->lang['users_mon']}<span> (".count($users).") </span></td></tr>
<tr id='user_online' style='display:none;'><td>".((count($users)>0) ? "<table cellspacing='0' cellpadding='2' width='100%'>".implode("", $users)."</table><hr />": "")."</td></tr>
</table>
<table cellspacing='2' cellpadding='0' width='100%'>
<tr class='pointer' onclick=\"switcher('bots_online');\"><td>{$img['plus']}{$img['bots']}{$main->lang['bots_mon']}<span> (".count($bots).") </span></td></tr>
<tr id='bots_online' style='display:none;'><td>".((count($bots)>0) ? "<table cellspacing='0' cellpadding='2' width='100%'>".implode("", $bots)."</table><hr />": "")."</td></tr>
</table>
<table cellspacing='2' cellpadding='0' width='100%'>
<tr class='pointer' onclick=\"switcher('guest_online');\"><td>{$img['plus']}{$img['guest']}{$main->lang['guest_mon']}<span> (".count($guest).") </span></td></tr>
<tr id='guest_online' style='display:none;'><td>".((count($guest)>0) ? "<table cellspacing='0' cellpadding='2' width='100%'>".implode("", $guest)."</table><hr />": "")."</td></tr>
</table>
<table cellspacing='2' cellpadding='0' width='100%'>
<tr><td style='padding-left: 12px;'>{$img['all_users']}{$main->lang['all_mon']}<span> (".(count($guest)+count($bots)+count($users)+count($admin)).") </span></td></tr>
</table>
</div>";

?>