<?php
/**
* Класс преобразований bb кодов в HTML и HTML в bb коды
* 
* @author Igor Ognichenko
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @filesource includes/classes/bbcode.class.php
* @version 2.0
*/
if (!defined("FUNC_FILE")) die("Access is limited");

class bbcode {
    /**
    * Конвертируемый текст
    * 
    * @var string
    */
    var $text = '';
    
    /**
    * Массив символов которые нужно заменить на их код
    * 
    * @var array
    */
    var $array_replace = array('/<#/', '/&lt;/', '/&gt;/', '/&quot;/', '/:/', '/\[/', '/\]/', '/\)/', '/\(/', '/#\s{1};/');
    
    /**
    * Коды символов для замены массива $this->array_replace
    * 
    * @var array
    */
    var $array_html = array("&#60;", "&#60;", "&#62;", "&#34;", "&#58;", "&#91;", "&#93;", "&#41;", "&#40;", "&#59;");
    
    /**
    * Коды символов
    * 
    * @var array
    */
    var $arr_html = array('/&\#60;/', '/&lt;/', '/&\#62;/', '/&gt;/', '/&\#34;/', '/&\#58;/', '/&\#91;/', '/&\#93;/', '/&\#41;/', '/&\#40;/');
    
    /**
    * Массив замены кодов с $this-> arr_html на символы
    * 
    * @var array
    */
    var $arr_replace = array("<", "<", ">", ">", "&quot;", ":", "[", "]", ")", "(");
    
    /**
    * Массив кэшируемых bb кодов
    * 
    * @var array
    */
    var $cache_code = array();

    /**
    * Функция кэша bb кодов и передачи текста в класс преобразования
    * 
    * @param mixed $text
    * @return void
    */
    function set_text($text){
        //cache bbcode
        $this->text = preg_replace('%\[nobb\](.+?)\[/nobb\]%ies', "\$this->nobb_tag('\\1')", $text);
        $this->text = preg_replace('%\[(video|flash|mp3|radio|code|php|html|css|xml|javascript|java|cpp|delphi|python|ruby|sql)\](.+?)\[\/(video|flash|mp3|radio|code|php|html|css|xml|javascript|java|cpp|delphi|python|ruby|sql)\]%ies', "\$this->cache_code('\\2', '\\1')", $this->text);
        $this->bb2html();
    }

    /**
    * Функция возвращает готовый HTML код полученный с bb кодов  за исключением кэшируемых
    * 
    * @return string
    */
    function get_html(){
        $this->text = nl2br($this->text);
        $this->parse_smiles();
        $this->text = preg_replace('%\{cache-bbcode-([0-9]+)-([a-zA-z]+)\}%e', "\$this->set_cache('\\1', '\\2')", $this->text);
        return $this->text;
    }

    /**
    * Возвращает bb код полученный с HTML
    * 
    * @return string
    */
    function get_bb(){
        return $this->text;
    }
    
    /**
    * Функция кэширования bb кодов
    * 
    * @param string $code
    * @param string $bb
    * @return string
    */
    function cache_code($code, $bb){
        $this->cache_code[] = $code;
        return "{cache-bbcode-".(count($this->cache_code)-1)."-{$bb}}";
    }
    
    /**
    * Функция очистки кэша bb кодов
    * 
    * @param int $code_id
    * @param string $bb
    */
    function set_cache($code_id, $bb){
        return '['.$bb.']'.stripslashes(stripslashes($this->cache_code[$code_id])).'[/'.$bb.']';
    }
    
    /**
    * Функция парсинга смайлов
    * 
    * @return void
    */
    function parse_smiles(){
    global $smiles;
        foreach($smiles as $value) {
            $this->text = str_replace(magic_quotes($value[0]), "<!--start smile--><img src='{$value[1]}' alt=\"".str_replace(')', '', htmlspecialchars($value[0], ENT_QUOTES))."\" /><!--end smile-->", $this->text);
        }
    }
    
    /**
    * Функция преобразования bb кодов в HTML
    * 
    * @return void
    */
    function bb2html(){
         $array_bb = array(
             '%\[url=(.*?)\](.*?)\[/url\]%sie',
             '%\[url\]([\w]+?://([\w\#$\%&~/.\-;:=,?@\]+]+|\[(?!url=))*?)\[/url\]%sie',
             '%\[mail\s*=\s*([\.\w\-]+\@[\.\w\-]+\.[\w\-]+)\s*\](.*?)\[/mail\]%si',
             '%\[mail\](\S+?)\[/mail\]%si',
             '%\[img=([a-zA-Z]+) alt=([a-zA-Zа-яА-Я0-9\_\-\. ]+)\]([^?](?:[^\[]+|\[(?!url))*?)\[/img\]%si',
             '%\[img alt=(.+?)\](.*?)\[/img\]%si',
             '%\[img\]([^?](?:[^\[]+|\[(?!url))*?)\[/img\]%si',
             '%\[backcolor=(#[0-9A-F]{6}|[a-z]+)\](.*?)\[/backcolor\]%si',
             '%\[color=(\#[0-9A-F]{6}|[a-z]+)\](.*?)\[/color\]%si',
             '%\[(left|right|center|justify)\](.*?)\[/\\1\]%si',
             '%\[family=([A-Za-z ]+)\](.*?)\[/family\]%si',
             '%\[size=([0-9]*)\](.*?)\[/size\]%si',
             '%\[blockquote\](.*?)\[/blockquote\]%si',
             '%\[sub\](.*?)\[/sub\]%si',
             '%\[sup\](.*?)\[/sup\]%si',
             '%\[li\](.*?)\[/li\]%si',
             '%\[b\](.+?)\[/b\]%si',
             '%\[i\](.+?)\[/i\]%si',
             '%\[u\](.+?)\[/u\]%si',
             '%\[s\](.+?)\[/s\]%si',
             '%\[h1\](.+?)\[/h1\]%si',
             '%\[h2\](.+?)\[/h2\]%si',
             '%\[h3\](.+?)\[/h3\]%si',
             '%\[h4\](.+?)\[/h4\]%si',
             '%\[h5\](.+?)\[/h5\]%si',
             '%\[h6\](.+?)\[/h6\]%si',
             '%\[hr\]%si',
             '%\(tm\)%si',
             '%\(c\)%si',
             '%\(r\)%si'
        );

         $array_html = array(
             "\$this->build_url(array('html' => '\\1', 'show' => '\\2', 'st' => ''))",
             "\$this->build_url(array('html' => '\\1', 'show' => '\\1', 'st' => ''))",
             "<a href='mailto:\\1'>\\2</a>",
             "<a href='mailto:\\1'>\\1</a>",
             "<img src='\\3' align='\\1' alt='\\2' title='\\2' />",
             "<img src='\\2' border='0' alt='\\1' title='\\1' />",
             "<img src='\\1' border='0' alt='\\1' title='\\1' />",
             "<!--start background--><span style='background: \\1'>\\2</span><!--end background-->",
             "<!--start color--><span style='color: \\1'>\\2</span><!--end color-->",
             "<div align='\\1'>\\2</div>",
             "<!--start font-family--><span style='font-family: \\1'>\\2</span><!--end font-family-->",
             "<!--start font-size--><span style='font-size: \\1px;'>\\2</span><!--end font-size-->",
             "<blockquote>\\1</blockquote>",
             "<sub>\\1</sub>",
             "<sup>\\1</sup>",
             "<li>\\1</li>",
             "<b>\\1</b>",
             "<i>\\1</i>",
             "<u>\\1</u>",
             "<s>\\1</s>",
             "<h1>\\1</h1>",
             "<h2>\\1</h2>",
             "<h3>\\1</h3>",
             "<h4>\\1</h4>",
             "<h5>\\1</h5>",
             "<h6>\\1</h6>",
             "<hr />",
             "&#153;",
             "&copy;",
             "&reg;"
        );     
        
        
        $this->text = str_replace('$', "&#036;", $this->text);
        $this->text = preg_replace('%\[nobb\](.+?)\[/nobb\]%ies', "\$this->nobb_tag('\\1')", $this->text);
        $this->text = preg_replace('%\[(miniature|attach)=(.+?)\]%ies', "\$this->attach_tags('\\1', '\\2')", $this->text);
        $this->text = preg_replace('%(^|\s)((http|news|https|ftp|aim|ed2k|magnet)://\w+[^\s\[\]]+)%ies', "\$this->build_url(array('html' => '\\2', 'show' => '\\2', 'st' => '\\1'))", $this->text);
        $this->text = preg_replace($array_bb, $array_html, $this->text);
    }
    
    /**
    * Функция преобразования дополнительных bb кодов в  HTML
    * 
    * @return void
    */
    function other_bb(){
        $array_bb = array(
             '%\[flash=(.+?)\,(.+?)\](.+?)\[\/flash\]%is',
             '%\[video\](.+?)\[\/video\]%ise',
             '%\[mp3\](.+?)\[\/mp3\]%is',
             '%\[radio\](.+?)\[\/radio\]%is',
             '%\[hide\](.+?)\[/hide\]%ies',
             '%(\[cite(.+?)?\].*\[/cite\])%ies'
        );

        $array_html = array(
             "<object classid='clsid:D27CDB6E-AE6D-11cf-96B8-444553540000' width='\\1' height='\\2'><param name='movie' value='\\3' /><param name='play' value='true' /><param name='loop' value='true' /><param name='quality' value='high' /><param name='allowscriptaccess' value='always' /><embed src='\\3' allowScriptAccess='always' width='\\1' height='\\2' play='true' loop='true' quality='high'></embed></object>",                          
             "\$this->create_player('\\1')",
             "<object type='application/x-shockwave-flash' data='includes/flash/mp3player.swf' width='200' height='20'><param name='wmode' value='transparent' /><param name='movie' value='includes/flash/mp3player.swf' /><param name='FlashVars' value='mp3=\\1&amp;showstop=1&amp;bgcolor1=ffffff&amp;bgcolor2=cccccc&amp;buttoncolor=999999&amp;buttonovercolor=0&amp;slidercolor1=cccccc&amp;slidercolor2=999999&amp;sliderovercolor=666666&amp;textcolor=0&amp;showvolume=1' /></object>",
             "<object id='mediaPlayer' classid='CLSID:22d6f312-b0f6-11d0-94ab-0080c74c7e95' codebase='http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=5,1,52,701' standby='Loading...' type='application/x-oleobject' width='250' height='80'><param name='FileName' value='\\1' /><param name='ShowControls' value='1' /><param name='ShowPositionControls' value='0' /><param name='ShowTracker' value='0' /><param name='ShowDisplay' value='0' /><param name='ShowStatusBar' value='1' /><param name='AutoSize' value='1' /><param name='AutoStart' value='True' /><param name='volume' value='50' /><embed type='application/x-mplayer2' pluginspage='http://www.microsoft.com/windows/mediaplayer/en/default.asp' filename='\\1' src='\\1' name='mediaPlayer' showcontrols='1' showpositioncontrols='0' showtracker='0' showdisplay='0' showstatusbar='1' aut ostart='0' volume='50' width='250' height='50'></object>",
             "\$this->hide_tag('\\1')",
             "\$this->quote_tag('\\1')"
        );
        $this->text = preg_replace('%\[(code|php|html|css|xml|javascript|java|cpp|delphi|python|ruby|sql)\](.+?)\[\/(code|php|html|css|xml|javascript|java|cpp|delphi|python|ruby|sql)\]%ies', "\$this->codes_tag('\\1', '\\2')", $this->text);
        $this->text = preg_replace($array_bb, $array_html, $this->text);
    }
    
    /**
    * Функция создания видео проигрывателя
    * 
    * @param string $url
    * @return string
    */
    function create_player($url){
    global $player_id, $tpl_create;
        $url = trim($url);
        if(empty($player_id)){
            $player_id = 1;
            $tpl_create->add2script('includes/javascript/jw/swfobject.js');
        } else $player_id++;
        $tpl_create->add2script("swfobject.registerObject('player_{$player_id}','9.0.0');", false);
        //param name='wmode' value='opaque' />
        $params = array(
            'movie'             => "includes/javascript/jw/flvplayer.swf",
            'allowfullscreen'   => "true",
            'allowscriptaccess' => "always",
            'flashvars'         => "file={$url}",
            'width'             => 540,
            'height'            => 405,
            'image'             => "includes/javascript/jw/preview.png",
            'skin'              => "includes/javascript/jw/skins/modieus/modieus.swf",
            'repeat'            => "list",
            'shuffle'           => "true"
        );
        
        $param = "";
        foreach($params as $key => $value) $params['flashvars'] = ($key!='flashvars') ? "{$key}={$value}&amp;".$params['flashvars'] : $params['flashvars'];
        foreach($params as $key => $value) $param .= "<param name='{$key}' value='{$value}' />\n";        
        return "\n<object id='player_{$player_id}' classid='clsid:D27CDB6E-AE6D-11cf-96B8-444553540000' name='player_{$player_id}' width='{$params['width']}' height='{$params['height']}'>\n{$param}".
               "<object type='application/x-shockwave-flash' data='{$params['movie']}' width='{$params['width']}' height='{$params['height']}'>\n{$param}".
               "<p><a href='http://get.adobe.com/flashplayer/'>Get Flash</a> to see this player.</p>".
               "</object>\n</object>\n";        
    }
    
    /**
    * Функция преобразования дополнительных тэгов таких как php, code, html, css…
    * 
    * @param string $type
    * @param string $code
    * @return string
    */
    function codes_tag($type, $code){
    global $syntax, $tpl_create;
        if(empty($type) OR empty($code)) return "";
        $tpl_create->add2link("includes/javascript/syntax/styles/shCore.css");
        $tpl_create->add2link("includes/javascript/syntax/styles/shThemeKasseler.css");
        $tpl_create->add2script("includes/javascript/syntax/src/shCore.js");
        $tpl_create->add2script("includes/javascript/syntax/scripts/{$syntax[strtolower($type)]}");
        $tpl_create->add2script("SyntaxHighlighter.all();", false);
        $code = str_replace('\\\\"', '"', $code);
        $code = preg_replace("/\\\\/", '\\\\\\', $code);
        $code = str_replace('\\\\', '&#92;', $code);
        $code = htmlspecialchars($code, ENT_QUOTES);
        $code = str_replace('&amp;#92;', '&#92;', $code);
        return "<pre class='brush: ".strtolower($type).";'>{$code}</pre>";
    }

    /**
    * Функция преобразования HTML в bb коды
    * 
    * @return void
    */
    function html2bb(){
        /*[X]*/
        //<img src='\\3' align='\\1' alt='\\2' title='\\2' />
        $this->text = stripcslashes($this->text);
        $array_html = array(
            '%&reg;%is',
            '%&copy;%is',
            '%&\#153;%is',
            '%<hr />%is',
            '%<h6>(.*?)</h6>%is',
            '%<h5>(.*?)</h5>%is',
            '%<h4>(.*?)</h4>%is',
            '%<h3>(.*?)</h3>%is',
            '%<h2>(.*?)</h2>%is',
            '%<h1>(.*?)</h1>%is',
            '%<s>(.*?)</s>%is',
            '%<u>(.*?)</u>%is',
            '%<i>(.*?)</i>%is',
            '%<b>(.*?)</b>%is',
            '%<li>(.*?)</li>%is',
            '%<sup>(.*?)</sup>%is',
            '%<sub>(.*?)</sub>%is',
            '%<div align=\'(.*?)\'>(.*?)</div>%is',
            '%<blockquote>(.*?)</blockquote>%is',
            '%<a href=\'engine.php\?do=redirect&amp;url=(.*?)\' target=\'_blank\' title=\'(.*?)\'>(.*?)</a>%ise',
            '%<a href=\'mailto:(.*?)\'>(.*?)</a>%is',
            '%<img src=\'(.*?)\' align=\'(.*?)\' alt=\'(.*?)\' title=\'(.*?)\' />%is',
            '%<img src=\'(.*?)\' border=\'0\' alt=\'(.*?)\' title=\'(.*?)\' />%is',
            '%<!--start\scolor--><span style=\'color:\s(.*?)\'>(.*?)</span><!--end\scolor-->%is',
            '%<!--start\sbackground--><span style=\'background:\s(.*?)\'>(.*?)</span><!--end\sbackground-->%is',
            '%<!--start\sfont-family--><span style=\'font-family:\s(.*?)\'>(.*?)</span><!--end\sfont-family-->%is',
            '%<!--start\sfont-size--><span style=\'font-size:\s(.*?)px;\'>(.*?)</span><!--end\sfont-size-->%is',
            '%<!--start\ssmile--><img src=\'(.*?)\' alt=\"(.*?)\" /><!--end\ssmile-->%ise'
        );
    
        $array_bb = array(
            "(r)",
            "(c)",
            "(tm)",
            "[hr]",
            "[h6]\\1[/h6]",
            "[h5]\\1[/h5]",
            "[h4]\\1[/h4]",
            "[h3]\\1[/h3]",
            "[h2]\\1[/h2]",
            "[h1]\\1[/h1]",
            "[s]\\1[/s]",
            "[u]\\1[/u]",
            "[i]\\1[/i]",
            "[b]\\1[/b]",
            "[li]\\1[/li]",
            "[sup]\\1[/sup]",
            "[sub]\\1[/sub]",
            "[\\1]\\2[/\\1]",
            "[blockquote]\\1[/blockquote]",
            "\$this->url2bb('\\1', '\\3')",
            "[mail=\\1]\\2[/mail]",
            "[img=\\2 alt=\\3]\\1[/img]",
            "[img alt=\\2]\\1[/img]",
            "[color=\\1]\\2[/color]",
            "[backcolor=\\1]\\2[/backcolor]",
            "[family=\\1]\\2[/family]",
            "[size=\\1]\\2[/size]",
            "preg_replace(\$this->arr_html, \$this->arr_replace, '\\2');"
        );
        
        $this->text = str_replace("&#036;", "$", $this->text);
        $this->text = str_replace("<br />", "", $this->text);
        $this->text = preg_replace('%<\!\-\-start\snobb\-\->(.+?)<\!\-\-end nobb\-\->%ies', "\$this->nobb_tag('\\1', 'decode')", $this->text);
        $this->text = preg_replace('%<\!\-\-start\sminiature\-\->(.+?)<\!\-\-end miniature\-\->%ies', "\$this->attach_tags('', '\\1', 'decode', 'miniature')", $this->text);
        $this->text = preg_replace('%<\!\-\-start\sattach\-\->(.+?)<\!\-\-end attach\-\->%ies', "\$this->attach_tags('', '\\1', 'decode', 'attach')", $this->text);
        $this->text = preg_replace($array_html, $array_bb, $this->text);
        $this->text = str_replace("<br />\r", "", $this->text);
    }
    
    /**
    * Функция преобразования прикрепленных файлов
    * 
    * @param string $tag
    * @param string $attach
    * @param string $code
    * @param string $decodetype
    * @return string
    */
    function attach_tags($tag, $attach, $code='encode', $decodetype=''){
    global $thumb;
        $thumb = (!isset($thumb) OR empty($thumb)) ? 0 : $thumb;
        $match = "";
        if($code=='encode'){
            if($tag=='attach'){
                $arr_dir = explode("/", $attach);
                $title = $arr_dir[count($arr_dir)-1];
                return "<!--start attach--><a href='engine.php?do=attach&amp;file={$attach}' title='{$title}'>{$title}</a><!--end attach-->";
            } else {
                preg_match('/(.+?)\salign=(.+?)$/is', $attach, $match);
                $arr_dir = explode("/", $match[1]);
                $title = $arr_dir[count($arr_dir)-1];
                $thumb++;
                return "<!--start miniature--><a id='thumb{$thumb}' href='".str_replace("mini-", '', $match[1])."' class='highslide' onclick='return hs.expand(this)'><img class='miniature' src='{$match[1]}' alt='{$title}' align='{$match[2]}' /></a><!--end miniature-->";                
            }
        } else {
            if($decodetype=='miniature') return "[miniature=".preg_replace('/(.+?)img class=\'miniature\' src=\'(.+?)\'\salt(.+?)$/is', '\\2', $attach)." align=".preg_replace('/(.+?)align=\'(.+?)\'(.+?)$/is', '\\2', $attach)."]";
            else return "[attach=".preg_replace('/(.+?)&amp;file=(.+?)\'\stitle(.+?)$/is', '\\2', $attach)."]";
        }
    }
    
    /**
    * Функция обработки кода nobb
    * 
    * @param string $text
    * @param string $code
    * @return string
    */
    function nobb_tag($text, $code='encode'){
        if($code=="encode") return "<!--start nobb-->".preg_replace($this->array_replace, $this->array_html, $text)."<!--end nobb-->";
        else return "[nobb]".preg_replace($this->arr_html, $this->arr_replace, $text)."[/nobb]";
    }

    /**
    * Функция обработки кода hide
    * 
    * @param string $text
    * @return string
    */
    function hide_tag($text){
    global $lang;
        return (is_support() OR is_user()) ? $text : "<div class='hide_conteiner'><div>{$lang['hide']}</div></div>";
    }

    /**
    * Функция обработки кода cite
    * 
    * @param string $text
    * @return string
    */
    function quote_tag($text=""){
    global $html;
        if ($text == "") return "";
        $text = str_replace(chr(173).']', '&#93;', $text);
        $html = $this->wrap_style('quote');
        $text = preg_replace('%\[cite\]%i', "<!--quote_start-->".$html['start'], $text);
        $text = preg_replace('%\[cite=([^\],]+?),([^\]]+?)\]%ie', "\$this->quote_user_tag('\\1', '\\2')", $text);
        $text = preg_replace('%\[cite=([^\]]+?)\]%ie', "\$this->quote_user_tag('\\1', '')", $text);
        $text = preg_replace('%\[/cite\]%i', $html['end']."<!--quote_end-->", $text);
        //$text = str_replace("\n", "<br />", $text);        
        return stripslashes($text);
    }

    /**
    * Разрешение для функции quote_tag если в теге встречается user
    * 
    * @param string $name
    * @param string $date
    * @return string
    */
    function quote_user_tag($name="", $date=""){
    global $html;
        $date = preg_replace("#:#", "&#58;", $date);
        if ($date != "") $default = '\[cite='.$name.','.$date.'\]';
        else $default = '\[cite='.$name.'\]';
        if (strstr($name, '<!--c1-->') or strstr($date, '<!--c1-->')) return $default;
        if ($date == "") $html = $this->wrap_style('quote', " ({$name})");
        else $html = $this->wrap_style('quote', " ({$name} &#064; {$date})");
        return "<!--quote_start-{$name}+{$date}-->{$html['start']}";
    }

    /**
    * Функция создания стиля для тега cite
    * 
    * @param string $type
    * @param string $extra
    * @return string
    */
    function wrap_style( $type='quote', $extra="" ){
    global $lang;
        $used = array(
            'quote'      => array('title' => $lang['quote']    , 'css_top' => 'quotetop'     , 'css_main' => 'quotemain')
        );
        return array( 'start' => "<div class='{$used[$type]['css_top']}'>{$used[ $type ]['title']}{$extra}</div><div class='{$used[$type]['css_main']}'>", 'end' => "</div>");
    }
    
    /**
    * Функция преобразования ссылок в BB коды
    * 
    * $url
    */
    function url2bb($url, $title){
        return "[url=".urldecode($url)."]{$title}[/url]";
    }

    /**
    * Функция парсинга ссылок
    * 
    * @param string $url
    * @param int $skip_it
    * @return string
    */
    function build_url($url=array(), $skip_it=0){
    global $lang;
    	$match = "";
        if(preg_match('/([.,?]|&#33;)$/', $url['html'], $match)) $url = array('end' => $match[1], 'html'   => preg_replace('/([.,?]|&#33;)$/', "", $url['html']), 'show'   => preg_replace('/([.,?]|&#33;)$/', "", $url['show']));
        if(!isset($url['end'])) $url['end'] = "";
        if (preg_match('%\[\/(html|cite|code|sql|javascript|css)%i', $url['html'])) return $url['html'];
        $url['html'] = preg_replace(array('%&amp;%', '%\[%', '%\]%', '%javascript:%i'), array("&", "%5b", "%5d", "javascript&#58; "), $url['html']);
        if (!preg_match('%^(http|news|https|ftp|aim|ed2k|magnet)://%', $url['html'])) $url['html'] = 'http://'.$url['html'];
        $url['show'] = preg_replace(array("/&amp;/", "/javascript:/i") , array("&", "javascript&#58;"), $url['show']);
        if(!preg_match('%^(http|news|https|ftp|aim|ed2k|magnet):\/\/%i', $url['show']) OR strlen($url['show'])-58<3 OR preg_match( "/^<img src/i", $url['show'])) $skip_it = 1;
        if ($skip_it!=1){
            $stripped = preg_replace('%^(http|news|https|ftp|aim|ed2k|magnet)://(\S+)$%i', "\\2", $url['show']);
            $uri_type = preg_replace('%^(http|news|https|ftp|aim|ed2k|magnet)://(\S+)$%i', "\\1", $url['show']);
            $url['show'] = "{$uri_type}://".substr($stripped, 0, 35)."...".substr($stripped, -15);
        }
        $url['st'] = (isset($url['st'])) ? $url['st'] : "";
        $site = parse_url($url['html']);
        preg_replace('/www\.(.*?)/', '\\1', $site['host']);
        return $url['st']."<a href='engine.php?do=redirect&amp;url=".urlencode($url['html'])."' target='_blank' title='{$lang['new_open_window']}'>{$url['show']}</a>{$url['end']}";
    }
}

//Создание объекта класса
$bb = new bbcode;
?>
