<?php
/**
* Класс кэширования SQL запросов
* 
* @author Igor Ognichenko
* @author Vladimer Kretov
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @filesource includes/classes/cache.class.php  
* @version 2.0
*/
if (!defined("FUNC_FILE")) die("Access is limited");

class db_cached extends sql_db{
    
    /**
    * Флаг статуса кэширования
    * 
    * @var bool
    */
    var $active = true;
    
    /**
    * Префикс таблиц
    * 
    * @var string
    */
    var $prefix = '';
    
    /**
    * Массив кэш файлов
    * 
    * @var array
    */
    var $cached = array();
    
    /**
    * Поинтер кэша
    * 
    * @var array
    */
    var $pointer = array();
    
    /**
    * Каталог для хранения кэша
    * 
    * @var string
    */
    var $cache_dir = 'uploads/cache/sql/';              
    
    /**
    * Массив индексов кэша
    * 
    * @var array
    */
    var $index_cache = array();
    
    /**
    * Файл индексов кэша
    * 
    * @var string
    */
    var $index_filename = 'index_cache';
    
    /**
    * Массив запросов, при которых удаляется кэш
    * 
    * @var array
    */
    var $reset_comm = array('INSERT', 'UPDATE', 'DELETE');
    
    /**
    * Массив таблиц, которые не кэшируются
    * 
    * @var array
    */
    var $not_cache_tables = array('sessions');
    
    /**
    * Список функция, которые не кэшируются
    * 
    * @var array
    */
    var $not_cache_func = array('NOW', 'RAND'); //array('NOW', 'UNIX_TIMESTAMP');

    /**
    * Конструктор класса
    * 
    * @param array $cfg
    * @param boot $persistency
    * @return resourse
    */
    function db_cached($cfg, $persistency = true){
    global $data;
        $this->reset_comm = explode(',', $cfg['sql_cache_clear']);
        $this->not_cache_tables = explode(',', $cfg['no_cache_tables']);        
        $this->prefix = $cfg['prefix'];
        if(kr_file_exists($this->cache_dir.$this->index_filename)){
            include_once($this->cache_dir.$this->index_filename);
            $this->index_cache = $data;
        }
        $this->sql_db($cfg, $persistency);
    }

    /**
    * Посылает запрос активной базе данных сервера
    *     
    * @param bool $transaction
    * @param string $query        
    * @return resourse
    **/
    function sql_query($query='', $transaction=false){
    global $cache_clear_ignore, $cache_ignore;
        if($cache_ignore==true) {
            //Запрос без создания кэша
            $this->query_result = parent::sql_query($query, $this->db_connect_id);
            $this->active = false;
            return;
        } else $this->active = true;
        unset($this->query_result);
        //Если нет каталога для кэша, создаем его
        if(!kr_file_exists($this->cache_dir)) kr_mkdir($this->cache_dir);
        if(!empty($query)){
            //Вычисляем crc запроса
            $file_name = crc32_integer($query).".php";
            //Проверяем наличие кэша
            if(!isset($this->cached[$file_name])){    
            	$match = "";
                if(preg_match('#([^\s]+)#i', $query, $match)) $command = strtoupper($match[1]);
                //Если SELECT делаем запрос и сохраняем кэш
                if($command=='SELECT'){
                    preg_match_all('/'.$this->prefix.'_([^`|\s]+)/i', $query, $match);
                    $tables = $match[1];
                    //Проверяем, возможно, ли кэширование текущего запроса
                    if(count(array_intersect($tables, $this->not_cache_tables))==0 AND !preg_match('#('.implode('|',$this->not_cache_func).')#i', $query)){
                        //Определяем название каталога для кэша
                        $folder_name = str_replace($this->prefix."_", "", implode('_', $tables)).'/';
                        //Проверяем наличие каталога для кэша
                        if(!kr_file_exists($this->cache_dir.$folder_name)){
                            kr_mkdir($this->cache_dir.$folder_name, 0777);
                            foreach($tables as $table){
                                $this->index_cache[$table]['data'][] = $folder_name;
                                $this->index_cache[$table]['linked'] = array_diff($tables, array($table));
                            }
                            $this->writefile($this->index_filename, '<?php '.arr2str($this->index_cache).' ?'.'>');
                        }
                        if(kr_file_exists($this->cache_dir.$folder_name.$file_name)){
                            //Если существует кэш файл запроса
                            $this->query_result = $file_name;
                            $this->readcache($folder_name.$file_name, $this->cached[$file_name]);
                            $this->pointer[$file_name] = 0;
                            $is_cached = true;
                        } else {
                            //Если не существует кэш Выполняем запрос в БД
                            $this->query_result = parent::sql_query($query, $this->db_connect_id);
                            if($this->query_result){
                                //Создаем кэш файл                                    
                                while(($tmp = parent::sql_fetchrow($this->query_result))) $this->cached[$file_name][] = $tmp;
                                $this->writecache($folder_name.$file_name, $this->cached[$file_name]);
                                $this->pointer[$file_name] = 0;
                                parent::sql_freeresult($this->query_result);
                                $this->query_result = $file_name;
                            }
                        }                        
                    } else $this->query_result = parent::sql_query($query, $this->db_connect_id);
                } else {  
                    //Если DELETE, UPDATE или INSTERT выполняем запрос и удаляем кэш таблицы
                    $this->query_result = parent::sql_query($query, $this->db_connect_id);
                    preg_match('/'.$this->prefix.'_([^`|\s]+)/i', $query, $match);                    
                    $table = isset($match[1]) ? $match[1] : "undefined";
                    if(!in_array($table, $this->not_cache_tables) AND isset($this->index_cache[$table]['data']) AND $cache_clear_ignore==false){
                        foreach($this->index_cache[$table]['data'] as $folder){
                            $this->cache_clear($folder);
                            foreach($this->index_cache[$table]['linked'] as $linked) unset($this->index_cache[$linked]['data'][$folder]);
                        }
                        if($cache_clear_ignore==false) unset($this->index_cache[$table]['data']);
                        else {
                            //Игнорируем очистку кэша
                            $index='<?php '.arr2str($this->index_cache).' ?'.'>';
                            $this->writefile($this->index_filename, $index);
                        }
                    }
                }
            }
        } else {
            $this->query_result = $file_name;
            $is_cached = true;
        }
        if(isset($this->query_result)){
            //$this->active = false;
            unset($this->row[$this->query_result], $this->rowset[$this->query_result]);
            return $this->query_result;
        } else return ($transaction == "END_TRANSACTION") ? true : false;
    }
    
    /**
    * Возвращает количество рядов результата запроса
    * 
    * @param resourse $query_id
    * @return int
    */
    function sql_numrows($query_id = 0){
        if($this->active){
            if(!$query_id) $query_id = $this->query_result;
            if($query_id){                
                if(!isset($this->cached[$query_id])) $result = parent::sql_numrows($query_id);                
                else $result = count($this->cached[$query_id]);
                if(empty($result)) $result = 0;
                return $result;
            } else return false;
        } else return parent::sql_numrows($query_id);
    }
    
    /**
    * Возвращает количество рядов, затронутых последним INSERT, UPDATE, DELETE запросом к серверу
    * 
    * @param resourse $query_id
    * @return int
    */
    function sql_fetchrow($query_id = 0) {    
        if($this->active){
            if(!$query_id) $query_id = $this->query_result;
            if($query_id) {
                if(isset($this->cached[$query_id])){
                    if($this->pointer[$query_id]<count($this->cached[$query_id])){
                        $this->row[$query_id]=$this->cached[$query_id][$this->pointer[$query_id]];
                        $this->pointer[$query_id]++;
                    } else return false;
                } else return parent::sql_fetchrow($query_id);                    
                return $this->row[$query_id];
            } else return false;
        } else return parent::sql_fetchrow($query_id);
    }
    
    /**
    * Обрабатывает ряд результата запроса, возвращая ассоциативный массив, численный массив или оба
    *     
    * @param resourse $query_id
    * @return array
    */
    function sql_fetchrowset($query_id = 0) {
        if($this->active){
            if (!$query_id) $query_id = $this->query_result;
            if ($query_id) {
                unset($this->rowset[$query_id]);
                unset($this->row[$query_id]);
                if(!isset($this->cached[$query_id])){
                    while(($this->rowset[$query_id] = parent::sql_fetchrowset($query_id))) $result[] = $this->rowset[$query_id];
                } else $result=$this->cached[$query_id];
                return $result;
            } else return false;
        } else return parent::sql_fetchrowset($query_id);
    }
    
    /**
    * Функция записи кэша в файл
    * 
    * @param string $filename
    * @param string $data
    * @return bool
    */
    function writecache($filename, &$data){
        return $this->writefile($filename, "<?php if (!defined('FUNC_FILE')) die('Illegal File Access');\n".arr2str($data)."\n?".">");
    }

    /**
    * Функция записи кэша в файл
    * 
    * @param string $filename
    * @param string $content
    * @return bool
    */
    function writefile($filename, $content){
    global $dbg_status;
        $dbg_status = false;
        //Устанавливаем, должно ли отсоединение клиента прерывать выполнение скрипта.
        if(!SAFE_MODE AND function_exists('ignore_user_abort')) ignore_user_abort(1);        
        $lockfile = $this->cache_dir.$filename.".lock";
        if(kr_file_exists($lockfile) AND time()-filemtime($lockfile)>5) kr_unlink($lockfile);
        $lock_ex = @fopen($lockfile, 'x');
        for ($i=0; ($lock_ex === false) AND ($i < 20); $i++){
            clearstatcache();
            usleep(rand(9, 75));
            $lock_ex = @fopen($lockfile, 'x');
        }
        $success = false;
        if ($lock_ex !== false) {
            $fp = @fopen($this->cache_dir.$filename, 'wb');
            if (@fwrite($fp, $content)) $success = true;
            @fclose($fp);
            @fclose($lock_ex);
            kr_unlink($lockfile);
        }
        ignore_user_abort(0);
        $dbg_status = true;
        return $success;
    }

    /**
    * Функция чтения кэш файла
    * 
    * @param string $filename
    * @param mixed $item
    * return void
    */
    function readcache($filename, &$item){
        if(kr_file_exists($this->cache_dir.$filename)) require_once $this->cache_dir.$filename;
        else $data = array();
        $item = $data;
    }
    
    /**
    * Функция удаления кэша
    * 
    * @author korsar
    * @param mstring $folder
    * @return bool
    */
    function cache_clear($folder){
        if(remove_dir("uploads/cache/sql/".$folder)) return true;
        else return false;
    }
}
?>