<?php
/**
* Класс фильтрации данных
* 
* @author Igor Ognichenko
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @filesource includes/classes/filter.class.php
* @version 2.0
*/
if (!defined("FUNC_FILE")) die("Access is limited");

class filter{
    /**
    * Тип фильтрации текста
    * 
    * @var string
    */
    var $filter_type = 'nohtml';
    
    /**
    * Тип используемого редактора
    * 
    * @var int
    */
    var $editor_type = 1;
    
    /**
    * Массив не фильтрируемых HTML тегов
    * 
    * @var array
    */
    var $html = array();
    
    /**
    * Массив кэшируемых bb кодов
    * 
    * @var array
    */
	  var $cache_code = array();

    /**
    * Функция установки параметров фильтрации
    * 
    * @param string $filter_type
    * @param int $editor_type
    * @param string $html
    */
    function set_filter_atribute($filter_type, $editor_type, $html){
        $this->filter_type = $filter_type;
        $this->editor_type = $editor_type;
        $this->html = $html;
        for ($i=0; $i<count($this->html); $i++) $this->html[$i] = trim($this->html[$i]);
    }

    /**
    * Функция удаляет обработчики событий
    * 
    * @param string $string
    * @return string
    */
    function clear_danger_html($string){
        $string = preg_replace('/onclick=[\"|\'](.+?)[\"|\']/is', "", $string);
        $string = preg_replace('/onmouseover=[\"|\'](.+?)[\"|\']/is', "", $string);
        $string = preg_replace('/onmouseout=[\"|\'](.+?)[\"|\']/is', "", $string);
        $string = preg_replace('/onmousedown=[\"|\'](.+?)[\"|\']/is', "", $string);
        $string = preg_replace('/onmouseup=[\"|\'](.+?)[\"|\']/is', "", $string);
        $string = preg_replace('/onselect=[\"|\'](.+?)[\"|\']/is', "", $string);
        $string = preg_replace('/onfocus=[\"|\'](.+?)[\"|\']/is', "", $string);
        $string = preg_replace('/onblur=[\"|\'](.+?)[\"|\']/is', "", $string);
        $string = preg_replace('/onload=[\"|\'](.+?)[\"|\']/is', "", $string);
        $string = preg_replace('/onkeydown=[\"|\'](.+?)[\"|\']/is', "", $string);
        $string = preg_replace('/onkeyup=[\"|\'](.+?)[\"|\']/is', "", $string);
        $string = preg_replace('/ondblclick=[\"|\'](.+?)[\"|\']/is', "", $string);
        $string = preg_replace('/onunload=[\"|\'](.+?)[\"|\']/is', "", $string);
        $string = preg_replace('/onmouseup=[\"|\'](.+?)[\"|\']/is', "", $string);
        $string = preg_replace('/onsubmit=[\"|\'](.+?)[\"|\']/is', "", $string);
        return $string;
    }

    /**
    * Функция удаляет весь javascript
    * 
    * @param string $string
    * @return string
    */
    function clear_javascript($string){
        $string = preg_replace('%(?is)<style(.*?)</style>%', '', $string);
        return preg_replace('%(?is)<script(.*?)</script>%', '', $string);
    }

    /**
    * Функция фильтрирует не желаемый HTML
    * 
    * @param string $tag
    * @param string $atribute
    */
    function filter_html_tags($tag, $atribute){
        if($tag[0]=="/") $search_tag = substr($tag, 1);
        else $search_tag = $tag;
        $atribute = (!empty($atribute)) ? " ".$atribute : "";
        if(in_array($search_tag, $this->html)) return "<{$tag}{$atribute}>";
        else return "&lt;{$tag}{$atribute}&gt;";
    }
    
    /**
    * Функция кэширования bb кодов
    * 
    * @param string $code
    * @param string $bb
    */
    function cache_code($code, $bb){       
        $this->cache_code[] = addslashes($code);
        return "{cache-bbcode-".(count($this->cache_code)-1)."-{$bb}}";
    }
    
    /**
    * Функция возвращает bb коды из кэша
    * 
    * @param string $code_id
    * @param string $bb
    */
    function set_cache($code_id, $bb){
        return '['.$bb.']'.$this->cache_code[$code_id].'[/'.$bb.']';
    }

    function filter_text($string){
    global $replace;
        require_once 'includes/config/replace.php';
        $string = preg_replace(explode(',', $replace['in']), explode(',', $replace['out']), $string);
        if($this->filter_type==TAGS) {
            $string = str_replace('$', "&#036;", $string);
            return strip_tags($string);
        }
        if($this->editor_type=="2"){
            $string = $this->clear_danger_html($string);
            $string = $this->clear_javascript($string);
        }
        if($this->editor_type!="2"){
            //Кэшируем bb коды
            $string = preg_replace('/\[(code|php|html|css|xml|javascript|java|cpp|delphi|python|ruby|sql)\](.+?)\[\/(code|php|html|css|xml|javascript|java|cpp|delphi|python|ruby|sql)\]/ies', "\$this->cache_code('\\2', '\\1')", $string);
            //Удаляем недопустимый HTML
            $string = preg_replace('%<(/?[[:alpha:]|\!\?]*)[[:space:]]*([^>]*)>%ise', "\$this->filter_html_tags('\\1', '\\2')", $string);
            //Возвращаем bb коды из кэша
            $string = preg_replace('/\{cache-bbcode-([0-9]+)-([a-zA-z]+)\}/e', "\$this->set_cache('\\1', '\\2')", $string);
            return $string;
        } else return $string;
    }
}

//Создание объекта класса
$filter = new filter;
?>