<?php
/**
* Класс отправки электронной почты
* 
* @author Igor Ognichenko
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @filesource includes/classes/mail.class.php
* @version 2.0
*/
if (!defined("FUNC_FILE")) die("Access is limited");

class mailman {
    /**
    * Конец строки последовательности
    *
    * @var string
    */
    var $sep = "\r\n";
    
    /**
    * Разделитель вложений
    * 
    * @var string
    */
    var $bnd = "-------";
    
    /**
    * Прикреплен ли к письму файл
    *   
    * @var bool
    */
    var $is_attache = false; 
    
    /**
    * Отправлять письмо в формате HTML
    * 
    * @var bool
    */
    var $is_html = false;
    
    /**
    * Запрашивать уведомление о получении почты
    * 
    * @var bool
    */
    var $receipt = false;  
    
    /**
    * Активировать log отправки сообщений
    * 
    * @var bool
    */
    var $log = false;
    
    /**
    * Использовать SMTP отправку
    * 
    * @var bool
    */
    var $smtp = false;
    
    /**
    * Активировать отправку сообщений
    * 
    * @var bool
    */
    var $sending = true;
    
    /**
    * Уровень важности письма
    * 
    * @var int
    */
    var $priority = 3;
    
    /**
    * Кодировка сообщения
    * 
    * @var string
    */
    var $charset = "UTF-8";
    
    /**
    * Каталог для хранения eml файлов
    * 
    * @var string
    */
    var $path_log = 'uploads/logs/mails/';
    
    /**
    * Массив прикрепленных файлов
    * 
    * @var mixed
    */
    var $parts = array();
    
    /**
    * log текущего сообщения
    * 
    * @var string
    */
    var $log_txt = '';
    
    /**
    * Статус подключения к SMTP серверу
    * 
    * @var mixed
    */
    var $smtp_fp = false;
    
    /**
    * Сообщение от SMTP сервера при отправке почты
    * 
    * @var string
    */
    var $smtp_msg = "";
    
    /**
    * Адрес SMTP сервера
    * 
    * @var string
    */    
    var $smtp_host = "localhost";
    
    /**
    * Порт SMTP сервера
    * 
    * @var int
    */
    var $smtp_port = 25;
    
    /**
    * Пользователь SMTP сервера
    * 
    * @var string
    */
    var $smtp_user = "";
    
    /**
    * Пароль пользователя SMTP сервера
    * 
    * @var string
    */
    var $smtp_pass = "";
    
    /**
    * Код ответа от SMTP сервера
    * 
    * @var mixed
    */
    var $smtp_code = "";
    
    /**
    * Конструктор
    * 
    * @param mixed $params
    * @return mailman
    */
    function mailman($params=array()){
    global $config;
        //Создаем bnd длиной 25 цифр
        $this->bnd = rand(10000, 99999).rand(10000, 99999).rand(10000, 99999).rand(10000, 99999).rand(10000, 99999);
        $this->smtp_host = $config['smtp_host'];      //Устанавливаем хост
        $this->smtp_port = $config['smtp_port'];      //Устанавливаем порт
        $this->smtp_user = $config['smtp_user'];      //Устанавливаем пользователя
        $this->smtp_pass = $config['smtp_password'];  //Устанавливаем пароль пользователя
    }
    
    /**
    * Функция отправки сообщения 
    * 
    * @param string $recipients
    * @param array $headers
    * @param string $body
    * @return bool
    */
    function send($recipients, $headers=array(), $body){
        if(!$this->is_html) $body = str_replace("<br />", "\n", $body);
        $sets = $this->headers($headers, $body);
        $to = is_array($recipients)?implode(', ', $recipients):$recipients;
        $this->log($sets['headers'], $sets['subject'], $body);
        $body = (!$this->is_attache) ? $body : '';
        if(!$this->smtp){
            if($this->sending) $return = mail($to, $sets['subject'], $body, $sets['headers']);
            else $return = true;
        } else {
            if($this->sending) $return = $this->smtp_send($sets['subject'], $sets['headers'], $headers, $body);
            else $return = true;
        }        
        return $return;
    }
    
    /**
    * Функция создания заголовка
    * 
    * @param array $header
    * @param string $body
    * @return array
    */
    function headers($header, $body=""){
    global $ip;
        $def_headers = array(
            'Subject'                    => '[ No subject ]',                          //Тема письма
            'Message-ID'                 => '',                                        //Уникальный идентификатор сообщения
            'Date'                       => date('r'),                                 //Дата написания письма
            'From'                       => '',                                        //Имя и адрес отправителя
            'Sender'                     => '',                                        //Отправитель письма
            'User-Agent'                 => 'Thunderbird 2.0.0.20 (Windows/20090302)', //Идентификатор клиента с которого было отправлено письмо            
            'Sender-IP'                  => $ip,                                       //IP адрес отправителя
            'X-Priority'                 => '3',                                       //Уровень важности сообщения от 1 до 5
            'X-Mailer'                   => 'Kasseler Mailer 2',                       //Идентификатор скрипта отправки
            'MIME-Version'               => '1.0',                                     //Версия MIME, с которым это сообщение создано
            'To'                         => '',                                        //Имя и адрес получателя
            'Cc'                         => '',                                        //Содержит имена и адреса к которым направляется копия
            'Bcc'                        => '',                                        //Содержит имена и адреса получателей письма, чьи адреса не следует показывать другим получателям
            'Reply-To'                   => ''                                         //Имя и адрес, куда следует адресовать ответы на это письмо.
        );
        foreach($def_headers as $key => $value){
            $headers[$key] = isset($header[$key]) ? (is_array($header[$key])?implode(', ', $header[$key]):$header[$key]) : $value;
            if(empty($headers[$key])) unset($headers[$key]);
        }
        
        $headers['Reply-To'] = !isset($headers['Reply-To']) ? $headers['From'] : $headers['Reply-To'];
        if($this->receipt) $headers['Return-Receipt-To'] = !isset($headers['Return-Receipt-To']) ? $headers['From'] : $headers['Return-Receipt-To'];
        $headers['Message-ID'] = !isset($headers['Message-ID']) ? "<".dechex(time()).".".time()."@".((substr($_SERVER['HTTP_HOST'], 0, 4)=='www.')?str_replace("www.", "", $_SERVER['HTTP_HOST']):$_SERVER['HTTP_HOST']).">" : $headers['Message-ID'];        
        //$headers['Subject'] = "=?{$this->charset}?B?".base64_encode($headers['Subject'])."=?=";
        //$headers['From'] = "=?{$this->charset}?B?".base64_encode($headers['From'])."=?=";

        $subject = $headers['Subject']; 
        if(!$this->smtp) unset($headers['Subject']); //Удаляем Subject с Header так как в mail() Заголовок сообщения передается отдельно
        
        $head = $this->text_headers($this->sanitize_headers($headers));
        if($this->is_attache){
            $attach = $this->attache2header();
            $head .= "Content-Type: multipart/mixed;{$this->sep} ".'boundary="------------'.$this->bnd.'"'.$this->sep.$this->sep.
            "This is a multi-part message in MIME format.".$this->sep."--------------".$this->bnd.$this->sep.
            "Content-Type: text/".(!$this->is_html ? "plain" : "html")."; charset={$this->charset}; format=flowed".$this->sep.
            "Content-Transfer-Encoding: 7bit".$this->sep.$this->sep.
            $body.$this->sep.$this->sep."--------------".$this->bnd.$this->sep.
            $attach."--";
        } else {
            $head .= "Content-Type: text/".(!$this->is_html ? "plain" : "html")."; charset={$this->charset}; format=flowed".$this->sep.
            "Content-Transfer-Encoding: 7bit".$this->sep;
        }
        return array("subject" => $subject, "headers" => $head);
    }
    
    /**
    * Добавляет файлы в список вложений.
    * 
    * @param string $file
    * @param array $conf
    * @return bool
    */        
    function add_attachment($file, $conf=array()){
    global $MIME;
        $this->is_attache = true;
        $def_conf = array(
            'isfile'      => true,
            'c_type'      => 'application/octet-stream',
            'description' => 'inline',
            'name'        => '',
        );        
        foreach($def_conf as $key => $value) $conf[$key] = !isset($conf[$key]) ? $value : $conf[$key];
        $filedata = ($conf['isfile'] === true) ? $this->file2str($file) : $file;
        if ($conf['isfile'] === true) $filename = (strlen($conf['name'])) ? $conf['name'] : $file;
        else $filename = $conf['name'];
        $filename = basename($filename);
        //Определяем и устанавливаем MIME для прикрепленного файла
        $exp = get_type_file($filename);
        $conf['c_type'] = (isset($MIME[$exp])) ? $MIME[$exp] : $conf['c_type'];
        $this->parts[] = array(
            'body'        => rtrim(chunk_split(base64_encode($filedata), 72, $this->sep)),
            'name'        => $filename,
            'c_type'      => $conf['c_type'],
            'description' => "inline"
        );
        return true;
    }
    
    /**
    * Получить содержимое данного файла как строку
    * 
    * @param string $file_name
    * @param string $cont
    * @return string
    */
    function file2str($file_name){
        if(($fd = fopen($file_name, 'rb'))){
            $filesize = kr_filesize($file_name);
            if($filesize>0){ 
                $cont = fread($fd, $filesize);
            } else $cont =  "";
            fclose($fd);
        }
        return $cont;
    }
    
    /**
    * Функция создания заголовка прикрепленных файлов
    * 
    * @return string
    */    
    function attache2header(){    
        $attache = "";
        $count = count($this->parts);
        $i=1;
        foreach($this->parts as $value){
            $headers = array(
                'Content-Type'              => "{$value['c_type']};{$this->sep} name=\"{$value['name']}\"",
                'Content-Transfer-Encoding' => 'base64',
                'Content-Disposition'       => "{$value['description']};{$this->sep} filename=\"{$value['name']}\"",
            );
            $attache .= $this->text_headers($headers).$this->sep.$value['body']."{$this->sep}--------------{$this->bnd}";
            $attache .= ($count>$i) ? $this->sep : "";
            $i++;
        }        
        return $attache;
    }

    /**
    * Функция нормализации заголовка
    * 
    * @param array $headers
    * @return array
    */
    function sanitize_headers($headers){
        foreach ($headers as $key => $value) $headers[$key] = preg_replace('=((<CR>|<LF>|0x0A/%0A|0x0D/%0D|\\n|\\r)\S).*=i', null, $value);        
        return $headers;
    }
   
    /**
    * Функция создания текстового заголовка 
    * 
    * @param array $headers
    * @param string $return
    * @return string
    */
    function text_headers($headers, $return=''){
        foreach ($headers as $key => $value) $return .= $key.': '.$value.$this->sep;
        return $return;
    }
    
    /**
    * Функция логирования отправки писем
    * 
    * @param string $headers
    * @param string $subject
    * @param string $body
    * @return bool
    */
    function log($headers, $subject, $body){
        if($this->log == false) return false;
        if(!$this->is_attache){
            $this->log_txt = (!$this->smtp) ? "Subject: {$subject}{$this->sep}".$headers : $headers;
            $this->log_txt .= $this->sep.$body;
        } else $this->log_txt = (!$this->smtp) ? "Subject: {$subject}{$this->sep}".$headers : $headers;
        $log_name = time().".".dechex(time()).".".rand(10000, 99999).".eml";
        $file = fopen($this->path_log.$log_name, "w");
        fputs ($file, $this->log_txt);
        fclose ($file);
        return true;
    }
    
    /**
    * Функция очистки
    * 
    * @return void
    */
    function clear(){
        $this->parts = array();
        $this->is_attache = false;
        $this->log_txt = '';
    }
    
    /**
    * Функция читает код ответа от сервера
    * 
    * @return void
    */
    function smtp_get_line(){
        $this->smtp_msg = "";
        while(($line = fgets($this->smtp_fp, 515))){
            $this->smtp_msg .= $line;
            if(substr($line, 3, 1) == " ") break;
        }
    }
    
    /**
    * Функция отправляет команду SMTP серверу
    * 
    * @param string $cmd
    * @return bool
    */
    function smtp_send_cmd($cmd){
        $this->smtp_msg  = "";
        $this->smtp_code = "";
        fputs($this->smtp_fp, $cmd."\r\n");
        $this->smtp_get_line();    
        $this->smtp_code = substr($this->smtp_msg, 0, 3);
        return $this->smtp_code == "" ? false : true;
    }
  
    /**
    * Функция устанавливает ошибку SMTP сервера
    * 
    * @param mixed $err
    * @return bool
    */
    function smtp_error($err = ""){
        $this->smtp_msg = $err;
        return false;
    }
  
    /**
    * Функция корректирует crlf для отправки SMTP серверу
    * 
    * @param string $data
    * @return string
    */
    function smtp_crlf_encode($data){
        $data .= "\n";
        $data = str_replace("\n", "\r\n", str_replace("\r", "", $data));
        $data = str_replace("\n.\r\n" , "\n. \r\n", $data);
        return $data;
    }
    
    /**
    * Функция выполняет отправку сообщения SMTP серверу.
    * 
    * @param string $subject
    * @param string $headers
    * @param array $headers_arr
    * @param string $body
    * @return bool 
    */
    function smtp_send($subject, $headers, $headers_arr, $body=""){
        //Подключение к SMTP серверу
        $errno = $errstr = "";
        $this->smtp_fp = @fsockopen($this->smtp_host, intval($this->smtp_port), $errno, $errstr, 30);
        if(!$this->smtp_fp){ 
            //Не удалось подключится к SMTP серверу
            $this->smtp_error("Could not open a socket to the SMTP server");
            return false;
        }
        $this->smtp_get_line();
        $this->smtp_code = substr($this->smtp_msg, 0, 3);
        if($this->smtp_code == 220){
            $data = $this->smtp_crlf_encode($headers."\n" . $body);
            $this->smtp_send_cmd("HELO ".$this->smtp_host);
            if($this->smtp_code != 250){
                $this->smtp_error("HELO");
                return false;
            }
            if(!empty($this->smtp_user) AND !empty($this->smtp_pass)){
                $this->smtp_send_cmd("AUTH LOGIN");
                if($this->smtp_code == 334){
                    $this->smtp_send_cmd(base64_encode($this->smtp_user));
                    if($this->smtp_code != 334){
                        //Имя пользователя не принято SMTP сервером
                        $this->smtp_error("Username not accepted from the server");
                        return false;
                    }
                    $this->smtp_send_cmd(base64_encode($this->smtp_pass));
                    if($this->smtp_code != 235){
                        //Пароль не принят SMTP сервером
                        $this->smtp_error("Password not accepted from the SMTP server");
                        return false;
                    }
                } else {
                    //Сервер не поддерживает авторизацию пользователей
                    $this->smtp_error("This SMTP server does not support authorisation");
                    return false;
                }
            }
            $this->smtp_send_cmd("MAIL FROM:".$headers_arr['From']);
            if($this->smtp_code != 250){
                //Не корректный E-mail адрес отправителя
                $this->smtp_error("Incorrect FROM address: {$headers_arr['From']}");
                return false;
            }
            $to_arry = array($headers_arr['To']);
            foreach($to_arry as $to_email){
                $this->smtp_send_cmd("RCPT TO:".$to_email);
                if($this->smtp_code != 250){
                    $this->smtp_error("Incorrect email address: {$to_email}");
                    return false;
                    break;
                }
            }      
            $this->smtp_send_cmd("DATA");
            if($this->smtp_code == 354){
                fputs($this->smtp_fp, $data."\r\n");
            } else {
                //Ошибка записи к SMTP серверу
                $this->smtp_error("Error on write to SMTP server");
                return false;
            }      
            $this->smtp_send_cmd(".");
            if($this->smtp_code != 250){
                $this->smtp_error();
                return false;
            }      
            $this->smtp_send_cmd("quit");
            if($this->smtp_code != 221){
                $this->smtp_error();
                return false;
            }      
            @fclose($this->smtp_fp);
            return true;
        } else {
            $this->smtp_error("SMTP service unaviable");
            return false;
        }
    }
}