<?php
/**
* Основной класс системы
* 
* @author Igor Ognichenko
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @filesource includes/classes/main.class.php
* @version 2.0
*/
if (!defined("FUNC_FILE")) die("Access is limited");

class main {
    /**
    * Параметр ЧПУ
    * 
    * @var bool
    */
    var $mod_rewrite = false;
    
    /**
    * Массив ссылок
    * 
    * @var array
    */
    var $links = array();
    
    /**
    * Название текущего модуля
    * 
    * @var string
    */
    var $module;
    
    /**
    * Заголовок текущего модуля
    * 
    * @var string
    */
    var $title;
    
    /**
    * Название текущего шаблона
    * 
    * @var string
    */
    var $tpl;
    
    /**
    * Информация о пользователе
    * 
    * @var array
    */
    var $user;
    
    /**
    * Текущая локализация
    * 
    * @var string
    */
    var $language;
    
    /**
    * Объект базы данных
    * 
    * @var object
    */
    var $db;
    
    /**
     * Языковый параментр
     * 
     * @var string
     */
    var $lang;
    
    /**
    * Массив изображений
    * 
    * @var array
    */
    var $img;
    
    /**
    * IP адрес пользователя
    * 
    * @var string
    */
    var $ip;
    
    /**
    * USER AGENT пользователя
    * 
    * @var string
    */
    var $agent;
    
    /**
    * Общая конфигурация системы
    * 
    * @var array
    */
    var $config;
    
    /**
    * REFERER пользователя
    * 
    * @var string
    */
    var $ref;
    
    /**
    * REQUEST_URI пользователя  
    * 
    * @var string
    */
    var $uri;
    
    /**
    * Доменное имя сайта
    * 
    * @var string
    */
    var $host;
    
    /**
    * Массив правил для добавления пунктов
    * 
    * @var array
    */
    var $points;
    
    /**
    * Флаг идентификатора
    * 
    * @var bool
    */
    var $rewrite_id = true;
    
    /**
    * Конструктор класса
    * 
    * @return void
    */
    function main(){
    global $config;
        if($config['rewrite']==ENABLED) $this->mod_rewrite = true;
    }
    
    /**
    * Инициализация глобальных переменных
    * 
    * @return void
    */
    function init(){
    global $module_name, $userinfo, $load_tpl, $db, $lang, $module_title, $language, $img, $ip, $agentinfo, $config, $points;
        $this->module = &$module_name;
        $this->tpl = &$load_tpl;
        $this->title = &$module_title;
        $this->user = &$userinfo;
        $this->db = &$db;
        $this->lang = &$lang;
        $this->language = &$language;
        $this->img = &$img;
        $this->ip = &$ip;
        $this->agent = &$agentinfo;
        $this->config = &$config;
        $this->points = &$points;
        $referer=get_env('HTTP_REFERER');
        $this->ref = (isset($referer) ? $referer : "");
        $this->uri = get_env('REQUEST_URI');
        $this->host = get_host_name();
    }

    /**
    * Функция генерации ссылок
    * 
    * @param array $link
    * @param string $return
    * @param array $addon дополнительные параметры(jscript линки)
    * @return string
    */
    function url($link, $type_link="", $return="",$addon=array()){
    global $config, $languages2code;
        if($config['multilanguage']==ENABLED AND isset($_COOKIE['lang']) AND count($link)>0 AND isset($languages2code[$_COOKIE['lang']])) $link = array('lang' => $languages2code[$_COOKIE['lang']])+$link;
        if(count($link)==0) return 'http://'.get_host_name().'/';
        else {
            if($this->mod_rewrite){
                foreach ($link as $kay=>$value) $return .= $config['separator_rewrite'].$value;
                $return = substr($return, 1).$config['file_rewrite'];
            } else {
                $is_java_link=array_key_exists('jscript',$addon);
                foreach ($link as $kay=>$value) $return .= "{$kay}={$value}".($is_java_link?"&":"&amp;");
                $return = (empty($type_link)?"index.php?":"{$type_link}?").substr($return, 0, ($is_java_link?strlen($return)-1:strlen($return)-5));
            }
        }
        $this->links[] = $return;
    return 'http://'.get_host_name().'/'.$return;
    }
    
    /**
    * Функция разбора конфигурации ЧПУ
    * 
    * @param array $mod
    * @return void
    */
    function parse_rewrite($mod=array()){
    global $rewrite, $config, $code2languages;
        if(!isset($_GET['mod_rewrite'])){
            $this->rewrite_id = false;
            return false; 
        } else foreach($_GET as $kay=>$value) unset($kay);
        $rewrite = (empty($mod)) ? $rewrite : $mod;
        $file_type = explode($config['file_rewrite'], substr(get_env('REQUEST_URI'), 1));
        $key_corect = 0;
        foreach($_GET as $key => $value) if($key!='mod_rewrite') unset($_GET[$key]);
        foreach (explode($config['separator_rewrite'], $file_type[0]) as $kay=>$value){
            if($config['multilanguage']==ENABLED AND isset($code2languages[$value])){
                if(!isset($_COOKIE['lang']) OR $_COOKIE['lang']!=$code2languages[$value]) setcookies($code2languages[$value], 'lang');
                $_COOKIE['lang'] = $code2languages[$value];
                $key_corect++;
                continue;
            }
            if(preg_match('/(\.\.\/|[\'"]|<|>|\(+)/s', $value)) kr_http_ereor_logs("403");
            elseif(isset($rewrite[$kay-$key_corect])) $_GET[$rewrite[$kay-$key_corect]] = (strpos($value, "%") === false) ? strip_tags($value) : strip_tags(utf8decode(urldecode($value)));
        }
        return true;
    }
}
$main = new main();

?>