<?php
/**
* Класс для работы системы с СУБД MySQL
* 
* @author Igor Ognichenko
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @filesource includes/classes/mysql.class.php
* @version 2.0
*/
if (!defined("FUNC_FILE")) die("Access is limited");
define("DB", true);

class sql_db{
    var $db_connect_id;
    var $query_result;
    var $row = array();
    var $rowset = array();
    var $num_queries = 0;
    var $total_time_db = 0;
    var $time_query = "";
    var $report_error = true;
    var $error = "";
    var $errno = "";

    /**
    * Конструктор класса
    * 
    * @param array $cfg
    * @param boot $persistency
    * @return resourse
    */
    function sql_db($cfg, $persistency = true) {
        $this->db_connect_id = ($persistency) ? @mysql_pconnect($cfg['host'], $cfg['user'], $cfg['password']) : 
        @mysql_connect($cfg['host'], $cfg['user'], $cfg['password']);
        if ($this->db_connect_id) {
            if ($cfg['name'] != "" && !@mysql_select_db($cfg['name'],$this->db_connect_id)) {
                @mysql_close($this->db_connect_id);
                $this->db_connect_id = false;
            }
            if(!empty($cfg['charset'])) @mysql_query("SET NAMES '{$cfg['charset']}'",$this->db_connect_id);
            return $this->db_connect_id;
        } else {
            return false;
        }
    }

    /**
    * Закрывает соединение с сервером
    *     
    * @return bool
    */
    function sql_close() {
        if ($this->db_connect_id) {
            if ($this->query_result) @mysql_free_result($this->query_result);
            $result = @mysql_close($this->db_connect_id);
            return $result;
        } else {
            return false;
        }
    }

    /**
    * Посылает запрос активной базе данных сервера
    *     
    * @param bool $transaction
    * @param string $query        
    * @return resourse
    **/
    function sql_query($query = "", $transaction = false) {
        if($this->db_connect_id) {
            unset($this->query_result);
            if($query != "") {
                $st = microtime(1);            
                $this->query_result = @mysql_query($query, $this->db_connect_id);            
                $total_tdb = round(microtime(1)-$st, 5);
                $this->total_time_db += $total_tdb;
                $this->time_query .= ($total_tdb > 0.01) ? "<div align='left' class='debbug_query'><font color='red' style='float: left;'><b>{$total_tdb}</b></font><pre>[".htmlspecialchars(trim($query), ENT_QUOTES)."]</pre></div>\n" : "<div align='left'><font color='green' style='float: left;'><b>{$total_tdb}</b></font><pre>[".htmlspecialchars(trim($query), ENT_QUOTES)."]</pre></div>\n";
            }                                                                                
            if($this->query_result) {                   
                $this->num_queries+=1;
                unset($this->row[$this->query_result]);
                unset($this->rowset[$this->query_result]);
                $this->error = "";
                $this->errno = "";
                return $this->query_result;
            } else {    
                $this->error = $this->sql_error($this->db_connect_id);
                $this->errno = $this->sql_errno($this->db_connect_id);
                if($this->report_error) kr_sql_erorr_logs($this->sql_errno($this->db_connect_id), $this->sql_error($this->db_connect_id), $query);
                return ($transaction == "END_TRANSACTION") ? true : false;
            }
        } else return false;
    }        
    
    /**
    * Возвращает количество рядов результата запроса
    * 
    * @param resourse $query_id
    * @return int
    */
    function sql_numrows($query_id = 0) {
        if(!$query_id) $query_id = $this->query_result;
        if($query_id) {
            $result = @mysql_num_rows($query_id);
            return $result;
        } else {
            return false;
        }
    }

    /**
    * Возвращает количество рядов, затронутых последним INSERT, UPDATE, DELETE запросом к серверу
    * 
    * @param resourse $query_id
    * @return int
    */
    function sql_affectedrows() {
        if($this->db_connect_id) {
            $result = @mysql_affected_rows($this->db_connect_id);
            return $result;
        } else {
            return false;
        }
    }

    /**
    * Возвращает количество полей результата запрооса  
    * 
    * @param resourse $query_id
    * @return int
    */
    function sql_numfields($query_id = 0) {
        if(!$query_id) $query_id = $this->query_result;
        if($query_id) {
            $result = @mysql_num_fields($query_id);
            return $result;
        } else {
            return false;
        }
    }

    /**
    * Возвращает название колонки с указанным индексом
    *                                                                                           
    * @param int $offset
    * @param resourse $query_id
    * @return string
    */
    function sql_fieldname($offset, $query_id = 0) {
        if(!$query_id) $query_id = $this->query_result;
        if($query_id) {
            $result = @mysql_field_name($query_id, $offset);
            return $result;
        } else {
            return false;
        }
    }

    /**
    * Возвращает тип колонки с указанным индексом
    *     
    * @param int $offset
    * @param resourse $query_id
    * @return string
    */
    function sql_fieldtype($offset, $query_id = 0) {
        if(!$query_id) $query_id = $this->query_result;
        if($query_id){
            $result = @mysql_field_type($query_id, $offset);
            return $result;
        } else {
            return false;
        }
    }
    
    /**
    * Возвращает массив с обработанным рядом результата запроса
    * 
    * @param resourse $query_id
    * @param bool $debug
    * @return array
    */
    function sql_fetchrow($query_id = 0) {
        if(!$query_id) $query_id = $this->query_result;
        if($query_id) {
            @$this->row[@$query_id] = @mysql_fetch_array($query_id);
            return @$this->row[@$query_id];
        } else {
            return false;
        }
    }

    /**
    * Обрабатывает ряд результата запроса, возвращая ассоциативный массив, численный массив или оба
    *     
    * @param resourse $query_id
    * @return array
    */    
    function sql_fetchrowset($query_id = 0) {
        if(!$query_id) $query_id = $this->query_result;
        if($query_id) {
            unset($this->rowset[$query_id]);
            unset($this->row[$query_id]);
            while(($this->rowset[$query_id] = @mysql_fetch_array($query_id))){
                $result[] = $this->rowset[$query_id];
            }
            return $result;
        } else {
            return false;
        }
    }

    /**
    * Перемещает внутренний указатель в результате запроса к ряду с указанным номером
    *   
    * @param int $rownum
    * @param resourse $query_id
    * @return bool
    */
    function sql_rowseek($rownum, $query_id = 0) {
        if (!$query_id) $query_id = $this->query_result;
        if ($query_id) {
            $result = @mysql_data_seek($query_id, $rownum);
            return $result;
        } else {
            return false;
        }
    }

    /**
    * Возвращает ID, сгенерированный колонкой с AUTO_INCREMENT последним запросом INSERT к серверу
    *     
    * @param resourse $query_id
    * @return int
    */
    function sql_nextid($query_id = "") {
        if ($this->db_connect_id) {
            $result = @mysql_insert_id($this->db_connect_id);
            return $result;
        } else {
            return false;
        }
    }

    /**
    * Высвободит всю память, занимаемую результатом, на который ссылается переданный функции указатель
    * 
    * @param resourse $query_id
    * @return bool
    */
    function sql_freeresult($query_id = 0){
        if (!$query_id) $query_id = $this->query_result;
        if ($query_id) {
            unset($this->row[$query_id]);
            unset($this->rowset[$query_id]);
            @mysql_free_result($query_id);
            return true;
        } else {
            return false;
        }
    }
    
    /**
    * Возвращает численный код ошибки выполнения последней операции с MySQL
    * 
    * @param resource $query_id
    * @return int
    */
    function sql_errno($query_id = 0){
        if(!$query_id) $query_id = $this->query_result;
        if($query_id) {
            return @mysql_errno($query_id);
        } else return false;
    }

    /**
    * Возвращает строку ошибки последней операции с MySQL.
    * 
    * @param resource $query_id
    * @return string
    */
    function sql_error($query_id = 0){
        if(!$query_id) $query_id = $this->query_result;
        if($query_id) {
            return @mysql_error($query_id);
        } else return false;
    }
}

global $database;
if(kr_file_exists('includes/classes/cache.class.php') AND $database['cache']==ENABLED){
    require_once 'includes/classes/cache.class.php';
    $db = new db_cached($database, false);
} else $db = new sql_db($database, false);
if (!$db->db_connect_id && !defined("INSTALLCMS") AND !isset($_GET['ajaxed'])) die("<br /><center>There seems to be a problem with the MySQL server, sorry for the inconvenience. We should be back shortly.</center>");
?>
