<?php
/**
* Класс создания дерево-видных структур
* 
* @author Igor Ognichenko
* @author Brovko Dmitry
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @filesource includes/classes/treedb.class.php  
* @version 2.0
*/
if (!defined('FUNC_FILE')) die('Access is limited');

class treedb {
    /**
    * Обрабатываемая таблица
    * 
    * @var string
    */
    var $table = "";
    var $count_char_in_level=2;
    var $pack_db_after_remove=TRUE;
    var $code_num_db=36;// основание для кодирования числе в БД
    
    /**
    * Конструктор
    * 
    * @param string $table
    * @return treedb
    */
    function treedb($table,$count_char_level=2){
        $this->table = $table;
        $this->count_char_in_level=$count_char_level;
    }
    function get_one_value($sql){
        $result = $main->db->sql_query($sql);
        $row = $main->db->sql_fetchrow($result);
        return $row[0];
    }
    /**
    * Получение нового(максимального знячения для .tree
    * 
    * @param string $parent
    * @return string
    */
    function get_max_id($parent){
    global $main;
        $s_zero="0000000000";
        $code_num=$this->code_num_db;
        $level=$this->count_char_in_level;
        $scase="when 0 then ''";
        for($i=1;$i<$level;$i++){;
            $lzero=substr($s_zero,1,$level-$i);
            $scase.="\n when 1 then '{$lzero}'";
        }
       $result = $main->db->sql_query("select if(isnull(max(t.tree)),'{$parent}01',\n".
                "concat(case mod(LenGth(conv(conv(max(t.tree),{$code_num},10)+1,10,{$code_num})),{$this->count_char_in_level})\n{$scase}\n".
                "end,conv(conv(max(t.tree),{$code_num},10)+1,10,{$code_num}))) newid\n".
                "from  {$this->table} t \n".
                "where t.tree LIKE '{$parent}__'");
         $row = $main->db->sql_fetchrow($result);
         return $row['newid'];
    }
    /**
    * Добавление ветки дерева
    * 
    * @param string $parent
    * @param string $sql_insert
    * @return string
    */
    function append($parent, $sql_insert){
    global $main;
         $main->db->sql_query(preg_replace('/\{IDTREE\}/i', $this->get_max_id($parent), $sql_insert));
    }
    /**
    * Сдвиг вверх поля tree после операций move и delete
    * 
    * @param string $parent
    */
    function pack_after($parent){
    global $main;
        if ($this->pack_db_after_remove) {
            $new_like = substr($parent,0,strlen($parent)-$this->count_char_in_level);
            $sql="update {$this->table} t \nset t.tree=".$this->get_concat_param($parent,FALSE)."\n".
                 "where t.tree like '{$new_like}%' and t.tree>'{$parent}' ";
            $main->db->sql_query($sql);
        }
    }
    /**
    * Удаление ветки дерева
    * 
    * @param mixed $parent
    * @return void
    */
    function delete($parent){
    global $main;
        $main->db->sql_query("DELETE FROM {$this->table} WHERE tree LIKE '{$parent}%'");
        $this->pack_after($parent);
    }
    /**
    * возвращает строку concat для сдвигов веток по дереву
    * 
    * @param string $parent (ветка от которой происходит сдвиг)
    * @param boolean $down_shift( сдвиг вниз?)
    */
    function get_concat_param($parent,$down_shift){
        $s_zero="0000000000";
        $code_num=$this->code_num_db;
        $lenparent=strlen($parent);
        $level=$this->count_char_in_level;  
        $scase="when 0 then ''";
        for($i=1;$i<$level;$i++){;
            $lzero=substr($s_zero,1,$level-$i);
            $scase.="\nwhen {$i} then '{$lzero}'";
        }
      return  "concat(case mod(length(conv(conv(substring(t.tree,1,{$lenparent}),{$code_num},10)".($down_shift?"+":"-")."1,10,{$code_num})),{$level})\n".
            "{$scase} \n".
            "end ,conv(conv(substring(t.tree,1,{$lenparent}),{$code_num},10)".($down_shift?"+":"-")."1,10,{$code_num}),substring(t.tree,".++$lenparent.",LenGth(t.tree)-{$level}))";
    }
    /**
    * Вставка ветки перед заданным элементом
    * 
    * @param string $parent
    * @param string $sql_insert
    * @return void
    */
    function insert_before($parent, $sql_insert){
    global $main;
        $code_num = $this->code_num_db;
        $new_like = substr($parent,0,strlen($parent)-$this->count_char_in_level);
        $sql="update {$this->table} t \nset t.tree=".$this->get_concat_param($parent,TRUE)."\n".
            "where t.tree like '{$new_like}%' and t.tree>='{$parent}'";
        $main->db->sql_query($sql);
        $main->db->sql_query(preg_replace('/\{IDTREE\}/i', $parent, $sql_insert));
    }
    /**
    * Вставка ветки после заданным элементом
    * 
    * @param string $parent
    * @param string $sql_insert
    * @return void
    */
    function insert_after($parent, $sql_insert){
    global $main;
        $s_zero="0000000000";
        $code_num=$this->code_num_db;
        $level=$this->count_char_in_level;  
        $new_like = substr($parent,0,strlen($parent)-$level);
        $sql="update {$this->table} t \nset t.tree=".$this->get_concat_param($parent,TRUE)."\n".
            "where t.tree like '".$new_like."%' and t.tree>'".$parent."' and not(t.tree like '".$parent."%')";
        $main->db->sql_query($sql);
        $new_id=base_convert(base_convert($parent,$code_num,10)+1,10,$code_num);
        $n=$level-(strlen($new_id) % $level);
        $new_id=substr($s_zero,1,$n).$new_id;
        $main->db->sql_query(preg_replace('/\{IDTREE\}/i',$new_id , $sql_insert));
    }
    /**
    * проверка на существование ветки дерева с заданным кодом
    * 
    * @param string $parent (код ветки для поиска)
    * @return void 
    */
    function exists_tree($parent){
    global $main;
        $sql="select t.tree from {$this->table} t where t.tree='{$parent}'";
        $result = $main->db->sql_query($sql);
        $row = $main->db->sql_fetchrow($result);
        return !empty($row['tree']);
    }
    /**
    * Перемещение в конец ветки дерева $dest
    * 
    * @param string $sourse
    * @param string $dest
    * @return void
    */
    function move($sourse, $dest){
    global $main;         
     if ($this->exists_tree($dest) or $dest=="") {
       $len_source=strlen($sourse);
       $new_id=$this->get_max_id($dest);
       $sql="update {$this->table} t \n".
            "set t.tree=concat('{$new_id}',substring(t.tree,".($len_source+1).",length(t.tree)-{$len_source})) \n".
            "where t.tree like '{$sourse}%'";
       $main->db->sql_query($sql);
       $this->pack_after($sourse);
     } 
    }
    /**
    * Перемещение веток дерева
    * 
    * @param string $sourse
    * @param string $dest
    * @return void
    */
    function replace($sourse, $dest){
    global $main;
     if ($this->exists_tree($dest)  and $this->exists_tree($sourse)){ 
         $main->db->sql_query("update {$this->table} t set t.tree=concat('ZZ',substring(t.tree,".(strlen($dest)+1).",length(t.tree)-".(strlen($dest)).")) where t.tree like '{$dest}%'");
         $main->db->sql_query("update {$this->table} t set t.tree=concat('{$dest}',substring(t.tree,".(strlen($sourse)+1).",length(t.tree)-".(strlen($sourse)).")) where t.tree like '{$sourse}%'");
         $main->db->sql_query("update {$this->table} t set t.tree=concat('{$sourse}',substring(t.tree,3,length(t.tree)-2)) where t.tree like 'ZZ%'");
         return TRUE;
     } else return FALSE;  
    }
}

?>