<?php
if (!defined('FUNC_FILE')) die('Access is limited');

/**
* Функция проверки является ли заданное имя, именем поисковой системы
* 
* @param string $name
* @return bool
*/
function is_bot($name=""){
global $list_bots;
    if(!empty($name)) return isset($list_bots[$name]) ? true : false;
    else return isset($list_bots[$_SESSION['user']]) ? true : false;
}

/**
* Проверка IP адреса на валидность
* 
* @param string $ip
* @return bool
*/
function validip($ip) {
global $reserved_ips;
    if (!empty($ip) AND $ip == long2ip(ip2long($ip))){
        foreach ($reserved_ips as $r) if ((ip2long($ip) >= $r[0]) AND (ip2long($ip) <= $r[1])) return false;
        return true;
    } else return false;
}

/**
* Проверяет поддержку gzip сжатия
* 
* @return bool
*/
function check_can_gzip(){
    if(headers_sent() || connection_aborted() || !function_exists('ob_gzhandler') || ini_get('zlib.output_compression')) return 0;
    if(get_env('HTTP_ACCEPT_ENCODING')){
        $encoding=get_env('HTTP_ACCEPT_ENCODING');
        if(strpos($encoding, 'x-gzip') !== false) return "x-gzip";
        if(strpos($encoding, 'gzip') !== false) return "gzip";
    }
    return false;
}

/**
* Функция проверки является ли страница главной
* 
* @return bool
*/
function is_home(){
global $adminfile, $code2languages, $main;
    $uri=get_env('REQUEST_URI');
    if($uri=="/" OR $uri=="/index.php" OR $uri=="/index{$main->config['file_rewrite']}" OR $uri=="/".$adminfile OR !empty($code2languages[str_replace("/", "", $uri)])) return true; return false;
}

/**
* Функция проверки является ли пользователь администратором или модератором
* 
* @return bool
*/
function is_support(){
    if(is_admin() OR is_moder()) return true; else return false;
}

/**
* Функция проверяет, является ли пользователь администратором
* 
* @return bool
*/
function is_admin(){
    if(isset($_SESSION['admin']) AND is_user() AND !is_bot()) return true; else return false;
}

/**
* Функция проверяет, является ли пользователь модератором
* 
* @param int $forum_id
* @return bool
*/
function is_moder($id = 0){
global $userinfo, $main;
    if(isset($_SESSION['admin']) AND $userinfo['user_level']=="1" AND is_user() AND !is_bot()) return true; else return false;
    if($id!=0){
        if(!isset($_SESSION['forum'][$id])){
            $result = $main->db->sql_query("SELECT * FROM ".ACC." WHERE uid='{$userinfo['uid']}' AND id='{$id}'");
            if($main->db->sql_numrows($result)>0) $_SESSION['forum'][$id] = true;
            else $_SESSION['forum'][$id] = false;
        }
        return $_SESSION['forum'][$id];
    }
}

/**
* Функция проверяет, является ли посетитель авторизированным пользователем
* 
* @return bool
*/
function is_user(){
global $userconf;
    if(isset($_SESSION['user']) AND $_SESSION['user']!=$userconf['guest_name'] AND !is_bot()) return true; else return false;
}

/**
* Функция проверки является ли переданное имя, именем гостя
* 
* @param string $name
* @return bool
*/
function is_guest_name($name){
global $userconf;
    if($name==$userconf['guest_name']) return true; else return false;
}

/**
* Функция проверки является ли посетитель гостем
* 
* @return bool
*/
function is_guest(){
global $userconf;
    if(isset($_SESSION['user']) AND ($_SESSION['user']==$userconf['guest_name'] OR is_bot())) return true; else return false;
}

/**
* Функция проверки выполнения аякс. Выполняется ли скрипт  как аякс приложение
* 
* @return bool
*/
function is_ajax(){
    //$hxrw = get_env('HTTP_X_REQUESTED_WITH');
    //if (isset($hxrw) AND $hxrw=="XMLHttpRequest") return true;
    if(isset($_SERVER['HTTP_AJAX_ENGINE']) OR isset($_GET['ajax']) OR isset($_POST['ajax'])) return true;
    else return false;
}

/**
* Функция определяет, является ли строка IP адресом
* 
* @param string $string
* @return bool
*/
function is_ip($string){
    if(preg_match('/^([0-9]|[0-9][0-9]|[01][0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([0-9]|[0-9][0-9]|[01][0-9][0-9]|2[0-4][0-9]|25[0-5])){3}$/', $string)) return true;
    else return false;
}

/**
* Функция проверки состоит ли пользователь в списке переданных групп
* 
* @param string $groups
* @return bool
*/
function check_user_group($groups){
global $main;
    if(empty($groups)) return true;
    else $arr = explode(',', $groups);
    $user_groups = array($main->user['user_group'])+(!empty($main->user['user_groups'])?explode(',', $main->user['user_groups']):array());    
    $array = array_intersect($arr, $user_groups);
    $_array = $array;
    foreach($_array as $key => $value) if(empty($array[$key])) unset($array[$key]);
    if(empty($array)) return false;
    else return true;
}

/**
* Функция проверки UTF8 кодировки
* 
* @param string $string
* @return bool
*/
function is_utf8($string=""){
    return preg_match('%(?:
        [\xC2-\xDF][\x80-\xBF]                    # non-overlong 2-byte
        |\xE0[\xA0-\xBF][\x80-\xBF]               # excluding overlongs
        |[\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}        # straight 3-byte
        |\xED[\x80-\x9F][\x80-\xBF]               # excluding surrogates
        |\xF0[\x90-\xBF][\x80-\xBF]{2}            # planes 1-3
        |[\xF1-\xF3][\x80-\xBF]{3}                # planes 4-15
        |\xF4[\x80-\x8F][\x80-\xBF]{2}            # plane 16
        )+%xs', $string);
}
?>