<?php
/**
* @author Igor Ognichenko
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @version 2.0
*/
if (!defined('FUNC_FILE')) die('Access is limited');  

function captcha($module=""){
global $captcha, $module_name, $lang, $captcha_set, $config, $lang_dbg;
    $mod = (empty($module)) ? $module_name : $module;
    if(empty($lang)){
        require_once "includes/language/{$config['language']}/debugging.php";
        foreach($lang_dbg as $key=>$value) $lang[$key] = $value;
    }
    return (((isset($captcha[$mod]) AND $captcha[$mod]==ENABLED) OR $captcha_set==true)) ? "<!--captcha-->\n".
    "<tr class='row_tr'><td colspan='2' class='form_text' style='text-align:left;'><b>{$lang['captcha_confirmation']}</b></td></tr>\n".
    "<tr class='row_tr'>\n<td class='form_text'>{$lang['captcha']}:</td>\n<td class='form_input'>\n<div id='newseccode' style='width: 120px;'>\n<img style='width: 110px; height: 45px; border: 1px #666666 solid; cursor: pointer;' id='imgseccode' src='includes/captcha.php' alt='' onclick=\"captcha();\" /></div>\n</td>\n</tr>\n".
    "<tr class='row_tr'><td class='form_text'>{$lang['captcha_input']}:<span class='star'>*</span></td><td class='form_input'><input class='input_text' type='text' style='width: 97%' name='seccode' id='seccode' /></td></tr>\n<!--/captcha-->\n" : "";
}

function check_captcha($module=""){
global $captcha, $module_name, $lang, $captcha_set, $config, $lang_dbg;
    $mod = (empty($module)) ? $module_name : $module;
    if(empty($lang)){
        require_once "includes/language/{$config['language']}/debugging.php";
        foreach($lang_dbg as $key=>$value) $lang[$key] = $value;
    }
    $msg = (!isset($_SESSION['security_keystring']) OR !isset($_POST['seccode']) OR $_POST['seccode'] != $_SESSION['security_keystring']) ? $lang['not_correct_capcha'] : "";
    unset($_SESSION['security_keystring']);
    return (((isset($captcha[$mod]) AND $captcha[$mod]==ENABLED) OR $captcha_set==true) AND !defined("ADMIN_FILE")) ? $msg : "";
}

function kr_error_php_handler($errno, $errstr, $errfile, $errline){
global $config, $lang_dbg, $dbg_status;
    if($dbg_status==false) return false;
    if(!empty($errno)) require_once "includes/language/{$config['language']}/debugging.php";
    if(preg_match('/mysql\.class\.php/s', $errfile)) return false;
    if($config['log_debugging_php']==ENABLED){
        file_write("uploads/logs/php_logs.log", gmdate("Y-m-d H:i:s")." | {$errstr} | in {$errfile} | on line {$errline} ||\n", "a");
    }
    if($config['mode_debugging_php']==ENABLED){
        if(preg_match('%<a\s(.+?)>(.*)<\/a>%', $errstr)) $errstr = preg_replace('%<a\s(.+?)>(.*)<\/a>%', 'www.php.net/manual/\\2.php', $errstr);
        switch($errno){
            case E_USER_ERROR: error_page($lang_dbg['error_php'], "{$errstr} Fatal error on line {$errline} in file {$errfile}, PHP ".PHP_VERSION." (".PHP_OS.")"); break;
            default: error_page($lang_dbg['error_php'], "<span class='type_error'>{$lang_dbg['error']}</span> - {$errstr} in <b>{$errfile}</b> on line {$errline}"); break;
        }
    }
    return true;
}

$old_error_handler = set_error_handler('kr_error_php_handler');

function kr_http_ereor_logs($int){
global $config, $lang_dbg, $dbg_status;
    if($dbg_status==false) return false;
    require_once "includes/language/{$config['language']}/debugging.php";
    switch($int){
        case "400": $error = array("Bad Request",           $lang_dbg['http_400']); break;
        case "401": $error = array("Unauthorized",          $lang_dbg['http_401']); break;
        case "403": $error = array("Forbidden",             $lang_dbg['http_403']); break;
        case "404": $error = array("Not Found",             $lang_dbg['http_404']); break;
        case "500": $error = array("Internal Server Error", $lang_dbg['http_500']); break;
        case "503": $error = array("Service Unavailable",   $lang_dbg['http_503']); break;
        default :   $error = array("Unknown Error",         $lang_dbg['unknown_error']); break;
    }    
    if($config['log_debugging_http']==ENABLED){
        file_write("uploads/logs/http_logs.log", "".gmdate("Y-m-d H:i:s")." | {$error[0]} | http://".get_env('HTTP_HOST').get_env('REQUEST_URI')." | ".(isset($_SERVER['HTTP_REFERER'])?$_SERVER['HTTP_REFERER']:'null | '.$_SERVER["REMOTE_ADDR"].'')."||\n", "a");       
    }
    if($config['mode_debugging_http']==ENABLED){
        if(!isset($_SERVER['HTTP_AJAX_ENGINE']) AND !isset($_GET['ajax']) AND !isset($_POST['ajax'])) error_page($lang_dbg['error_http'].$int.": ".$error[0], $error[1], 0, true, '', $int);
        else echo "<script language='javascript'>alert('".$lang_dbg['error_http'].$int.": ".$error[0]."');</script>";
    } else {
        switch($int){
            case 404: header('HTTP/1.1 404 Not Found'); break;
            case 403: header('HTTP/1.1 403 Forbidden'); break;            
            case 500: header('HTTP/1.1 500 Internal Server Error'); break;            
        }
        //header ('HTTP/1.1 301 Moved Permanently');
        //header ('Location: index.php');
        exit;
    }   
}

function kr_sql_erorr_logs($code, $msg, $query){
global $config, $lang_dbg, $dbg_status;
    if($dbg_status==false) return false;
    require_once "includes/language/{$config['language']}/debugging.php";   
    if($config['log_debugging_sql']==ENABLED){
        file_write("uploads/logs/sql_logs.log", gmdate("Y-m-d H:i:s")." :|: {$code} :|: {$msg} :|: {$query}||\n", "a");
    }
    $query_msg = htmlspecialchars($query);
    $match = "";
    if(preg_match("%right syntax to use near '(.*?)' at%is", $msg, $match)){
        $query_msg = str_replace($match[1], "<span style='color: black; font-weight: bold;'>{$match[1]}</span>", $query_msg);
    }
    if($config['mode_debugging_sql']==ENABLED) error_page($lang_dbg['error_sql'], "<span class='type_error'>{$lang_dbg['error']}</span> - {$code}: <b>{$msg}</b>.<br /><span style='color: #7F3F3F; font-family: Courier New;'>{$query_msg}</span>");
}

function error_page($title, $msg, $type=0, $send=true, $url='', $http=''){
global $config, $captcha_set, $lang_dbg;      
    if(!isset($_GET['ajax']) AND !isset($_POST['ajax'])) require_once "includes/nocache.php";
    if(empty($lang_dbg)) require_once "includes/language/{$config['language']}/debugging.php";
    $url = empty($url) ? "http://{$_SERVER['HTTP_HOST']}/" : $url;
    $move_to = ($type!=0) ? str_replace("{URL}", $url, "<br />".$lang_dbg['move_to']) : "";
    $captcha_set = true;
    $kill = @ob_get_contents();
    if(strlen($kill)>0) @ob_end_clean();
    $content = preg_replace(
        array(
            '/\{error.MOVE\}/i', 
            '/\{error.MESSAGE\}/i', 
            '/\{error.TITLE\}/i', 
            '/\{error.ACTION\}/i', 
            '/\{error.REFERER\}/i', 
            '/\{error.URL\}/i', 
            '/\{error.HTML_MESSAGE\}/i', 
            '/\{error.TEXT_YOR_NAME\}/i', 
            '/\{error.TEXT_REFERER_PAGE\}/i', 
            '/\{error.CAPTCHA\}/i', 
            '/\{error.LANGUAGE\}/i',
            '/\{error.TYPE\}/i',
            '/\{error.SITE\}/i'
        ), 
        array(
            $move_to, 
            $msg, 
            $title,
            "engine.php?do=mail2admin' name='errorform", 
            addslashes(str_replace("&", "&amp;", isset($_SERVER['HTTP_REFERER'])?$_SERVER['HTTP_REFERER']:'null')), 
            addslashes(str_replace("&", "&amp;", "http://{$_SERVER['HTTP_HOST']}".$_SERVER['REQUEST_URI'])), 
            strip_tags($msg), 
            $lang_dbg['you_name'], 
            $lang_dbg['referer_this_page'], 
            function_exists("captcha")?captcha():"", 
            $config['language'], 
            $http, 
            "<a href='http://{$_SERVER['HTTP_HOST']}/' title='{$config['home_title']}'>{$config['home_title']}</a>"
        ), 
        kr_get_content("includes/template/error_page.tpl")        
    );
    if(!$send) $content = preg_replace('/(.*?)<!--BEGIN SEND-->(.*?)<!--END SEND-->(.*?)/s', "\\1\\3", $content);
die("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>
<title>{$config['home_title']} - ".strip_tags(str_replace("&#33;", "!", $title))."</title>
<meta http-equiv='content-type' content='text/html; charset={$config['charset']}' />
<meta name='generator' content='{$config['cms_version']}' />
<meta name='Cache-Control' content='no-cache' />
<meta http-equiv='Expires' content='0' />
<base href='http://{$_SERVER['HTTP_HOST']}/' />
<meta name='copyright' content='Copyright (c){$config['cms_version']}' />".(($type!=0) ? "<meta http-equiv='refresh' content='{$type}; url={$url}' />\n" : "")."
<link rel='stylesheet' type='text/css' href='includes/template/css/errors.css' />
</head>\n
<body class='page_bg'>\n
<script type='text/javascript' src='includes/javascript/function.js'></script>
{$content}
</body>\n</html>");
}

function info_page($title, $msg, $type=0, $send=true, $url=''){
    error_page($title, $msg, $type, $send, $url);
}

function debug_var($text, $at="a"){
    $file = fopen('uploads/logs/debugging.log', $at);
    fputs ($file, "============================================\ndate: ".date("Y-m-d H:i:s")."\n============================================\n".$text."\n============================================\n\n");
    fclose ($file);
}
?>