<?php
/**
* Функции создания форм и HTML элементов
* 
* @author Igor Ognichenko
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @filesource includes/function/forms.php 
* @version 2.0
*/
if (!defined('FUNC_FILE')) die('Access is limited');

/**
* Функция создания выпадающего списка
* 
* @param string $name
* @param array $options
* @param string $class
* @param mixed $value
* @param string $onchange
* @param bool $multiple
* @return string
*/
function in_sels($name, $options, $class, $value="", $onchange="", $multiple="", $size=0){        
    $is = is_array($value); $select = ""; $value = (isset($_POST[$name])) ? $_POST[$name] : $value; 
    $sel = "<select{$onchange}".($is?"":" id='{$name}'")." name='{$name}".($is?'[]':'')."' class='{$class}'".(($is AND $multiple!=false)?" multiple='multiple'":'')."".(($is OR $size!=0)?" size='".($size==0?8:$size)."'":'').">\n";    
    foreach($options as $key=>$val){        
        $match = "";        
        if(preg_match('/(.+?)_optgroup_(.*)/i', $key, $match)){
            if($match[1]=='begin') $sel .= "<optgroup label='{$val}'>\n";
            else $sel .= "</optgroup>\n";
            continue;
        } else {
            if(!$is) $select = ($value==$key) ? " style='font-weight: bold;' selected='selected'" : "";
            else $select = in_array($key, $value) ? " style='font-weight: bold;' selected='selected'" : "";
            $sel .=  "<option value='{$key}'{$select}>{$val}</option>\n";
        }
    }
    return $sel."</select>";
}

/**
* Функция создания текстового поля input
* 
* @param string $name
* @param string $class
* @param string $value
* @param bool $disabled
* @param string $add
* @return bool
*/
function in_text($name, $class="", $value="", $disabled=false, $add=""){
    if($value=='') $value = (isset($_POST[$name])) ? stripslashes($_POST[$name]) : "";
    else $value = (isset($_POST[$name])) ? stripslashes($_POST[$name]) : $value;
    $value = str_replace("&#036;", '$', $value);
    return "<input".(!empty($class) ? " class='{$class}'" : "")." type='text' name='{$name}' id='{$name}' value='".htmlspecialchars($value, ENT_QUOTES)."'".(($disabled) ? " readonly='readonly'" : "")."{$add} />";
}

/**
* Функция создания динамически добавляемого текстового поля input
* 
* @param string $name
* @param string $class
* @param array $value
* @return string
*/
function in_text_many($name, $class="", $value=array()){
global $lang;
    $value = isset($_POST[$name]) ? $_POST[$name] : $value; 
    if(empty($value)){
        $return = "<table width='100%' cellspacing='0' cellpadding='0'><tr><td id='addinputs'>".
        "<table width='100%' cellspacing='0' cellpadding='0'><tr><td><input".(!empty($class) ? " class='{$class}'" : "")." type='text' name='{$name}[]' value='' /></td></tr></table>".
        "</td><td width='18' valign='bottom'><img onclick=\"addinput('addinputs', '{$name}', '{$class}')\" style='cursor: pointer; margin-bottom: 4px;' src='includes/images/plus.gif' alt='{$lang['add']}' /></td></tr></table>";
    } else {
        $return = "<table width='100%' cellspacing='0' cellpadding='0'><tr><td id='addinputs'>";
        foreach($value as $link){
            $return .= "<table width='100%' cellspacing='0' cellpadding='0' style='margin-top: 2px;'><tr><td><input".(!empty($class) ? " class='{$class}'" : "")." type='text' name='{$name}[]' value='".htmlspecialchars($link, ENT_QUOTES)."' /></td></tr></table>";    
        }
        $return .= "</td><td width='18' valign='bottom'><img onclick=\"addinput('addinputs', '{$name}', '{$class}')\" style='cursor: pointer; margin-bottom: 4px;' src='includes/images/plus.gif' alt='{$lang['add']}' /></td></tr></table>";
    }
    return $return;
}

/**
* Функция создания текстового поля password
* 
* @param string $name
* @param string $class
* @param string $value
* @return string
*/
function in_pass($name, $class="", $value=""){
    return "<input".(!empty($class) ? " class='{$class}'" : "")." type='password' name='{$name}' id='{$name}' value='{$value}' />";
}

/**
* Функция создания текстового поля textarea
* 
* @param string $name
* @param string $class
* @param int $rows
* @param string $value
* @return string
*/
function in_area($name, $class="", $rows=5, $value=""){
    if(empty($value)) $value = (isset($_POST[$name])) ? stripslashes($_POST[$name]) : "";
    else $value = (isset($_POST[$name])) ? stripslashes($_POST[$name]) : $value;
    $value = str_replace("&#036;", '$', $value);
    return "<textarea".(!empty($class) ? " class='{$class}'" : "")." name='{$name}' id='{$name}' rows='{$rows}' cols='10'>".htmlspecialchars($value, ENT_QUOTES)."</textarea>";
}

/**
* Функция создания элемента checkbox
* 
* @param string $name
* @param string $class
* @param mixed $checked
* @param string $add
* @return string
*/
function in_chck($name, $class="", $checked=" checked='checked'", $add="", $id=true){
    return "<input type='hidden' name='hide_{$name}' value='set' /><input type='checkbox'".(!empty($class) ? " class='{$class}'" : "")."".($id?" id='{$name}'":"")." name='{$name}'".(($checked==ENABLED OR $checked==1 OR isset($_POST[$name])) ? " checked='checked'" : (($checked=="off" OR $checked=="" OR $checked==0) ? "" : $checked))." {$add}/>";
}

/**
* Функция создания скрытого поля hidden
* 
* @param string $name
* @param string $value
* @param string $js
* @return string
*/
function in_hide($name, $value, $js=false){    
global $tpl_create;
    if($js) $tpl_create->add2script("KR_AJAX.addEvent(window, 'load', function(){document.getElementById('{$name}').value='{$value}'});", false);
    return "<input type='hidden' name='{$name}' id='{$name}' value='{$value}' />\n";
}

/**
* Функция создания элемента radio
* 
* @param string $name
* @param string $value
* @param string $text
* @param string $id
* @param bool $defult_checked
* @return string
*/
function in_radio($name, $value, $text, $id="", $defult_checked=false, $add=""){    
    return "<input type='radio' name='{$name}' value='{$value}' id='{$id}'".((($defult_checked AND !isset($_POST[$name])) OR (isset($_POST[$name]) AND $_POST[$name]==$value)) ? " checked='checked'" : "")." {$add}/> <label for='{$id}' class='pointer'>{$text}</label>";
}

/**
* Функция создания кнопки удаления
* 
* @param string $url
* @param string $elm
* @return string
*/
function delete_button($url, $elm='', $onclock=true){
global $lang;
    return "<a href='{$url}' class='delete_button' title='{$lang['delete']}'".($onclock?" onclick=\"update_ajax('{$url}', '{$elm}', '{$lang['realdelete']}'); return false;\"":$elm)."><img src='includes/images/pixel.gif' alt='' /></a>";
}

/**
* Функция создания кнопки установки
* 
* @param string $url
* @param string $add
* @return string
*/
function install_button($url, $add=""){
global $lang;
    return "<a href='{$url}' class='install_button' title='{$lang['install']}'{$add}><img src='includes/images/pixel.gif' alt='' /></a>";
}

/**
* Функция создания кнопки редактирования
* 
* @param string $url
* @param string $add
* @return string
*/
function edit_button($url="#", $add=""){
global $lang;
    return "<a href='{$url}' title='{$lang['edit']}' class='edit_button'{$add}><img src='includes/images/pixel.gif' alt='' /></a>";
}

/**
* Функция создания кнопки вверх
* 
* @param string $url
* @param string $elm
* @return string
*/
function up_button($url, $elm){
global $lang;
    return "<a href='{$url}' title='{$lang['move_up']}' class='up_button' onclick=\"move_ajax('{$url}', '{$elm}'); return false;\"><img src='includes/images/pixel.gif' alt='' /></a>";
}

/**
* Функция создания кнопки вниз
* 
* @param string $url
* @param string $elm
* @return string
*/
function down_button($url, $elm){
global $lang;
    return "<a href='{$url}' title='{$lang['move_down']}' class='down_button' onclick=\"move_ajax('{$url}', '{$elm}'); return false;\"><img src='includes/images/pixel.gif' alt='' /></a>";
}

/**
* Функция создания кнопки "Отправить"
* 
* @return string
*/
function send_button($onclick=""){
global $tpl_config, $main;
    if(isset($tpl_config['submit'])){
        if($tpl_config['submit']=="image") return "<input{$onclick} class='submit' type='image' src='{$main->img['submit_button']}' alt='{$main->lang['send']}' />";
        else return "<input{$onclick} type='submit' class='submit' value='{$main->lang['send']}' />";
    } else return "<input{$onclick} type='submit' class='submit' value='{$main->lang['send']}' />";
}

/**
* Функция создания кнопки "Поиск" в модуле
* 
* @return string
*/
function button_search_module(){
global $tpl_config, $main;
    if(isset($tpl_config['search_module'])){
        if($tpl_config['search_module']=="image") return "<input class='search_module_button' type='image' src='{$main->img['search_module_image']}' alt='{$main->lang['search']}' />";
        else return "<input type='submit' class='search_module_button' value='{$main->lang['search']}' />";
    } else return "<input type='submit' class='search_module_button' value='{$main->lang['search']}' />";
}

/**
* Функция создания кнопки "Поиск"
* 
* @return string
*/
function button_search(){
global $tpl_config, $main;
    if(isset($tpl_config['search'])){
        if($tpl_config['search']=="image") return "<input class='search_button' type='image' src='{$main->img['search_image']}' alt='{$main->lang['search']}' />";
        else return "<input type='submit' class='search_button' value='{$main->lang['search']}' />";
    } else return "<input type='submit' class='search_button' value='{$main->lang['search']}' />";
}

/**
* Функция создания кнопки info
* 
* @param string $url
* @param string $add
* @return string
*/
function info_button($url="#", $add=""){
global $lang;
    return "<a href='{$url}' title='{$lang['info']}' class='info_button'{$add}>&nbsp;</a>";
}

/**
* Функция создания кнопки insert
* 
* @param string $url
* @param string $add
* @return string
*/
function insert_button($url="#", $add=""){
global $lang;
    return "<a href='{$url}' title='{$lang['insert']}' class='insert_button'{$add}>&nbsp;</a>";
}

/**
* Функция создания кнопки clear
* 
* @param string $url
* @param string $add
* @return string
*/
function clear_button($url="#", $elm=''){
global $lang;
    return "<a href='{$url}' title='{$lang['clear']}' class='clear_button' onclick=\"clear_ajax('{$url}', '{$elm}', '{$lang['realy_clear']}'); return false;\">&nbsp;</a>";
}

/**
* Функция создания кнопки favorite
* 
* @param string $id
* @param string $idelm
* @param array $lang
* @param string $class
* @return string
*/
function favorite_button($id, $idelm, $lang=array(), $class='', $module=''){
global $main;
    $module = empty($module) ? $main->module : $module;
    $del = (isset($lang['del'])) ? $lang['del'] : $main->lang['favorite_del'];
    $add = (isset($lang['add'])) ? $lang['add'] : $main->lang['favorite_add'];
    $picture  = ($id != '') ?  "class='{$class}favorite_off' title='{$del}'" : "class='{$class}favorite_on' title='{$add}'";
    $favorite = "<img id='favorite-{$idelm}' onclick=\"set_favorite({$idelm},'favorite-{$idelm}','{$module}', ['{$del}', '{$add}'], '{$class}');\" {$picture} src='includes/images/pixel.gif' align='left' alt=''/>";
    return $favorite;
}

function in_tag(){
global $main;
    $tags = "";
    if(isset($_SESSION['tags_pub']) AND count($_SESSION['tags_pub'])>0 AND !empty($_SESSION['tags_pub'][0])){
        $tags .= "<table class='tag_table' cellpadding='0' cellspacing='0' style='margin:0px' width='100%'>";
        $bg = 'bg1';        
        foreach($_SESSION['tags_pub'] as $value) {
            $tags .= "<tr class='{$bg}'><td>{$value}</td><td width='15'><a class='remove_tag' href='#' onclick=\"remove_tag('{$value}'); return false;\" title='{$main->lang['delete']}'><img src='includes/images/pixel.gif' alt='' /></a></td></tr>";
            $bg = ($bg!='bg1') ? 'bg1' : 'bg2';
        }
        $tags .= "</table>";
    }
    return in_text("tags", "tegs_input", "", false, " onkeyup=\"KR_AJAX.qs.init(this, '".TAG."', 'tag', 2, {'modul':'{$main->module}'})\"")."\n".
    "<input class='tegs_add_button' type='button' value='{$main->lang['add']}' onclick=\"add_tag(document.getElementById('tags')); return false;\" />\n".
    "<input class='tegs_add_button' type='button' value='{$main->lang['case']}' onclick=\"case_tags('{$main->module}', '{$main->lang['case_tags']}'); return false;\" />\n".
    "<img style='display: none;' id='tag_loader' src='includes/images/loading/small.gif' alt='Loading...' class='tag_loader' /><div ".(empty($tags)?"style='display:none;' ":"")."class='tag_list' id='tag_list'>{$tags}</div>";
}
?>