<?php
/**
* Файл дополнительных функций
* 
* @author Igor Ognichenko
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @filesource includes/function/functions.php
* @version 2.0
*/
if (!defined('FUNC_FILE')) die('Access is limited');

/**
* Функция записи в файл
* 
* @param string $file_link
* @param mixed $text
* @param string $at
* @return void
*/
function file_write($file_link, $text, $at="w"){
    $file = fopen($file_link, $at);
    fputs ($file, $text);
    fclose ($file);
}

/**
* Функция создания отступа для построения деревьев
* 
* @param int $int
* @param string $space
* @return string
*/
function pre_html($int, $space=""){
    for($i=0;$i<$int;$i++) $space .= "  ";
    return ($int!=0) ? $space."› " : $space;
}

/**
* Поиск элемента массива по заданному значению
* 
* @param mixed $key
* @param array $array
* @return int
*/
function array_search_key($key, $array){
    foreach($array as $id=>$value) if($value==$key) return $id;
    return (-1);
}

/**
* Функция проверки chmod
* 
* @param int $chmod
* @param string $file
* @return bool
*/
function chmod_check($chmod, $file){
     if(decoct(0777 & fileperms($file))>=$chmod) return true; else return false;
}

/**
* Функция HTTP авторизации
* 
*/
function phplogin(){
global $security, $lang;
    Header('WWW-Authenticate: Basic realm="Kasseler CMS"');
    Header('HTTP/1.0 401 Unauthorized');
    error_page($lang['error_login'], $security['msgnologin']);
}

/**
* Функция чтения каталога
* 
* @param string $patch
* @param string $regexp
* @return array
*/
eval(base64_decode("Z2xvYmFsICRjb250X3NlZWs7ICRjb250X3NlZWsrKzs="));
function scan_dir($patch, $regexp){
    $files = array();
    if(($handle = kr_opendir($patch))){
        while(false !== ($file = readdir($handle))) if(!kr_is_dir($patch.$file) AND preg_match($regexp, $file)) $files[$file]=$file;
        closedir($handle);
    }
    return $files;
}

/**
* Функция преобразования секунд в дни, часы, минуты
* 
* @param int $sal
* @param string $return
* @return string
*/
function time2string($sal, $return=""){
global $lang;
    $days = preg_replace('/(.*?)\.(.*)/', "\\1", $sal/86400);
    $sal -= $days*86400;
    $h = preg_replace('/(.*?)\.(.*)/', "\\1", $sal/3600);
    $sal -= $h*3600;
    $m = preg_replace('/(.*?)\.(.*)/', "\\1", $sal/60);
    $sal -= $m*60;
    $txt = array(
        'day' => (substr($days, strlen($days)-1, 1)==1) ? $lang['u_day'] : ((substr($days, strlen($days)-1, 1)>1 AND (substr($days, strlen($days)-1, 1)<5)) ? $lang['u_day2'] : $lang['u_day3']),
        'h'   => (substr($h, strlen($h)-1, 1)==1) ? $lang['u_h'] : ((substr($h, strlen($h)-1, 1)>1 AND (substr($h, strlen($h)-1, 1)<5)) ? $lang['u_h2'] : $lang['u_h3']),
        'm'   => (substr($m, strlen($m)-1, 1)==1) ? $lang['u_m'] : ((substr($m, strlen($m)-1, 1)>1 AND (substr($m, strlen($m)-1, 1)<5)) ? $lang['u_m2'] : $lang['u_m3']),
        's'   => (substr($sal, strlen($sal)-1, 1)==1) ? $lang['u_s'] : ((substr($sal, strlen($sal)-1, 1)>1 AND (substr($sal, strlen($sal)-1, 1)<5)) ? $lang['u_s2'] : $lang['u_s3']),
    );
    $return .= ($days!=0) ? "{$days} {$txt['day']}" : "";
    $return .= ($h!=0) ? " {$h} {$txt['h']}" : "";
    $return .= ($m!=0) ? " {$m} {$txt['m']}" : "";
    $return .= ($sal!=0) ? " {$sal} {$txt['s']}" : "";
    return $return;      
}

/**
* Функция нормализации массива тегов
* 
* @param array $tags_arr
* @return array
*/
function kr_normalize_tags(){
global $main;
    if(!isset($_SESSION['tags_pub']) OR count($_SESSION['tags_pub'])==0) return array('str'=>'', 'arr' => array());
    $i = 1; $where = ''; $base_arr = $temp_arr = array();
    foreach ($_SESSION['tags_pub'] as $key => $value) { 
        while(strpos($value,'  ') !== false) $value = str_replace('  ',' ',$value);
        $_SESSION['tags_pub'][$key] = trim($value);
        if(empty($_SESSION['tags_pub'][$key])) unset($_SESSION['tags_pub'][$key]);
        else $temp_arr[$key] = kr_chenge_reg($_SESSION['tags_pub'][$key]);
    }
    $temp_arr = array_unique($temp_arr);
    foreach ($temp_arr as $key => $value) { 
        $where.= ($i==1) ? " WHERE LOWER(tag)='{$value}'" : " OR LOWER(tag)='{$value}'";
        $i++;
    }
    if($where!='') {
        $result = $main->db->sql_query("SELECT tag FROM ".TAG." {$where} GROUP BY tag"); 
        if($main->db->sql_numrows($result)>0){
            while(($row = $main->db->sql_fetchrow($result))){
                $key = kr_chenge_reg($row['tag']);
                $base_arr[$key] = $row['tag'];
            }
        }
    }
    foreach($_SESSION['tags_pub'] as $key => $value){
        if(!isset($temp_arr[$key])) unset($_SESSION['tags_pub'][$key]);
        else if (isset($base_arr[$value])) $_SESSION['tags_pub'][$key] = $base_arr[$value];
    }
    sort($_SESSION['tags_pub']);
    $return = array('arr'=>$_SESSION['tags_pub'], 'str'=>implode(',', $_SESSION['tags_pub']));
    unset($_SESSION['tags_pub']);
    return $return;
}

/**
* Функция заполнения таблицы тегов
* 
* @param array $tags
* @param int      $post
* @param string $post_id
* @param string $modul
*/
function set_tags_sql($tags, $post, $modul){
global $main;
    if($tags['str']!='') foreach ($tags['arr'] as $key => $value) sql_insert(array( 'tag'=>$value, 'post'=>$post, 'modul'=>$modul), TAG);
}

function case_module_tags(){
global $main;
    $result = $main->db->sql_query("SELECT t.*, (SELECT COUNT(*) FROM ".TAG." as tt WHERE tt.tag=t.tag) AS count FROM ".TAG." as t WHERE t.modul='{$main->module}' GROUP BY tag");
    if($main->db->sql_numrows($result)>0){
        $value = isset($_SESSION['tags_pub']) ? $_SESSION['tags_pub'] : array();
        open();
        echo "<div style='padding: 5px;' id='case_taf_div'><h1 class='case_tag'>{$main->lang['case_tag_in_module']}: {$main->title}</h1>";
        echo "\n<table class='tagcaselist' width='100%' align='center'><tr><th>&nbsp;</th><th>{$main->lang['tag']}</th><th>{$main->lang['count']}</th></tr>\n";
        while($row = $main->db->sql_fetchrow($result)){
            echo "<tr><td width='15'><input type='checkbox' name='select_tag[]' class='case_tag' value='{$row['tag']}' ".(in_array($row['tag'], $value)?"checked='checked' ":'')."/></td><td>{$row['tag']}</td><td width='15' align='center'>{$row['count']}</td></tr>";
        }
        echo "</table></div>\n";
        close();
    } else info($main->lang['noinfo']);
}
?>