<?php
if (!defined('FUNC_FILE')) die('Access is limited');

/**
* Функция возвращает текущий языковый параметр
* 
* @return string
*/
function get_lang(){
global $language;
    return $language;
}

/**
* Функция генерации маски загружаемых файлов
* 
* @param string $string
* @param string $return
*/
function get_mask_types($string, $return=""){
    $arr = explode(",", $string);
    $count = count($arr);
    for($i=0; $i<$count; $i++) $return .= ($i<$count-1) ? "*.{$arr[$i]};" : "*.{$arr[$i]}";
    return $return;
}

/**
* Возвращает тип файла
* 
* @param string $file
* @return string
*/
function get_type_file($file){
    return preg_replace('/(.+?)[.]([a-zA-z0-9]+)$/', '\\2', $file);
}

/**
* Возвращает имя файла
* 
* @param string $file
* @return string
*/
function get_name_file($file){
    return preg_replace('/(.+?)[.]([a-zA-z0-9]+)$/', '\\1', $file);
}

/**
* Функция возвращает атрибуты файла
* 
* @param string $filepath
* @return string
*/
function get_perms($filepath) {
    $mode = @fileperms($filepath);
    if (($mode & 0xC000) === 0xC000) {$type = 's';}
    elseif (($mode & 0x4000) === 0x4000) {$type = 'd';}
    elseif (($mode & 0xA000) === 0xA000) {$type = 'l';}
    elseif (($mode & 0x8000) === 0x8000) {$type = '-';} 
    elseif (($mode & 0x6000) === 0x6000) {$type = 'b';}
    elseif (($mode & 0x2000) === 0x2000) {$type = 'c';}
    elseif (($mode & 0x1000) === 0x1000) {$type = 'p';}
    else {$type = '?';}

    $owner['read'] = ($mode & 00400) ? 'r' : '-'; 
    $owner['write'] = ($mode & 00200) ? 'w' : '-'; 
    $owner['execute'] = ($mode & 00100) ? 'x' : '-'; 
    $group['read'] = ($mode & 00040) ? 'r' : '-'; 
    $group['write'] = ($mode & 00020) ? 'w' : '-'; 
    $group['execute'] = ($mode & 00010) ? 'x' : '-'; 
    $world['read'] = ($mode & 00004) ? 'r' : '-'; 
    $world['write'] = ($mode & 00002) ? 'w' : '-'; 
    $world['execute'] = ($mode & 00001) ? 'x' : '-'; 

    if( $mode & 0x800 ) {$owner['execute'] = ($owner['execute']=='x') ? 's' : 'S';}
    if( $mode & 0x400 ) {$group['execute'] = ($group['execute']=='x') ? 's' : 'S';}
    if( $mode & 0x200 ) {$world['execute'] = ($world['execute']=='x') ? 't' : 'T';}
 
    return $type.$owner['read'].$owner['write'].$owner['execute'].$group['read'].$group['write'].$group['execute'].$world['read'].$world['write'].$world['execute'];
}

/**
* Функция преобразования байтов в более высшую систему измерения KB, Mb, Gb, TB
* 
* @param mixed $bytes
* @return string
*/
function get_size($bytes){
    if ($bytes < 1000 * 1024) return number_format($bytes / 1024, 2) . " KB";
    elseif ($bytes < 1000 * 1048576) return number_format($bytes / 1048576, 2) . " MB";
    elseif ($bytes < 1000 * 1073741824) return number_format($bytes / 1073741824, 2) . " GB";
    else return number_format($bytes / 1099511627776, 2) . " TB";
}

/**
* Функция возвращает текущий chmod файла
* 
* @param string $file
* @return string
*/
function get_chmod($file, $substr=0){
    $chmod = substr(sprintf('%o', fileperms($file)), -4);
    return substr($chmod, $substr, strlen($chmod));
}
 
/*
function get_ip() {
global $proxy, $ip;   
    $serverVars = array(
        "HTTP_X_FORWARDED_FOR",
        "HTTP_X_FORWARDED",
        "HTTP_FORWARDED_FOR",
        "HTTP_FORWARDED",
        "HTTP_VIA",
        "HTTP_X_COMING_FROM",
        "HTTP_COMING_FROM",
        "HTTP_CLIENT_IP",
        "HTTP_XROXY_CONNECTION",
        "HTTP_PROXY_CONNECTION",
        "HTTP_USERAGENT_VIA",
        "HTTP_X_CLUSTER_CLIENT_IP"
    );
    $ip="0.0.0.0";
    $proxy="0.0.0.0";
        
    foreach ($serverVars as $serverVar) {
        if (!empty($_SERVER) && !empty($_SERVER[$serverVar])){$proxy = $_SERVER[$serverVar];break;}
        elseif (!empty($HTTP_SERVER_VARS) && !empty($HTTP_SERVER_VARS[$serverVar])){$proxy = $HTTP_SERVER_VARS[$serverVar];break;}
        elseif (!empty($_ENV) && isset($_ENV[$serverVar])){$proxy = $_ENV[$serverVar];break;}
        elseif (@get_env($serverVar))if(!$proxy){$proxy = get_env($serverVar);break;}
    }
    if(!empty($proxy)){
        $ip = preg_match('|^([0-9]{1,3}\.){3,3}[0-9]{1,3}|', $proxy, $regs);
        $long = ip2long($regs[0]);
        if($ip && (sizeof($regs) > 0) && $long != -1 && $long !== false)
        $ip=$regs[0];
    } else $ip=$_SERVER['REMOTE_ADDR'];    
} */

/**
* Функция возвращает текущий USER AGENT
* 
* @return string
*/
function get_user_agent(){
    static $ua;
    if($ua) return $ua;
    return $ua = get_env('HTTP_USER_AGENT');
}

/**
* Функция возвращает текущий HTTP HOST
* 
* @return string
*/
function get_host_name($whith_port=true){
    static $_host_name;
    if($_host_name) return $_host_name;
    $_host_name = get_env('HTTP_HOST');
    if(!$_host_name) $_host_name=get_env('SERVER_NAME');
    if(!$whith_port){ 
    	if(strpos($_host_name,':')) list($_host_name)=explode(':',$_host_name);
    }
    return preg_replace('/[^a-z0-9-:._]/i', '', $_host_name);
}

/**
* Функция возвращает количество истекших лет от заданной даты
* 
* @param string $date
* @return int
*/
function get_age($date){
    $Year = date("Y") - date("Y", strtotime($date));
    if(date("m")<date("m", strtotime($date))) return --$Year;
    if(date("m")==date("m", strtotime($date)))
    if(date("d")<date("d", strtotime($date))){return --$Year;} else return $Year;
    if(date("m")>date("m", strtotime($date))) return $Year;
    return 0;
}

/**
* Функция возвращает знак зодиака указанной даты
* 
* @param string $date
* @return array
*/
function get_zodiak($date){
global $lang, $img;
    if(empty($date) OR $date=='0000-00-00') return $lang['noinfo'];
    $zodiac = array(
        //NAME                      IMAGE                DATE
        array($lang['capricorn'],   $img['capricorn'],   "22-12"),
        array($lang['sagittarius'], $img['sagittarius'], "23-11"),
        array($lang['scorpio'],     $img['scorpio'],     "24-10"),
        array($lang['libra'],       $img['libra'],       "24-09"),
        array($lang['virgo'],       $img['virgo'],       "24-08"),
        array($lang['leo'],         $img['leo'],         "23-07"),
        array($lang['cancer'],      $img['cancer'],      "22-06"),
        array($lang['gemini'],      $img['gemini'],      "22-05"),
        array($lang['taurus'],      $img['taurus'],      "21-04"),
        array($lang['aries'],       $img['aries'],       "22-03"),
        array($lang['pisces'],      $img['pisces'],      "21-02"),
        array($lang['aquarius'],    $img['aquarius'],    "21-01")
    );
    for($i=0; $i<count($zodiac); $i++) {
        if((substr($date, 5, 2) == substr($zodiac[$i][2], 3, 2))){
            if(substr($date, 8, 2) >= substr($zodiac[$i][2], 0, 2)){
                $zodiac_img = $zodiac[$i][1];
                $zodiac_name = $zodiac[$i][0];
            } else {
                if($i == 11){
                    $zodiac_img = $zodiac[0][1];
                    $zodiac_name = $zodiac[0][0];
                } else {
                    $zodiac_img = $zodiac[$i+1][1];
                    $zodiac_name = $zodiac[$i+1][0];
                }
            }
        }
    }
    return array($zodiac_name, $zodiac_img);
}

/**
* Функция возвращает информацию об ошибке загрузки файла
* 
* @param int $int
* @return string
*/
function get_uploads_error($int){
global $lang;
    $msg =($int==2) ? string_report($lang['error_size']) : "";
    $msg.=($int==3) ? string_report($lang['error_type']) : "";
    $msg.=($int==4) ? string_report($lang['error_pix']) : "";
    $msg.=($int==5) ? string_report($lang['error_load']) : "";
    return $msg;
}

/**
* Функция определение языкового файла
* 
* @return void
*/
function get_language(){
global $config, $userinfo, $language, $module_name, $lang;
    $lang = array();         
    if(isset($_COOKIE['lang']) AND kr_file_exists("includes/language/{$_COOKIE['lang']}/")) $language = $_COOKIE['lang'];
    else $language = empty($userinfo['user_language']) ? $config['language'] : $userinfo['user_language'];    
    foreach(load_includes('lang*?\.php', "includes/language/{$language}/") as $filename) {
        $tpl_lang = $lang;
        require_once $filename;
        $lang += $tpl_lang;
    }    
    if(defined("ADMIN_FILE") AND kr_file_exists("includes/language/{$language}/admin.php")) {
        $tpl_lang = $lang;
        require_once "includes/language/{$language}/admin.php";
        $lang += $tpl_lang;
    }
    if(isset($_GET['module']) AND kr_file_exists("includes/language/{$language}/{$_GET['module']}.php")){        
        $tpl_lang = $lang;
        require_once "includes/language/{$language}/{$module_name}.php";
        $lang += $tpl_lang; 
    }
    if(kr_file_exists("modules/{$module_name}/language/language.{$language}.php")){
        $tpl_lang = $lang;
        require_once "modules/{$module_name}/language/language.{$language}.php";
        $lang += $tpl_lang; 
    }
    foreach (load_includes('lang_.*?\.php', "includes/language/{$language}/") as $filename){
        $tpl_lang = $lang;
        require_once($filename);
        $lang += $tpl_lang;         
    }
}

/**
* Создает строку с произвольных символов
* 
* @param int $size
* @param string $string
* @return string
*/
function get_random_string($size=25, $string=""){
    $chars = array("a","A","b","B","c","C","d","D","e","E","f","F","g","G","h","H",
                   "i","I","j","J","k","K","l","L","m","M","n","N","o","O","p","P",
                   "q","Q","r","R","s","S","t","T","u","U","v","V","w","W","x","X",
                   "y","Y","z","Z","1","2","3","4","5","6","7","8","9");
    for($i = 0; $i<$size; $i++) $string .= $chars[rand(0, count($chars) - 1)];
return $string;
}

/**
* Функция создания выпадающего списка локализаций системы
* 
* @param string $select
* @return string
*/
function get_lang_file($select=""){
global $lang;
    $dir = kr_opendir('includes/language/');
    while(($file = readdir($dir))) if(kr_is_dir('includes/language/'.$file) AND $file!='.' AND $file!='..') $sel[$file] = isset($lang[$file])?$lang[$file]:$file;
    closedir($dir);
    return in_sels('language', array_merge(array('' => $lang['no']), $sel), 'select', isset($_POST['lang']) ? $_POST['lang'] :$select);
}

/**
* Функция создания выпадающего списка модулей системы
* 
* @param string $select
* @param string $onchange
* @return string
*/
function select_modules($select="", $onchange=""){
global $lang;
    $dir = kr_opendir('modules/');
    while(($file = readdir($dir))) if(kr_is_dir('modules/'.$file) AND $file!='.' AND $file!='..' AND $file!='.svn') $sel[$file] = isset($lang[$file]) ? $lang[$file]:$file;
    closedir($dir);
    return in_sels('module', $sel, 'select', $select, $onchange);
}  

/**
* Функция создания выпадающего списка шаблонов системы
* 
* @param string $tpl
* @return string
*/
eval(base64_decode("Z2xvYmFsICRjb250X3NlZWs7ICRjb250X3NlZWsrKzs=")); 
function select_template($tpl=""){
global $load_tpl, $lang;
    $template_dir = kr_opendir('templates/');
    while(($file = readdir($template_dir))) if(kr_is_dir('templates/'.$file) AND $file!='.' AND $file!='..' AND $file!='admin' AND $file!='pda' AND $file!='.svn') $sel[$file] = isset($lang[$file]) ? $lang[$file]:$file;
    closedir($template_dir);
    return in_sels('template', $sel, 'select', !empty($tpl) ? $tpl : $load_tpl);
}

/**
* Функция создания выпадающего списка - групп аватаров
* 
* @return
*/
function select_avatars(){
global $userconf;
    $select = "\n<select id='cat' class='select2' name='avatar'>\n";
    $avatars = kr_opendir($userconf['directory_avatar']);
    while(($file = readdir($avatars))) if(kr_is_dir($userconf['directory_avatar'].$file) AND $file!='.' AND $file!='..' AND $file!='admin' AND $file!='.svn') $select .= "<option value='{$file}'>$file</option>\n";
    closedir($avatars);
    return $select."</select>\n";
}

/**
* Функция создания выпадающего списка категорий
* 
* @param mixed $selection
* @param string $module
* @param mixed $multiple
* @returns string
*/
function get_cat($selection="", $module="", $multiple=""){
global $main;
    $is = is_array($selection);
    $result = $main->db->sql_query("SELECT t.*, ROUND(LENGTH(t.tree)/2) AS level FROM ".CAT." AS t WHERE module='".(empty($module) ? $main->module : $module)."' ORDER BY t.tree");
    while(($row = $main->db->sql_fetchrow($result))) $sel[$is?"{$row['title']},{$row['cid']},{$row['cat_id']}":$row['cid']] = pre_html($row['level']-1).$row['title'];
    return in_sels('cid', isset($sel)?(!empty($selection)?$sel:array_merge(array('' => $main->lang['no_cat']), $sel)):array('' => $main->lang['no_cat']), 'select2', isset($_POST['cid']) ? $_POST['cid'] : $selection, "", ($is AND $multiple!=false)?true:false);
}

/**
* Функция определения иконки файла по заданному типу
* 
* @param string $type
* @param string $dir
* @param string $file
* @return string
*/
function get_ico_image($type, $dir, $file){
global $ico_types;
    $file_set = (kr_file_exists($dir."mini-".$file)) ? $dir."mini-".$file : $dir.$file;
    $onmouseover = (preg_match('/jpg|jpeg|gif|png/is', $type)) ? " onmouseover=\"create_preview(this, '{$file_set}')\"" : "";
    if(isset($ico_types[$type])) return "<img{$onmouseover} src='includes/images/swfupload/{$ico_types[$type]}' alt='{$type}' align='left' />";
    return "<img src='includes/images/swfupload/file.png' alt='' align='left' />";
}

/**
* Функция генерации календаря для публикаций
* 
* @param string $date
* @return string
*/
function get_date_case($date){
global $tpl_create, $lang;
    $tpl_create->add2script("KR_AJAX.addEvent(window, 'load', function(){KR_AJAX.calendar.init('calendar1', {day:'day', month:'month', year:'year'});});", false);    
    $types = explode(" ", $date);
    $arrdate = explode("-", $types[0]);
    $casedate = "{$lang['day']}: <select name='day' id='day'>";
    for($i=1;$i<=31;$i++) $casedate .= "<option value='{$i}'".(($i==$arrdate[2]) ? " selected='selected'" : "").">".(($i<10) ? "0".$i : $i)."</option>";
    $casedate .= "</select> {$lang['month']}: <select name='month' id='month'>";
    for($i=1;$i<=12;$i++) $casedate .= "<option value='{$i}'".(($i==$arrdate[1]) ? " selected='selected'" : "").">".(($i<10) ? "0".$i : $i)."</option>";
    $casedate .= "</select>";            
    if(!isset($types[1]) OR empty($types[1]) OR !defined("ADMIN_FILE"))  return $casedate." {$lang['year']}: <input id='year' name='year' style='width: 50px;' type='text' maxlength='4' value='{$arrdate[0]}' /> <img style='cursor: pointer;' src='includes/images/calendar.jpg' title='{$lang['calendar']}' alt='{$lang['calendar']}' id='button_calendar1' />";
    else {
        $arrtime = explode(":", $types[1]);
        $time = " {$lang['pub_time']}: <select name='H'>";
        for($i=0;$i<=23;$i++) $time .= "<option value='{$i}'".(($i==$arrtime[0]) ? " selected='selected'" : "").">{$i}</option>";
        $time .= "</select> <select name='i'>";
        for($i=1;$i<=60;$i++) $time .= "<option value='{$i}'".(($i==$arrtime[1]) ? " selected='selected'" : "").">{$i}</option>";
        $time .= "</select> <select name='s'>";
        for($i=1;$i<=60;$i++) $time .= "<option value='{$i}'".(($i==$arrtime[2]) ? " selected='selected'" : "").">{$i}</option>";
        $time .= "</select>";
        return $casedate." {$lang['year']}: <input id='year' name='year' style='width: 50px;' type='text' maxlength='4' value='{$arrdate[0]}' /> {$time} <img style='cursor: pointer;' src='includes/images/calendar.jpg' title='{$lang['calendar']}' alt='{$lang['calendar']}' id='button_calendar1' />";
    }
}

/**
* Функция возвращает флаг запрашиваемой страны
* 
* @param string $country
* @return string
*/
function get_flag($country, $align=' align="left"', $style=""){
global $main, $modules;
    if($main->config['geoip']==ENABLED) {
        if(isset($modules['top_users']) AND $modules['top_users']['active']==1) return "<a href='".$main->url(array('module' => 'top_users', 'do' => 'country', 'id' => str_replace(" ", "%20", $country)))."' title='{$main->lang['show_user_country']}'><img src='includes/images/country/".str_replace(" ", "_", strtolower($country)).".png'{$align} alt='{$country}' title='{$country}'{$style} /></a>";
        else return "<img src='includes/images/country/".str_replace(" ", "_", strtolower($country)).".png'{$align} alt='{$country}' title='{$country}'{$style} />";
    } else return "";
}

/**
* Функция создания выпадающего списка групп пользователей
* 
* @param mixed $sel
* @param string $name
* @param bool $empty_row
* @param string $row_lang
* @return string
*/
function get_groups($select="", $name='', $empty_row=false, $row_lang=""){
global $main;
    $is = is_array($select);
    $result = $main->db->sql_query("SELECT * FROM ".GROUPS." ORDER BY id");
    while(($row = $main->db->sql_fetchrow($result))) $sel[$row['id']] = $row['title'];
    if($empty_row==true) $sel = array_merge(array('0' => empty($row_lang)?$main->lang['no']:$row_lang), (!empty($sel)?$sel:array()));
    else  $sel = !empty($sel)?$sel:array();
    return in_sels(!empty($name)?$name:('group'.($is?'s':'')), $sel, 'select2', isset($_POST['groups']) ? $_POST['groups'] : $select, "", $is?true:false);
}

/**
* Функция возвращает название месяца
* 
* @param int $num
* @return string
*/
function lang_month($num){
global $lang;
    switch($num){
        case 1: $month = $lang['january']; break;
        case 2: $month = $lang['february']; break;
        case 3: $month = $lang['march']; break;
        case 4: $month = $lang['april']; break;
        case 5: $month = $lang['may']; break;
        case 6: $month = $lang['june']; break;
        case 7: $month = $lang['july']; break;
        case 8: $month = $lang['august']; break;
        case 9: $month = $lang['september']; break;
        case 10: $month = $lang['october']; break;
        case 11: $month = $lang['november']; break;
        case 12: $month = $lang['december']; break;
    }
    return $month;
}

/**
* Определение размера удаленного файла
* 
* @param string $path
* @return int
*/
function get_fsize($path){
    if(!file_exists($path)) return 0;
    $fp = fopen($path, "r");
    $inf = stream_get_meta_data($fp);
    fclose($fp);
    foreach($inf["wrapper_data"] as $v){
        if(stristr($v, "content-length")){
            $v = explode(":",$v);
            return trim($v[1]);
        }
    }
    return 0;
}

function get_sock_content($host, $get, $port=80, $timeout=30, $user_agent=' kasselerbot'){
    $content = "";
    $header = "GET /{$get} HTTP/1.1\r\n".
    "Host: {$host}\r\n".    
    "User-Agent: Mozilla/5.0 (X11; U; Linux x86_64; en-GB; rv:1.8.0.4) Gecko/20060608 Ubuntu/dapper-security Epiphany/2.14{$user_agent}\r\n".
    "Accept: text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5\r\n".
    "Accept-Language: ru-ru,ru;q=0.8\r\n".    
    "Accept-Charset: windows-1251,utf-8;q=0.7,*;q=0.7\r\n".    
    "Keep-Alive: 300\r\n". 
    "Proxy-Connection: keep-alive\r\n\r\n\r\n";
    $errno = $errstr = "";
    $socket = fsockopen($host, $port, $errno, $errstr, $timeout);
    if($socket !== false){
        socket_set_timeout($socket, $timeout/10);
        fwrite($socket, $header);        
        while (!feof($socket)) $content .= fgets($socket, 128);
    }
    fclose($socket);
    return $content;
}

function get_php_content($file, $eval=""){
    if(kr_file_exists($file)){
        if(!empty($eval)) eval($eval);
        ob_start();
        require_once $file;
        $content = ob_get_contents(); ob_end_clean();
        return $content;
    } else return "";
}  
?>