<?php
/**
* Файл инициализации системы
* 
* @author Igor Ognichenko
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @filesource includes/function/init.php
* @version 2.0
*/
if(!defined("KASSELERCMS") AND !defined("ADMIN_FILE")) die("Access is limited");

define("BLOCK_FILE", true);
define("FUNC_FILE", true);

//session_cache_limiter("private");
session_start();
  
if(function_exists('date_default_timezone_set')) date_default_timezone_set("Europe/Kiev");

function load_includes($pattern, $path){
    $files=array();
    if(($tmpHandle = kr_opendir($path))){
        while(false !== ($tmpFile = readdir($tmpHandle))) if(!kr_is_dir($path.$tmpFile) AND preg_match("#$pattern#i",$tmpFile)) $files[]=$path.$tmpFile;
        closedir($tmpHandle);
    }
    return $files;
}


require_once 'includes/config/config.php';
require_once 'includes/config/configdb.php';
global $config, $cont_seek;
$cont_seek = 2;
header("Content-type: text/html; charset={$config['charset']}");
require_once "includes/function/debugging.php";
 
//Подключение файлов конфигурации 
foreach(load_includes('config_.*?\.php', 'includes/config/') as $filename) require_once $filename;
require_once "includes/function/ipblock.php";
//Подключение файлов define
foreach(load_includes('.*?\.php', 'includes/define/') as $filename) require_once $filename;

global $database;
$adminfile = $config['adminfile'];
$magic_quotes = true;
$dbg_status = true;
$redirect = "";
$parse_ref = (isset($_SERVER['HTTP_REFERER']) AND !empty($_SERVER['HTTP_REFERER'])) ? parse_url($_SERVER['HTTP_REFERER']) : array();

//Подключение основных классов системы
if(preg_match('/(.*?)utf(.*?)/i', $config['charset'])) require_once "includes/function/utf8.php";
if(kr_file_exists("includes/classes/{$database['type']}.class.php") AND !defined("INSTALLCMS")) require_once "includes/classes/{$database['type']}.class.php";   
require_once "includes/classes/session.class.php";
require_once "includes/classes/templates.class.php";
require_once "includes/classes/main.class.php";
require_once "includes/classes/classes.php";

//Подключение функций системы
require_once "includes/function/functions.php";
require_once "includes/function/replace.php";
require_once "includes/function/gets.php"; 
require_once "includes/function/bool.php";
require_once "includes/function/kernel.php";  
require_once "includes/function/templates.php";
require_once "includes/function/forms.php";
if(is_ajax()) require_once "includes/function/additional.php";

function remove_port($host_value){
    $out = "";
    if(preg_match("/([^:]+)/", $host_value, $out)) return $out[1];
    return $host_value; 
}

global $lang, $db, $main, $language, $template; 
$httphost = remove_port(get_env('HTTP_HOST'));
if(!empty($parse_ref)) $parse_host=remove_port($parse_ref['host']);
if($config['filrer_referer']==ENABLED AND isset($_POST) AND count($_POST)>0 AND !empty($parse_ref) AND $httphost!=$parse_host) redirect(get_env('HTTP_REFERER')); 
load_tpl();
$geterate_time = new timer;
$version_sys = "2.0.5";
$license_sys = "FULL";

$modules_sitemap = array(
    'news'     => NEWS,
    'files'    => FILES,
    'media'    => MEDIA,
    'pages'    => PAGES,
    'shop'     => SHOP,
    'jokes'    => '',
    'top_site' => '',
    'faq'      => '',
    'voting'   => '',
    'content'  => ''  
);

$copyright_file = "<?php\n/**********************************************/\n/* Kasseler CMS: Content Management System    */\n/**********************************************/\n/*                                            */\n/* Copyright (c)2007-2009 by Igor Ognichenko  */\n/* http://www.kr-cms.net/               */\n/*                                            */\n/**********************************************/\n\nif (!defined('FUNC_FILE')) die('Access is limited');\n\n";
$cache_clear_ignore = false;

//Проверка и создание директорий для временных файлов
if(!kr_file_exists("uploads/cache/")) kr_mkdir("uploads/cache/", 0777);
if(!kr_file_exists("uploads/tmpfiles/")) kr_mkdir("uploads/tmpfiles/", 0777);
  
@ini_set('url_rewriter.tags', '');
@ini_set('arg_separator.output', '&amp;');
@ini_set('register_globals', 'off');
@ini_set('display_errors', true);
@ini_set('html_errors', false);
@ini_set('error_reporting', E_ALL ^ E_NOTICE);
@ini_set("safe_mode", false);

if(isset($_REQUEST['GLOBALS']) || isset($_FILES['GLOBALS']) || isset($_SERVER['GLOBALS']) || isset($_COOKIE['GLOBALS']) || isset($_ENV['GLOBALS'])) die('GLOBALS overwrite attempt');
if(count($_REQUEST) > 1000) die('possible exploit');
foreach ($GLOBALS as $key => $dummy) if(is_numeric($key)) die('numeric key detected');

if(is_ajax()){
	foreach($_POST as $key => $dummy) if(!empty($_POST[$key]) AND !is_int($_POST[$key]) AND !is_array($_POST[$key])) $_POST[$key] = utf8decode($dummy);
}

//Отключение register_globals on
if (ini_get('register_globals') == 1) foreach($_REQUEST as $key => $var) unset($GLOBALS[$key]);

foreach (array('PHP_SELF', 'HTTP_ACCEPT_LANGUAGE', 'HTTP_AUTHORIZATION') as $current) {
    if(get_env($current) AND false === strpos(get_env($current), '<')) $$current = get_env($current);
    elseif(!isset($$current) OR false !== strpos($$current, '<')) $$current = '';  // очистка XSS
}
unset($current);
//Фильтрация GET массива
if(!$main->mod_rewrite AND !isset($_GET['mod_rewrite'])){
    foreach($_GET as $name=>$value){
        if(!is_array($value)){
            if(preg_match('/(\.\.\/|[\'"]|<|>|\(+)/s', $value)) kr_http_ereor_logs("403");
            $_GET[$name] = strip_tags($value);
        }
    }
} else $main->parse_rewrite();
$_arr_home_modules = explode(',', $config['default_module']);
$module_name = (isset($_GET['module'])) ? $_GET['module'] : $_arr_home_modules[0];
if(isset($_GET['id']) AND !preg_match('/([a-zA-Zа-яА-Я_\-0-9\.]+)/is', $_GET['id'])) kr_http_ereor_logs("403");
$session = new session($config['interval_session_update']);
if(isset($_GET['http_error'])) kr_http_ereor_logs($_GET['http_error']);
//Определение языкового файла
get_language();
//Подключение графических элементов систем
(isset($main->tpl) AND kr_file_exists("templates/{$main->tpl}/{$language}/images.php")) ? require_once "templates/{$main->tpl}/{$language}/images.php" : require_once "includes/language/{$language}/images.php";

if($config['disable_site']==ENABLED AND !is_support() AND !defined("ADMIN_FILE")){
    die(stripslashes($config['disable_description']));
}
$main->init();
$template = new template;

define("USER_FOLDER", "filedata-".$main->user['user_folder']);
load_tpl();
if(!defined("ENGINE") AND !isset($_GET['blockfile'])){
    if(!is_ajax()){
        if(!defined("ADMIN_FILE")) $template->get_tpl(get_index());
        else {
            if(!defined("INSTALLCMS")){
                if(isset($_SESSION['admin'])) $template->get_tpl("templates/admin/index.tpl");
                else $template->get_tpl("templates/admin/login.tpl");
            } else $template->get_tpl("install/template/index.tpl");
        }
    }
    if(!isset($_GET['ajaxed'])){
        if(!defined("ADMIN_FILE")){
            require_once "includes/function/usertpl.php";
            $tpl_create = new user_tpl;
        } else {
            require_once "includes/function/admintpl.php";
            $tpl_create = new admin_tpl;
        }
        $tpl_create->add2script("includes/language/{$language}/lang.js");                
        $tpl_create->tpl_creates();
    } else $tpl_create = new tpl_create;
    if(!is_ajax() AND !defined("INSTALLCMS")) $template->set_tpl('$time', preg_replace(array("#{query}#", "#{query_time}#", "#{time}#"), array($db->num_queries, $db->total_time_db, $geterate_time->stop()), $lang['page_generate']));
} elseif(defined("ENGINE")) {
    require_once "includes/function/usertpl.php";
    $tpl_create = new user_tpl;
}
?>