<?php
/**
* Ядро системы
* 
* @author Igor Ognichenko
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @filesource includes/function/kernel.php
* @version 2.0
*/
if (!defined('FUNC_FILE')) die('Access is limited');

/**
* Функция вывода страниц без оформления
* 
* @param string $content
* @param string $title
* @return void
*/
function page($content, $title){
global $config, $load_tpl;
require_once "includes/nocache.php";
die("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>
<title>{$title}</title>
<meta http-equiv='content-type' content='text/html; charset={$config['charset']}' />
<meta name='author' content='{$config['home_title']}' />
<meta name='resource-type' content='document' />
<meta name='document-state' content='dynamic' />
<meta name='distribution' content='global' />
<meta name='robots' content='index, follow' />
<meta name='revisit-after' content='1 days' />
<meta name='rating' content='general' />
<meta name='generator' content='{$config['cms_version']}' />
<meta name='description' content='{$config['description']}' />
<meta name='keywords' content='{$config['keywords']}' />
<meta name='Cache-Control' content='no-cache' />
<meta http-equiv='Expires' content='0' />
<meta name='copyright' content='Copyright (c){$config['cms_version']}' />
<base href='http://".get_host_name()."/' />
<link rel='stylesheet' href='templates/{$load_tpl}/style.css' type='text/css' />
<link rel='stylesheet' href='includes/css/system.css' type='text/css' />
<link rel='shortcut icon' href='favicon.ico' type='image/x-icon' />
</head>
<body>
<script type='text/javascript' src='includes/javascript/kr_ajax.js'></script>
<script type='text/javascript' src='includes/javascript/function.js'></script>
<script type='text/javascript' src='templates/{$load_tpl}/jsconfig.js'></script>
{$content}
</body>
</html>");
}

/**
* Функция фильтрации полученных данных
* 
* @param string $str
* @param mixed $html
* @return string
*/
function kr_filter($str, $html=""){
global $config, $filter;
    if(!class_exists('filter')) require_once "includes/classes/filter.class.php";
    if($str){
        $filter->set_filter_atribute($html, $config['typeEditor'], explode(",", $config['htmlTags']));
        return trim($filter->filter_text($str));
    }
    return $str;
}

/**
* Функция фильтрации массива по заданным ключевым полям
* 
* @param array $array_kay
* @param string $name
* @param mixed $type
*/
function filter_arr($array_kay, $name, $type=""){
    if($name == POST) foreach ($array_kay as $value) $_POST[$value] = (isset($_POST[$value])) ? kr_filter($_POST[$value], $type) : "";
    elseif($name == GET) foreach ($array_kay as $value) $_GET[$value] = (isset($_GET[$value])) ? kr_filter($_GET[$value], $type) : "";
}

/**
* Функция декодирования кодировки с UTF8
* 
* @param string $str
* @return string
*/
function utf8decode($str){
global $config;
    $is_utf = is_utf8($str);
    if(strtoupper($config['charset'])!='UTF-8'){
        if(function_exists('mb_convert_encoding') AND $is_utf) return mb_convert_encoding($str, strtoupper($config['charset']), "UTF-8");
        elseif(function_exists('iconv') AND $is_utf) return iconv("UTF-8", strtoupper($config['charset']), $str);
        else return $str;
    } else return $str;
}

/**
* Функция кодирования в UTF8
* 
* @param string $str
* @return string
*/
function utf8code($str){
global $config;
   $is_utf = is_utf8($str);
   if(function_exists('mb_convert_encoding') AND !$is_utf) return mb_convert_encoding($str, "UTF-8", $config['charset']);
   elseif(function_exists('iconv') AND !$is_utf) return iconv($config['charset'], "UTF-8", $str);
   else return $str;
}

/**
* Функция даты по Гринвичу с учетом коррекции системы
* 
* @param string $format
* @return string
*/
function kr_date($format){
global $config;
    return date($format, strtotime(gmdate($format))+(intval($config['GMT_correct'])*60*60));
}

/**
* Функция коррекции выводимой даты
* 
* @param string $date
* @param string $format_date
* @return string
*/
function format_date($date, $format_date=""){
global $config, $userinfo;
    if(empty($userinfo['user_gmt']) OR !isset($userinfo['user_gmt'])) $userinfo['user_gmt'] = 0;
    $GMT = $userinfo['user_gmt'];
    $format_date = (empty($format_date)) ? $config['date_format'] : $format_date;
    return (preg_match('/\+|([0-9]*)/', $GMT)) ? date($format_date, strtotime($date)+intval($GMT)*(60*60)) : date($format_date, strtotime($date)-intval($GMT)*(60*60));
}

/**
* Функция обратной коррекции даты
* 
* @param string $date
* @param string $format_date
* @return string
*/
function backgmdate($date, $format_date=""){
global $config, $userinfo;
    if(empty($userinfo['user_gmt']) OR !isset($userinfo['user_gmt'])) $userinfo['user_gmt'] = 0;
    $GMT = $userinfo['user_gmt'];
    $format_date = (empty($format_date)) ? $config['date_format'] : $format_date;
    return (preg_match('/\+|([0-9]*)/', $GMT)) ? date($format_date, strtotime($date)-intval($GMT)*(60*60)) : date($format_date, strtotime($date)+intval($GMT)*(60*60));
}

/**
* Функция коррекции выводимой даты и определение давности публикации. Сегодня в ..., Вчера в 
* 
* @param mixed $date
* @return string
*/
function user_format_date($date, $his=false){
global $config, $lang;    
    $format_date = $config['date_format'];
    $d = format_date($date, "Y-m-d");
    $today = date("Y-m-d");
    if(date("Y-m-d", strtotime($d)+60*60*24)==$today OR $d==$today){
        if($d==$today) return "{$lang['today']} ".format_date($date, "H:i");
        else return "{$lang['yesterday']} ".format_date($date, "H:i");
    } elseif(!$his) return format_date($date, $format_date);
    else return format_date($date, "{$format_date} H:i:s");
}

/**
* Функция проверки являться ли посетитель поисковой системой
* 
* @param string $name
* @param string $robots
*/
function check_bots($name){
global $list_bots;    ;
    foreach ($list_bots as $bot_name) {
        if (preg_match("/$bot_name/i", $name)) return true;
    }
    return false;
}

/**
* Удаляет директорию включая поддиректории
* 
* @param string $dir
* @return bool
*/
function remove_dir($dir){
    if ($dir[strlen($dir)-1]!="/") $dir .= "/";
    if (kr_file_exists($dir) AND $handle = kr_opendir($dir)){
        while(($obj = readdir($handle))){
            if ($obj!="." AND $obj!=".."){
                if (kr_is_dir($dir.$obj)){
                    if (!remove_dir($dir.$obj)) return false;
                } else if(kr_is_file($dir.$obj)){
                           if (!kr_unlink($dir.$obj)) return false;
                       }
                }
       }
       closedir($handle);
       if(kr_file_exists($dir) AND @rmdir($dir)) return true;
       else return false;
   }
return false;
}

/**
* Возвращает количество файлов в директории и включая поддиректории
* 
* @param string $dir
* @param string $regEx
* @return int
*/
function dir_file_count($dir){
    if(!kr_file_exists($dir)) return false;
    if(kr_is_file($dir)) return 1;
    if(kr_is_dir($dir) AND $dh=kr_opendir($dir)){
        $size=0;
        while(($file=readdir($dh))!==false){
            if($file=="." OR $file=="..") continue;
            $size+=dir_file_count($dir."/".$file);
        }
        closedir($dh);
        return $size;
    } else return 0;
}

/**
* Возвращает размер файлов в директории и включая поддиректории
* 
* @param string $dir
* @param int $buf
* @return int
*/
function dir_size($dir, $buf=2){
    static $buffer;
    if(isset($buffer[$dir])) return $buffer[$dir];
    if(kr_is_file($dir)) return kr_filesize($dir);
    if(($dh=kr_opendir($dir))){
        $size=0;
        while(($file=readdir($dh))!==false){
            if($file=="." OR $file=="..") continue;
            $size+=dir_size($dir."/".$file,$buf-1);
        }
        closedir($dh);
        if($buf>0) $buffer[$dir]=$size;
     return $size;
     }
return false;
}

/**
* Вырезает текст от начала, входящего текста, до заданного слова
* 
* @param string $text
* @param int $count
* @param string $return
* @return string
*/
function cut_text($text, $count=63, $return=""){
    $textarr = explode(" ", $text);
    if (count($textarr)>$count){
        for($i=0; $i<$count; $i++) $return .= $textarr[$i]." ";
        return $return."...";
    } else return $text;
}

/**
* Вырезает текст от начала, входящего текста, до заданного слова
* 
* @param string $text
* @param int $count
* @param string $return
* @return string
*/
function cut_char($text, $count=55, $return=""){
    if(strlen($text)>$count) return $return.substr($text, 0, $count)."...";
    else return $text;
}

/**
* Преобразования массива в информационную строку
* 
* @param array $var
* @param string $class
* @param string $text
* @return string
*/
function var2string($var, $class, $text){
    $string = "";
    foreach ($var as $var_name=>$var_value){
        if(!is_array($var_value)) $string .= "<span class='{$class}'>{$text}: </span>{$var_name} = {$var_value}<br />\n";
        else $string .= "<span class='{$class}'>{$text}: </span><pre>{$var_name} =  ".htmlspecialchars(var_export($var_value, true))."</pre><br />\n";  
    }
    return $string;
}

/**
* Функция транслитерации
* 
* @param string $string
* @return string
*/
function cyr2lat($string){
    $cyr = "/а/ /б/ /в/ /г/ /д/ /е/ /з/ /и/ /к/ /л/ /м/ /н/ /о/ /п/ /р/ /с/ /т/ /у/ /ф/ /ц/ /ы/";
    $lat = "a b v g d e z i k l m n o p r s t u f c y";
    $cyr2  = "/А/ /Б/ /В/ /Г/ /Д/ /Е/ /З/ /И/ /К/ /Л/ /М/ /Н/ /О/ /П/ /Р/ /С/ /Т/ /У/ /Ф/ /Ы/";
    $cyr3 = "/й/ /ё/ /ж/ /х/ /ч/ /ш/ /щ/ /э/ /ю/ /я/ /ъ/ /ь/ /'/ /\"/";
    $cyr2lat = "j,jo,zh,h,ch,sh,sch,je,ju,ya,,,,";
    return kr_chenge_reg(preg_replace("/ +/ms", "_", trim(strip_tags(preg_replace(explode(' ', $cyr2), explode(' ', $lat), preg_replace(explode(' ', $cyr), explode(' ', $lat), preg_replace(explode(' ', $cyr2), explode(' ', $lat), preg_replace(explode(' ', $cyr3), explode(',', $cyr2lat), $string))))))));
}  

/**
* Собстеная функция strtolower
* 
* @param string $string
* @param string $type
* @return string
*/
function kr_chenge_reg($string, $type='lower'){
  $convert_to = array(
    "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u",
    "v", "w", "x", "y", "z", "à", "á", "â", "ã", "ä", "å", "æ", "ç", "è", "é", "ê", "ë", "ì", "í", "î", "ï",
    "ð", "ñ", "ò", "ó", "ô", "õ", "ö", "ø", "ù", "ú", "û", "ü", "ý", "а", "б", "в", "г", "д", "е", "ё", "ж",
    "з", "и", "й", "к", "л", "м", "н", "о", "п", "р", "с", "т", "у", "ф", "х", "ц", "ч", "ш", "щ", "ъ", "ы",
    "ь", "э", "ю", "я"
  );
  $convert_from = array(
    "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U",
    "V", "W", "X", "Y", "Z", "À", "Á", "Â", "Ã", "Ä", "Å", "Æ", "Ç", "È", "É", "Ê", "Ë", "Ì", "Í", "Î", "Ï",
    "Ð", "Ñ", "Ò", "Ó", "Ô", "Õ", "Ö", "Ø", "Ù", "Ú", "Û", "Ü", "Ý", "А", "Б", "В", "Г", "Д", "Е", "Ё", "Ж",
    "З", "И", "Й", "К", "Л", "М", "Н", "О", "П", "Р", "С", "Т", "У", "Ф", "Х", "Ц", "Ч", "Ш", "Щ", "Ъ", "Ъ",
    "Ь", "Э", "Ю", "Я"
  );

  if($type=='lower') return str_replace($convert_from, $convert_to, $string);
  else return str_replace($convert_to, $convert_from, $string);
} 
     
/** 
* Функция перенаправления страницы
* 
* @param string $var
* @return void
*/
function redirect($var){
global $adminfile, $main;
    if(is_int($var)){
        if($var==BACK){
            $REFERER = kr_filter(get_env('HTTP_REFERER'), TAGS);
            if(is_ajax()) kr_header("Location: {$REFERER}&ajax=true");
            else kr_header("Location: {$REFERER}");
        }elseif($var==MODULE){
            if(is_ajax()){
                if(!defined("ADMIN_FILE")) kr_header("Location: ".$main->url(array('module' => $main->module))."&ajax=true");
                else kr_header("Location: {$adminfile}?module={$_GET['module']}&ajax=true");
            } else {
                if(!defined("ADMIN_FILE")) kr_header("Location: ".$main->url(array('module' => $main->module)));
                else kr_header("Location: {$adminfile}?module={$_GET['module']}");
            }
        }
    } else {
        $var = str_replace("amp;", "", $var);
        if(is_ajax()) kr_header("Location: {$var}&ajax=true");
        else kr_header("Location: {$var}");
    }
}

/**
* Функция создания редактора
* 
* @param string $name
* @param int $rows
* @param string $size
* @param string $value
* @param int $type
* @param string $butons
* @return string
*/
function editor($name, $rows=5, $size='345px', $value="", $type=0, $butons=""){
global $editor_js, $tpl_create;
    $value = (isset($_POST[$name])) ? $_POST[$name] : $value;
    if($type==0){
    	$tpl_create->add2script("includes/javascript/kr_bbeditor.js");
    	$tpl_create->add2script("KR_AJAX.addEvent(window, 'load', function(){bbeditor.init('{$name}', '{$butons}');});", false);
    	$r = "<table cellpadding='0' cellspacing='0' style='width: {$size}'><tr><td><textarea id='{$name}' name='{$name}' rows='".(is_int($rows)?$rows:5)."' cols='60' style='width: {$size};".(!is_int($rows)?" height:{$rows};":"")."' class='main_editor'>".htmlspecialchars($value, ENT_QUOTES)."</textarea></td></tr></table>";
    }
    $editor_js = true;
    return $r;
}

/**
* Функция разбора категорий
* 
* @param string $string
* @return string
*/
function cat_parse($string){
global $main;
    if(empty($string)) return $main->lang['nocat'];
    $return = "";
    $cats = explode("|", $string);
    $count = count($cats);
    if($count>0 AND $string!='|'){
        for($i=0;$i<$count-1;$i++){
            $list = explode(",", $cats[$i]);
            $return .= "<a class='sys_link' href='".$main->url(array('module' => $main->module, 'do' => 'category', 'id' => case_id($list[2], $list[1])))."' title='{$main->lang['view_cat']}'>{$list[0]}</a>";
            $return .= ($i<$count-2) ? ", " : "";
        }
        return $return;
    } else return $main->lang['nocat'];
}

/**
* Функция выбора URL идентификатора
* 
* @param mixed $rewrite_id
* @param mixed $id
* @return string
*/
function case_id($rewrite_id, $id){
global $main;
    if($main->mod_rewrite) return kr_encodeurl($rewrite_id);
    else return $id;
}

/**
* Функция проверки передаваемых параметров методом POST
* 
* @param array $kays
* @param array $langs
* @param string $msg
*/
function error_empty($kays, $langs, $msg=""){
global $lang;
    foreach ($kays as $kay=>$value) if(empty($_POST[$value])) $msg .= (isset($lang[$langs[$kay]])) ? $lang[$langs[$kay]] : $langs[$kay];
    return $msg;
}

/**
* Функция проверки e-mail адреса на валидность
* 
* @param mixed $email
* @resurn string
*/
function check_mail($email){
global $lang;
    if(empty($email) OR !preg_match('/^[_\.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,6}$/i', strtolower($email))) return "{$lang['error_email']}";
    else return "";
}

/**
* Функция преобразования строки в URL учитывая параметр mod_rewrite
* 
* @param string $url
* @return string
*/
function kr_encodeurl($url){
global $main;
    if($main->rewrite_id) return str_replace('+', ' ', urlencode(utf8code($url)));
    else return urlencode($url);
}

/**
* Функция преобразования URL в строку учитывая параметр mod_rewrite
* 
* @param string $url
* @return string
*/
function kr_decodeurl($url){
global $main;
    if($main->rewrite_id) return utf8decode(urldecode($url));
    else return urldecode($url);
}

/**
* Функция преобразования URL в строку
* 
* @param string $url
* @return string
*/
function kr_normalize_url($url){
   return urlencode(utf8code(urldecode($url)));
}

/**
* Функция преобразования строки в строковой массив
* 
* @param string $string
* @param string $return
*/
function array_create($string, $return=""){
    $arr = explode(",", $string);
    $count = count($arr);
    for($i=0;$i<$count;$i++) $return .= ($i<$count-1) ? "'{$arr[$i]}', " : "'{$arr[$i]}'";
    return $return;
}

/**
* Функция проверки элемента массива, если, элемент найден возвращается значение в ином случаи его ключ
* 
* @param mixed $key
* @param mixed $array
* @return mixed
*/
function array_value_set($key, $array){
    if(isset($array[$key])) return $array[$key]; else return $key;
}

/**
* Функция выполнения SQL запроса INSERT
* 
* @param arrray $array
* @param string $table
* @return resourse
*/
function sql_insert($array, $table){
global $db;
    $insert = "INSERT INTO `{$table}` (";
    $values = ") VALUES (";
    $count = count($array);
    $i=0;
    foreach ($array as $kay=>$value){
        $insert .= ($i<$count-1) ? "`{$kay}`, " : "`{$kay}`";
        $values .= ($i<$count-1) ? "'{$value}', " : "'{$value}'";
        $i++;
    }
    return $db->sql_query($insert.$values .= ");");
}

/**
* Функция выполнения SQL запроса UPDATE
* 
* @param array $array
* @param string $table
* @param string $where
* @return resourse
*/
function sql_update($array, $table, $where){
global $db;
    $update = "UPDATE {$table} SET ";
    $count = count($array);
    $i=0;
    foreach ($array as $kay=>$value){
        $update .= ($i<$count-1) ? "`{$kay}`='{$value}', " : "`{$kay}`='{$value}'";
        $i++;
    }
    $update .= " WHERE {$where}";
    return $db->sql_query($update);
}

/**
* Функция всегда положительного CRC32
* 
* @param string $string
* @return string
*/
function crc32_integer($string){
    $crc32 = crc32($string);
    return(($crc32<0) ? $crc32*-1 : $crc32);
}    

/**
* Функция преобразования масива в строковой массив
* 
* @param array $array
* @param string $arr_name
* @param int $level
*/
function arr2str($array, $arr_name='data', $level=0){
    if($level==0) return '$'.$arr_name." = ".var_export($array, true).";";
    else return "array(".implode(", ",$array).")";
}

/**
* Функция META перенаправления  с выводом информации на заданных промежуток времени
* 
* @param int $time
* @param string $url
* @param string $message
* @return void
*/
function meta_refresh($time, $url, $message=""){
    echo "<meta http-equiv='refresh' content='{$time}; url={$url}'>";
    if(!empty($message)) info($message);
}

/**
* Функция g-zip сжатия страницы
* 
* @param string $contents
* @return string
*/
function gz($contents){
global $config;
    if (!check_can_gzip() || $config['gz']!=ENABLED) echo $contents;
    else {         
        header("Content-Encoding: gzip");
        echo "\x1f\x8b\x08\x00\x00\x00\x00\x00";
        $size = strlen($contents);
        $crc = crc32($contents);
        $contents = gzcompress($contents, $config['gzlevel']);
        $contents = substr($contents, 0, strlen($contents) - 4);
        print $contents;
        print pack('V', $crc);
        print pack('V', $size);
    } 
}

/**
* Функция создания cookies
* 
* @param string $value
* @param string $name
* @param int $time
*/
function setcookies($value, $name, $time=0){
global $config;
       $time = ($time==0) ? time() + 60*60*24*intval($config['time_of_life_session']) : $time;
       $time = ($time==1) ? 0 : $time;
       setcookie($name, $value, $time, "/");
}

/**
* Функция экранирования
* 
* @param string $var
* @return string
*/
function magic_quotes($var){
global $magic_quotes;
    if($magic_quotes==true){
        if(function_exists("mysql_escape_string")) return str_replace('\\\"', '"', mysql_escape_string(trim($var)));
        else return str_replace('\\\"', '"', addslashes(trim($var)));    
    } else return $var;
}

/**
* Функция декодирования bb тегов в HTML
* 
* @param string $string
* @param string $code
* @return string
*/
function bb($string, $code='encode'){
global $bb;
    require_once "includes/classes/bbcode.class.php";
    if($code=='encode'){
        $bb->set_text($string);
        return addslashes($bb->get_html());
    } else {
        $bb->text = $string;
        $bb->html2bb();
        return $bb->get_bb();
    }
}

/**
* Дополнительная функция декодирования bb тегов в HTML
* 
* @param string $text
* @return string
*/
function parse_bb($text){
global $bb, $config, $tpl_create;
    if(!is_object($bb)) require_once "includes/classes/bbcode.class.php";
    if($config['imgpdaversion']!=ENABLED AND $config['pdaversion']==ENABLED){
        require_once "includes/function/pda.php";
        if(check_pda()) $text = preg_replace('/<img(.*?)>/si', '', $text);
    }  
  if(preg_match('/<\!\-\-start\sminiature\-\->(.+?)<\!\-\-end miniature\-\->/', $text)) $tpl_create->add2script('includes/javascript/highslide/highslide.js');  
    if(preg_match('/(.*?)(\[(flash.*|video|mp3|radio|hide|cite.*|code|php|html|css|xml|javascript|java|cpp|delphi|python|ruby|sql)\])(.*?)/si', $text)){
        $bb->text = $text;
        $bb->other_bb();
        return stripcslashes($bb->get_bb());
    } else return stripcslashes($text);
}

/**
* Функция определения загружаемого шаблона
* 
* @return void
*/
function load_tpl(){
global $config, $load_tpl, $tpl_config, $main, $userinfo;
    if(defined("ADMIN_FILE")) $load_tpl = "admin";
    elseif(!is_user()) $load_tpl = $config['template'];
    elseif(isset($main->user['user_template']) AND $config['case_template']==ENABLED AND kr_file_exists("templates/{$main->user['user_template']}")) $load_tpl = $main->user['user_template'];
    elseif(isset($main->user['user_template']) AND empty($main->user['user_template'])) $load_tpl = $config['template'];    
    else $load_tpl = $config['template'];
    if(!defined("ADMIN_FILE") AND isset($_COOKIE['them']) AND kr_file_exists("templates/{$_COOKIE['them']}/")) $load_tpl = $_COOKIE['them'];
    if($config['pdaversion']==ENABLED){
        require_once "includes/function/pda.php";
        if(check_pda()) $load_tpl = 'pda'; 
    }
    if(kr_file_exists("templates/{$load_tpl}/config_tpl.php")) require_once "templates/{$load_tpl}/config_tpl.php";
}

/**
* Функция создания анализатора переменных
* 
* @return void
*/
function variables(){
global $variable;
    if(isset($_GET)) $variable['GET'] = var2string($_GET, 'get_var', 'GET');
    if(isset($_POST)) $variable['POST'] = var2string($_POST, 'post_var', 'POST');
    if(isset($_SESSION)) $variable['SESSION'] = var2string($_SESSION, 'session_var', 'SESSION');
    if(isset($_COOKIE)) $variable['COOKIE'] = var2string($_COOKIE, 'cookie_var', 'COOKIE');
    if(isset($_FILES)) $variable['FILES'] = var2string($_FILES, 'files_var', 'FILES');
    $variable['SESSIONID'] = "<span class='files_var'>SESSION_ID: </span>".session_id()."<br />\n";
}

/**
* Синоним функции header
* 
* @param mixed $command
* @return void
*/
eval(base64_decode("Z2xvYmFsICRjb250X3NlZWs7ICRjb250X3NlZWstLTs="));
function kr_header($command){
    header($command);
    exit;
}

/**
* Функция отправки e-mail сообщений
* 
* @param string $to
* @param string $sender
* @param string $from
* @param string $from_name
* @param string $subject
* @param string $body
* @return bool
*/
function send_mail($to, $sender, $from, $from_name, $subject, $body){
global $config;    
    require_once "includes/classes/mail.class.php"; 
    $sender = parse_mylang($sender);    
    $from_name = parse_mylang($from_name);
    $subject = parse_mylang($subject);
    $body = parse_mylang($body);
    $body = str_replace("\n", "<br />", $body);
    $mail = new mailman();
    if($config['log_emails_send']==ENABLED) $mail->log = true;
    if($config['send_mail']!=ENABLED) $mail->sending = false;    
    $mail->smtp = ($config['type_email_send']!='mail') ? true : false;
    $mail->charset = $config['charset_mail'];
    $mail->is_html = ($config['type_emeils']=='text/html') ? true : false;
    $header = array(
        'To' => "{$sender} <{$to}>",
        'From' => "{$from_name} <{$from}>",
        'Subject' => $subject,
    );    
    $mail->send($to, $header, $body);
}

/**
* Функция разбиения на страницы
* 
* @param mixed $count
* @param mixed $this_page
* @param array $url_array
*/
function other_pages_list($count, $this_page, $url_array){
global $main;
    $uris = array();
    $pages = "<div class='pagebreak' id='{$main->module}_other_pages'>";
    if ($count > 1) {
        if (isset($this_page) AND $this_page>1){
            $pages .= "<a class='sys_link' href='\$uris[".count($uris)."]'><b>&#171;</b></a>";
            $uris[] = $this_page-1;
        }
        for ($i=1;$i<=$count;$i++) {
            if ($i == $this_page) $pages .= "<b class='noselect'>{$i}</b>";
            elseif((($i > ($this_page - 5)) AND ($i < ($this_page + 5))) OR ($i == $count) OR ($i == 1)){
                $pages .= "<a class='sys_link' href='\$uris[".count($uris)."]'><b>{$i}</b></a>";
                $uris[] = $i;
            } elseif ($i<$count AND ($count>6 AND $i==1) OR ($pagenum<$count-5 AND $i==$count-1)) $pages .= "<b class='noselect'>...</b>";
        }
        if ($this_page<$count) {
            $pages .= "<a class='sys_link' href='\$uris[".count($uris)."]'><b>&#187;</b></a>";
            $uris[] = $this_page+1;
        }
        foreach($uris as $kay=>$value) $uris_link[$kay] = $main->url($url_array+array('pagebreak' => $value)+(isset($_GET['page']) ? array('page' => $_GET['page']) : array()));
        $pages = preg_replace('/\$uris\[([0-9]*)\]/sie', "\$uris_link['\\1']", $pages);
    }
    return $pages."</div>";
}

/**
* Функция парсинга тега page_breack
* 
* @param string $text
* @param mixed $config
* @return string
*/
function pagebreak($text, $config){
global $main;
    if($config!=ENABLED) return $text = preg_replace('/\[PAGE_BREAK\]/is', '', $text);
    else{
        if(preg_match('/\[PAGE_BREAK\]/s', $text)){
            $arr_page = explode("[PAGE_BREAK]", $text);
            $main->parse_rewrite(array('module', 'do', 'id', 'pagebreak', 'page'));
            $link = array('module' => $main->module, 'do' => $_GET['do'], 'id' => $_GET['id']);
            if(isset($_GET['pagebreak']) AND isset($arr_page[$_GET['pagebreak']-1])) return $arr_page[intval($_GET['pagebreak'])-1].other_pages_list(count($arr_page), intval($_GET['pagebreak']), $link);
            else return $arr_page[0].other_pages_list(count($arr_page), 1, $link);
        } else return $text;
    }
}

/**
* Функция переименования временной директории прикрепленных файлов
* 
* @param string $source
* @param string $dest
* @return bool
*/
function rename_attach($source, $dest){
global $main;
    $result = $main->db->sql_query("SELECT id, path FROM ".ATTACH." WHERE path LIKE '{$source}%'");
    if($main->db->sql_numrows($result)>0 AND $source!=$dest){
        if(kr_file_exists($source)) kr_rename($source, $dest);
        while(($row = $main->db->sql_fetchrow($result))) sql_update(array('path' => str_replace($source, $dest, $row['path'])), ATTACH, "id='{$row['id']}'");
        return true;
    } else {
        if(kr_file_exists($source) AND dir_file_count($source)==0) remove_dir($source);
        return false;
    }
}

/**
* Функция шифрования пароля пользователей
* 
* @param string $string
* @return string
*/
function pass_crypt($string){
    return md5($string);
}

/**
* Функция добавления пунктов к пользователю
* 
* @param int $points
* @return void
*/
function add_points($points=0){
global $main;
    if($main->user['uid']!='-1') {
        if(isset($_SESSION['cache_session_user'])) unset($_SESSION['cache_session_user']);
        $main->user['user_points'] += $points;
        $main->db->sql_query("UPDATE ".USERS." SET user_points=user_points+{$points} WHERE uid='{$main->user['uid']}'");
        list($special) = $main->db->sql_fetchrow($main->db->sql_query("SELECT special FROM ".GROUPS." WHERE id={$main->user['user_group']}"));
        if($special!="1"){
            list($gid, $points) = $main->db->sql_fetchrow($main->db->sql_query("SELECT id, points FROM ".GROUPS." WHERE id>'{$main->user['user_group']}' AND special=0 ORDER BY id LIMIT 1"));
            if($main->user['user_points']>=$points AND !empty($gid)) $main->db->sql_query("UPDATE ".USERS." SET user_group='{$gid}' WHERE uid='{$main->user['uid']}'");
        }
    }
}

/**
* Функция создает строку переменных из GET массива текучей страницы
* 
* @param array $ignore
* @param array $ignore_key
* @return string
*/
function parse_get($ignore=array(), $ignore_key=array()){
    $GET = $_GET; $url = "";
    foreach($GET as $key => $value) $url .= (!in_array($key, $ignore) AND !isset($ignore_key[$key])) ? "&amp;{$key}={$value}" : "";
    return $url;
}

/**
* Функция создания списка тегов
* 
* @param string $tags_str
* @param string $modul
* @return string
*/
function list_tags($tags_str, $modul){
global $main;
    $tags_list = '';
    if ($tags_str!= '') {
        $tags_arr = explode(',', $tags_str);
        foreach ($tags_arr as $key => $value)  $tags_list.= "<span class='tag'><a href='".$main->url(array('module' => $modul, 'do' => 'tags', 'id' => kr_encodeurl($value)))."' title='{$main->lang['tags_goto']} {$value}'>{$value}</a></span>";
    }
    return $tags_list;
}

/**
* Функция создания облака тегов
* 
* @param string $modul
* @param string $limit
* @return string
*/
function kr_create_tags($modul='', $limit='') {
global $main;
    $content = '';
    $count = $tags = array();
    $sizes = array('tag_level1', 'tag_level2', 'tag_level3', 'tag_level4', 'tag_level5');
    $where = ($modul=='') ? '' : "WHERE modul='{$modul}'";
    $limit = ($limit=='') ? '' : "LIMIT {$limit}";
    $result = $main->db->sql_query("SELECT tag, COUNT(*) AS count FROM ".TAG." {$where} GROUP BY tag ORDER BY count DESC {$limit}");
    if ($main->db->sql_numrows($result)>0) {
        while(($row = $main->db->sql_fetchrow($result))) {
            $tags['tags'][]  = $row['tag'];
            $tags['count'][] = $row['count'];
        }
        $min = min($tags['count']); $max = max($tags['count']); $res = $max - $min;
        foreach ($tags['count'] as $kay => $value) {
            $i = ($res) ? floor(($value-$min)/$res*4) : 0;
            $tags['size'][] = $sizes[$i];
        }
        uasort($tags['tags'], 'kr_sort_tag');
        foreach ($tags['tags'] as $kay => $value) $content.= "&nbsp;&nbsp;<a href='".$main->url(array('module' => $modul, 'do' => 'tags', 'id' => urlencode($value)))."' class='{$tags['size'][$kay]}' title='{$main->lang['tags_goto']} {$value} ({$tags['count'][$kay]}).'>{$value}</a> ";
    }
    return $content;
}

/**
* Функция сортировки массива тегов
* 
* @param string $a
* @param string $b
* @return string
*/
function kr_sort_tag($a, $b) {
    return ($a == $b) ? 0 : strcmp($a , $b);
}

function set_calendar_date($id, $module, $date, $status){
global $main;
    $result = $main->db->sql_query("SELECT * FROM ".CALENDAR." WHERE module='{$module}' AND id='{$id}'");
    if($main->db->sql_numrows($result)>0){
        $main->db->sql_query("UPDATE ".CALENDAR." SET status='{$status}', date='{$date}' WHERE module='{$module}' AND id='{$id}'");
    } else $main->db->sql_query("INSERT INTO ".CALENDAR." (id, module, date, status) VALUES ('{$id}', '{$module}', '{$date}', '{$status}')");
}

variables();
?>