<?php
/**
* Генератор sitemap
* 
* @author Wit
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://kr-cms.net/
* @filesource includes/function/sitemap.php
* @version 2.0
*/
if (!defined('FUNC_FILE')) die('Access is limited');
global $main, $adminfile, $modules_sitemap, $file_sitemap;

if(!SAFE_MODE AND function_exists('set_time_limit')) set_time_limit(0);
if(kr_file_exists($file_sitemap)){
    clearstatcache();
    $file = stat($file_sitemap);
    if(date('Y-m-d')==date('Y-m-d', $file['mtime'])) exit;
} else exit;

function get_setting_sitemap($str=''){
    $set = array('priority'=>'0.5', 'changefreq'=>'monthly');
    if ($str!='') {
        $modul = explode ('|', $str); 
        if (isset($modul[0])) $set['priority']   = $modul[0];
        if (isset($modul[1])) $set['changefreq'] = $modul[1];
    }
    return $set;
}

$result = $main->db->sql_query("SELECT * FROM ".MODULES." WHERE active='1' AND (view='1' OR view='2')");
$row = $main->db->sql_fetchrowset($result);
$for = array();
foreach ($row as $key=>$value) {
    if($value['module']=='forum') $for = $row[$key];  
    if(!isset($modules_sitemap[$value['module']])) unset($row[$key]);  
}

$HTML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\"\n\t\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\t\txsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\">\n\n\t";
if(count($row)!=0) {    
    foreach ($row as $key=>$value) {
        $set = get_setting_sitemap($value['sitemap']);
        if($modules_sitemap[$value['module']]!='') {
            $res = $main->db->sql_query("SELECT id, {$value['module']}_id, date FROM {$modules_sitemap[$value['module']]} WHERE status='1' ORDER BY date DESC"); 
            if($main->db->sql_numrows($res)>0){
                while(($row = $main->db->sql_fetchrow($res))){
                    $HTML.= "<url>\n\t\t<loc>".($main->url(array('module' => $value['module'], 'do' => 'more', 'id' => case_id($row["{$value['module']}_id"], $row['id']))))."</loc>\n\t\t<priority>{$set['priority']}</priority>\n\t\t<lastmod>".date("c", strtotime($row['date']))."</lastmod>\n\t\t<changefreq>{$set['changefreq']}</changefreq>\n\t</url>\n\t";  
                }
            } else $HTML.= "<url>\n\t\t<loc>".($main->url(array('module' => $value['module'])))."</loc>\n\t\t<priority>{$set['priority']}</priority>\n\t\t<lastmod>".date("c", time())."</lastmod>\n\t\t<changefreq>{$set['changefreq']}</changefreq>\n\t</url>\n\t";  
        } else $HTML.= "<url>\n\t\t<loc>".($main->url(array('module' => $value['module'])))."</loc>\n\t\t<priority>{$set['priority']}</priority>\n\t\t<lastmod>".date("c", time())."</lastmod>\n\t\t<changefreq>{$set['changefreq']}</changefreq>\n\t</url>\n\t";    
    }
}
if(isset($for['module']) AND $for['active']==1 AND ($for['view']==1 or $for['view']==2)) {    
    $res = $main->db->sql_query("SELECT t.topic_id AS id, p.post_time FROM ".TOPICS." AS t LEFT JOIN ".POSTS." AS p ON (p.post_id=t.topic_last_post_id) ORDER BY p.post_time DESC "); 
    if($main->db->sql_numrows($res)>0){
        $set = get_setting_sitemap($for['sitemap']);
        while(($row = $main->db->sql_fetchrow($res))){
            $HTML .= "<url>\n\t\t<loc>".($main->url(array('module' => 'forum', 'do' => 'showtopic', 'id' => $row['id'])))."</loc>\n\t\t<priority>{$set['priority']}</priority>\n\t\t<lastmod>".date("c", $row['post_time'])."</lastmod>\n\t\t<changefreq>{$set['changefreq']}</changefreq>\n\t</url>\n\t";  
        }
    } else $HTML.= "<url>\n\t\t<loc>".($main->url(array('module' => 'forum')))."</loc>\n\t\t<priority>{$set['priority']}</priority>\n\t\t<lastmod>".date("c", time())."</lastmod>\n\t\t<changefreq>{$set['changefreq']}</changefreq>\n\t</url>\n\t";    
}
$HTML.= "\n</urlset>";
file_write($file_sitemap, $HTML);
?>