<?php
/**
* Общие функции шаблонизатора
* 
* @author Igor Ognichenko
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @filesource includes/function/templates.php
* @version 2.0
*/
if (!defined('FUNC_FILE')) die('Access is limited');

class tpl_main{
    var $cache = array();

    function open_table(){
    global $load_tpl;
        if(!isset($this->cache['open_table'])) return loads_tpl("templates/{$load_tpl}/open_table");
        else return $this->cache['open_table'];
    }

    function close_table(){
    global $load_tpl;
        if(!isset($this->cache['close_table'])) return loads_tpl("templates/{$load_tpl}/close_table");
        else return $this->cache['close_table'];
    }

    function publisher(){
    global $load_tpl;
        if(!isset($this->cache['publisher'])) return loads_tpl("templates/{$load_tpl}/publisher");
        else return $this->cache['publisher'];
    }
}

class pub_list{
    var $row_tpl;
    var $tpl;
    var $content = "";
    var $replace_title = false;

    function pub_list($id = ''){
    global $load_tpl, $module_name;
        if (kr_file_exists("templates/{$load_tpl}/{$module_name}/{$id}.tpl")) $file = "templates/{$load_tpl}/{$module_name}/{$id}.tpl";
        elseif (kr_file_exists("templates/{$load_tpl}/publisher_list-{$module_name}-{$id}.tpl")) $file = "templates/{$load_tpl}/publisher_list-{$module_name}-{$id}.tpl";
        elseif (kr_file_exists("templates/{$load_tpl}/publisher_list-{$module_name}.tpl")) $file = "templates/{$load_tpl}/publisher_list-{$module_name}.tpl";
        else $file = "templates/{$load_tpl}/publisher_list.tpl";
        $content = kr_get_content($file);
        $this->row_tpl = preg_replace('/(.+?)<\!--BEGIN row-->(.+?)<\!--END row-->(.+?)$/si', "\\2", $content);
        $this->tpl = preg_replace('/<\!--BEGIN\srow-->(.+?)<\!--END\srow-->/si', '<!--content-->', $content);
    }

    function add_row($id, $pub){
        $this->content .= preg_replace('#\$pub\[([a-z_-]+)\]#ise', "\$pub['\\1']", $this->row_tpl);
        if(!$this->replace_title){
            $this->tpl = preg_replace('#\$pub\[([a-z_-]+)\]#ise', "\$pub['\\1']", $this->tpl);
            $this->replace_title = true;
        }
    }

    function init($return=false){
        $row = preg_replace('/<\!--content-->/si', $this->content, $this->tpl);
        if (!$return) {
            open();
            echo $row;
            close();
        } else return $row;
        return "";
    }
}

//Создает заголовок страницы а также keywords и description
function set_meta_value($array){
global $keywords, $description, $page_title, $config;
    $page_title = "";
    $keywords = "";
    $description = "";
    $count = count($array);
    for ($i=0; $i<$count; $i++){
        $page_title .= ($i<$count-1) ? "{$array[$i]} {$config['separator']} " : "{$array[$i]}";
        $keywords .= $array[$i].", ";
        $description .= $array[$i].", ";
    }
    $page_title .= " @ {$config['home_title']}";
}

class tpl_create{
    var $design = true;
    var $script = "";
    var $link = "";
    var $cache_link = array();
    var $cache_script = array();

    function add2script($text, $link=true){
        if(in_array($text, $this->cache_script)) return false;
        if (preg_match("#includes/javascript/highslide/(.+?)$#D", $text) != false) {
            $highslide_setting = true;
            foreach ($this->cache_script as $key => $value) {
            	$highslide = "";
                if(preg_match("#includes/javascript/highslide/(.+?)$#D", $value, $highslide) != false) {
                    if ($highslide[1] == 'highslide-full.js') return false;
                    $this->cache_script[$key] = 'includes/javascript/highslide/highslide-full.js';
                    $this->script = str_replace($highslide[1], 'highslide-full.js', $this->script);
                    return false;
                }
            }
        }
        if($link){
            $this->script .= !is_ajax() ? "<script type='text/javascript' src='{$text}'></script>\n" : "<script type='text/javascript'>KR_AJAX.include.script('{$text}')</script>\n";
            $this->cache_script[] = $text;
        } else $this->script .= "<script type='text/javascript'>{$text}</script>\n";
        if (isset($highslide_setting)) $this->script .= "<script type='text/javascript'>
            hs.graphicsDir = 'includes/javascript/highslide/graphics/';
            hs.outlineType = 'rounded-white';
            hs.showCredits = false;
            hs.loadingText = window.js_lang.loading;
            hs.restoreTitle = window.js_lang.restore;
            hs.fullExpandTitle = window.js_lang.fullExpand;\n</script>\n";
        return true;
    }

    function add2link($url){
        if(in_array($url, $this->cache_link)) return false;
        $this->cache_link[] = $url;
        $this->link .= !is_ajax() ? "<link rel='stylesheet' href='{$url}' type='text/css' />\n" : "<script type='text/javascript'>KR_AJAX.include.style('{$url}')</script>";
        return true;
    }

    //Функция генерации meta тегов
    function meta_insert(){
    global $config, $keywords, $description;
        return "<meta http-equiv='content-type' content='text/html; charset={$config['charset']}' />\n".
            "<meta name='author' content='".$config['home_title']."' />\n".
            "<meta name='copyright' content='Copyright (c) Kasseler CMS {$config['cms_version']}' />\n".
            "<meta name='resource-type' content='document' />\n".
            "<meta name='document-state' content='dynamic' />\n".
            "<meta name='distribution' content='global' />\n".
            "<meta name='robots' content='index, follow' />\n".
            "<meta name='revisit-after' content='1 days' />\n".
            "<meta name='rating' content='general' />\n".
            "<meta name='generator' content='Kasseler CMS {$config['cms_version']}' />\n".
            "<meta name='description' content='{$description}{$config['description']}' />\n".
            "<meta name='keywords' content='{$keywords}{$config['keywords']}' />\n".
            "<meta name='Cache-Control' content='no-cache' />\n".
            "<meta http-equiv='Expires' content='0' />\n".
        "<base href='http://".get_host_name()."/' />";
    }

    function javascript_insert(){
    global $load_tpl;
        return "<script type='text/javascript' src='includes/javascript/kr_ajax.js'></script>\n".
            "<script type='text/javascript' src='includes/javascript/function.js'></script>\n".
            ((kr_file_exists("templates/{$load_tpl}/jsconfig.js")) ?"<script type='text/javascript' src='templates/{$load_tpl}/jsconfig.js'></script>\n" : '').
            "".(defined("ADMIN_FILE") ? "<script type='text/javascript' src='includes/javascript/adminJS.js'></script>\n" : "").$this->script;
    }

    function link_insert(){
    global $load_tpl, $userinfo;
        $special = '';
        if(strpos(get_env('HTTP_USER_AGENT'), 'Opera') !== false) $special = (kr_file_exists("templates/{$load_tpl}/css/opera.css")) ? "<link rel='stylesheet' href='templates/{$load_tpl}/css/opera.css' type='text/css' />\n" : '';
        elseif(preg_match('/Flock|Phoenix|Firebird|Firefox|Shiretoko|NetPositive/i', get_env('HTTP_USER_AGENT'))) $special = (kr_file_exists("templates/{$load_tpl}/css/firefox.css")) ? "<link rel='stylesheet' href='templates/{$load_tpl}/css/firefox.css' type='text/css' />\n" : '';
        elseif(strpos(get_env('HTTP_USER_AGENT'), 'MSIE') !== false) $special = (kr_file_exists("templates/{$load_tpl}/css/ie.css")) ? "<link rel='stylesheet' href='templates/{$load_tpl}/css/ie.css' type='text/css' />\n" : '';        
        elseif(strpos(get_env('HTTP_USER_AGENT'), 'Chrome') !== false) $special = (kr_file_exists("templates/{$load_tpl}/css/сhrome.css")) ? "<link rel='stylesheet' href='templates/{$load_tpl}/css/сhrome.css' type='text/css' />\n" : '';        
        elseif(strpos(get_env('HTTP_USER_AGENT'), 'Safari') !== false) $special = (kr_file_exists("templates/{$load_tpl}/css/safari.css")) ? "<link rel='stylesheet' href='templates/{$load_tpl}/css/safari.css' type='text/css' />\n" : '';
        return "<link rel='stylesheet' href='templates/{$load_tpl}/style.css' type='text/css' />\n".
            "<link rel='stylesheet' href='includes/css/system.css' type='text/css' />\n".
            "<link rel='shortcut icon' href='favicon.ico' type='image/x-icon' />\n".$special.$this->link;
    }

    //Функция вывода списка Глобальных переменных
    function variable_insert(){
    global $variable;
        return "<div class='variables-title' id='variables-title' onclick=\"switch_content('variables')\">Variables Inform</div>".
        "<div class='variables' id='variables' style='display: none;' align='left'>{$variable['GET']}{$variable['POST']}{$variable['SESSION']}{$variable['SESSIONID']}{$variable['COOKIE']}{$variable['FILES']}</div>";
    }

    //Функция вывода списка запросов к базе данных
    function query_insert(){
    global $db;
        if(defined("INSTALLCMS") OR defined("ADMIN_FILE")) return "";
        $query = $db->time_query;
        return ($query!="") ? "<div onclick=\"switch_content('query')\" class='query-title' id='query-title'>Query Inform</div><div style='display: none;' class='query' id='query'>{$query}</div>" : "";
    }

    function tpl_creates(){
    global $template, $load_tpl, $load_tpl, $config, $add_style, $agentinfo, $lang, $main;
        //Проверяем события планировщика
        $this->check_planner();
        if(kr_file_exists("templates/{$load_tpl}/css/".strtolower($agentinfo['browser']).".css")) $this->add2link("templates/{$load_tpl}/css/".strtolower($agentinfo['browser']).".css");
        $template->template = preg_replace('#\$lang\[([a-z_-]+)\]#ise', "array_value_set('\\1', \$lang)", $template->template);
        $template->template = preg_replace('#\$user\[([a-z_-]+)\]#ise', "array_value_set('\\1', \$main->user)", $template->template);
        $template->template = preg_replace('#\$module\[([a-z_-]+)\]#ise', "\$main->url(array('module' => '\\1'))", $template->template);
        $template->set_tpl('$host', get_host_name());
        //Вставка названия текущего шаблона
        $template->set_tpl('$load_tpl', $load_tpl);
        //Вставка заголовка страницы
        $template->set_tpl('$title', $this->title_insert());
        //Вставка мета тегов
        $template->set_tpl('$meta', $this->meta_insert());
        //Вставка javascript
        $script = $this->javascript_insert();
        $template->set_tpl('$script', substr($script, 0, strlen($script)-1));
        //Вставка таблиц стилей
        $link = $this->link_insert();
        $template->set_tpl('$link', substr($link, 0, strlen($link)-1).$add_style);
        $template->set_tpl('$license', "Copyright ©2007-2009 by <a href='http://www.kr-cms.net/' target='_BLANK' title='Content Management System'>Kasseler CMS</a>. All rights reserved.");
        //Подключение дополнительных пользовательских функций шаблона
        if(kr_file_exists("templates/{$load_tpl}/tpl.php")) require_once "templates/{$load_tpl}/tpl.php";
        //Вставка анализа переменных
        $template->set_tpl('$var_info', (($config['variables']==1) OR ($config['variables']==2 AND is_admin())) ? $this->variable_insert() : "");
        //Вставка запросов к базе данных
        $template->set_tpl('$query_info', (($config['query']==1) OR ($config['query']==2 AND is_admin())) ? $this->query_insert() : "");
        if(!defined("INSTALLCMS")){
            $time_db = $main->db->total_time_db;
            $num_queries = $main->db->num_queries;
        }
        if(is_ajax()){ 
            echo $this->script;
            echo $this->link;
        }
    }
    
    function check_planner(){
    global $planner;
        foreach($planner as $id => $run){
            if(gmdate('Y-m-d', strtotime($run['nextrun']))<=kr_date('Y-m-d H:i')){
                if(gmdate('H:i', strtotime($run['nextrun']))<=kr_date('H:i') AND in_array(gmdate('w'), explode(',', $run['weekdays'])) AND $run['status']==ENABLED) {
                    $this->add2script("KR_AJAX.addEvent(window, 'load', function(){haja({action:'index.php?ajaxed=runer', animation:false}, {}, {})});", false);
                    break;
                }
            }
        }
    }
}

//Функция определения загружаемого шаблона
function get_index(){
global $module_name, $load_tpl;
    if(isset($_GET['id']) AND kr_file_exists("templates/{$load_tpl}/index-{$module_name}-{$_GET['id']}.tpl")) return "templates/{$load_tpl}/index-{$module_name}-{$_GET['id']}.tpl";
    elseif(kr_file_exists("templates/{$load_tpl}/index-{$module_name}.tpl") AND isset($_GET['module'])) return "templates/{$load_tpl}/index-{$module_name}.tpl";
    elseif(kr_file_exists("templates/{$load_tpl}/index-home.tpl") AND !isset($_GET['module'])) return "templates/{$load_tpl}/index-home.tpl";
    else return "templates/{$load_tpl}/index.tpl";
}

function open_table($return=false){
global $tpl_main;
    $content = $tpl_main->open_table();
    if($return) return $content;
    else echo $content;
    return "";
}

function close_table($return=false){
global $tpl_main;
    $content = $tpl_main->close_table();
    if($return) return $content;
    else echo $content;
    return "";
}

function warning($string, $return=false){
global $module_name, $load_tpl;
    if(kr_file_exists("templates/{$load_tpl}/warning-{$module_name}.tpl")) $warning_tpl = "templates/{$load_tpl}/warning-{$module_name}.tpl";
    else $warning_tpl = "templates/{$load_tpl}/warning.tpl";
    $warning = str_replace('$load_tpl', $load_tpl, kr_get_content($warning_tpl));
    $warning = str_replace('$content', $string, $warning);
    if($return) return $warning;
    else echo $warning;
    return "";
}

function info($string, $return=false){
global $module_name, $load_tpl;
    if(!defined("ENGINE")){
        if(kr_file_exists("templates/{$load_tpl}/info-{$module_name}.tpl")) $info_tpl = "templates/{$load_tpl}/info-{$module_name}.tpl";
        else $info_tpl = "templates/{$load_tpl}/info.tpl";
        $info = str_replace('$load_tpl', $load_tpl, kr_get_content($info_tpl));
        $info = str_replace('$content', $string, $info);
        if($return) return $info;
        else echo $info;
    }
    return "";
}

function open($return=false){
    if($return) return open_table($return);
    else open_table($return);
    return "";
}

function close($return=false){
    if($return) return close_table($return);
    else close_table($return);
    return "";
}

function title($title_set, $return=false){
global $module_name;
    $title = open(true);
    $title .= "<h1 id='style_{$module_name}' class='module_title'>{$title_set}</h1>";
    $title .= close(true);
    if($return) return $title;
    else echo $title;
    return "";
}

function total_pages($numrows, $limit, $numpages){
global $lang;
    return "<h4>".preg_replace(array("#{TOTAL}#", "#{PAGES}#", "#{COUNT}#"), array($numrows, $numpages, $limit), $lang['total_pages'])."</h4>";
}

function pages($numrows, $limit, $url_array, $total=false, $return=false, $last_url_array=array(), $parse_get=false){
global $main, $lang, $adminfile;
    $rew = $main->mod_rewrite; $content = '';
    if(defined('ADMIN_FILE')) $main->mod_rewrite = false;
    if(isset($_GET['page'])) add_meta_value($lang['title_page'].intval($_GET['page']));
    $numpages = ceil($numrows / $limit); $pagenum = (isset($_GET['page']) AND !empty($_GET['page'])) ? intval($_GET['page']) : 1;
    if($pagenum<=$numpages){
        if ($numpages > 1) {
            $content = "<div class='basepub'><div class='basenumbers'><div class='binner'><div class='numbers'>";
            if($total) $content .= total_pages($numrows, $limit, $numpages);
            $content .= "<table><tr><td>";
            if(isset($pagenum) AND $pagenum>1) $content .= "<a class='sys_link' href='".$main->url(array_merge($url_array, array('page' => $pagenum-1), $last_url_array), defined('ADMIN_FILE')?$adminfile:"").($parse_get==true?parse_get(array('page', 'delete', 'change_op'), array_merge($url_array, $last_url_array)):"")."'><b class='arrowleft'>&#171;</b></a>";
            for ($i=1;$i<=$numpages;$i++) {
                if ($i == $pagenum) $content .= "<span class='noselect'><b>{$i}</b></span>\n";
                elseif((($i > ($pagenum - 5)) AND ($i < ($pagenum + 5))) OR ($i == $numpages) OR ($i == 1)) $content .= "<a class='sys_link' href='".$main->url(array_merge($url_array, array('page' => $i), $last_url_array), defined('ADMIN_FILE')?$adminfile:"").($parse_get==true?parse_get(array('page', 'delete', 'change_op'), array_merge($url_array, $last_url_array)):"")."'><b>{$i}</b></a>\n";
                elseif ($i<$numpages AND ($pagenum>6 AND $i==1) OR ($pagenum<$numpages-5 AND $i==$numpages-1)) $content .= "<span class='more'><b>...</b></span>\n";
            }
            if($pagenum<$numpages) $content .= "<a class='sys_link' href='".$main->url(array_merge($url_array, array('page' => $pagenum+1), $last_url_array), defined('ADMIN_FILE')?$adminfile:"").($parse_get==true?parse_get(array('page', 'delete', 'change_op'), array_merge($url_array, $last_url_array)):"")."'><b class='arrowright'>&#187;</b></a>";
            $content .= "</td></tr></table></div></div></div></div>";
        }
        if($return) return $content;
        else echo $content;
        $main->mod_rewrite = $rew;
    } else redirect(MODULE);
    return "";
}

function univeral_create_tpl($file,  $array, $return=true){
global $load_tpl, $module_name;
    $id = isset($_GET['id']) ? $_GET['id'] : "";
    if (kr_file_exists("templates/{$load_tpl}/{$file}-{$module_name}-{$id}.tpl")) $file_tpl = "templates/{$load_tpl}/{$file}-{$module_name}-{$id}.tpl";
    elseif (kr_file_exists("templates/{$load_tpl}/{$file}-{$module_name}.tpl")) $file_tpl = "templates/{$load_tpl}/{$file}-{$module_name}.tpl";
    else $file_tpl = "templates/{$load_tpl}/{$file}.tpl";
    $content = kr_get_content($file_tpl);
    foreach($array as $key => $value){
        $content = str_replace('$'.$key, $value, $content);
    }
    if($return) return $content;
    else echo $content;
    return "";
}

function loads_tpl($file){
global $module_name, $load_tpl;
    if(kr_file_exists("{$file}-{$module_name}.tpl")) $tpl_file = "{$file}-{$module_name}.tpl";
    else $tpl_file = "{$file}.tpl";
    return str_replace('$load_tpl', $load_tpl, kr_get_content($tpl_file));
}

$tpl_main = new tpl_main;
?>