<?php
/**
* Файл функций Attach
* 
* @author Igor Ognichenko
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @filesource includes/function/usertpl.php
* @version 2.0
*/
if (!defined('KASSELERCMS')) die('Access is limited');

class user_tpl extends tpl_create{
    function title_insert(){
    global $page_title, $config, $modules, $module_name;
        if(isset($modules[$module_name]) AND !is_home()) return (empty($page_title)) ? "{$modules[$module_name]['title']} @ {$config['home_title']}" : $page_title;
        else return $config['home_title'];
    }
    
    function create_home_message(){
    global $main, $template, $messages;
        $mess = "";
        if(count($messages)>0 AND is_home() AND kr_file_exists("templates/{$main->tpl}/message.tpl")){
            foreach($messages as $m){
                if(check_user_group($m['groups']) AND $m['status']==1){
                    $mess .= preg_replace(
                        array('/\$load_tpl/i', '/\$title/i', '/\$content/i'),
                        array($main->tpl, $m['title'], parse_bb($m['content'])),
                        kr_get_content("templates/{$main->tpl}/message.tpl")
                    );
                }
            }
        }
        $template->set_tpl('$message', "<div id='home_message'>{$mess}</div>");
    }

    function create_blocks($position = array(), $return = false){
    global $block_config, $module_name, $modules, $lang, $template, $language, $main;
        $blocksmas = array('l' => '', 'r' => '', 'c' => '', 'd' => '', 'b' => '', 'f' => '');        
        foreach ($block_config as $conf){
            $module = (isset($_GET['module'])) ? $module_name : "home"; $continue = false; $block_module = 0;
            if(isset($modules[$module_name])) $block_module = $modules[$module_name]['blocks'];            
            if(!empty($position) AND !in_array($conf['position'], $position)) $continue = true;
            if($continue==false){
                if((!empty($conf['language']) AND $conf['language']!=$language) OR $conf['active']==0) $continue = true;
                if($block_module=="3" AND ($conf['position']=='l' OR $conf['position']=='r')) $continue = true;
                elseif($block_module=="1" AND $conf['position']=='r') $continue = true;
                elseif($block_module=="2" AND $conf['position']=='l') $continue = true;
                if(strrpos($conf['modules'], $module)===false AND !empty($conf['modules'])) $continue = true;
                if($conf['view']=="2" AND is_user() AND !is_admin()) $continue = true;
                elseif($conf['view']=="3" AND !is_user() AND !is_admin()) $continue = true;
                elseif($conf['view']=="4" AND !is_admin()) $continue = true;
            }
            if($continue==true) {$blocksmas[$conf['position']] .= "<div id='blockid_{$conf['id']}'></div>\n"; continue;}
            if(empty($conf['content']) OR kr_file_exists("blocks/{$conf['blockfile']}")){
                if(kr_file_exists("blocks/{$conf['blockfile']}") AND !empty($conf['blockfile'])){
                    ob_start();
                    require("blocks/{$conf['blockfile']}");
                    $content = ob_get_contents(); ob_end_clean();
                }
                $content = (isset($content)) ? $content.$conf['content'] : $conf['content'];
                if(empty($content)) $content="<div id='blockid_{$conf['id']}'><center>{$lang['blocknocontent']}</center></div>";
            } else $content = "<div id='blockid_{$conf['id']}'><center>{$lang['blockproblem']}</center></div>";
            $blocksmas[$conf['position']] .= $this->tpl_blocks($conf['id'], $conf['title'], $content, $conf['position'], $conf['blockfile']);
            $content = "";
        } 
        if($return==false){
            $l = trim(strip_tags($blocksmas['l'])); $r = trim(strip_tags($blocksmas['r']));
            if(!empty($l)){
                $template->template = preg_replace(array('/<\!--BEGIN\sblock-->(.+?)<\!--END\sblock-->/si', '/<\!--BEGIN\sleftblock-->(.+?)<\!--END\sleftblock-->/si'), array('', '\\1'), $template->template);            
                $template->template = preg_replace("#<td id='leftcol' valign='top' style='display: none;'>#si", "<td id='leftcol' valign='top'>", $template->template);
                $template->set_tpl('$block_left', $blocksmas['l']);
            } else $template->template = preg_replace('/<\!--BEGIN\sleftblock-->(.+?)<\!--END\sleftblock-->/si', '', $template->template);
            if(!empty($r)){
                $template->template = preg_replace(array('/<\!--BEGIN\sblock-->(.+?)<\!--END\sblock-->/si', '/<\!--BEGIN\srightblock-->(.+?)<\!--END\srightblock-->/si'), array('', '\\1'), $template->template);
                $template->template = preg_replace("#<td id='rightcol' valign='top' style='display: none;'>#si", "<td id='rightcol' valign='top'>", $template->template);
                $template->set_tpl('$block_right', $blocksmas['r']);
            } else $template->template = preg_replace('/<\!--BEGIN\srightblock-->(.+?)<\!--END\srightblock-->/si', '', $template->template);
            $template->set_tpl('$block_center', $blocksmas['c']);
            $template->set_tpl('$block_down', $blocksmas['d']);
            $template->set_tpl('$topbaner', !empty($blocksmas['b']) ? $blocksmas['b'] : "&nbsp;");
            $template->set_tpl('$footbaner', !empty($blocksmas['f']) ? $blocksmas['f'] : "&nbsp;");
        } else return $blocksmas;
    }

    function tpl_blocks($id, $title, $content, $position, $blockfile){
    global $module_name, $load_tpl;
        switch ($position){
            case "l": $block_tpl = "block-left"; break;
            case "r": $block_tpl = "block-right"; break;
            case "c": $block_tpl = "block-center"; break;
            case "d": $block_tpl = "block-down"; break;
            case "b": $block_tpl = "block-head"; break;
            case "f": $block_tpl = "block-footer"; break;
            default: $block_tpl = "block-fly"; break;
        }
        $blockfile = str_replace(".php", "", $blockfile);
        if (kr_file_exists("templates/{$load_tpl}/{$blockfile}.tpl")) $block_tpl = $blockfile;
        elseif (kr_file_exists("templates/{$load_tpl}/{$block_tpl}-{$module_name}.tpl")) $block_tpl = $block_tpl."-".$module_name;
        $block = kr_get_content("templates/{$load_tpl}/{$block_tpl}.tpl");
        $block = preg_replace(array('/\$title/', '/\$content/', '/\$load_tpl/'), array($title, stripslashes($content), $load_tpl), $block);
        return "<div id='blockid_{$id}'>{$block}</div>\n";
    }
    
    function blocks_reload($module){
    global $block_config, $main;
        $script = "";
        if(!is_home()) $script .= "if($$('home_message')) $$('home_message').style.display = 'none';\n";
        else $script .= "if($$('home_message')) $$('home_message').style.display = '';\n";
        $module = (isset($_GET['module'])) ? $main->module : "home";
        foreach($block_config as $block){
            if(strrpos($block['modules'], $module)===false AND !empty($block['modules'])) $script .= "if(\$\$('blockid_{$block['id']}')) \$\$('blockid_{$block['id']}').style.display = 'none';\n";
            else $script .= "if(\$\$('blockid_{$block['id']}')) \$\$('blockid_{$block['id']}').style.display = '';\n";
        }
        return $script;
    }    

    /**
    * Функция загрузки модуля
    * 
    * @param string $module_name
    * @return string
    */
    function include_module($module_name){
    global $parametr_design, $main, $modules, $module_title;
        $contents = ""; $_module = $main->module;
        $_arr_home_modules = is_home() ? explode(',', $main->config['default_module']) : array($main->module);
        if(count($_arr_home_modules)>1){
            $_arr = array();
            foreach($modules as $_k => $_c) if(in_array($_k, $_arr_home_modules) AND $_c['active']==1) $_arr[] = $_k;
            $_arr_home_modules = $_arr;
        }
        foreach($_arr_home_modules as $m){
            $main->module = $m;
            $module_title = (isset($modules[$main->module])) ? $modules[$main->module]['title'] : $main->module;
            if(kr_file_exists("modules/{$m}/index.php")){
                if(isset($modules[$m]['groups']) AND check_user_group($modules[$m]['groups'])){
                    ob_start();
                    require_once "modules/{$m}/index.php";
                    $contents .= ob_get_contents(); ob_end_clean();
                } else $contents .= warning($main->lang['no_view_module'], true);
            } else $contents .= warning($main->lang['error_load_module'], true);
        }
        $main->module = $_module;
        return $contents;
    }

    function load_module(){
    global $modules, $module_name, $lang;
        if(!isset($modules[$module_name]) AND !is_home() AND !is_ajax()){
            //redirect("index.php"); //Убрать комментарий в том случаи если нужно все http ошибки переадресовывать на главную.
            kr_http_ereor_logs("404");

            //foreach($_GET AS $key => $value) unset($_GET[$key]);
            //$_GET['module'] = $module_name = "news";
            //return $this->include_module($module_name);
        } elseif(is_support()) return $this->include_module($module_name);
        else {
            if(isset($modules[$module_name]) AND $modules[$module_name]['active']!="0"){ 
                switch($modules[$module_name]['view']){
                    case '1': return $this->include_module($module_name);  break;
                    case '2': if(is_guest()) return $this->include_module($module_name); else return warning($lang['only_guest_module'], true); break;
                    case '3': if(is_user()) return $this->include_module($module_name); else return warning($lang['only_users_module'], true); break;
                    case '4': if(is_support()) return $this->include_module($module_name); else return warning($lang['only_admin_module'], true); break;                    
                    default: return warning($lang['no_view_module'], true); break;
                }
            } elseif(isset($modules[$module_name])) return $lang['module_off'];
            else kr_http_ereor_logs("404");
        }
        return "";
    }
    
    function generate_info_insert($generate, $time_sql_query, $sql_querys, $size_page, $gz_size_page){
    global $lang, $config, $generate_template;
        $lang['generate'] = str_replace("{time}", $generate, $lang['generate']);
        $lang['time_sql_query'] = str_replace("{time}", $time_sql_query, $lang['time_sql_query']);
        $lang['sql_querys'] = str_replace("{query}", $sql_querys, $lang['sql_querys']);
        $lang['gz_level'] = str_replace("{encoding}", $config['gzlevel'], $lang['gz_level']);
        $lang['generate_template'] = str_replace("{time}", $generate_template, $lang['generate_template']);
        $info = "\n<!--{$lang['generate']}-->\n".
        "<!--{$lang['generate_template']}-->\n".
        "<!--{$lang['time_sql_query']}-->\n".
        "<!--{$lang['sql_querys']}-->\n";
        if($config['gz']==ENABLED){
            $lang['page_size'] = str_replace("{size_page}", $size_page, $lang['page_size']);
            $lang['page_size'] = str_replace("{gz_size_page}", $gz_size_page, $lang['page_size']);
            $info .= "<!--".$lang['gz_level']."-->\n".
            "<!--".$lang['page_size']."-->\n";
        }    
        return $info;
    }      
    
    function rss_link(){
    global $rss, $main;
        foreach($rss as $key=>$value){
            $conf = explode("|", $value);
            if($conf[1]==ENABLED) $this->link .= "<link rel='alternate' type='application/rss+xml' href='".$main->url(array('module' => $key, 'do' => 'rss'))."' title='{$conf[0]}' />\n";
        }    
    }
    
    function tpl_creates(){
    global $template, $load_tpl, $lang, $parametr_design, $config, $main, $modules;
        //eval(base64_decode("Z2xvYmFsICRjb250X3NlZWs7ICRjb250X3NlZWstLTs=")); 
        if($config['ajaxload']==ENABLED) $this->add2script("\nKR_AJAX.this_module = '{$main->module}';\nvar ajaxload = true;\nvar classes = Array(".array_create($config['classes_links']).");\n", false);
        $footer = "";        
        if(!is_ajax()) $this->rss_link();
        $parametr_design = true;
        //Подключение модуля
        $mod = $this->load_module();
        $tit = $this->title_insert();
        if(!$parametr_design OR !$this->design) page($mod, $tit);
        if(is_ajax()) {
            $script = "";
            if(isset($modules[$main->module])){                
                $_b = $modules[$main->module]['blocks'];
                if($_b==0) $b = $this->create_blocks(array('l','r'), true);
                elseif($_b==1) $b = $this->create_blocks(array('l'), true);
                elseif($_b==2) $b = $this->create_blocks(array('r'), true);
                else $b = '';
                if($_b=='2' OR $_b=='3') $script .= "if($$('leftcol')) $$('leftcol').style.display = 'none';\n";
                else $script .= "if($$('leftcol')) $$('leftcol').style.display = ''; if($$('leftcol')) $$('leftcol').innerHTML = '".magic_quotes($b['l'])."';\n";                
                if($_b=='1' OR $_b=='3') $script .= "if($$('rightcol')) $$('rightcol').style.display = 'none';\n";
                else $script .= "if($$('rightcol')) $$('rightcol').style.display = ''; if($$('rightcol')) $$('rightcol').innerHTML = '".magic_quotes($b['r'])."';\n";
                $script = "<script type='text/javascript'>".$script.$this->blocks_reload($main->module)."</script>";
            }
            die("<title>{$tit}</title>".$this->script.$this->link.$mod.$script);
        }        
        $this->create_blocks();
        parent::tpl_creates();
        $template->set_tpl('$modules', "\n<!--BEGIN content-->\n<div id='ajax_content'>{$mod}</div>\n<!--END content-->\n");
        ob_start();
        require_once "includes/header.php";
        $footer = ob_get_contents(); ob_end_clean();
        //Подключение дополнительных пользовательских функций
        $template->set_tpl('$footer', $footer);
        $template->set_tpl('$user_name', $main->user['user_name']);
        $this->create_home_message();
        
    }
}

function add_meta_value($value){
global $keywords, $description, $page_title, $module_name, $modules, $config;      
    $page_title = empty($page_title) ? "{$modules[$module_name]['title']} @ {$config['home_title']}" : $page_title;
    $page_title = $value." {$config['separator']} ".$page_title;
    $keywords = empty($keywords) ? $modules[$module_name]['title'] : $keywords;
    $keywords = $value.", ".$keywords.", ";
    $description = empty($description) ? $modules[$module_name]['title'] : $description;
    $description = $value.", ".$description.", ";
}

//Функция определения загружаемого стиля
function get_style(){
global $module_name, $load_tpl;
    if(kr_file_exists("templates/{$load_tpl}/style-{$module_name}.css")) return "templates/{$load_tpl}/style_{$module_name}.css";
    elseif(kr_file_exists("templates/{$load_tpl}/style-{$module_name}-{$_GET['id']}.tpl") AND !isset($_GET['module'])) return "templates/{$load_tpl}/style-{$module_name}-{$_GET['id']}.tpl";
    elseif(kr_file_exists("templates/{$load_tpl}/style-home.tpl") AND !isset($_GET['module'])) return "templates/{$load_tpl}/style-home.tpl";
    else return "templates/{$load_tpl}/style.css";
}

function show_category($col=2){
global $main;
    if(isset($_GET['do']) AND $_GET['do']=='category') $parent = (!$main->rewrite_id) ? "c.cid='{$_GET['id']}'" : "c.cat_id='{$_GET['id']}'";
    else $parent = "c.cid IS NULL";
    $result = $main->db->sql_query("SELECT t.*, ROUND(LENGTH(t.tree)/2) AS level, c.cid AS parent_id, c.cat_id AS parent_cat FROM ".CAT." AS t LEFT JOIN ".CAT." AS c ON(SUBSTR(t.tree,1,LENGTH(t.tree)-2)=c.tree) WHERE t.module='{$main->module}' AND {$parent} ORDER BY t.title");
    if($main->db->sql_numrows($result)>0){
        $array_cat = array(); $i=0;   
        while(($row = $main->db->sql_fetchrow($result))) $array_cat[] = array('cid' => $row['cid'], 'cat_id' => $row['cat_id'], 'title'  => $row['title'], 'image'  => $row['image'], 'description' => $row['description']);        
        open();
        echo "<table class='catlist'>";
        while($i<count($array_cat)){
            echo "<tr><td>";
            for($y=1;$y<=$col;$y++){
                if(!isset($array_cat[$i+$y-1])) continue;
                echo "<div style='width: ".round(100/$col,2)."%;'><a class='sys_link' href='".$main->url(array('module' => $main->module, 'do' => 'category', 'id' => case_id($array_cat[$i+$y-1]['cat_id'], $array_cat[$i+$y-1]['cid'])))."' title='{$array_cat[$i+$y-1]['title']}'><span>".(($array_cat[$i+$y-1]['image']!='no.png') ? "<img src='includes/images/cat/{$array_cat[$i+$y-1]['image']}' alt='{$array_cat[$i+$y-1]['title']}' />" : "")."<b>{$array_cat[$i+$y-1]['title']}</b><br />".cut_char($array_cat[$i+$y-1]['description'])."</span></a></div>";
            }
            echo "</td></tr>";
            $i+=$col;
        }
        echo "</table>";
        close();
    }
}

function publisher($id, $vars, $return=false){
global $tpl_main, $module_name;
    $tp = $tpl_main->publisher();
    $content = preg_replace('#\$pub\[([a-z_-]+)\]#ise', "isset(\$vars['\\1']) ? \$vars['\\1'] : ''", $tpl_main->publisher());    
    $content = "<div id='{$module_name}_{$id}'>{$content}</div>";
    if($return) return $content;
    else echo $content;
    return "";
}

function publisher_more($id, $vars, $return=false){
global $load_tpl, $module_name, $load_tpl;
    if (kr_file_exists("templates/{$load_tpl}/{$module_name}/{$id}.tpl")) $file = "templates/{$load_tpl}/{$module_name}/{$id}.tpl";
    elseif (kr_file_exists("templates/{$load_tpl}/more-{$module_name}-{$id}.tpl")) $file = "templates/{$load_tpl}/more-{$module_name}-{$id}.tpl";
    elseif (kr_file_exists("templates/{$load_tpl}/more-{$module_name}.tpl")) $file = "templates/{$load_tpl}/more-{$module_name}.tpl";
    else $file = "templates/{$load_tpl}/more.tpl";
    $content = str_replace('$load_tpl', $load_tpl, kr_get_content($file)); 
    $content = preg_replace('#\$pub\[([a-z_-]+)\]#ise', "isset(\$vars['\\1']) ? \$vars['\\1'] : ''", $content);
    if($return) return $content;
    else echo $content;
    return "";
}

function publisher_print($id, $vars){
global $description, $keywords, $tpl_create, $main;
    if (kr_file_exists("templates/{$main->tpl}/print-{$main->module}-{$id}.tpl")) $file = "templates/{$main->tpl}/print-{$main->module}-{$id}.tpl";
    elseif (kr_file_exists("templates/{$main->tpl}/print-{$main->module}.tpl")) $file = "templates/{$main->tpl}/print-{$main->module}.tpl";
    else $file = "templates/{$main->tpl}/print.tpl";
    $meta = "<meta http-equiv='content-type' content='text/html; charset={$main->config['charset']}' />\n".
            "<meta name='author' content='{$main->config['home_title']}' />\n".
            "<meta name='copyright' content='Copyright (c) Kasseler CMS {$main->config['cms_version']}' />\n".
            "<meta name='resource-type' content='document' />\n".
            "<meta name='document-state' content='dynamic' />\n".
            "<meta name='distribution' content='global' />\n".
            "<meta name='robots' content='index, follow' />\n".
            "<meta name='revisit-after' content='1 days' />\n".
            "<meta name='rating' content='general' />\n".
            "<meta name='generator' content='Kasseler CMS {$main->config['cms_version']}' />\n".
            "<meta name='description' content='{$description}{$main->config['description']}' />\n".
            "<meta name='keywords' content='{$keywords}{$main->config['keywords']}' />\n".
            "<meta name='Cache-Control' content='no-cache' />\n".
            "<meta http-equiv='Expires' content='0' />\n".
            "<base href='http://".get_host_name()."/' />";
    $vars = array_merge($vars, array(
        'meta'       => $meta,
        'style'      => $tpl_create->link_insert(),
        'sitename'   => "{$main->lang['site']}: <a href='{$main->config['http_home_url']}' title='{$main->config['home_title']}'>{$main->config['home_title']}</a>",
        'pub_author' => "{$main->lang['author']}: {$vars['author']}",
        'url'        => "{$main->lang['url']}: <a href='".$main->url(array('module' => $main->module, 'do' => 'more', 'id' => $_GET['id']))."'>".$main->url(array('module' => $main->module, 'do' => 'more', 'id' => $_GET['id']))."</a>",
        'logo'       => "<img src='{$main->config['sitelogo']}' alt='{$main->config['home_title']}' title='{$main->config['home_title']}' />",
        'page_title' => $tpl_create->title_insert()
    ));
    $content = preg_replace('#\$print\[([a-z_-]+)\]#ise', "\$vars['\\1']", kr_get_content($file));    
    echo $content;
    exit;
}
function create_link($id, $links, $op){
global $title;
    if(isset($links[$id])){
        $add_param=sizeof($links[$id])==4?$links[$id][3]:"";
        if(isset($_GET[$op]) AND $_GET[$op]==$links[$id][2]){
            $title = $links[$id][1];
            return "<a class='module_navi_sel' href='{$links[$id][0]}' title='{$links[$id][1]}' {$add_param}><b>{$links[$id][1]}</b></a>";
        } else return "<a class='module_navi' href='{$links[$id][0]}' title='{$links[$id][1]}' {$add_param}><b>{$links[$id][1]}</b></a>";
    } else return "";
}

function navi($links, $search=true, $link=true, $user_title='', $op='do'){
global $main, $title;
    if (isset($_GET['id']) AND kr_file_exists("templates/{$main->tpl}/navi-{$main->module}-{$_GET['id']}.tpl")) $file = "templates/{$main->tpl}/navi-{$main->module}-{$_GET['id']}.tpl";
    elseif (kr_file_exists("templates/{$main->tpl}/navi-{$main->module}.tpl")) $file = "templates/{$main->tpl}/navi-{$main->module}.tpl";
    else $file = "templates/{$main->tpl}/navi.tpl";
    $content = kr_get_content($file);
    if(!$search) $content = preg_replace('/<\!--BEGIN\ssearch-->(.+?)<\!--END\ssearch-->/si', '', $content);
    if(!$link) $content = preg_replace('/<\!--BEGIN\slinks-->(.+?)<\!--END\slinks-->/si', '', $content);
    $content = preg_replace('#\$link\[([0-9]+)\]#ise', "create_link(\\1, \$links, \$op)", $content);    
    if(!empty($user_title)) add_meta_value($user_title);
    if(!empty($title) AND $title!="&nbsp;") add_meta_value($title);    
    $user_title = (!empty($user_title)) ? $user_title : $main->title;        
    $title = (empty($title)) ? "&nbsp;" : $title;
    $nav = array('module' => $user_title, 'title' => $title, 'search' => searche_module());
    $content = preg_replace('#\$nav\[([a-z_-]+)\]#ise', "\$nav['\\1']", $content);
    return $content;
}

function searche_module(){
global $main;
    return "<form class='search_module_form' action='".$main->url(array('module' => 'search', 'do' => 'result', 'module' => $main->module))."' method='get'>".
    "<input class='module_search' type='text' value='' /> ".button_search_module().
    "</form>";
}

function show_comment($id, $vars, $cid=0, $class="", $return=false){
global $load_tpl, $module_name, $comment_file, $main;
    if(empty($comment_file)){
        if (kr_file_exists("templates/{$load_tpl}/comment-{$module_name}-{$id}.tpl")) $file = "templates/{$load_tpl}/comment-{$module_name}-{$id}.tpl";
        elseif (kr_file_exists("templates/{$load_tpl}/comment-{$module_name}.tpl")) $file = "templates/{$load_tpl}/comment-{$module_name}.tpl";
        else $file = "templates/{$load_tpl}/comment.tpl";
        $comment_file = $file;
    } else $file = $comment_file;
    $content = "<div id='comment_{$cid}' class='{$class}'>".preg_replace('#\$pub\[([a-z_-]+)\]#ise', "\$vars['\\1']", str_replace('$load_tpl', $load_tpl, kr_get_content($file)))."</div>";
    $content = preg_replace('#\$lang\[([a-z_-]+)\]#ise', "array_value_set('\\1', \$main->lang)", $content);      
    if($return) return $content;
    else echo $content;
    return "";
}

function list_liter(){
global $main;
    open();
    echo "<div class='basepub'><div class='basenumbers'><div class='binner'><div class='listlit'><table><tr><td>";
    foreach(range('0', '9') as $letter) echo "<a class='list_link' href='".$main->url(array('module' => $main->module, 'do' => 'list', 'page' => 1, 'id' => $letter))."'><b>{$letter}</b></a>";
    echo "</td></tr></table><table><tr><td>";
    foreach(range('A', 'Z') as $letter) echo "<a class='list_link' href='".$main->url(array('module' => $main->module, 'do' => 'list', 'page' => 1, 'id' => $letter))."'><b>{$letter}</b></a>";
    echo "</td></tr></table><table><tr><td>";    
    foreach(array('А','Б','В','Г','Д','Е','Ё','Ж','З','И','Й','К','Л','М','Н','О','П','Р','С','Т','У','Ф','Х','Ц','Ч','Ш','Щ','Ъ','Ы','Ь','Э','Ю','Я') as $letter) echo "<a class='list_link' href='".$main->url(array('module' => $main->module, 'do' => 'list', 'page' => 1, 'id' => kr_encodeurl($letter)))."'><b>{$letter}</b></a>";
    echo "</td></tr></table></div></div></div></div>";
    close();    
}
 
?>