<?php
/**
* Файл синонимов стандартных функций
* 
* @author Igor Ognichenko
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @filesource includes/function/xining.php
* @version 2.0
*/
if (!defined("KASSELERCMS") AND !defined("ADMIN_FILE")) die("Access is limited");

/**
* Синоним функции file_exists 
* 
* @param string $file
* @return bool
*/
function kr_file_exists($file){
    return file_exists($file);
}

/**
* Синоним функции rename
* 
* @param string $path
* @param string $name
* @return bool
*/
function kr_rename($path, $name){
    if(kr_file_exists($path)) return rename($path, $name);
    else return false;
}

/**
* Синоним функции unlink
* 
* @param string $file
* @return bool
*/
function kr_unlink($file){
    if(kr_file_exists($file)) return @unlink($file);
    else return false;
}

/**
* Синоним функции file_get_contents
* 
* @param string $file
* @return string
*/
function kr_get_content($file){
    if(kr_file_exists($file)) return file_get_contents($file);
    return "";
}

/**
* Синоним функции mkdir
* 
* @param string $dir
* @param int $chmod
* @return bool
*/
function kr_mkdir($dir, $chmod=777){
global $func_conf;
    if(!kr_file_exists($dir)){
        if($func_conf['chmod_mk_dir']==true) return mkdir($dir, ($chmod[0]!=0)?'0'.$chmod:$chmod);
        else return mkdir($dir);
    } else return true;
}

/**
* Синоним функции copy  
* 
* @param string $source
* @param string $dest
* @return bool
*/
function kr_copy($source, $dest){
    return copy($source, $dest);
}

/**
* Синоним функции opendir
* 
* @param string $path
* @return resource
*/
function kr_opendir($path){
    return opendir($path);
}

/**
* Синоним функции is_dir 
* 
* @param string $file
* @return bool
*/
function kr_is_dir($file){
    return is_dir($file);
}

/**
* Синоним функции is_file
* 
* @param mixed $file
* @return bool
*/
function kr_is_file($file){
    return is_file($file);
}

/**
* Синоним функции filesize
* 
* @param string $file
* @return int
*/
function kr_filesize($file){
    return filesize($file);
}

/**
* Функция находит позицию последнего вхождения char в строке.
* 
* @param string $str
* @param string $needle
* @param int $offset
* @return int
*/
function kr_strrpos($str, $needle, $offset = null){
global $config;
    if(preg_match('/(.*?)utf(.*?)/i', $config['charset'])) return utf8_strrpos($str, $needle, $offset);
    else return strrpos($str, $needle, $offset);
}

/**
* Функция находит позицию первого вхождения строки.
* 
* @param string $str
* @param string $needle
* @param int $offset
* @return int
*/
function kr_strpos($str, $needle, $offset = null){
global $config;
    if(preg_match('/(.*?)utf(.*?)/i', $config['charset'])) return utf8_strpos($str, $needle, $offset);
    else return strpos($str, $needle, $offset);
}

/**
* Функция переводит символы строки в нижний регистр.
* 
* @param string $string
* @return string
*/
function kr_strtolower($string){
global $config;
    if(preg_match('/(.*?)utf(.*?)/i', $config['charset'])) return utf8_strtolower($string);
    else return strtolower($string);
}

/**
* Фунакия переводит символы строки в верхний регистр.
* 
* @param string $string
* @return string
*/
function kr_strtoupper($string){
global $config;
    if(preg_match('/(.*?)utf(.*?)/i', $config['charset'])) return utf8_strtoupper($string);
    else return strtoupper($string);
}

/**
* Функция возвращает часть строки.
* 
* @param string $str
* @param int $offset
* @param int $length
* @return string
*/
function kr_substr($str, $offset, $length = NULL){
global $config;
    if(preg_match('/(.*?)utf(.*?)/i', $config['charset'])) return utf8_substr($str, $offset, $length);
    else return substr($str, $offset, $length);
}

/**
* Функция получает длину строки.
* 
* @param string $text
* @return int
*/
function kr_strlen($string){
global $config;
    if(preg_match('/(.*?)utf(.*?)/i', $config['charset'])) return utf8_strlen($string);
    else return strlen($string);
}
?>