//////////////////////////////////////////////
// Kasseler CMS: Content Management System  //
// =========================================//
// Copyright (c)2007-2009 by Igor Ognichenko//
// http://www.kr-cms.net/                   //
//////////////////////////////////////////////
KR_AJAX.addEvent(window, 'load', function(){
    KR_AJAX.create.element('div', {id:'quickselect', className:'quickselect'}, {display:'none'});
});         

(function($){$.extend($, {
    //autocomplete='off'
    qs:{                
        timeout:Object,
        thisObj:Object,
        cacheStr:'',
        keyCode:-1,
        active:{
            string:'',
            textId:0
        },        
        
        init:function(obj, table, col, length, options){
            clearTimeout($.qs.timeout);
            if(!length) length = 3;
            if(options){
                var str = ' ';
                for (var i in options) str += i+"='"+options[i]+"' AND ";
            } else str = '';
            document.onkeydown=document.onkeyup=function(e){
                if(window.event) KR_AJAX.qs.keyCode = event.keyCode;
                else KR_AJAX.qs.keyCode = e.which;
            }            
            $.qs.thisObj = obj;            
            var o = $$('quickselect');
            if(obj.onblur==null) obj.onblur=function(){setTimeout(function(){$$('quickselect').style.display = 'none'; KR_AJAX.qs.clearOpetions();}, 100);}
            if($.qs.keyCode == 13){                
                $.qs.setText($.qs.active.string);                
                return false;
            } else if($.qs.keyCode == 38){
                $.qs.moveHighlight(-1);
                return false;
            } else if($.qs.keyCode == 40){
                $.qs.moveHighlight(1);
                return false;
            }
            $.qs.timeout = setTimeout(function(){             
                if(obj.value.length>length && $.qs.cacheStr != obj.value){
                    haja({action:'index.php?ajaxed=quickselect', animation:false}, {'table':table, 'col':col, 'string':obj.value, 'param':str}, {
                        onendload:function(){
                            var result = KR_AJAX.result;
                            if(!result){
                                $.qs.clearOpetions();
                                return false;
                            }
                            $.qs.searchForm(obj);
                            var p = elmPos(obj);
                            KR_AJAX.set.style({top:(obj.offsetHeight+parseInt(p.top)+1)+'px', left:(parseInt(p.left)-1)+'px', display:'block', width:(obj.offsetWidth-3)+'px'}, o);                        
                            o.innerHTML = '';
                            var texts = result.split(' ');
                            var re = new RegExp(obj.value, "gi");
                            var classRow = 'class1';                        
                            for(var i=0;i<texts.length;i++){
                                if(i==9) break;
                                if(texts[i].length>length){
                                    aStart = texts[i].search(re); matchedText = texts[i].substring(aStart, aStart + obj.value.length);                                
                                    o.innerHTML += '<input type="hidden" value="'+texts[i]+'" id="selh_'+(i+1)+'" /><a id="sel_'+(i+1)+'" class="'+classRow+'" href="#" onclick=\'KR_AJAX.qs.setText("'+texts[i]+'"); return false;\'>'+texts[i].replace(re, '<u><b>'+matchedText+'</b></u>')+'</a>';
                                    if(i<texts.length-2) o.innerHTML += '<hr />';
                                    classRow = (classRow=='class1') ? 'class2' : 'class1';
                                }
                            }
                            $.qs.cacheStr = obj.value;
                        }
                    });                                           
                } else if(obj.value.length<=length && $$('quickselect')) $$('quickselect').style.display = 'none'; 
            }, 1000);
        }, 
        
        clearOpetions:function(){
            document.onkeydown=document.onkeyup=null; 
            $$('quickselect').style.display = 'none';
            $$('quickselect').innerHTML = '';
            $.qs.active.textId = 0;
            $.qs.cacheStr = '';
            $.qs.active.string = '';
            $.qs.keyCode=-1;
        },
        
        searchForm:function(obj){
            var parent = obj.parentNode;
            while(true){
                if(parent.nodeName.toUpperCase()=='FORM') break;
                else parent = parent.parentNode;
            }
            parent.setAttribute('autocomplete','off');
            var onsubmit=parent.onsubmit;
            parent.onsubmit=function(){                
                setTimeout(function(){parent.onsubmit=onsubmit;}, 100);
                return false;                
            }
        },
        
        setText:function(text){
            $$('quickselect').style.display = 'none';
            $.qs.thisObj.value = text;
            $.qs.clearOpetions();
            return false;
        },
        
        moveHighlight:function(move){            
            var newId = $.qs.active.textId+move;            
            if($$('sel_'+newId)) {                
                for(var i=0;i<=10;i++) if($$('sel_'+i)) $$('sel_'+i).className = $$('sel_'+i).className.replace('_active', '');  
                if($$('sel_'+newId)) {
                    $.qs.active.string = $$('selh_'+newId).value;
                    $$('sel_'+newId).className = $$('sel_'+newId).className+'_active';
                }
                if($$('sel_'+$.qs.active.textId)) $$('sel_'+$.qs.active.textId).className = $$('sel_'+$.qs.active.textId).className.replace('_active', '');
                $.qs.active.textId = $.qs.active.textId+move;
            }           
        }
    }
})
})(KR_AJAX)