//////////////////////////////////////////////
// Kasseler CMS: Content Management System  //
// =========================================//
// Copyright (c)2007-2009 by Igor Ognichenko//
// http://www.kr-cms.net/                   //
//////////////////////////////////////////////
if (!window.bbeditor) window.bbeditor = {};

bbeditor.extend = function(dest, src, skipexist){
    for (var i in src) if (!skipexist || !dest.hasOwnProperty(i)) dest[i] = src[i];
    return dest;
};

(function($){$.extend($, {
    version:'1.0',
    active_editor:'',
    editors:new Array(), //id, obj, width, height
    fonts:new Array("Arial", "Comic Sans MS", "Courier New", "Georgia", "Impact", "Sans Serif", "Tahoma", "Times New Roman", "Verdana"),
    buttonHeight:20,
    style:'',
    timeout:function(){},
    classCache:{},
    cachebars:{},
    buttons:{
        "seperator": ['seperator',                           3,  0],
        "b":         [window.js_lang.bb_Bold,                20, 0],
        "i":         [window.js_lang.bb_Italic,              20, 0],
        "u":         [window.js_lang.bb_Underline,           20, 0],
        "s":         [window.js_lang.bb_Strikethrough,       20, 0],
        "left":      [window.js_lang.bb_Justifyleft,         20, 0],
        "center":    [window.js_lang.bb_Justifycenter,       20, 0],
        "right":     [window.js_lang.bb_Justifyright,        20, 0],
        "justify":   [window.js_lang.bb_JustifyFull,         20, 0],
        "li":        [window.js_lang.bb_InsertUnorderedList, 20, 0],
        "blockquote":[window.js_lang.bb_Indent,              20, 0],
        "sub":       [window.js_lang.bb_Subscript,           20, 0],
        "sup":       [window.js_lang.bb_Superscript,         20, 0],
        "hr":        [window.js_lang.bb_InsertHorizontalRule,20, 0],
        "font":      [window.js_lang.bb_SelectFont,          50, 1],
        "size":      [window.js_lang.bb_SelectSize,          50, 1],
        "color":     [window.js_lang.bb_ForeColor,           20, 1],
        "smiles":    [window.js_lang.bb_Smiles,              20, 1],
        "img":       [window.js_lang.bb_InsertImage,         20, 0],
        "link":      [window.js_lang.bb_CreateLink,          20, 1],
        "code":      [window.js_lang.bb_InsertCode,          20, 0],
        "cite":      [window.js_lang.bb_InsertQuote,         20, 0],
        "hide":      [window.js_lang.bb_InsertHide,          20, 0],
        "translit":  [window.js_lang.bb_Translit,            20, 1],
        "preview":   [window.js_lang.bb_Preview,             20, 1],
        "charset":   [window.js_lang.bb_CharMap,             20, 0],
        "backcolor": [window.js_lang.bb_BackColor,           20, 1],
        "attach":    [window.js_lang.bb_Attach,              20, 1]
    },
    
    buttonBars:[
        ["b", "i", "u", "s", "seperator", "left", "center", "right", "justify", "seperator", "li", "seperator", "blockquote", "seperator", "sub", "sup", "seperator", "translit", "charset"],
        ["font", "size", "seperator", "color", "backcolor", "seperator", "smiles", "img", "link", "seperator", "code", "cite", "hide", "preview", "hr"]
    ],

    init:function(id, buttons){         
        //if(!$$(id)) return false;
        $.active_editor = id;
        var obj = $$(id);
        if(obj.style.width.indexOf('%')>-1) {
            var procent = obj.style.width.replace('%', '');            
            obj.style.width  = ((obj.parentNode.parentNode.parentNode.parentNode.parentNode.offsetWidth-6)/100*procent)+4+'px';
        }
        if(parseInt(obj.style.width)>=390) $.buttonBars=[["b", "i", "u", "s", "seperator", "left", "center", "right", "justify", "seperator", "font", "size", "seperator", "color", "backcolor", "seperator", "smiles", "img", "link", "preview", "seperator", "translit", "charset", "li", "blockquote", "sub", "sup", "seperator", "code", "cite", "hide", "seperator", "hr"], []];            
    
        if($$('attache') && $.buttonBars[0][$.buttonBars[0].length-1]!="attach"){$.buttonBars[0][$.buttonBars[0].length] = "seperator"; $.buttonBars[0][$.buttonBars[0].length] = "attach";}                    
    
        if(KR_AJAX.browser.msie && obj.style.height) obj.style.height = (parseInt(obj.style.height)-2)+'px';
        $.createBars({id:id, obj:obj, width:parseInt(obj.style.width), height:obj.clientHeight ? obj.clientHeight:obj.offsetHeight});
        KR_AJAX.parse.style("<style type='text/css'>"+$.style+"</style>");
        $.createUniquButtons(id);
        $.c_sel(id);        
        $$(id).onclick=function(){
            bbeditor.active_editor = this.id;
            $.closeall(this.id);
        };
        if($$('resize_'+id)) $$('resize_'+id).onmousedown = function(e){
            var start = $$(id).offsetHeight;
            ps = (KR_AJAX.browser.mozilla) ? {x:e.pageX, y:e.pageY}:{x:event.clientX, y:event.clientY};
            document.onmousemove = function(e){
                p = (KR_AJAX.browser.mozilla) ? {x:e.pageX, y:e.pageY}:{x:event.clientX, y:event.clientY};
                $$(id).style.height = start+(p.y-ps.y)+'px';
                hack_sel();
            }            
            document.onmouseup = function(){document.onmousemove = function(){}}
        }
    }, 
    
    c_sel:function(id){
        var size = ['1', '2', '3', '4', '5', '6', '7'];
        var html = '';
        html += '<div id="size_'+id+'" class="dropdown" style="position: absolute; width: 160px; height: 140px;"><table cellpadding="0" cellspacing="0" width="100%">';
        for (var i=0;i<size.length;i++) {
            switch (size[i]){
                case "1": sizepx = "8"; break;
                case "2": sizepx = "10"; break;
                case "3": sizepx = "12"; break;
                case "4": sizepx = "14"; break;
                case "5": sizepx = "18"; break;
                case "6": sizepx = "24"; break;
                case "7": sizepx = "36"; break;
            }
            html += '<tr><td onclick="bbeditor.insert(\'[size='+sizepx+']\', \'[/size]\', \''+id+'\');" class="ower_button" onmouseover="this.className=\'hower_button\'" onmouseout="this.className=\'ower_button\'" style="font-size:'+sizepx+'px; height:'+sizepx+'px; cursor:pointer;"">'+size[i]+' ('+sizepx+')</td></tr>';
        }
        html += '</table></div><div id="font_'+id+'" class="dropdown" style="position: absolute; width: 160px; height: 140px;"><table cellpadding="0" cellspacing="0" width="100%">';
        for (var i=0;i<$.fonts.length;i++) {
            html += '<tr><td onclick="bbeditor.insert(\'[family='+$.fonts[i]+']\', \'[/family]\', \''+id+'\');" class="ower_button" onmouseover="this.className=\'hower_button\'" onmouseout="this.className=\'ower_button\'" style="font-family: '+$.fonts[i]+'; cursor:pointer;">'+$.fonts[i]+'</td></tr>';
        }                
        html += '</table></div>';
        document.getElementById('sels_elm_'+id).insertAdjacentHTML("afterBegin", html);
    },
    
    createUniquButtons:function(id){        
        if($$("click_preview"+id)) $$("click_preview"+id).onclick = function(){
            KR_AJAX.kr_window.onendcreate = function(){
                $$('cont_previews'+id).innerHTML = '<table cellpadding="0" cellspacing="0" height="'+(KR_AJAX.kr_window.wns['previews'+id].height-80)+'" width="100%"><tr><td align="center"><img src="includes/images/loading/mini_loading.gif" alt="Loading..."></td></tr></table>';
                haja({action:'index.php?ajaxed=preview', elm:'cont_previews'+id, animation:false}, {'text':$V(id)}, {});
            }
            KR_AJAX.kr_window.init('previews'+id, (KR_AJAX.browser.msie)?460:500, 400, null, null, {title : 'Preview', close : true, content:'', mooved:true, fone:true, resize:true, buttons:{button1:{title:'Cancel', options:{onclick:'KR_AJAX.kr_window.close("previews'+id+'", true); return false;'}}}}); return false;}
            if($$("click_backcolor"+id)) $$("click_backcolor"+id).onclick = function(){KR_AJAX.kr_window.init('backcolor'+id, (KR_AJAX.browser.msie)?235:230, (KR_AJAX.browser.msie)?250:240, null, null, {title : 'Color Picker', close : true, iframe:'includes/popups/color.html', mooved:true, fone:true, buttons:{button1:{title:'OK', options:{onclick:'bbeditor.insert("[backcolor=#"+$$("cont_frame_backcolor'+id+'").contentWindow.document.getElementById("plugHEX").innerHTML+"]", "[/backcolor]", "'+id+'"); KR_AJAX.kr_window.close("backcolor'+id+'", true); return false;'}}, button2:{title:'Cancel', options:{onclick:'KR_AJAX.kr_window.close("backcolor'+id+'", true); return false;'}}}}); return false;}
            if($$("click_color"+id)) $$("click_color"+id).onclick = function(){KR_AJAX.kr_window.init('color'+id, (KR_AJAX.browser.msie)?235:230, (KR_AJAX.browser.msie)?250:240, null, null, {title : 'Color Picker', close : true, iframe:'includes/popups/color.html', mooved:true, fone:true, buttons:{button1:{title:'OK', options:{onclick:'bbeditor.insert("[color=#"+$$("cont_frame_color'+id+'").contentWindow.document.getElementById("plugHEX").innerHTML+"]", "[/color]", "'+id+'"); KR_AJAX.kr_window.close("color'+id+'", true); return false;'}}, button2:{title:'Cancel', options:{onclick:'KR_AJAX.kr_window.close("color'+id+'", true); return false;'}}}}); return false;}
            if($$("click_translit"+id)) $$("click_translit"+id).onclick = function(){KR_AJAX.kr_window.init('translin'+id, 550, (KR_AJAX.browser.mozilla)?420:390, null, null, {title : 'Convert Translit', close : true, iframe:'includes/popups/translit.html', mooved:true, fone:true, buttons:{button1:{title:'OK', options:{onclick:'document.getElementById("'+id+'").value = document.getElementById("'+id+'").value+$$("cont_frame_translin'+id+'").contentWindow.document.getElementById("cyr").value; KR_AJAX.kr_window.close("translin'+id+'", true); return false;'}}, button2:{title:'Cancel', options:{onclick:'KR_AJAX.kr_window.close("translin'+id+'", true); return false;'}}}}); return false;}
            if($$("click_smiles"+id)) $$("click_smiles"+id).onclick = function(){
            bbeditor.timeout=bbeditor.insert_smile(id);
            KR_AJAX.kr_window.init('smile'+id, (KR_AJAX.browser.msie)?400:500, (KR_AJAX.browser.msie)?545:525, null, null, {title : 'Select Smile', close : true, iframe:'index.php?module=account&do=smiles&id='+id, mooved:true, fone:true, buttons:{button1:{title:'Cancel', options:{onclick:'KR_AJAX.kr_window.close("smile'+id+'", true); return false;'}}}}); 
            return false;
        }
        if($$("click_charset"+id)) $$("click_charset"+id).onclick = function(){
            bbeditor.timeout=bbeditor.insert_charset(id); 
            KR_AJAX.kr_window.init('chset'+id, (KR_AJAX.browser.msie)?480:515, 400, null, null, {title : 'Select custom character', close : true, iframe:'includes/popups/charset.html', mooved:true, fone:true, buttons:{button1:{title:'Cancel', options:{onclick:'KR_AJAX.kr_window.close("chset'+id+'", true); return false;'}}}}); 
            return false;
        }
        if($$("click_link"+id)) $$("click_link"+id).onclick = function(){KR_AJAX.kr_window.init('hylink'+id, 330, (KR_AJAX.browser.msie)?170:140, null, null, {title : 'Insert Hyperlink', close : true, iframe:'includes/popups/hyperlink.html', mooved:true, fone:true, buttons:{button1:{title:'OK', options:{onclick:'bbeditor.insert_link("'+id+'"); KR_AJAX.kr_window.close("hylink'+id+'", true); return false;'}}, button2:{title:'Cancel', options:{onclick:'KR_AJAX.kr_window.close("hylink'+id+'", true); return false;'}}}}); return false;}        
        if($$("click_attach"+id)) $$("click_attach"+id).onclick = function(){switch_content('attache'); return false;}        
        if($$("click_img"+id)) $$("click_img"+id).onclick = function(){KR_AJAX.kr_window.init('image'+id, 330, (KR_AJAX.browser.msie)?170:140, null, null, {title : 'Insert Image', close : true, iframe:'includes/popups/image.html', mooved:true, fone:true, buttons:{button1:{title:'OK', options:{onclick:'bbeditor.insert_img("'+id+'"); KR_AJAX.kr_window.close("image'+id+'", true); return false;'}}, button2:{title:'Cancel', options:{onclick:'KR_AJAX.kr_window.close("image'+id+'", true); return false;'}}}}); return false;}        
        if($$("click_size"+id)) $$("click_size"+id).onclick = function(){
            KR_AJAX.set.style(elmPos("click_size"+id),$$('size_'+id));
            $$('size_'+id).style.top = parseInt($$('size_'+id).style.top)+21+'px';
            $.show_sel($$('size_'+id), id);
            return false;
        }
        if($$("click_font"+id)) $$("click_font"+id).onclick = function(){
            KR_AJAX.set.style(elmPos("click_font"+id),$$('font_'+id));
            $$('font_'+id).style.top = parseInt($$('font_'+id).style.top)+21+'px';
            $.show_sel($$('font_'+id), id);
            return false;
        }
    },

    show_sel:function(e, id){        
        if(e.style.display!='block'){
            $.closeall(id);
            e.style.display='block';
        } else e.style.display='none';
    },
    
    insert_smile:function(id){
        return setInterval(function(){
            if($$("cont_frame_smile"+id)){
                if($$("cont_frame_smile"+id).contentWindow.document.getElementById('setsmile') && $$("cont_frame_smile"+id).contentWindow.document.getElementById('setsmile').value){
                    var st = $$("cont_frame_smile"+id).contentWindow.document.getElementById('setsmile').value;
                    $$("cont_frame_smile"+id).contentWindow.document.getElementById('setsmile').value = ''; 
                    $$(id).value = $$(id).value+st;
                    KR_AJAX.kr_window.close("smile"+id, true);
                    clearInterval($.timeout);                    
                }    
            }    
        }, 10);
    },
    
    insert_charset:function(id){
        return setInterval(function(){
            if($$("cont_frame_chset"+id)){
                if($$("cont_frame_chset"+id).contentWindow.document.getElementById('charset_string') && $$("cont_frame_chset"+id).contentWindow.document.getElementById('charset_string').value){
                    var st = $$("cont_frame_chset"+id).contentWindow.document.getElementById('charset_string').value;
                    $$("cont_frame_chset"+id).contentWindow.document.getElementById('charset_string').value = ''; 
                    $$(id).value = $$(id).value+st;
                    KR_AJAX.kr_window.close("chset"+id, true);
                    clearInterval($.timeout);                    
                }    
            }    
        }, 10);
    },
    
    insert_img:function(id){
        var url = $$("cont_frame_image"+id).contentWindow.document.getElementById('img_url').value;
        if (url) $.insert('[img='+$$("cont_frame_image"+id).contentWindow.document.getElementById('img_align').value+' alt='+$$("cont_frame_image"+id).contentWindow.document.getElementById('img_title').value+']'+url+'[/img]', '', id);
    },
    
    insert_link:function(id){
        var url = $$("cont_frame_hylink"+id).contentWindow.document.getElementById('url').value;
        url = url.replace('http//', '').replace('ftp://', '').replace('https://', '').replace('http://', '').replace('mailto:', '');
        var tag = '[url=' + $$("cont_frame_hylink"+id).contentWindow.document.getElementById('linkType').value + url + ']' + $$("cont_frame_hylink"+id).contentWindow.document.getElementById('titlelink').value + '[/url]';
        if (url) $.insert(tag, '', id);
    },
    
    createBars:function(e){
        if($.cachebars[e.id]) return false;
        $.editors[$.editors.length] = e;
        document.getElementById(e.id).insertAdjacentHTML("beforeBegin", '<div style="background: url(includes/images/editor/background_silver.jpg);" class="editorBars" id="topmenu_'+e.id+'">'+$.createButtons(e, $.buttonBars[0], 'top')+'</div>');
        if($.buttonBars[1].length>0) document.getElementById(e.id).insertAdjacentHTML("afterEnd",  '<div class="resizeBar" id="resize_'+e.id+'"><img src="includes/images/pixel.gif" alt="" /></div><div style="background: url(includes/images/editor/background_silver.jpg);" class="editorBars" id="bottommenu_'+e.id+'">'+$.createButtons(e, $.buttonBars[1], 'bottom')+'</div><span id="sels_elm_'+e.id+'"></span>');
        else document.getElementById(e.id).insertAdjacentHTML("afterEnd",  '<div class="resizeBar" id="resize_'+e.id+'"><img src="includes/images/pixel.gif" alt="" /></div><span id="sels_elm_'+e.id+'"></span>');
        $.cachebars[e.id] = true;
    },
    
    createButtons:function(e, arrB, pos){
        if(arrB.length==0) return false;
        var elms = {id:0, sum:8};
        var sum = 8;
        for(var i=0; i<arrB.length;i++) sum += $.buttons[arrB[i]][1];
        for(var i=0; i<arrB.length;i++){
            if(elms.sum+$.buttons[arrB[i]][1]<e.width-$.buttons[arrB[i]][1]){
                elms.id = i;
                elms.sum += $.buttons[arrB[i]][1]-0.4;
            } else break;
        }
        var other_width = sum-elms.sum;
        var buttons = '';
        var buttons2 = '';
        var lastImg = '';
        var seperator = "<td><img src='includes/images/editor/seperator.png' alt='' style='margin: px;'></td>";
        for(var i=0; i<=elms.id; i++){
            if(arrB[i]!="seperator"){
                $.style += '#click_'+arrB[i]+e.id+' {background: url(includes/images/editor/'+arrB[i]+'.png) top left repeat-x;} #click_'+arrB[i]+e.id+':hover {background: url(includes/images/editor/'+arrB[i]+'.png) bottom left repeat-x;} ';
                onclicks = "bbeditor.insert('["+arrB[i]+"]', '[/"+arrB[i]+"]', '"+e.id+"'); return false;";
                buttons += '<td><a href="#" onclick="'+onclicks+'" style="width: '+$.buttons[arrB[i]][1]+'px; height: '+$.buttonHeight+'px; display: block; float: left;" title="'+$.buttons[arrB[i]][0]+'" id="click_'+arrB[i]+e.id+'" class="editor_click"></a></td>';
                lastImg = arrB[i];
            } else {
                buttons += seperator;
                lastImg = "seperator";
            }
        }                      
        for(i=elms.id+1; i<=arrB.length; i++){
            if(!$.buttons[arrB[i]]) break;
            if(arrB[i]!="seperator"){
                $.style += '#click_'+arrB[i]+e.id+' {background: url(includes/images/editor/'+arrB[i]+'.png) top left repeat-x;} #click_'+arrB[i]+e.id+':hover {background: url(includes/images/editor/'+arrB[i]+'.png) bottom left repeat-x;} ';
                onclicks = "bbeditor.insert('["+arrB[i]+"]', '[/"+arrB[i]+"]', '"+e.id+"'); return false;";
                buttons2 += '<td><a href="#" onclick="'+onclicks+'" style="width: '+$.buttons[arrB[i]][1]+'px; height: '+$.buttonHeight+'px; display: block; float: left;" title="'+$.buttons[arrB[i]][0]+'" id="click_'+arrB[i]+e.id+'" class="editor_click"></a></td>';
                lastImg = arrB[i];
            } else if(i!=elms.id+1){  
                buttons2 += seperator;
                lastImg = "seperator";
            }
        }  
        if(elms.id<arrB.length-1){
            $.style += '#click_other'+e.id+' {background: url(includes/images/editor/other.png) top left repeat-x;} #click_other'+e.id+':hover {background: url(includes/images/editor/other.png) bottom left repeat-x;} ';
            if(lastImg!="seperator") buttons += seperator;
            buttons += '<td><a onclick="bbeditor.show_other_button(this, \''+"other_buttons_"+pos+"_"+e.id+'\', '+other_width+'); return false;" href="#" style="width: 9px; height: '+$.buttonHeight+'px; display: block; float: left;" title="" id="click_other'+e.id+'" class="editor_click"></a></td>';
        }
        return "<div style='height: "+($.buttonHeight+2)+"px; display: block; width: "+e.width+"px;'><span style='clear: left'><table cellpadding='0' cellspacing='0'><tr><td><img src='includes/images/editor/seperator2.png' alt=''></td>"+buttons+"</tr></table></span><span style='border:0px; display: none; position: absolute;' id='other_buttons_"+pos+"_"+e.id+"' class='other_bar'><table cellpadding='0' cellspacing='0' style='background: url(includes/images/editor/background_silver.jpg);' cellpadding='0' cellspacing='0'><tr>"+buttons2+"</tr></table></span>";
    },
    
    show_other_button:function(obj, id, width){
        if($$(id).style.display!='block') $$(id).style.display = 'block';
        else $$(id).style.display = 'none';
        KR_AJAX.set.style(elmPos(obj), $$(id));
        $$(id).style.top = parseInt($$(id).style.top)+21+'px';
        $$(id).style.left = parseInt($$(id).style.left)-width+'px';        
    },              
    
    insert:function(open, close, id){
        if(open=='[hr]'){close = '';}
        if(id) e = $$(id);
        else e = $$($.active_editor);
        if(!e) return false;
        e.focus();
        if(typeof document.selection != 'undefined'){
            var range = document.selection.createRange();
            range.text = open+range.text+close;
            range = document.selection.createRange();
            range.select();
        } else if(typeof e.selectionStart != 'undefined'){
            var start = e.selectionStart;
            var end   = e.selectionEnd;
            var scroll = e.scrollTop;
            var caret  = e.value.substr(0, start) + open + e.value.substring(start, end) + close + e.value.substr(end);
            e.value = caret;
            e.selectionStart = caret;
            e.selectionEnd = caret;
            e.scrollTop = scroll;
        } else e.value += open + close;
        setTimeout(function(){e.focus()}, 100);
        $.closeall(id);
    },
    
    closeall:function(id){
        var elms = ['font_', 'size_', 'other_buttons_top_', 'other_buttons_bottom_'];
        for(var i=0;i<elms.length;i++) if($$(elms[i]+id)) $$(elms[i]+id).style.display='none';
    }
})
})(bbeditor)