//////////////////////////////////////////////
// Kasseler CMS: Content Management System  //
// =========================================//
// Copyright (c)2007-2009 by Igor Ognichenko//
// http://www.kr-cms.net/                   //
//////////////////////////////////////////////
if(!window.KR_AJAX) KR_AJAX = {};


(function($){$.extend($, {
    calendar:{
        weekdays:[window.js_lang.Mo, window.js_lang.Tu, window.js_lang.We, window.js_lang.Th, window.js_lang.Fr, window.js_lang.Sa, window.js_lang.Su],
        months:[window.js_lang.january, window.js_lang.february, window.js_lang.march, window.js_lang.april, window.js_lang.may, window.js_lang.june, window.js_lang.july, window.js_lang.august, window.js_lang.september, window.js_lang.october, window.js_lang.november, window.js_lang.december],
        mDays:[31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31],
        cells:{width:19, height:15},
        offset:1,
        ids:{},
        date:{},
        set_date:{},

        init:function(e, options){
            if($$(options.year).value=='0000' && $$(options.month).value=='00' && $$(options.day).value=='00'){
                var localTime = new Date();  
                this.date[e] = {year:localTime.getFullYear(), month:localTime.getMonth()+1, day:localTime.getDate()};
            } else this.date[e] = {year:$$(options.year).value, month:$$(options.month).value, day:$$(options.day).value};
            this.ids[e] = options;
            $.create.element('div', {id:e, className:'cal_conteiner'}, {'display':'none'});
            $$('button_'+e).onclick=function(){
                $.calendar.set_date[e] = {year:$$(options.year).value, month:$$(options.month).value, day:$$(options.day).value};
                if($$(e).style.display=='none'){
                    var pos = elmPos(this);
                    $$(e).innerHTML = $.calendar.create.get_html($.calendar.date[e].year, $.calendar.date[e].month, $.calendar.date[e].day, e);
                    setTimeout(function(){
                        document.onclick=function(){KR_AJAX.calendar.hideAll(); document.onclick=function(){}}
                        $$(e).onmouseout=function(){document.onclick=function(){KR_AJAX.calendar.hideAll(); document.onclick=function(){}}}; 
                        $$(e).onmousemove=function(){document.onclick=function(){}};
                        $$(e).onclick=function(){hack_sel();};
                    }, 100);
                    $.set.style({left:pos.left, top:parseInt(pos.top)+17+'px', display:'block'}, $$(e));
                } else $$(e).style.display='none';
            }
        },

        create:{
            get_html:function(y, m, d, n){
               if(m==13) {m=1, y++;} else if(m==0) {m=12, y--;}
               $.calendar.date[n] = {year:y, month:m, day:d};
               setTimeout(function(){
                   $$('backYear'+n).onclick=function(){$$(n).innerHTML = $.calendar.create.get_html(parseInt($.calendar.date[n].year)-1, $.calendar.date[n].month, $.calendar.date[n].day, n);}
                   $$('nextYear'+n).onclick=function(){$$(n).innerHTML = $.calendar.create.get_html(parseInt($.calendar.date[n].year)+1, $.calendar.date[n].month, $.calendar.date[n].day, n);}
                   $$('backMonth'+n).onclick=function(){$$(n).innerHTML = $.calendar.create.get_html($.calendar.date[n].year, parseInt($.calendar.date[n].month)-1, $.calendar.date[n].day, n);}
                   $$('nextMonth'+n).onclick=function(){$$(n).innerHTML = $.calendar.create.get_html($.calendar.date[n].year, parseInt($.calendar.date[n].month)+1, $.calendar.date[n].day, n);}
               }, 100);
                var i, days, daycount = 1;
                if($.calendar.LeapYear(y)) $.calendar.mDays[1] = 29; else $.calendar.mDays[1] = 28;
                for(i=days=0;i<m-1;i++) days += $.calendar.mDays[i];
                var start = $.calendar.getMonDay(y, days);
                var html = '<table cellspacing=1 cellpadding=2>'+this.head(y, $.calendar.months[m-1], n);
                while(daycount <= $.calendar.mDays[m-1]){
                    html += '<tr>';
                    for(i=1; i<=7; i++){
                        if((daycount == 1 && i < start) || daycount > $.calendar.mDays[m-1]) html += this.cell('&nbsp;', 'cellspase', n);
                        else {
                            classname = (y==$.calendar.set_date[n].year && m==$.calendar.set_date[n].month && daycount==$.calendar.set_date[n].day) ? "thisdate" : "cell";                            
                            html += this.cell(daycount, classname, i, n);
                            daycount++;
                        }
                    }
                    html += '</tr>';
                }
                return html+'</table>';
            },
                
            head:function(year, month, n){
                var head = '<tr><td colspan="7" align="center"><table cellspacing="0" cellpadding="0" width="100%"><tr><td width="'+$.calendar.cells.width+'" align="center"><span style="cursor: pointer; font-weight: bold;" id="backYear'+n+'">&#171</span>&nbsp;&nbsp;&nbsp;<span style="cursor: pointer; font-weight: bold;" id="backMonth'+n+'">&#8249</span></td><td align="center"><b>'+month+'&nbsp;'+year+'</b></td><td width="'+$.calendar.cells.width+'" align="center"><span style="cursor: pointer; font-weight: bold;" id="nextMonth'+n+'">&#8250</span>&nbsp;&nbsp;&nbsp;<span style="cursor: pointer; font-weight: bold;" id="nextYear'+n+'">&#187</span></td></tr></table></td></tr><tr>';                
                for (var i=0;i<=6;i++) head += this.cell($.calendar.weekdays[(i+$.calendar.offset-1) % 7], 'cellspace', 0, n);
                return head+'</tr>';
            },

            cell:function(content, classname, day, n){
                if(classname!='thisdate') classname = (day==6)?"sa":((day==7)?"su":classname);
                onclick = (content!='&nbsp;') ? ' onclick="KR_AJAX.calendar.setDate(\''+content+'\', \''+n+'\')"' : '';
                return '<td '+onclick+' class="'+classname+'" align="center" width="'+$.calendar.cells.width+'" height="'+$.calendar.cells.height+'">'+content+'</td>';
            }
        },

        setDate:function(day, n){
            $$($.calendar.ids[n].year).value = $.calendar.date[n].year;
            $$($.calendar.ids[n].month).value = $.calendar.date[n].month;
            var month = $$($.calendar.ids[n].month).value;
            $$($.calendar.ids[n].month).value = (month.length>1) ? month : '0'+month;
            $$($.calendar.ids[n].day).value = (day.length>1) ? day : '0'+day;
            this.hideAll();
        },

        getMonDay:function(year, days) {
            var a = days;
            if(year) a += (year-1)*365;
            for(var i=1;i<year;i++) if(this.LeapYear(i)) a++;
            if(year>1582 || (year==1582 && days>=277)) a -= 10.5;
            if(a) a = (a-this.offset)%7;
            else if(this.offset) a += 7-this.offset;
            return a;
        },

        hideAll:function(){document.onclick=function(){}; for(var i in this.ids){$$(i).style.display='none'; $$(i).onmouseout=function(){}; $$(i).onmousemove=function(){};}},
        LeapYear:function(year){return(!(year%4) && (year<1582 || year%100 || !(year%400)))?true:false;}
    }
})
})(KR_AJAX)