<?php
/**
* Proxy
* 
* @author Brovko Dmitry
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @filesource includes/myzip.php
* @version 2.0
*/

define ("MOD_TITLE", FALSE); //модифицировать title информацией о сжатии и прочем
define ("GETURL", "urlx"); //наименование GET-параметра, в котором идет url
 
function getStrMas($_MAS, $MAS_STR){
    $MAS_STR="";
    foreach($_MAS as $key => $value){
        //если включены magic_quotes, то делаем "unMagic_quotes"
        if(get_magic_quotes_gpc()) $value=stripslashes($value);
        $MAS_STR.='&'.$key.'='.urlencode($value);
    }
    //убираем первый '&'
    if($MAS_STR!="") $MAS_STR=substr($MAS_STR, 1);
}

/**
*  Находит, вырезает и обрабатывает служебный заголовок страницы полученной пхп-проксей (от целевого сервера).
*  По этому заголовку формируется заголовок страницы, идущий от пхп-прокси браузеру.
*  Вырезается заголовок из $ret_data.
*/
function getHeader($_ret_data){
global $no_zip, $head_sep;
    $no_zip = false; $head_sep="";
    //находим позицию разделителя на заголовок и тело страницы
    //нахождение меньшего связано с тем, что некоторые сервера разделяют заголовок от тела \n\n
    //вместо необходимых \r\n\r\n (например, http://www.mts.ru/sms, в дояйцевую эпоху)
    $classic = strpos($_ret_data, "\r\n\r\n");
    $olen = strpos($_ret_data, "\n\n");
    if(($classic!==FALSE) && (($olen===FALSE) || ($olen>$classic))){
        $i_head=$classic; //i_head - позиция разделителя заголовка и тела полученных данных
        $head_mes_separator="\r\n\r\n";
    }elseif($olen!==FALSE){
        $i_head=$olen;
        $head_mes_separator="\n\n";
        $head_sep="олень"; //флажок "сервера-оленя" (выводится в title страницы)
    } else die ("<h1>HTTP-header error /olen/ !</h1>");
    
    //получаем хедер страницы и ее тело
    $header=substr($_ret_data, 0, $i_head);
    $_ret_data=substr($_ret_data, $i_head+strlen($head_mes_separator));
    //получаем массив строк из header-а и его вставка в header, отдаваемый браузеру клиента
    $header_mas=split("\r\n", $header);
    //$fout=fopen("tmp.log", "wb");
    //fwrite ($fout, "***".$header_mas[9]."***\r\n");

    //среди заголовков ищем редирект (через location - если он есть, то даем этот заголовок клиенту)
    while (current ($header_mas)){
        $headline=$header_mas[key($header_mas)];
       //здесь, далее и ранее некоторые операции можно производить через регул. выражения
       //fwrite ($fout, "***".$headline."***\r\n");
       //header ($headline);
       //ловим уже сжатые страницы, чтоб не пережимать их дважды
       if ((findHeaderLine ( "Content-Encoding", $headline)==1) AND (strpos(strtolower($headline), 'gzip')!=FALSE)) $no_zip=true;
       elseif((findHeaderLine ( "Content-Type", $headline)==1) AND
             ((strpos(strtolower($headline), 'image/jpeg')!=FALSE) OR //сделано ради IE5, т.к. опера 7.51 запросто "кушала" зипованый jpeg и png
             (strpos(strtolower($headline), 'image/png')!=FALSE))) $no_zip=true; 
       if (findHeaderLine ( "Transfer-Encoding", $headline)!=1) header ($headline);
       next($header_mas);
    }
    // fclose ($fout);
}

/**
*  Проверяет строку из заголовка на наличие в ней подстроки ($template="location" /редирект/, например),
*  если находит, то возвращает 1.
*/
function findHeaderLine ($template, $headline){
    //поиск ключевых заголовков  - если находим,
    //то возвращаем 1
    $res=preg_replace($template, "", substr($headline, 0, strlen($template)));
    if($res!=substr($headline, 0, strlen($template)))  return 1; //т.е. нашли
    return -1;
}

/**
*  Возвращает метку времени с микросекундами
*/
function getMicroTime(){
    list($msec, $sec) = explode(" ", microtime());
    return ((float)$msec + (float)$sec);
}

function convert_http_param($h_str){
    $h_tmp=strtolower($h_str);
    $h_tmp=preg_replace('(_)','_ ',$h_tmp);
    $h_tmp=ucwords($h_tmp);
    $h_tmp=preg_replace('(_ )','-',$h_tmp);
    return $h_tmp;
}

if(isset($_GET[GETURL])){
    //запускаем систему веб-прокси, если установлен get-параметр GETURL
    $time_start=getMicroTime();
    $POST_STR="";
    $GET_STR="";
    $COOKIE_STR="";

    //получаем урл требуемой страницы (в этот параметр также идет первый ГЕТ-параметр)
    $url=$_GET[GETURL];
    $parse_url=explode('?', $url); //parse_url[0] - урл страницы; parse_url[1] - первый гет-параметр
    //парсим первый гет-параметр, если он существует
    if(isset($parse_url[1])) {
        $sub_parse=explode('=', $parse_url[1]);//разбиваем на название GET-переменной и ее значение
        //здесь, далее и ранее некоторые операции можно производить через регул. выражения
        if(isset($sub_parse[1])){
            //если включены magic_quotes, то делаем "unMagic_quotes"
            if (get_magic_quotes_gpc()) $sub_parse[1]=stripslashes($sub_parse[1]);
            $url=$parse_url[0].'?'.$sub_parse[0].'='.urlencode($sub_parse[1]);
        } else $url=$parse_url[0].'?'.$sub_parse[0];
    } else $url=$parse_url[0];
    //получаем развернутые строки параметров
    $GET_STR=substr(strstr ($_SERVER["QUERY_STRING"], '&'),1);
    getStrMas($_POST, &$POST_STR);
    getStrMas($_COOKIE, &$COOKIE_STR);
    // инициализация сеанса CURL-a
    $ch = curl_init();
    // установка URL и других необходимых параметров для взятия запрашиваемой страницы из инета
    if ($GET_STR!="") {$GET_STR="&".$GET_STR; $params="G";}
    curl_setopt($ch, CURLOPT_URL, $url.$GET_STR);
    curl_setopt($ch, CURLOPT_HEADER, 1); //устанавливаем параметр CURL, чтобы в ответе ловить заголовки страницы
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 10); //результат CURL возвращает, а НЕ выводит
    curl_setopt($ch, CURLOPT_MUTE, 1);
    //делать перенаправление средствами CURL-а, если оно потребуется
    //если бы CURL не возвращал два заголовка в случае редиректа, то можно было бы разремарить
    //curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    //отправляем пост-переменные CURL-ом
    if($POST_STR!="") {
        curl_setopt($ch, CURLOPT_POSTFIELDS, $POST_STR);
        $params.="P";
    }
    //отправляем КУКИ CURL-ом
    if($COOKIE_STR!=""){
        curl_setopt($ch, CURLOPT_COOKIE, $COOKIE_STR);
        $params.="C";
    }
    $i=0; //проставляем заголовки запроса от браузера клиента в CURL-хттп-параметры (пропуская HOST)
    foreach($_SERVER as $h=>$v){
        if(preg_match('HTTP_(.+)', $h, $hp)){
            $adp=convert_http_param($hp[1]).": ".$v;
            if(strtolower($hp[1])=="host") $adp="";
            $sbt = strtolower(substr($hp[1],0,2));
            if($sbt=="x_") $adp="";
            $shead=$shead.$adp;
            if($adp!=""){
                $httpheaders[$i++]=convert_http_param($hp[1]).": ".$v;
                // echo $sbt."   ".convert_http_param($hp[1]).": ".$v."\r\n";
            }
            // if (strtolower($hp[1])!="host") $httpheaders[$i++]=convert_http_param($hp[1]).": ".$v;
        }
    }
    curl_setopt ($ch, CURLOPT_HTTPHEADER, $httpheaders);

    // fclose ($fout);
    //CURLOPT_HTTPHEADER
    //curl_setopt ($ch, CURLOPT_HTTPHEADER, Array("Accept-Language: ru"));
    // загрузка страницы и выдача её в переменную $ret_data
    $ret_data=curl_exec($ch);

    //вырезаем заголовок из ret_data и передаем нужные (location, content-type) части заголовка клиенту
    getHeader (&$ret_data);
    //сжимаем передаваемые данные
    if ($no_zip==false){
        $gzdata = gzencode($ret_data, 9); //пробное сжатие на определение объема сжатого
        $inSize=strlen($ret_data); $outSize=strlen($gzdata);
        $tmp_ret_data=$ret_data; //сохраняем исходное значение на случай наличия нетекстовых символов в $ret_data == двоичный файл
        //делаем модифицированный тайтл для ХТМЛ
        if(MOD_TITLE) $ret_data = preg_replace( "<title>", "<title>".sprintf("[%s/%s=%5.2fx::%s::%5.2fс::%s]",$inSize, $outSize, ($inSize/$outSize), $params, (getMicroTime()-$time_start), $head_sep)." ", $ret_data);
        //проверка уменьшения длины строки после (такое возможно только в случае скачивания нетекстового файла)
        //если длина уменьшилась - восстанавливаем в $ret_data прежнее содержимое
        if(strlen($tmp_ret_data)>strlen($ret_data)) $ret_data=$tmp_ret_data;
        //сжатие делается дважды, чтобы в тайтл при втором сжатии поместить доп. информацию,
        //полученную отчасти по результатам первого сжатия
        $gzdata = gzencode($ret_data, 9);
        header("Content-Encoding: gzip");
        header("Vary: Accept-Encoding");
        header("Content-Length: ".strlen($gzdata));
        print $gzdata;
    } else {
        //НЕ сжимаем передаваемые данные
        //(используется для jpeg и png [сжатый gif все брайзеры "кушают", потому /как правило, избыточно/ на всякий случай его тоже жмем])
        header("Content-Length: ".strlen($ret_data));
        print $ret_data;
    }
    // завершение сеанса и освобождение ресурсов
    curl_close($ch);
} else header("HTTP/1.0 404 Not Found");
?>