<?php
/**
* Установочный файл системы
* 
* @author Igor Ognichenko
* @copyright Copyright (c)2007-2009 by Kasseler CMS
* @link http://www.kr-cms.net/
* @filesource install.php
* @version 2.0
*/
define('KASSELERCMS', true);
define("ADMIN_FILE", true);
define('INSTALLCMS', true);

require_once "base.php";  
require_once "includes/function/xining.php";
require_once "includes/function/init.php";
if(isset($_GET['lang']) AND kr_file_exists("install/language/{$_GET['lang']}.php")){
    $_SESSION['wizard_lang'] = $_GET['lang'];
    setcookies($_GET['lang'], "admin_lang");
    setcookies($_GET['lang'], "lang");
    redirect("install.php");
}
global $install_lang, $language_install;
$language_install = isset($_COOKIE["admin_lang"]) ? $_COOKIE["admin_lang"] : 'russian';
require_once "install/language/{$language_install}.php";

function button_case(){
global $language_install;
    return ($language_install=='russian') ? "ru" : "en";
}

function scan_directories($dir='uploads'){
static $row;
    if(@$dir[strlen(@$dir)-1]!="/") @$dir .= "/";
    if(($handle = kr_opendir($dir))){
        while(($obj = readdir($handle))){
            if(!preg_match('/\.+/', $obj)){
                $row = ($row=='row4') ? 'row5' : 'row4';
                $chmod = substr(get_chmod($dir.$obj), 1);
                echo "<tr class='{$row}'><td>{$dir}{$obj}</td><td align='center'><span style='color: ".($chmod==777?'green':'red')."'><b>{$chmod}</b></span></td><td align='center'><span style='color: #777777;'><b>777</b></span></td></tr>";                
                if(kr_is_dir($dir.$obj)) scan_directories($dir.$obj);
            }
        }
        closedir($handle);
    }
}

function step1(){
global $install_lang;
    return array('content' => $install_lang['step1_content']."<div align='right'><a href='install.php?do=step2'><input onclick=\"location.href='install.php?do=step2';\" class='submit' type='image' src='install/template/images/next_".button_case().".png' alt='{$install_lang['next']}' /></a></div>", 'title' => $install_lang['step1_title']);
}

function step2(){
global $install_lang;
    $content = "<textarea rows='17' readonly='readonly' cols='60' style='border: 1px #F1F1F1 solid; background-color: #FFFFFF; width: 100%'>".kr_get_content("install/licence.txt")."</textarea><br /><br />".
    "<div align='right'>
    <form method='post' action='install.php?do=step3'>
    <input type='hidden' name='apply' value='yes' />
    <input class='submit' type='image' src='install/template/images/apply_".button_case().".png' alt='{$install_lang['accept']}' />
    <a href='#' onclick=\"location.href='http://kr-cms.net/'; return false;\"><input class='submit' type='image' src='install/template/images/noapply_".button_case().".png' alt='{$install_lang['doaccept']}' /></a>    
    </form></div>";
    return array('content' => $content, 'title' => $install_lang['step2_title']);
}

function step3(){
global $install_lang;
static $row;
    if(isset($_POST['apply']) AND $_POST['apply']=='yes'){
        ob_start();
        echo $install_lang['step3_content']."<br /><br />".
        "<h1>{$install_lang['chmod_dir']}</h1>".
        "<table width='100%' class='table'><tr><th>{$install_lang['link_dir']}</th><th width='150'>{$install_lang['chmod_this']}</th><th width='150'>{$install_lang['chmod_corect']}</th></tr>";
        scan_directories();
        echo "</table>";
        echo "<br /><br /><h1>{$install_lang['chmod_file']}</h1><table width='100%' class='table'><tr><th>{$install_lang['link_dir']}</th><th width='150'>{$install_lang['chmod_this']}</th><th width='150'>{$install_lang['chmod_corect']}</th></tr>";
        $config_dir = kr_opendir("includes/config");
        while(($file = readdir($config_dir))){
            if (preg_match('/(.+?)\.php/', $file)){ 
                $chmod = substr(get_chmod("includes/config/{$file}"), 1);
                $row = ($row=='row4') ? 'row5' : 'row4';
                echo "<tr class='{$row}'><td>/includes/config/{$file}</td><td align='center'><span style='color: ".($chmod>=666?'green':'red')."'><b>{$chmod}</b></span></td><td align='center'><span style='color: #777777'><b>666</b></span></td></tr>";
            }
        }
        closedir($config_dir);
        echo "</table><br /><br /><div align='right'><a href='install.php?do=step4'><input onclick=\"location.href='install.php?do=step4';\" class='submit' type='image' src='install/template/images/next_".button_case().".png' alt='{$install_lang['next']}' /></a></div>";
        $content = ob_get_contents(); ob_end_clean();
        $_SESSION['apply'] = true;
    } else $content = warning($install_lang['noyeslicense'], true);
    return array('content' => $content, 'title' => $install_lang['step3_title']);
}

function step4($connect=""){
global $install_lang;
    if(isset($_SESSION['apply']) AND $_SESSION['apply']==true){
        $content = "";
        $msg = (!is_writable('includes/config/config.php')) ? $install_lang['config_error'] : "";
        $msg .= (!is_writable('includes/config/configdb.php')) ? $install_lang['configdb_error'] : "";
        if(empty($msg)){
            if(!empty($connect)) $content .= warning($connect, true);
            $content .= "<form action='install.php?do=step5' method='post'>".
            "<table width='100%' class='form'>".
            "<tr class='row_tr'><td class='form_text2'>{$install_lang['database']}</td><td class='form_input2'>".in_sels("type", array('mysql' => 'MySql'), 'select')."</td></tr>".
            "<tr class='row_tr'><td class='form_text2'>{$install_lang['server']}</td><td class='form_input2'>".in_text("host", 'input_text2', 'localhost')."</td></tr>".
            "<tr class='row_tr'><td class='form_text2'>{$install_lang['user']}</td><td class='form_input2'>".in_text("user", 'input_text2', 'root')."</td></tr>".
            "<tr class='row_tr'><td class='form_text2'>{$install_lang['password']}</td><td class='form_input2'>".in_pass("password", 'input_text2')."</td></tr>".
            "<tr class='row_tr'><td class='form_text2'>{$install_lang['dbname']}</td><td class='form_input2'>".in_text("name", 'input_text2', 'kasseler')."</td></tr>".
            "<tr class='row_tr'><td class='form_text2'>{$install_lang['prefix']}</td><td class='form_input2'>".in_text("prefix", 'input_text2', 'kasseler')."</td></tr>".
            "<tr class='row_tr'><td class='form_text2'>{$install_lang['charset']}</td><td class='form_input2'>".in_text("db_charset", 'input_text2', 'utf8')."</td></tr>".
            "</table><br /><br /><div align='right'><input class='submit' type='image' src='install/template/images/next_".button_case().".png' alt='{$install_lang['next']}' /></div>".
            "</form>";
        } else $content .= warning($msg, true);
        
    } else $content = warning($install_lang['noyeslicense'], true);
    return array('content' => $content, 'title' => $install_lang['step4_title']);
}

function step5(){
global $install_lang, $db, $database, $config;
    if(isset($_SESSION['apply']) AND $_SESSION['apply']==true){
        $content = "";
        $database = array(
            'host'                => $_POST['host'],
            'user'                => $_POST['user'],
            'password'            => $_POST['password'],
            'name'                => $_POST['name'],
            'prefix'              => $_POST['prefix'],
            'type'                => $_POST['type'],
            'charset'             => $_POST['db_charset'],
            'cache'               => '',
            'sql_cache_clear'     => 'INSERT,UPDATE,DELETE',
            'no_cache_tables'     => 'sessions'
        );
        if(kr_file_exists("includes/classes/{$_POST['type']}.class.php")) require_once "includes/classes/{$_POST['type']}.class.php";
        $msg = (!$db->db_connect_id) ? $install_lang['connect_error'] : "";
        if(empty($msg)){
            require_once "includes/function/sources.php";
            $POST = array(
                'http_home_url'    => "http://".str_replace('www.', '', get_host_name())."/",
                'rewrite'          => '',
                'admin_mail'       => 'admin@'.str_replace('www.', '', get_host_name()),
                'contact_mail'     => 'support@'.str_replace('www.', '', get_host_name()),
                'sends_mail'       => 'info@'.str_replace('www.', '', get_host_name()),
                'install_date'     => gmdate("Y-m-d"),
                'user_cookies'     => preg_replace('/[\-\.]*/', '', str_replace('www.', '', get_host_name()))."_user",
                'admin_cookies'    => preg_replace('/[\-\.]*/', '', str_replace('www.', '', get_host_name()))."_user",
            );
            foreach($POST as $key => $value) $_POST[$key] = $value;
            save_config('configdb.php', '$database', $database);
            save_config('config.php', '$config', $config);
            $content = "<form action='install.php?do=step6' method='post'>".in_hide('type', $_POST['type']).
            "<table width='100%' class='form'>".
            "<tr class='row_tr'><td class='form_text2'>{$install_lang['admin']}</td><td class='form_input2'>".in_text("admin", 'input_text2', 'Admin')."</td></tr>".
            "<tr class='row_tr'><td class='form_text2'>{$install_lang['email']}</td><td class='form_input2'>".in_text("email", 'input_text2', 'admin@'.str_replace('www.', '', get_host_name()))."</td></tr>".
            "<tr class='row_tr'><td class='form_text2'>{$install_lang['passwordadmin']}</td><td class='form_input2'>".in_pass("password", 'input_text2')."</td></tr>".
            "<tr class='row_tr'><td class='form_text2'>{$install_lang['repasswordadmin']}</td><td class='form_input2'>".in_pass("repassword", 'input_text2')."</td></tr>".
            "</table><br /><br /><div align='right'><input class='submit' type='image' src='install/template/images/install_".button_case().".png' alt='Install' /></div>".
            "</form>";
        } else {
            $step = step4($msg);
            $content .= $step['content'];
        }
    } else $content = warning($install_lang['noyeslicense'], true);
    return array('content' => $content, 'title' => $install_lang['step5_title']);
}

function step6(){
global $db, $install_lang, $database, $adminfile, $license_sys, $version_sys;
    if(isset($_SESSION['apply']) AND $_SESSION['apply']==true){
        $content = "";
        if(kr_file_exists("includes/classes/{$_POST['type']}.class.php")) require_once "includes/classes/{$_POST['type']}.class.php";
        $readdump = fopen("install/sql/install.sql", "rb");
        $stringdump = fread($readdump, kr_filesize("install/sql/install.sql"));
        fclose($readdump);
        $_stringdump = explode(";\r\n", $stringdump);
        if(count($_stringdump)<5) $_stringdump = explode(";\n", $stringdump);
        $stringdump = $_stringdump;
        $dump_count = count($stringdump);
        $row = "row4";
        for ($i = 0; $i < $dump_count; $i++) {
            if(trim($stringdump[$i])=='') continue;
            $string = str_replace("{PREFIX}", $database['prefix'], $stringdump[$i]);
            $string = str_replace("{USER}", $_POST['admin'], $string);
            $string = str_replace("{DATE}", kr_date("Y-m-d"), $string);
            $string = str_replace("{DATETIME}", kr_date("Y-m-d H:i:s"), $string);
            $string = str_replace("{CHARSET}", $database['charset'], $string);
            $id = $db->sql_query($string);
            if(preg_match("/CREATE/", $string)){
                $table = explode("`", $string);
                $content .= "<tr class='{$row}'><td width='50%'>{$table[1]}</td>".(($id) ? "<td align='center'><font color='green'><b>{$install_lang['yes']}</b></font></td>" : "<td align='center'><font color='red'><b>{$install_lang['no']}</b></font></td>")."</tr>";
                $row = ($row=='row4') ? 'row5' : 'row4';
            }
        }
        sql_insert(array(
            'user_id'        => cyr2lat($_POST['admin']),
            'user_name'      => $_POST['admin'],
            'user_email'     => $_POST['email'],
            'user_password'  => pass_crypt($_POST['password']),
            'user_group'     => '1',
            'user_avatar'    => 'admin.png',
            'user_website'   => "http://".get_host_name()."/",
            'user_regdate'   => kr_date("Y-m-d H:i:s"),
            'user_level'     => '2'
        ), USERS);
        $content = "<table class='table' width='100%'><tr><th>{$install_lang['table']}</th><th>{$install_lang['status']}</th></tr>{$content}</table><br /><br /><div align='right'><a href='{$adminfile}'><input onclick=\"location.href='{$adminfile}';\" class='submit' type='image' src='install/template/images/next_".button_case().".png' alt='{$install_lang['next']}' /></a></div>";
    } else $content = warning($install_lang['noyeslicense'], true);
    return array('content' => $content, 'title' => $install_lang['step6_title']);
}

$install = array('content' => '', 'title' => '');
if(isset($_GET['do'])){
    switch($_GET['do']){
        case "step2" : $install = step2(); break;
        case "step3" : $install = step3(); break;
        case "step4" : $install = step4(); break;
        case "step5" : $install = step5(); break;
        case "step6" : $install = step6(); break;
        default: $install = step1(); break;
    }
} else $install = step1();

add_meta_value($install['title']);
$template->set_tpl('$language', "<a href='install.php?lang=russian'>".(($language_install=='russian')?"<b>{$install_lang['russian']}</b>":$install_lang['russian'])."</a> | <a href='install.php?lang=english'>".(($language_install=='english')?"<b>{$install_lang['english']}</b>":$install_lang['english'])."</a>");
$template->set_tpl('$content', $install['content']);
$template->set_tpl('$install_title', $install['title']);

$contents = $template->tpl_create(true);
require_once "includes/nocache.php";
gz($contents);
?>