CREATE TABLE `{PREFIX}_acc` (
  `uid` int(11) NOT NULL default '0',
  `id` int(11) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_attach` (
  `id` int(11) NOT NULL auto_increment,
  `module` varchar(50) default NULL,
  `path` varchar(255) default NULL,
  `file` varchar(100) default NULL,
  `downloads` int(11) NOT NULL default '0',
  `user_id` int(11) NOT NULL default '0',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_audio` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(100) default NULL,
  `name` varchar(100) default NULL,
  `performers` varchar(255) default NULL,
  `author` varchar(50) default NULL,
  `description` varchar(255) default NULL,
  `cid` varchar(255) default NULL,
  `file` varchar(150) default NULL,
  `status` int(1) NOT NULL default '0',
  `comment` int(11) NOT NULL default '0',
  `show_comment` int(1) NOT NULL default '1',
  `rating` float(5,2) NOT NULL default '0.00',
  `voted` int(11) NOT NULL default '0',
  `tags` varchar(100) NOT NULL default '',
  `downloads` int(11) NOT NULL default '0',
  `playing` int(11) NOT NULL default '0',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `filesize` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_audio_authors` (
  `id` int(11) NOT NULL auto_increment,
  `author` varchar(255) default NULL,
  `biography` text default NULL,
  `photo` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_blocks` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(50) NOT NULL,
  `position` char(1) NOT NULL default 'l',
  `view` int(1) NOT NULL default '1',
  `active` int(1) NOT NULL default '1',
  `blockfile` varchar(255) NOT NULL default '',
  `modules` text default NULL,
  `weight` int(11) NOT NULL default '0',
  `content` text default NULL,
  `language` varchar(50) default NULL,
  PRIMARY KEY  (`id`),
  KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

INSERT INTO `{PREFIX}_blocks` VALUES
(1, '', 'l', 1, 1, 'block-modules.php', '', 1, '', ''),
(2, '', 'l', 4, 1, 'block-monitoring.php', '', 2, '', ''),
(3, '', 'r', 1, 1, 'block-calendar.php', '', 2, '', ''),
(4, ' ', 'r', 1, 1, 'block-user_menu.php', '', 1, '', ''),
(5, '', 'r', 1, 1, 'block-last_voting.php', '', 3, '', '');


CREATE TABLE `{PREFIX}_calendar` (
  `cid` int(11) NOT NULL auto_increment,
  `id` int(11) NOT NULL default '0',
  `module` varchar(50) NOT NULL default '',
  `date` date NOT NULL default '0000-00-00',
  `status` int(1) NOT NULL default '0',
  PRIMARY KEY  (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

INSERT INTO `{PREFIX}_calendar` VALUES
(27, 1, 'news', '{DATE}', 1),
(26, 2, 'news', '{DATE}', 1),
(25, 3, 'news', '{DATE}', 1);

CREATE TABLE `{PREFIX}_categories` (
  `cid` int(11) NOT NULL auto_increment,
  `cat_id` varchar(50) default NULL,
  `title` varchar(100) NOT NULL default '',
  `module` varchar(255) NOT NULL default '',
  `description` text default NULL,
  `image` varchar(255) NOT NULL default '',
  `tree` varchar(60) NOT NULL,
  PRIMARY KEY  (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_comment` (
  `cid` int(11) NOT NULL auto_increment,
  `modul` varchar(60) NOT NULL default '',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `name` varchar(60) NOT NULL default '',
  `ip` varchar(16) NOT NULL default '0.0.0.0',
  `comment` text NOT NULL,
  `parentid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_content` (
  `cid` int(11) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `text` text NOT NULL,
  `hits` int(11) NOT NULL default '0',
  `language` varchar(50) NOT NULL default '',
  `status` int(1) NOT NULL default '0',
  PRIMARY KEY  (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_faq` (
  `id` int(11) NOT NULL auto_increment,
  `question` text NOT NULL,
  `answer` text NOT NULL,
  `cid` varchar(255) NOT NULL default '',
  `status` int(1) NOT NULL default '0',
  `language` varchar(25) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_favorite` (
  `id` int(11) NOT NULL auto_increment,
  `post` int(11) NOT NULL,
  `users` varchar(50) NOT NULL default '',
  `modul` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_files` (
  `id` int(11) NOT NULL auto_increment,
  `files_id` varchar(100) default NULL,
  `title` varchar(100) default NULL,
  `description` text default NULL,
  `content` text default NULL,
  `author` varchar(25) default NULL,
  `email` varchar(50) default NULL,
  `url` varchar(255) NOT NULL default '',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `filesize` varchar(15) NOT NULL default '',
  `version` varchar(15) NOT NULL default '',
  `homepage` varchar(100) NOT NULL default '',
  `hits` int(11) NOT NULL default '0',
  `view` int(11) default '0',
  `comment` int(11) NOT NULL default '0',
  `cid` varchar(255) NOT NULL default '',
  `language` varchar(25) default '',
  `show_comment` int(1) NOT NULL default '1',
  `show_group` varchar(255) default '',
  `status` int(1) NOT NULL default '0',
  `rating` float(5,2) NOT NULL default '0.00',
  `voted` int(11) NOT NULL default '0',
  `tags` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_forum_categories` (
  `cat_id` mediumint(8) unsigned NOT NULL auto_increment,
  `cat_title` varchar(100) default NULL,
  `cat_sort` int(8) NOT NULL default '0',
  PRIMARY KEY  (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_forum_forums` (
  `forum_id` int(5) NOT NULL auto_increment,
  `cat_id` mediumint(8) unsigned NOT NULL default '0',
  `forum_name` varchar(150) default NULL,
  `forum_desc` text default NULL,
  `forum_status` tinyint(4) NOT NULL default '0',
  `forum_posts` mediumint(8) unsigned NOT NULL default '0',
  `forum_topics` mediumint(8) unsigned NOT NULL default '0',
  `forum_last_post_id` mediumint(8) unsigned NOT NULL default '0',
  `acc_view` int(1) NOT NULL default '0',
  `acc_write` int(1) NOT NULL default '0',
  `acc_post` int(1) NOT NULL default '0',
  `acc_edit` int(1) NOT NULL default '2',
  `acc_delete` int(1) NOT NULL default '2',
  `pos` int(11) NOT NULL default '0',
  PRIMARY KEY  (`forum_id`),
  KEY `cat_id` (`cat_id`),
  KEY `forum_last_post_id` (`forum_last_post_id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_forum_posts` (
  `post_id` mediumint(8) unsigned NOT NULL auto_increment,
  `topic_id` mediumint(8) unsigned NOT NULL default '0',
  `forum_id` smallint(5) unsigned NOT NULL default '0',
  `poster_id` mediumint(8) NOT NULL default '0',
  `post_time` int(11) NOT NULL default '0',
  `poster_ip` varchar(15) default NULL,
  `post_edit_time` int(11) default NULL,
  `post_subject` varchar(150) default NULL,
  `post_text` text default NULL,
  `poster_name` varchar(50) default NULL,
  `ico` varchar(50) default NULL,
  `post_tnx` text  default NULL,
  PRIMARY KEY  (`post_id`),
  KEY `forum_id` (`forum_id`),
  KEY `topic_id` (`topic_id`),
  KEY `poster_id` (`poster_id`),
  KEY `post_time` (`post_time`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_forum_search` (
  `id` int(11) NOT NULL auto_increment,
  `key` varchar(32) default NULL,
  `topic_id` int(11) NOT NULL default '0',
  `time` varchar(16) default NULL,
  `keywords` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_forum_search_keys` (
  `id` int(11) NOT NULL auto_increment,
  `key` varchar(32) default NULL,
  `query` text default NULL,
  `ignore` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_forum_topics` (
  `topic_id` mediumint(8) unsigned NOT NULL auto_increment,
  `forum_id` smallint(8) unsigned NOT NULL default '0',
  `topic_title` varchar(60) NOT NULL default '',
  `topic_desc` varchar(255) NOT NULL default '',
  `topic_poster` mediumint(8) NOT NULL default '0',
  `topic_time` int(11) NOT NULL default '0',
  `topic_views` mediumint(8) unsigned NOT NULL default '0',
  `topic_replies` mediumint(8) unsigned NOT NULL default '0',
  `topic_status` tinyint(3) NOT NULL default '0',
  `topic_type` int(1) default '0',
  `topic_first_post_id` mediumint(8) unsigned NOT NULL default '0',
  `topic_last_post_id` mediumint(8) unsigned NOT NULL default '0',
  `topic_poster_name` varchar(50) NOT NULL default '',
  `ico` varchar(20) default NULL,
  PRIMARY KEY  (`topic_id`),
  KEY `forum_id` (`forum_id`),
  KEY `topic_status` (`topic_status`),
  KEY `topic_type` (`topic_type`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_groups` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `description` text default NULL,
  `special` int(1) NOT NULL default '0',
  `color` varchar(7) NOT NULL default '',
  `points` int(11) NOT NULL default '0',
  `img` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

INSERT INTO `{PREFIX}_groups` VALUES
(1, '', ' ', 1, 'dd0000', 0, 'admin.png'),
(2, '', ' ', 1, '2ba94f', 0, 'moderators.png'),
(3, ' ', '  ()', 1, '000000', 0, ''),
(4, '', ' ', 1, '660000', 0, 'guestspng.png'),
(5, '', ' ', 0, '0066cc', 5, 'users.png');

CREATE TABLE `{PREFIX}_internet_radio` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(20) NOT NULL default '',
  `radio_id` varchar(50) NOT NULL,
  `description` text default NULL,
  `country` varchar(100) default NULL,
  `stream` varchar(255) NOT NULL default '',
  `img` varchar(255) NOT NULL default '',
  `show_comment` int(1) NOT NULL default '1',
  `comment` int(11) NOT NULL default '0',
  `status` int(1) NOT NULL default '0',
  `language` varchar(30) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_jokes` (
  `id` int(11) NOT NULL auto_increment,
  `author` varchar(25) default '',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `title` varchar(100) default '',
  `cid` varchar(255) NOT NULL default '',
  `joke` text default NULL,
  `status` int(1) NOT NULL default '0',
  `rating` float(5,2) NOT NULL default '0.00',
  `voted` int(11) NOT NULL default '0',
  `language` varchar(25) default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_media` (
  `id` int(11) NOT NULL auto_increment,
  `media_id` varchar(100) default NULL,
  `cid` varchar(255) NOT NULL default '',
  `title` varchar(100) NOT NULL default '',
  `subtitle` varchar(100) default NULL,
  `year` varchar(10) default NULL,
  `director` varchar(100) default NULL,
  `roles` text default NULL,
  `description` text default NULL,
  `createdby` varchar(100) default NULL,
  `duration` varchar(100) default NULL,
  `format` varchar(20) default NULL,
  `quality` varchar(20) default NULL,
  `size` varchar(20) default NULL,
  `lang` varchar(20) default NULL,
  `author` varchar(25) default NULL,
  `placed` varchar(100) default NULL,
  `links` text default NULL,
  `img` varchar(100) default NULL,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `view` int(11) NOT NULL default '0',
  `status` int(1) NOT NULL default '0',
  `show_comment` int(1) NOT NULL default '1',
  `note` text default NULL,
  `rating` float(5,2) NOT NULL default '0.00',
  `voted` int(11) NOT NULL default '0',
  `comment` int(11) NOT NULL default '0',
  `language` varchar(25) default NULL,
  `show_group` int(1) NOT NULL default '1',
  `tags` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `cid` (`cid`),
  KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_menu` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(50) NOT NULL default '',
  `url` varchar(255) NOT NULL default '',
  `groups` varchar(100) default NULL,
  `class` varchar(15) default NULL,
  `pos` int(3) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_message` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(50) default NULL,
  `content` text default NULL,
  `status` int(1) NOT NULL default '0',
  `groups` varchar(255) NOT NULL default '',
  `pos` int(3) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_modules` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(50) default NULL,
  `module` varchar(50) NOT NULL,
  `active` int(1) NOT NULL default '0',
  `view` int(1) NOT NULL default '0',
  `blocks` int(1) NOT NULL default '0',
  `groups` varchar(255) default NULL,
  `pos` int(3) NOT NULL default '0',
  `sitemap` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

INSERT INTO `{PREFIX}_modules` VALUES
(1, '', 'account', 1, 1, 1, '', 1, ''),
(2, '', 'forum', 1, 1, 3, '', 2, ''),
(3, '', 'news', 1, 1, 0, '', 3, ''),
(4, '', 'pages', 1, 1, 0, '', 4, ''),
(5, '', 'files', 1, 1, 0, '', 5, ''),
(6, 'Media', 'media', 1, 1, 0, '', 6, ''),
(7, '', 'jokes', 1, 1, 0, '', 7, ''),
(8, '', 'shop', 1, 1, 0, '', 8, ''),
(9, '', 'search', 1, 1, 0, '', 9, ''),
(10, 'FAQ', 'faq', 1, 1, 0, '', 10, ''),
(11, '', 'voting', 1, 1, 0, '', 11, ''),
(12, '', 'audio', 1, 1, 0, '', 12, ''),
(13, ' ', 'radio', 1, 1, 0, '', 13, ''),
(14, ' ', 'top_site', 1, 1, 1, '', 14, ''),
(15, ' ', 'top_users', 1, 1, 1, '', 15, ''),
(16, '', 'recommend', 1, 1, 0, '', 16, ''),
(17, ' ', 'contact', 1, 1, 0, '', 17, '');

CREATE TABLE `{PREFIX}_news` (
  `id` int(11) NOT NULL auto_increment,
  `news_id` varchar(255) default NULL,
  `title` varchar(100) default NULL,
  `begin` text default NULL,
  `content` text default NULL,
  `author` varchar(25) default NULL,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `view` int(11) NOT NULL default '0',
  `comment` int(11) NOT NULL default '0',
  `cid` varchar(255) NOT NULL default '',
  `language` varchar(25) default '',
  `show_comment` int(1) NOT NULL default '1',
  `show_group` varchar(255) NOT NULL,
  `status` int(1) NOT NULL default '0',
  `rating` float(5,2) NOT NULL default '0.00',
  `voted` int(11) NOT NULL default '0',
  `tags` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

INSERT INTO `{PREFIX}_news` VALUES
(2, 'centroarts', '     ', '<div align=\'center\'><img src=\'uploads/images/centroarts.jpg\' border=\'0\' alt=\'uploads/centroarts.png\' title=\'uploads/centroarts.jpg\' /></div>\r\n Centroarts -        .   Centroarts         ,  ,   . ,           Centroarts.', '<div align=\'center\'><img src=\'uploads/images/centroarts.jpg\' border=\'0\' alt=\'uploads/centroarts.png\' title=\'uploads/centroarts.jpg\' /></div>\r\n Centroarts -        .   Centroarts         ,  ,   . ,           Centroarts.\r\n\r\n<a href=\'engine.php?do=redirect&url=http://www.centroarts.com/\' target=\'_blank\' title=\' \'> </a>', '{USER}', '{DATETIME}', 0, 0, '', '', 0, '', 1, '0.00', 0, ''),
(1, 'kassel4russian', '-  Kassel4Russian', '<div align=\'center\'><img src=\'uploads/images/kassel4russian.jpg\' border=\'0\' alt=\'uploads/images/kassel4russian.png\' title=\'uploads/images/kassel4russian.png\' /></div><br />\r\n-  Kassel4Russian    2005 .            -.     <a href=\'engine.php?do=redirect&amp;url=http://www.kassel4russian.info\' target=\'_blank\' title=\'www.kassel4russian.info\'>www.kassel4russian.info</a>            . <br />\r\n<br />\r\n      , , ,     (      ).     -  ,     .    ,  .        .        ,    5000  IP  .', '<div align=\'center\'><img src=\'uploads/images/kassel4russian.jpg\' border=\'0\' alt=\'uploads/images/kassel4russian.jpg\' title=\'uploads/images/kassel4russian.jpg\' /></div><br />\r\n-  Kassel4Russian    2005 .            -.     <a href=\'engine.php?do=redirect&amp;url=http://www.kassel4russian.info\' target=\'_blank\' title=\'www.kassel4russian.info\'>www.kassel4russian.info</a>             . <br />\r\n<br />\r\n      , , ,     (      ).     -  ,     .    ,  .        .        ,    5000  IP  .<br />\r\n<br />\r\n<a href=\'engine.php?do=redirect&amp;url=http://www.kassel4russian.info\' target=\'_blank\' title=\' \'> </a>', '{USER}', '{DATETIME}', 0, 0, '', '', 0, '', 1, '0.00', 0, ''),
(3, 'netlevel', 'NetLevel -    ', '<div align=\'center\'><img src=\'uploads/images/netlevel_logo.png\' align=\'middle\' border=\'0\' alt=\'NetLevel\' title=\'NetLevel\' /></div><br />\r\nNetLevel.ru       Kasseler CMS.   ,         ,       .    NetLevel :', '<div align=\'center\'><img src=\'uploads/images/netlevel_logo.png\' align=\'middle\' border=\'0\' alt=\'NetLevel\' title=\'NetLevel\' /></div><br />\r\nNetLevel.ru       Kasseler CMS.   ,         ,       .    NetLevel :<br />\r\n<br />\r\n    *    Kasseler CMS   <br />\r\n    *       Kasseler CMS<br />\r\n    *  ,   <br />\r\n    *   24/7/365<br />\r\n    *   <br />\r\n<br />\r\n<br />\r\n       .<br />\r\n<br />\r\n<b></b>:<br />\r\n<br />\r\n<i><b>1.    </b></i><br />\r\n   ,          .                 nginx,   CPanel        CMS-.<br />\r\n<a href=\'engine.php?do=redirect&amp;url=http://www.netlevel.ru/hosting\' target=\'_blank\' title=\'   \'>   </a><br />\r\n<a href=\'engine.php?do=redirect&amp;url=http://www.netlevel.ru/domains\' target=\'_blank\' title=\'   \'>   </a><br />\r\n<br />\r\n<br />\r\n<i><b>2.    </b></i><br />\r\n (VPS)    -     ,        .        ,           root-            . <br />\r\n<a href=\'engine.php?do=redirect&amp;url=http://www.netlevel.ru/vps-servers\' target=\'_blank\' title=\'    (VPS/VDS)\'>    (VPS/VDS)</a><br />\r\n<a href=\'engine.php?do=redirect&amp;url=http://www.netlevel.ru/dedicated-servers\' target=\'_blank\' title=\'   \'>   </a><br />\r\n<br />\r\n<i><b>3.   </b></i><br />\r\n     ,   ,  .     .            .  -        DDoS ,    ,       ..  ()                 .  -           ,     ..            .<br />\r\n<a href=\'engine.php?do=redirect&amp;url=http://www.netlevel.ru/administration/permanent\' target=\'_blank\' title=\'   \'>   </a><br />\r\n<a href=\'engine.php?do=redirect&amp;url=http://www.netlevel.ru/administration/one-time\' target=\'_blank\' title=\' \'> </a><br />\r\n<br />\r\n          ,            .<br />\r\n<a href=\'engine.php?do=redirect&amp;url=http://www.netlevel.ru/\' target=\'_blank\' title=\'\'></a>', '{USER}', '{DATETIME}', 0, 0, '', '', 0, '', 1, '0.00', 0, '');

CREATE TABLE `{PREFIX}_pages` (
  `id` int(11) NOT NULL auto_increment,
  `pages_id` varchar(255) default NULL,
  `title` varchar(100) default NULL,
  `begin` text default NULL,
  `content` text default NULL,
  `author` varchar(25) default NULL,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `view` int(11) NOT NULL default '0',
  `comment` int(11) NOT NULL default '0',
  `cid` varchar(255) NOT NULL default '',
  `status` int(1) NOT NULL default '0',
  `language` varchar(25) default '',
  `show_comment` int(1) NOT NULL default '1',
  `show_group` varchar(255) NOT NULL,
  `rating` float(5,2) NOT NULL default '0.00',
  `voted` int(11) NOT NULL default '0',
  `tags` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_pm` (
  `mid` int(11) unsigned NOT NULL auto_increment,
  `tid` int(11) NOT NULL default '0',
  `subj` varchar(255) NOT NULL default '',
  `user` varchar(50) NOT NULL default '',
  `user_from` varchar(50) NOT NULL default '',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `pm_read` int(1) NOT NULL default '0',
  `status` int(1) NOT NULL default '0',
  `type` int(1) NOT NULL default '0',
  PRIMARY KEY  (`mid`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_pm_text` (
  `tid` int(11) NOT NULL auto_increment,
  `text` text NOT NULL,
  PRIMARY KEY  (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_robot` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default '',
  `visit` datetime NOT NULL default '0000-00-00 00:00:00',
  `country` varchar(50) NOT NULL default 'default',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_search` (
  `id` int(11) NOT NULL auto_increment,
  `key` varchar(32) default NULL,
  `title` varchar(150) default NULL,
  `author` varchar(50) default NULL,
  `content` text default NULL,
  `date` datetime NOT NULL COMMENT '0000-00-00 00:00:00',
  `module` varchar(25) default NULL,
  `subid` int(11) NOT NULL default '0',
  `rewrite_id` varchar(50) default NULL,
  `time` varchar(16) default NULL,
  `keywords` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_search_keys` (
  `id` int(11) NOT NULL auto_increment,
  `key` varchar(32) default NULL,
  `query` text default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_sessions` (
  `sid` varchar(100) NOT NULL default '',
  `uname` varchar(25) default NULL,
  `is_admin` int(1) NOT NULL default '0',
  `ip` varchar(15) default NULL,
  `time` varchar(14) NOT NULL default '0',
  `module` varchar(20) default NULL,
  `url` varchar(255) default NULL,
  `user_agent` varchar(255) default NULL,
  `country` varchar(50) NOT NULL default 'default',
  PRIMARY KEY  (`sid`),
  UNIQUE KEY `uname` (`uname`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_shop` (
  `id` int(11) NOT NULL auto_increment,
  `shop_id` varchar(100) default NULL,
  `title` varchar(100) default NULL,
  `author` varchar(25) default NULL,
  `description` text default NULL,
  `content` text default NULL,
  `pay` float(11,2) NOT NULL default '0.00',
  `img` varchar(255) default NULL,
  `cid` varchar(255) NOT NULL default '',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `clients` int(11) NOT NULL default '0',
  `view` int(11) NOT NULL default '0',
  `comment` int(11) NOT NULL default '0',
  `status` int(1) NOT NULL default '0',
  `show_comment` int(1) NOT NULL default '1',
  `language` varchar(25) default '',
  `rating` float(5,2) NOT NULL default '0.00',
  `voted` int(11) NOT NULL default '0',
  `advanced` text default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_shop_clients` (
  `sid` int(11) NOT NULL auto_increment,
  `date` date NOT NULL default '0000-00-00',
  `form` text NOT NULL,
  `pay` float(11,2) NOT NULL default '0.00',
  `comment` text default NULL,
  `unique_id` varchar(30) default NULL,
  `status` int(1) default '0',
  `user` int(11) default '-1',
  PRIMARY KEY  (`sid`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_tags` (
  `id` int(11) NOT NULL auto_increment,
  `post` int(11) NOT NULL,
  `tag` varchar(100) NOT NULL default '',
  `modul` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_topsites` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(100) default NULL,
  `link` varchar(50) default NULL,
  `mail` varchar(255) NOT NULL default '',
  `img` varchar(50) default NULL,
  `description` text default NULL,
  `date` date NOT NULL default '0000-00-00',
  `hits_out` int(11) NOT NULL default '0',
  `hits_in` int(11) NOT NULL default '0',
  `hosts` longtext default NULL,
  `status` int(1) NOT NULL default '0',
  `rating` float(5,2) NOT NULL default '0.00',
  `voted` int(11) NOT NULL default '0',
  `language` varchar(25) default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

CREATE TABLE `{PREFIX}_users` (
  `uid` int(11) NOT NULL auto_increment,
  `user_id` varchar(50) NOT NULL default '',
  `user_name` varchar(25) NOT NULL default '',
  `user_email` varchar(255) default NULL,
  `user_website` varchar(255) NOT NULL default 'http://',
  `user_avatar` varchar(100) NOT NULL default 'default.png',
  `user_regdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `user_country` varchar(50) NOT NULL default 'default',
  `user_level` int(1) NOT NULL default '0',
  `user_icq` varchar(15) default NULL,
  `user_aim` varchar(18) default NULL,
  `user_yim` varchar(25) default NULL,
  `user_msnm` varchar(25) default NULL,
  `user_password` varchar(40) NOT NULL,
  `user_group` int(11) NOT NULL default '0',
  `user_groups` varchar(255) default NULL,
  `user_last_ip` varchar(15) NOT NULL default '0.0.0.0',
  `user_last_proxy` varchar(15) NOT NULL default 'N/A',
  `user_last_visit` datetime NOT NULL default '0000-00-00 00:00:00',
  `user_last_os` varchar(100) NOT NULL default 'N/A',
  `user_last_browser` varchar(100) NOT NULL default 'N/A',
  `user_birthday` date NOT NULL default '0000-00-00',
  `user_gender` int(1) NOT NULL default '0',
  `user_language` varchar(50) default NULL,
  `user_template` varchar(50) default NULL,
  `user_locality` varchar(100) default NULL,
  `user_signature` text default NULL,
  `user_interests` varchar(100) default NULL,
  `user_occupation` varchar(100) default NULL,
  `user_viewemail` int(1) NOT NULL default '0',
  `user_comments` int(5) NOT NULL default '0',
  `user_points` int(11) NOT NULL default '0',
  `user_posts` int(11) NOT NULL default '0',
  `user_timeout` int(11) NOT NULL default '0',
  `user_tnx` int(11) NOT NULL default '0',
  `user_baned` int(1) NOT NULL default '0',
  `user_baned_time` int(11) NOT NULL default '0',
  `user_baned_reason` varchar(100) default NULL,
  `user_activation` int(1) NOT NULL default '0',
  `user_activation_code` varchar(25) default NULL,
  `user_moderation` int(1) NOT NULL default '1',
  `user_password_update` int(11) NOT NULL default '0',
  `user_gmt` int(2) NOT NULL default '0',
  `rating` float(5,2) NOT NULL default '0.00',
  `voted` int(11) NOT NULL default '0',
  `user_pm_send` int(1) NOT NULL default '1',
  `user_adm_modules` tinytext default NULL,
  PRIMARY KEY  (`uid`),
  UNIQUE KEY `uname` (`user_name`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

INSERT INTO `{PREFIX}_users` VALUES
(-1, 'guest', 'Guest', '', '', 'default.png', '0000-00-00 00:00:00', 'default', 0, '', '', '', '', '', 5, '', '0', '', '0000-00-00 00:00:00', '', '', '0000-00-00', 0, '', '', '', '', '', '', 0, -1, 0, 0, 0, 0, 0, 0, '', 0, 'MBzx97cQMjKQ47tJgil9PBQDr', 1, 0, 0, '0.00', 0, 1, NULL);

CREATE TABLE `{PREFIX}_voting` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `vote_case` text NOT NULL,
  `vote_ip` text default NULL,
  `vote_users` text default NULL,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `result` text default NULL,
  `comment` int(11) NOT NULL default '0',
  `status` int(1) NOT NULL default '0',
  `language` varchar(25) default NULL,
  `show_comment` int(1) NOT NULL default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET={CHARSET};

INSERT INTO `{PREFIX}_voting` VALUES
(1, '    ?', '| ||  || |  |', '', '', '{DATETIME}', '', 0, 1, '', 1);