/*drop tables*/
DROP TABLE IF EXISTS `kasseler_attached`;
DROP TABLE IF EXISTS `kasseler_search`;
DROP TABLE IF EXISTS `kasseler_search_result`;
DROP TABLE IF EXISTS `kasseler_modules`;
DROP TABLE IF EXISTS `kasseler_users_tmp`;
DROP TABLE IF EXISTS `kasseler_content`;

ALTER TABLE kasseler_groups CHANGE gid id int(11) auto_increment;

/*comments*/
ALTER TABLE kasseler_comment MODIFY date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL;
ALTER TABLE kasseler_comment MODIFY ip varchar(16) DEFAULT '0.0.0.0' NOT NULL;

/*users modify*/
ALTER TABLE kasseler_users CHANGE language user_language varchar(50) DEFAULT '';
ALTER TABLE kasseler_users CHANGE template user_template varchar(50) DEFAULT NULL;
ALTER TABLE kasseler_users CHANGE locality user_locality varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_users CHANGE signature user_signature text DEFAULT NULL;
ALTER TABLE kasseler_users CHANGE interests user_interests varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_users CHANGE occupation user_occupation varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_users CHANGE viewemail user_viewemail int(1) NOT NULL DEFAULT '0';
ALTER TABLE kasseler_users CHANGE comment user_comments int(5) NOT NULL DEFAULT '0';
ALTER TABLE kasseler_users CHANGE points user_points int(11) NOT NULL DEFAULT '0';
ALTER TABLE kasseler_users CHANGE posts user_posts int(11) NOT NULL DEFAULT '0';
ALTER TABLE kasseler_users CHANGE timeout user_timeout int(11) NOT NULL;
ALTER TABLE kasseler_users ADD user_pm_send int(1) DEFAULT '1' NOT NULL;
ALTER TABLE kasseler_users ADD user_baned int(1) DEFAULT '0' NOT NULL;
ALTER TABLE kasseler_users ADD user_baned_time int(11) DEFAULT '0' NOT NULL;
ALTER TABLE kasseler_users ADD user_baned_reason varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_users ADD user_activation int(1) DEFAULT '0' NOT NULL;
ALTER TABLE kasseler_users ADD user_activation_code varchar(25) DEFAULT NULL;
ALTER TABLE kasseler_users ADD user_moderation int(1) DEFAULT '1' NOT NULL;
ALTER TABLE kasseler_users ADD user_id varchar(50) DEFAULT NULL;
ALTER TABLE kasseler_users ADD user_password_update int(11) DEFAULT '0' NOT NULL;
ALTER TABLE kasseler_users ADD user_gmt int(2) DEFAULT '0' NOT NULL;
ALTER TABLE kasseler_users ADD user_country varchar(50) DEFAULT 'default' NOT NULL;
ALTER TABLE kasseler_users ADD user_groups varchar(255) DEFAULT '' NOT NULL;
ALTER TABLE kasseler_users ADD user_adm_modules tinytext DEFAULT NULL; /**/
ALTER TABLE kasseler_users DROP COLUMN activemenu;
ALTER TABLE kasseler_users DROP COLUMN usermenu;
ALTER TABLE kasseler_users DROP COLUMN viewip;
ALTER TABLE kasseler_users DROP COLUMN status;
ALTER TABLE kasseler_users DROP COLUMN modules;
ALTER TABLE kasseler_users MODIFY user_avatar varchar(100) DEFAULT 'default.png' NOT NULL;
ALTER TABLE kasseler_users MODIFY user_gender int(1) NOT NULL DEFAULT '0';
ALTER TABLE kasseler_users MODIFY user_icq varchar(15) DEFAULT NULL;
ALTER TABLE kasseler_users MODIFY user_aim varchar(18) DEFAULT NULL;
ALTER TABLE kasseler_users MODIFY user_yim varchar(25) DEFAULT NULL;
ALTER TABLE kasseler_users MODIFY user_msnm varchar(25) DEFAULT NULL;


/*category*/
ALTER TABLE kasseler_categories ADD cat_id varchar(50) DEFAULT NULL;
ALTER TABLE kasseler_categories ADD tree varchar(60) NOT NULL;
ALTER TABLE kasseler_categories DROP COLUMN subid;

/*session*/
ALTER TABLE kasseler_sessions ADD country varchar(50) DEFAULT 'default' NOT NULL;
ALTER TABLE kasseler_sessions MODIFY sid varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_sessions MODIFY uname varchar(25) DEFAULT NULL;
ALTER TABLE kasseler_sessions MODIFY ip varchar(15) DEFAULT NULL;
ALTER TABLE kasseler_sessions MODIFY time varchar(14) NOT NULL DEFAULT '0';
ALTER TABLE kasseler_sessions MODIFY module varchar(20) DEFAULT NULL;
ALTER TABLE kasseler_sessions MODIFY url varchar(255) DEFAULT NULL;
ALTER TABLE kasseler_sessions MODIFY user_agent varchar(255) DEFAULT NULL;

/*home message*/
ALTER TABLE kasseler_message CHANGE mgid id int(11) auto_increment;
ALTER TABLE kasseler_message CHANGE active status int(1) NOT NULL DEFAULT '0';
ALTER TABLE kasseler_message CHANGE view groups varchar(255) NOT NULL DEFAULT '';
ALTER TABLE kasseler_message CHANGE position pos int(3) NOT NULL DEFAULT '0';
ALTER TABLE kasseler_message MODIFY title varchar(50) DEFAULT NULL;
ALTER TABLE kasseler_message MODIFY content text DEFAULT NULL;

/*blocks*/
ALTER TABLE kasseler_blocks MODIFY modules text DEFAULT NULL;
ALTER TABLE kasseler_blocks MODIFY content text DEFAULT NULL;
ALTER TABLE kasseler_blocks CHANGE bid id int(11) auto_increment;
ALTER TABLE kasseler_blocks ADD language varchar(15) DEFAULT '';

/*Module News*/
ALTER TABLE kasseler_news CHANGE nid id int(11) auto_increment;
ALTER TABLE kasseler_news CHANGE beginning begin text DEFAULT NULL;
ALTER TABLE kasseler_news MODIFY content text DEFAULT NULL;
ALTER TABLE kasseler_news MODIFY title varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_news MODIFY author varchar(25) DEFAULT NULL;
ALTER TABLE kasseler_news MODIFY language varchar(25) DEFAULT '';
ALTER TABLE kasseler_news MODIFY cid varchar(255) NOT NULL DEFAULT '';
ALTER TABLE kasseler_news ADD news_id varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_news ADD show_comment int(1) NOT NULL DEFAULT '1';
ALTER TABLE kasseler_news ADD show_group varchar(255) DEFAULT '';

/*Module Media*/
ALTER TABLE kasseler_media CHANGE mid id int(11) auto_increment;
ALTER TABLE kasseler_media CHANGE hits view int(11) NOT NULL DEFAULT '0';
ALTER TABLE kasseler_media ADD media_id varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_media ADD show_comment int(1) NOT NULL DEFAULT '1';
ALTER TABLE kasseler_media ADD show_group int(1) NOT NULL DEFAULT '1';
ALTER TABLE kasseler_media MODIFY subtitle varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_media MODIFY year varchar(10) DEFAULT NULL;
ALTER TABLE kasseler_media MODIFY director varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_media MODIFY roles text DEFAULT NULL;
ALTER TABLE kasseler_media MODIFY description text DEFAULT NULL;
ALTER TABLE kasseler_media MODIFY createdby varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_media MODIFY duration varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_media MODIFY format varchar(20) DEFAULT NULL;
ALTER TABLE kasseler_media MODIFY quality varchar(20) DEFAULT NULL;
ALTER TABLE kasseler_media MODIFY size varchar(20) DEFAULT NULL;
ALTER TABLE kasseler_media MODIFY lang varchar(20) DEFAULT NULL;
ALTER TABLE kasseler_media MODIFY author varchar(25) DEFAULT NULL;
ALTER TABLE kasseler_media MODIFY placed varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_media MODIFY links text DEFAULT NULL;
ALTER TABLE kasseler_media MODIFY img varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_media MODIFY note text DEFAULT NULL;
ALTER TABLE kasseler_media MODIFY language varchar(25) DEFAULT '';
ALTER TABLE kasseler_media MODIFY cid varchar(255) NOT NULL DEFAULT '';

/*Module Forum*/
ALTER TABLE kasseler_forum_forums ADD pos int(11) NOT NULL default 0;

ALTER TABLE kasseler_forum_topics MODIFY topic_type int(1) DEFAULT 0;
ALTER TABLE kasseler_forum_topics MODIFY ico varchar(20) DEFAULT NULL;

ALTER TABLE kasseler_forum_posts MODIFY post_subject varchar(60) DEFAULT NULL;
ALTER TABLE kasseler_forum_posts MODIFY ico varchar(50) DEFAULT NULL;
ALTER TABLE kasseler_forum_posts MODIFY post_tnx text DEFAULT NULL;

/*Module Files*/
ALTER TABLE kasseler_files CHANGE fid id int(11) auto_increment;
ALTER TABLE kasseler_files CHANGE authormail email varchar(50) DEFAULT NULL;
ALTER TABLE kasseler_files MODIFY title varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_files MODIFY description text DEFAULT NULL;
ALTER TABLE kasseler_files MODIFY author varchar(25) DEFAULT NULL;
ALTER TABLE kasseler_files MODIFY language varchar(25) DEFAULT '';
ALTER TABLE kasseler_files MODIFY cid varchar(255) NOT NULL DEFAULT '';
ALTER TABLE kasseler_files MODIFY filesize varchar(15) NOT NULL DEFAULT '';
ALTER TABLE kasseler_files MODIFY version varchar(15) NOT NULL DEFAULT '';
ALTER TABLE kasseler_files MODIFY homepage varchar(100) NOT NULL DEFAULT '';
ALTER TABLE kasseler_files MODIFY img varchar(255) NOT NULL DEFAULT '';
ALTER TABLE kasseler_files MODIFY url varchar(255) NOT NULL DEFAULT '';
ALTER TABLE kasseler_files ADD files_id varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_files ADD show_comment int(1) NOT NULL DEFAULT '1';
ALTER TABLE kasseler_files ADD show_group varchar(255) DEFAULT '';
ALTER TABLE kasseler_files ADD content text DEFAULT NULL;
ALTER TABLE kasseler_files ADD view int(11) DEFAULT '0';
ALTER TABLE kasseler_files DROP COLUMN ip_author;
ALTER TABLE kasseler_files DROP COLUMN img;

/*Module Shop*/
ALTER TABLE kasseler_shop CHANGE sid id int(11) auto_increment;
ALTER TABLE kasseler_shop CHANGE description content text DEFAULT NULL;
ALTER TABLE kasseler_shop CHANGE preview description text DEFAULT NULL;
ALTER TABLE kasseler_shop CHANGE hits view int(11) NOT NULL DEFAULT '0';  
ALTER TABLE kasseler_shop MODIFY title varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_shop MODIFY author varchar(25) DEFAULT NULL;
ALTER TABLE kasseler_shop MODIFY img varchar(255) DEFAULT NULL;
ALTER TABLE kasseler_shop MODIFY cid varchar(255) NOT NULL DEFAULT '';
ALTER TABLE kasseler_shop MODIFY language varchar(25) DEFAULT '';
ALTER TABLE kasseler_shop ADD shop_id varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_shop ADD show_comment int(1) NOT NULL DEFAULT '1';
ALTER TABLE kasseler_shop ADD comment int(11) NOT NULL DEFAULT '0';
ALTER TABLE kasseler_shop ADD advanced text DEFAULT NULL;
ALTER TABLE kasseler_shop DROP COLUMN email;


ALTER TABLE kasseler_shop_clients ADD comment text DEFAULT NULL;
ALTER TABLE kasseler_shop_clients ADD unique_id varchar(30) DEFAULT NULL;
ALTER TABLE kasseler_shop_clients ADD status int(1) DEFAULT 0;
ALTER TABLE kasseler_shop_clients ADD user int(11) DEFAULT -1;
ALTER TABLE kasseler_shop_clients DROP COLUMN count;


/*FAQ*/
ALTER TABLE kasseler_faq CHANGE fqid id int(11) auto_increment;
ALTER TABLE kasseler_faq MODIFY cid varchar(255) NOT NULL DEFAULT '';
ALTER TABLE kasseler_faq ADD status int(1) NOT NULL DEFAULT '0';
ALTER TABLE kasseler_faq ADD language varchar(25) DEFAULT '';
ALTER TABLE kasseler_faq DROP COLUMN relisername;
ALTER TABLE kasseler_faq DROP COLUMN reliseremail;


/*VOTING*/
ALTER TABLE kasseler_voting CHANGE vid id int(11) auto_increment;
ALTER TABLE kasseler_voting CHANGE pubdate date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL;
ALTER TABLE kasseler_voting CHANGE vote_res result text DEFAULT NULL;
ALTER TABLE kasseler_voting ADD status int(1) NOT NULL DEFAULT '0';
ALTER TABLE kasseler_voting ADD language varchar(25) DEFAULT '';
ALTER TABLE kasseler_voting ADD show_comment int(1) NOT NULL DEFAULT '1';
ALTER TABLE kasseler_voting MODIFY vote_ip text DEFAULT NULL;
ALTER TABLE kasseler_voting MODIFY vote_users text DEFAULT NULL;

/*TOP SITES*/
ALTER TABLE kasseler_topsites CHANGE tid id int(11) auto_increment;
ALTER TABLE kasseler_topsites ADD language varchar(25) DEFAULT '';
ALTER TABLE kasseler_topsites MODIFY title varchar(100) DEFAULT NULL;
ALTER TABLE kasseler_topsites MODIFY link varchar(50) DEFAULT NULL;
ALTER TABLE kasseler_topsites MODIFY img varchar(50) DEFAULT NULL;
ALTER TABLE kasseler_topsites MODIFY description text DEFAULT NULL;
ALTER TABLE kasseler_topsites MODIFY hosts longtext DEFAULT NULL;

/*Module Jokes*/
ALTER TABLE kasseler_jokes CHANGE jid id int(11) auto_increment;
ALTER TABLE kasseler_jokes CHANGE name title varchar(100) DEFAULT '';
ALTER TABLE kasseler_jokes MODIFY author varchar(25) DEFAULT '';
ALTER TABLE kasseler_jokes MODIFY cid varchar(255) NOT NULL DEFAULT '';
ALTER TABLE kasseler_jokes MODIFY joke text DEFAULT NULL;
ALTER TABLE kasseler_jokes MODIFY language varchar(25) DEFAULT '';

/*Calendar*/
ALTER TABLE kasseler_calendar ADD status int(1) DEFAULT '0' NOT NULL;

CREATE TABLE `kasseler_acc` (
  `uid` int(11) NOT NULL default '0',
  `id` int(11) NOT NULL default '0'
) ENGINE=MyISAM;

CREATE TABLE `kasseler_menu` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(50) NOT NULL default '',
  `url` varchar(255) NOT NULL default '',
  `groups` varchar(100) default NULL,
  `class` varchar(15) default NULL,
  `pos` int(3) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE `kasseler_modules` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(50) default NULL,
  `module` varchar(50) NOT NULL,
  `active` int(1) NOT NULL default '0',
  `view` int(1) NOT NULL default '0',
  `blocks` int(1) NOT NULL default '0',
  `groups` varchar(255) default NULL,
  `pos` int(3) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE `kasseler_attach` (
  `id` int(11) NOT NULL auto_increment,
  `module` varchar(50) default NULL,
  `path` varchar(255) default NULL,
  `file` varchar(100) default NULL,
  `downloads` int(11) NOT NULL default '0',
  `user_id` int(11) NOT NULL default '0',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE `kasseler_internet_radio` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `radio_id` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(20) NOT NULL DEFAULT '',
  `description` text DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `stream` varchar(255) NOT NULL DEFAULT '',  
  `img` varchar(255) NOT NULL DEFAULT '',
  `show_comment` int(1) NOT NULL DEFAULT '1',
  `comment` int(11) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '0',
  `language` varchar(30) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM;

CREATE TABLE `kasseler_favorite` (
  `id` int(11) NOT NULL auto_increment,
  `post` int(11) NOT NULL,
  `users` varchar(50) NOT NULL default '',
  `modul` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE `kasseler_robot` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default '',
  `visit` datetime NOT NULL default '0000-00-00 00:00:00',
  `country` varchar(50) NOT NULL default 'default',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE `kasseler_tags` (
  `id` int(11) NOT NULL auto_increment,
  `post` int(11) NOT NULL,
  `tag` varchar(100) NOT NULL default '',
  `modul`  varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE `kasseler_audio_authors` (
  `id` int(11) NOT NULL auto_increment,
  `author` varchar(150) default NULL,
  `biography` text default NULL,
  `photo` varchar(100) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE `kasseler_audio` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(100) default NULL,
  `name` varchar(100) default NULL,
  `performers` varchar(255) default NULL,
  `author` varchar(50) default NULL,
  `description` varchar(255) default NULL,
  `cid` varchar(255) default NULL,
  `file` varchar(150) default NULL,
  `status` int(1) NOT NULL default '0',
  `comment` int(11) NOT NULL default '0',
  `show_comment` int(1) NOT NULL default '1',
  `rating` float(5,2) NOT NULL default '0.00',
  `voted` int(11) NOT NULL default '0',
  `tags` varchar(100) NOT NULL default '',
  `downloads` int(11) NOT NULL default '0',
  `playing` int(11) NOT NULL default '0',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `filesize` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE `kasseler_search` (
  `id` int(11) NOT NULL auto_increment,
  `key` varchar(32) default NULL,
  `title` varchar(150) default NULL,
  `author` varchar(50) default NULL,
  `content` text default NULL,
  `date` datetime NOT NULL COMMENT '0000-00-00 00:00:00',
  `module` varchar(25) default NULL,
  `subid` int(11) NOT NULL default '0',
  `rewrite_id` varchar(50) default NULL,
  `time` varchar(16) default NULL,
  `keywords` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE `kasseler_search_keys` (
  `id` int(11) NOT NULL auto_increment,
  `key` varchar(32) default NULL,
  `query` text default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE `kasseler_forum_search` (
  `id` int(11) NOT NULL auto_increment,
  `key` varchar(32) default NULL,
  `topic_id` int(11) NOT NULL default '0',
  `time` varchar(16) default NULL,
  `keywords` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE `kasseler_forum_search_keys` (
  `id` int(11) NOT NULL auto_increment,
  `key` varchar(32) default NULL,
  `query` text default NULL,
  `ignore` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;


ALTER TABLE kasseler_news  ADD tags varchar(100) DEFAULT '' NOT NULL;
ALTER TABLE kasseler_files ADD tags varchar(100) DEFAULT '' NOT NULL;
ALTER TABLE kasseler_pages ADD tags varchar(100) DEFAULT '' NOT NULL;
ALTER TABLE kasseler_media ADD tags varchar(100) DEFAULT '' NOT NULL;

ALTER TABLE kasseler_modules ADD sitemap varchar(100) DEFAULT '' NOT NULL;
/*Далее приобразование БД запуск пхп скрипта*/