# ========================================================
#
# Database saved : spaiz
# On 08-19-2006 at 21:59
#
# ========================================================


# --------------------------------------------------------
#
# Table structure for table 'spn_admins'
#

CREATE TABLE spn_admins (
   admins_login varchar(255) NOT NULL,
   admins_key_name varchar(255) NOT NULL,
   admins_email varchar(255) NOT NULL,
   admins_password varchar(255) NOT NULL,
   admins_avatar varchar(255) NOT NULL,
   admins_icq varchar(45) NOT NULL,
   admins_from varchar(45) NOT NULL,
   admins_about varchar(255) NOT NULL,
   admins_mail_notify tinyint(1) unsigned DEFAULT '1' NOT NULL,
   admins_comments_count int(11) DEFAULT '0' NOT NULL,
   admins_status VARCHAR(45) NOT NULL,
   KEY admins_key_name (admins_key_name)
);


# --------------------------------------------------------
#
# Table structure for table 'spn_admins_access'
#

CREATE TABLE spn_admins_access (
   admins_access_login char(255) NOT NULL,
   admins_access_mod_name char(255) NOT NULL
);



# --------------------------------------------------------
#
# Table structure for table 'spn_articles'
#

CREATE TABLE spn_articles (
   articles_id int(11) unsigned NOT NULL auto_increment,
   articles_categories_id int(11) unsigned DEFAULT '0' NOT NULL,
   articles_title varchar(255) NOT NULL,
   articles_enabled tinyint(1) unsigned DEFAULT '1' NOT NULL,
   articles_text text NOT NULL,
   articles_date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
   articles_hits int(11) unsigned DEFAULT '0' NOT NULL,
   articles_allow_comments tinyint(1) unsigned DEFAULT '1' NOT NULL,
   articles_comments_counter int(11) unsigned DEFAULT '0' NOT NULL,
   articles_author varchar(255) NOT NULL,
   articles_auto_br tinyint(1) unsigned DEFAULT '1' NOT NULL,
   articles_rate_count int(10) unsigned DEFAULT '0' NOT NULL,
   articles_rate_value int(10) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (articles_id),
   KEY articles_categories_id (articles_categories_id),
   KEY articles_enabled (articles_enabled)
);

# --------------------------------------------------------
#
# Table structure for table 'spn_articles_categories'
#

CREATE TABLE spn_articles_categories (
   articles_categories_id int(11) unsigned NOT NULL auto_increment,
   articles_categories_title varchar(255) NOT NULL,
   articles_categories_description text,
   articles_categories_articles_counter int(11) unsigned DEFAULT '0' NOT NULL,
   articles_categories_parent_id int(11) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (articles_categories_id),
   KEY articles_categories_parent_id (articles_categories_parent_id)
);


# --------------------------------------------------------
#
# Table structure for table 'spn_articles_comments'
#

CREATE TABLE spn_articles_comments (
   articles_comments_id int(11) unsigned NOT NULL auto_increment,
   articles_comments_articles_id int(11) unsigned DEFAULT '0' NOT NULL,
   articles_comments_date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
   articles_comments_admin int(2) unsigned DEFAULT '0' NOT NULL,
   articles_comments_author varchar(255) NOT NULL,
   articles_comments_author_ip varchar(85) NOT NULL,
   articles_comments_text text NOT NULL,
   articles_comments_pid int(10) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (articles_comments_id),
   KEY articles_comments_articles_id (articles_comments_articles_id)
);

# --------------------------------------------------------
#
# Table structure for table 'spn_banned'
#

CREATE TABLE spn_banned (
   banned_id int(11) unsigned NOT NULL auto_increment,
   banned_ip varchar(30) NOT NULL,
   banned_range varchar(200),
   PRIMARY KEY (banned_id),
   KEY banned_ip (banned_ip)
);

#
# Dumping data for table 'spn_banned'
#


# --------------------------------------------------------
#
# Table structure for table 'spn_banners'
#

CREATE TABLE spn_banners (
   banners_id int(11) unsigned NOT NULL auto_increment,
   banners_description varchar(255) NOT NULL,
   banners_content text NOT NULL,
   banners_enabled tinyint(1) unsigned DEFAULT '1' NOT NULL,
   banners_place varchar(5) DEFAULT 'up' NOT NULL,
   PRIMARY KEY (banners_id),
   KEY banners_enabled (banners_enabled),
   KEY banners_place (banners_place)
);

# --------------------------------------------------------
#
# Table structure for table 'spn_blocks'
#

CREATE TABLE spn_blocks (
   blocks_id int(11) unsigned NOT NULL auto_increment,
   blocks_title varchar(255) NOT NULL,
   blocks_text text,
   blocks_enabled tinyint(1) unsigned DEFAULT '1' NOT NULL,
   blocks_file varchar(255) NOT NULL,
   blocks_show_to_users tinyint(1) unsigned DEFAULT '1' NOT NULL,
   blocks_image varchar(255) NOT NULL,
   PRIMARY KEY (blocks_id),
   KEY blocks_enabled (blocks_enabled)
);

#
# Dumping data for table 'spn_blocks'
#

INSERT INTO spn_blocks VALUES ( '1', 'Files', '', '1', 'block-Files.php', '1', '');
INSERT INTO spn_blocks VALUES ( '2', 'Last Articles', '', '1', 'block-Last_Articles.php', '1', '');
INSERT INTO spn_blocks VALUES ( '3', 'Menu', '', '1', 'block-Menu.php', '1', '');
INSERT INTO spn_blocks VALUES ( '4', 'Random pic', '', '1', 'block-Gallery.php', '1', '');
INSERT INTO spn_blocks VALUES ( '5', 'Polls', '', '1', 'block-Polls.php', '1', '');
INSERT INTO spn_blocks VALUES ( '6', 'News Topics', '', '1', 'block-News_Topics.php', '1', '');
INSERT INTO spn_blocks VALUES ( '7', 'News Search', '', '1', 'block-News_Search.php', '1', '');
INSERT INTO spn_blocks VALUES ( '8', 'Who is Online', '', '1', 'block-Who_is_Online.php', '1', '');
INSERT INTO spn_blocks VALUES ( '9', 'Calendar', '', '1', 'block-News_Calendar.php', '1', '');
INSERT INTO spn_blocks VALUES ( '10', 'Login', '', '1', 'block-Login.php', '1', '');
INSERT INTO spn_blocks VALUES ( '11', 'Last News', '', '1', 'block-Last_News.php', '1', '');

# --------------------------------------------------------
#
# Table structure for table 'spn_files'
#

CREATE TABLE spn_files (
   files_id int(11) unsigned NOT NULL auto_increment,
   files_cat_id int(11) unsigned DEFAULT '0' NOT NULL,
   files_title varchar(255) NOT NULL,
   files_url varchar(255) NOT NULL,
   files_description text NOT NULL,
   files_date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
   files_author_name varchar(255) NOT NULL,
   files_hits int(11) unsigned DEFAULT '0' NOT NULL,
   files_allow_comments tinyint(1) unsigned DEFAULT '1' NOT NULL,
   files_comments_counter int(11) unsigned DEFAULT '0' NOT NULL,
   files_size int(11) unsigned,
   files_version varchar(255),
   files_homepage varchar(255) NOT NULL,
   files_rate_count int(10) unsigned DEFAULT '0' NOT NULL,
   files_rate_value int(10) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (files_id),
   KEY files_cat_id (files_cat_id)
);


# --------------------------------------------------------
#
# Table structure for table 'spn_files_broken'
#

CREATE TABLE spn_files_broken (
   files_broken_id int(11) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (files_broken_id)
);

#
# Dumping data for table 'spn_files_broken'
#


# --------------------------------------------------------
#
# Table structure for table 'spn_files_categories'
#

CREATE TABLE spn_files_categories (
   files_categories_id int(11) unsigned NOT NULL auto_increment,
   files_categories_title varchar(255) NOT NULL,
   files_categories_description text NOT NULL,
   files_categories_files_counter int(11) unsigned DEFAULT '0' NOT NULL,
   files_categories_parent_id int(11) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (files_categories_id),
   KEY files_categories_title (files_categories_title),
   KEY files_categories_parent_id (files_categories_parent_id)
);


# --------------------------------------------------------
#
# Table structure for table 'spn_files_comments'
#

CREATE TABLE spn_files_comments (
   files_comments_id int(11) NOT NULL auto_increment,
   files_comments_files_id int(11) DEFAULT '0' NOT NULL,
   files_comments_date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
   files_comments_admin int(2) unsigned DEFAULT '0' NOT NULL,
   files_comments_author varchar(255) NOT NULL,
   files_comments_author_ip varchar(85) NOT NULL,
   files_comments_text text NOT NULL,
   files_comments_pid int(10) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (files_comments_id),
   KEY articles_comments_articles_id (files_comments_files_id)
);


# --------------------------------------------------------
#
# Table structure for table 'spn_gal'
#

CREATE TABLE spn_gal (
   gal_id int(11) unsigned NOT NULL auto_increment,
   gal_cat_id int(11) unsigned DEFAULT '0' NOT NULL,
   gal_title varchar(255) NOT NULL,
   gal_url varchar(255) NOT NULL,
   gal_rate_num int(5) unsigned DEFAULT '0' NOT NULL,
   gal_date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
   gal_author_name varchar(255) NOT NULL,
   gal_hits int(11) unsigned DEFAULT '0' NOT NULL,
   gal_main_rate int(10) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (gal_id),
   KEY gal_cat_id (gal_cat_id)
);

# --------------------------------------------------------
#
# Table structure for table 'spn_gal_categories'
#

CREATE TABLE spn_gal_categories (
   gal_categories_id int(11) unsigned NOT NULL auto_increment,
   gal_categories_title varchar(255) NOT NULL,
   gal_categories_description text NOT NULL,
   gal_categories_pics_counter int(11) unsigned DEFAULT '0' NOT NULL,
   gal_categories_parent_id int(11) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (gal_categories_id),
   KEY gal_categories_title (gal_categories_title),
   KEY gal_categories_parent_id (gal_categories_parent_id)
);


# --------------------------------------------------------
#
# Table structure for table 'spn_message'
#

CREATE TABLE spn_message (
   message_id int(11) unsigned NOT NULL auto_increment,
   message_title varchar(255) NOT NULL,
   message_text text NOT NULL,
   message_date varchar(14) NOT NULL,
   message_date_expire int(7) unsigned DEFAULT '0' NOT NULL,
   message_enabled tinyint(1) unsigned DEFAULT '1' NOT NULL,
   message_show_in_mod varchar(255) DEFAULT 'All' NOT NULL,
   PRIMARY KEY (message_id),
   KEY message_enabled (message_enabled),
   KEY message_show_in_mod (message_show_in_mod)
);


# --------------------------------------------------------
#
# Table structure for table 'spn_mods'
#

CREATE TABLE spn_mods (
   mod_id int(11) unsigned NOT NULL auto_increment,
   mod_title varchar(255) NOT NULL,
   mod_custom_title varchar(255) NOT NULL,
   mod_active tinyint(1) unsigned DEFAULT '1' NOT NULL,
   mod_in_block tinyint(1) unsigned DEFAULT '1' NOT NULL,
   mod_show_unreg tinyint(1) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (mod_id),
   UNIQUE mod_title (mod_title),
   KEY mod_active (mod_active),
   KEY mod_in_block (mod_in_block)
);

#
# Dumping data for table 'spn_mods'
#

INSERT INTO spn_mods VALUES ( '1', 'Articles', '', '1', '1', '1');
INSERT INTO spn_mods VALUES ( '2', 'Feedback', 'Feedback', '1', '1', '1');
INSERT INTO spn_mods VALUES ( '3', 'Files', 'Files', '1', '1', '1');
INSERT INTO spn_mods VALUES ( '4', 'News', 'News', '1', '1', '1');
INSERT INTO spn_mods VALUES ( '5', 'Pages', 'Pages', '1', '1', '1');
INSERT INTO spn_mods VALUES ( '6', 'Polls', 'Polls', '1', '1', '1');
INSERT INTO spn_mods VALUES ( '7', 'Top', 'Top', '1', '1', '1');
INSERT INTO spn_mods VALUES ( '8', 'Users', 'Users', '1', '0', '1');
INSERT INTO spn_mods VALUES ( '9', 'News_Calendar', 'News Calendar', '1', '1', '1');
INSERT INTO spn_mods VALUES ( '10', 'Gallery', 'Gallery', '1', '1', '1');
INSERT INTO spn_mods VALUES ( '11', 'Search', 'Search', '1', '1', '1');

# --------------------------------------------------------
#
# Table structure for table 'spn_mods_blocks'
#

CREATE TABLE spn_mods_blocks (
   mod_mod_id int(11) unsigned DEFAULT '0' NOT NULL,
   mod_block_id int(11) unsigned DEFAULT '0' NOT NULL,
   mod_block_place tinyint(1) unsigned DEFAULT '1' NOT NULL,
   mod_block_weight tinyint(11) unsigned DEFAULT '0' NOT NULL,
   KEY blocks_mod_id (mod_mod_id),
   KEY mod_block_place (mod_block_place),
   KEY mod_block_weight (mod_block_weight)
);

#
# Dumping data for table 'spn_mods_blocks'
#

INSERT INTO spn_mods_blocks VALUES ( '1', '10', '0', '1');
INSERT INTO spn_mods_blocks VALUES ( '1', '3', '0', '2');
INSERT INTO spn_mods_blocks VALUES ( '1', '6', '0', '3');
INSERT INTO spn_mods_blocks VALUES ( '1', '4', '0', '4');
INSERT INTO spn_mods_blocks VALUES ( '1', '2', '0', '5');
INSERT INTO spn_mods_blocks VALUES ( '1', '8', '0', '6');
INSERT INTO spn_mods_blocks VALUES ( '1', '1', '1', '5');
INSERT INTO spn_mods_blocks VALUES ( '1', '11', '1', '4');
INSERT INTO spn_mods_blocks VALUES ( '1', '5', '1', '3');
INSERT INTO spn_mods_blocks VALUES ( '1', '9', '1', '2');
INSERT INTO spn_mods_blocks VALUES ( '1', '7', '1', '1');

INSERT INTO spn_mods_blocks VALUES ( '2', '10', '0', '1');
INSERT INTO spn_mods_blocks VALUES ( '2', '3', '0', '2');
INSERT INTO spn_mods_blocks VALUES ( '2', '6', '0', '3');
INSERT INTO spn_mods_blocks VALUES ( '2', '4', '0', '4');
INSERT INTO spn_mods_blocks VALUES ( '2', '2', '0', '5');
INSERT INTO spn_mods_blocks VALUES ( '2', '8', '0', '6');
INSERT INTO spn_mods_blocks VALUES ( '2', '1', '1', '5');
INSERT INTO spn_mods_blocks VALUES ( '2', '11', '1', '4');
INSERT INTO spn_mods_blocks VALUES ( '2', '5', '1', '3');
INSERT INTO spn_mods_blocks VALUES ( '2', '9', '1', '2');
INSERT INTO spn_mods_blocks VALUES ( '2', '7', '1', '1');

INSERT INTO spn_mods_blocks VALUES ( '3', '10', '0', '1');
INSERT INTO spn_mods_blocks VALUES ( '3', '3', '0', '2');
INSERT INTO spn_mods_blocks VALUES ( '3', '6', '0', '3');
INSERT INTO spn_mods_blocks VALUES ( '3', '4', '0', '4');
INSERT INTO spn_mods_blocks VALUES ( '3', '2', '0', '5');
INSERT INTO spn_mods_blocks VALUES ( '3', '8', '0', '6');
INSERT INTO spn_mods_blocks VALUES ( '3', '1', '1', '5');
INSERT INTO spn_mods_blocks VALUES ( '3', '11', '1', '4');
INSERT INTO spn_mods_blocks VALUES ( '3', '5', '1', '3');
INSERT INTO spn_mods_blocks VALUES ( '3', '9', '1', '2');
INSERT INTO spn_mods_blocks VALUES ( '3', '7', '1', '1');

INSERT INTO spn_mods_blocks VALUES ( '4', '10', '0', '1');
INSERT INTO spn_mods_blocks VALUES ( '4', '3', '0', '2');
INSERT INTO spn_mods_blocks VALUES ( '4', '6', '0', '3');
INSERT INTO spn_mods_blocks VALUES ( '4', '4', '0', '4');
INSERT INTO spn_mods_blocks VALUES ( '4', '2', '0', '5');
INSERT INTO spn_mods_blocks VALUES ( '4', '8', '0', '6');
INSERT INTO spn_mods_blocks VALUES ( '4', '1', '1', '5');
INSERT INTO spn_mods_blocks VALUES ( '4', '11', '1', '4');
INSERT INTO spn_mods_blocks VALUES ( '4', '5', '1', '3');
INSERT INTO spn_mods_blocks VALUES ( '4', '9', '1', '2');
INSERT INTO spn_mods_blocks VALUES ( '4', '7', '1', '1');

INSERT INTO spn_mods_blocks VALUES ( '5', '10', '0', '1');
INSERT INTO spn_mods_blocks VALUES ( '5', '3', '0', '2');
INSERT INTO spn_mods_blocks VALUES ( '5', '6', '0', '3');
INSERT INTO spn_mods_blocks VALUES ( '5', '4', '0', '4');
INSERT INTO spn_mods_blocks VALUES ( '5', '2', '0', '5');
INSERT INTO spn_mods_blocks VALUES ( '5', '8', '0', '6');
INSERT INTO spn_mods_blocks VALUES ( '5', '1', '1', '5');
INSERT INTO spn_mods_blocks VALUES ( '5', '11', '1', '4');
INSERT INTO spn_mods_blocks VALUES ( '5', '5', '1', '3');
INSERT INTO spn_mods_blocks VALUES ( '5', '9', '1', '2');
INSERT INTO spn_mods_blocks VALUES ( '5', '7', '1', '1');

INSERT INTO spn_mods_blocks VALUES ( '6', '10', '0', '1');
INSERT INTO spn_mods_blocks VALUES ( '6', '3', '0', '2');
INSERT INTO spn_mods_blocks VALUES ( '6', '6', '0', '3');
INSERT INTO spn_mods_blocks VALUES ( '6', '4', '0', '4');
INSERT INTO spn_mods_blocks VALUES ( '6', '2', '0', '5');
INSERT INTO spn_mods_blocks VALUES ( '6', '8', '0', '6');
INSERT INTO spn_mods_blocks VALUES ( '6', '1', '1', '5');
INSERT INTO spn_mods_blocks VALUES ( '6', '11', '1', '4');
INSERT INTO spn_mods_blocks VALUES ( '6', '5', '1', '3');
INSERT INTO spn_mods_blocks VALUES ( '6', '9', '1', '2');
INSERT INTO spn_mods_blocks VALUES ( '6', '7', '1', '1');

INSERT INTO spn_mods_blocks VALUES ( '7', '10', '0', '1');
INSERT INTO spn_mods_blocks VALUES ( '7', '3', '0', '2');
INSERT INTO spn_mods_blocks VALUES ( '7', '6', '0', '3');
INSERT INTO spn_mods_blocks VALUES ( '7', '4', '0', '4');
INSERT INTO spn_mods_blocks VALUES ( '7', '2', '0', '5');
INSERT INTO spn_mods_blocks VALUES ( '7', '8', '0', '6');
INSERT INTO spn_mods_blocks VALUES ( '7', '1', '1', '5');
INSERT INTO spn_mods_blocks VALUES ( '7', '11', '1', '4');
INSERT INTO spn_mods_blocks VALUES ( '7', '5', '1', '3');
INSERT INTO spn_mods_blocks VALUES ( '7', '9', '1', '2');
INSERT INTO spn_mods_blocks VALUES ( '7', '7', '1', '1');

INSERT INTO spn_mods_blocks VALUES ( '8', '10', '0', '1');
INSERT INTO spn_mods_blocks VALUES ( '8', '3', '0', '2');
INSERT INTO spn_mods_blocks VALUES ( '8', '6', '0', '3');
INSERT INTO spn_mods_blocks VALUES ( '8', '4', '0', '4');
INSERT INTO spn_mods_blocks VALUES ( '8', '2', '0', '5');
INSERT INTO spn_mods_blocks VALUES ( '8', '8', '0', '6');
INSERT INTO spn_mods_blocks VALUES ( '8', '1', '1', '5');
INSERT INTO spn_mods_blocks VALUES ( '8', '11', '1', '4');
INSERT INTO spn_mods_blocks VALUES ( '8', '5', '1', '3');
INSERT INTO spn_mods_blocks VALUES ( '8', '9', '1', '2');
INSERT INTO spn_mods_blocks VALUES ( '8', '7', '1', '1');

INSERT INTO spn_mods_blocks VALUES ( '9', '10', '0', '1');
INSERT INTO spn_mods_blocks VALUES ( '9', '3', '0', '2');
INSERT INTO spn_mods_blocks VALUES ( '9', '6', '0', '3');
INSERT INTO spn_mods_blocks VALUES ( '9', '4', '0', '4');
INSERT INTO spn_mods_blocks VALUES ( '9', '2', '0', '5');
INSERT INTO spn_mods_blocks VALUES ( '9', '8', '0', '6');
INSERT INTO spn_mods_blocks VALUES ( '9', '1', '1', '5');
INSERT INTO spn_mods_blocks VALUES ( '9', '11', '1', '4');
INSERT INTO spn_mods_blocks VALUES ( '9', '5', '1', '3');
INSERT INTO spn_mods_blocks VALUES ( '9', '9', '1', '2');
INSERT INTO spn_mods_blocks VALUES ( '9', '7', '1', '1');

INSERT INTO spn_mods_blocks VALUES ( '10', '10', '0', '1');
INSERT INTO spn_mods_blocks VALUES ( '10', '3', '0', '2');
INSERT INTO spn_mods_blocks VALUES ( '10', '6', '0', '3');
INSERT INTO spn_mods_blocks VALUES ( '10', '4', '0', '4');
INSERT INTO spn_mods_blocks VALUES ( '10', '2', '0', '5');
INSERT INTO spn_mods_blocks VALUES ( '10', '8', '0', '6');
INSERT INTO spn_mods_blocks VALUES ( '10', '1', '1', '5');
INSERT INTO spn_mods_blocks VALUES ( '10', '11', '1', '4');
INSERT INTO spn_mods_blocks VALUES ( '10', '5', '1', '3');
INSERT INTO spn_mods_blocks VALUES ( '10', '9', '1', '2');
INSERT INTO spn_mods_blocks VALUES ( '10', '7', '1', '1');

INSERT INTO spn_mods_blocks VALUES ( '11', '10', '0', '1');
INSERT INTO spn_mods_blocks VALUES ( '11', '3', '0', '2');
INSERT INTO spn_mods_blocks VALUES ( '11', '6', '0', '3');
INSERT INTO spn_mods_blocks VALUES ( '11', '4', '0', '4');
INSERT INTO spn_mods_blocks VALUES ( '11', '2', '0', '5');
INSERT INTO spn_mods_blocks VALUES ( '11', '8', '0', '6');
INSERT INTO spn_mods_blocks VALUES ( '11', '1', '1', '5');
INSERT INTO spn_mods_blocks VALUES ( '11', '11', '1', '4');
INSERT INTO spn_mods_blocks VALUES ( '11', '5', '1', '3');
INSERT INTO spn_mods_blocks VALUES ( '11', '9', '1', '2');
INSERT INTO spn_mods_blocks VALUES ( '11', '7', '1', '1');



# --------------------------------------------------------
#
# Table structure for table 'spn_news'
#

CREATE TABLE spn_news (
   news_id int(11) unsigned NOT NULL auto_increment,
   news_title varchar(255) NOT NULL,
   news_date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
   news_start_text text,
   news_end_text text,
   news_comments_counter int(11) unsigned DEFAULT '0' NOT NULL,
   news_hit_counter int(11) unsigned DEFAULT '0' NOT NULL,
   news_topic_id int(11) unsigned DEFAULT '1' NOT NULL,
   news_author varchar(255) NOT NULL,
   news_enabled tinyint(1) unsigned DEFAULT '1' NOT NULL,
   news_show_in_home tinyint(1) unsigned DEFAULT '1' NOT NULL,
   news_allow_comments tinyint(1) unsigned DEFAULT '1' NOT NULL,
   news_with_poll tinyint(1) unsigned DEFAULT '0' NOT NULL,
   news_poll_id int(11) unsigned DEFAULT '0' NOT NULL,
   news_auto_br tinyint(1) unsigned DEFAULT '1' NOT NULL,
   news_rate_value int(10) unsigned DEFAULT '0' NOT NULL,
   news_rate_count int(10) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (news_id),
   KEY news_enabled (news_enabled),
   KEY news_topic_id (news_topic_id),
   KEY news_show_in_home (news_show_in_home),
   KEY news_author (news_author)
);

# --------------------------------------------------------
#
# Table structure for table 'spn_news_comments'
#

CREATE TABLE spn_news_comments (
   news_comments_id int(11) unsigned NOT NULL auto_increment,
   news_comments_news_id int(11) unsigned DEFAULT '0' NOT NULL,
   news_comments_date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
   news_comments_admin int(1) unsigned DEFAULT '0' NOT NULL,
   news_comments_author varchar(255) NOT NULL,
   news_comments_author_ip varchar(85) NOT NULL,
   news_comments_text text NOT NULL,
   news_comments_pid int(10) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (news_comments_id),
   KEY news_comments_news_id (news_comments_news_id)
);

# --------------------------------------------------------
#
# Table structure for table 'spn_news_scheduled'
#

CREATE TABLE spn_news_scheduled (
   news_scheduled_id int(11) unsigned NOT NULL auto_increment,
   news_scheduled_title varchar(255) NOT NULL,
   news_scheduled_date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
   news_scheduled_start_text text NOT NULL,
   news_scheduled_end_text text,
   news_scheduled_topic_id int(3) unsigned DEFAULT '1' NOT NULL,
   news_scheduled_author varchar(255) NOT NULL,
   news_scheduled_enabled tinyint(1) unsigned DEFAULT '0' NOT NULL,
   news_scheduled_show_in_home tinyint(1) unsigned DEFAULT '1' NOT NULL,
   news_scheduled_allow_comments tinyint(1) unsigned DEFAULT '1' NOT NULL,
   news_scheduled_auto_br tinyint(1) unsigned DEFAULT '1' NOT NULL,
   PRIMARY KEY (news_scheduled_id)
);

#
# Dumping data for table 'spn_news_scheduled'
#


# --------------------------------------------------------
#
# Table structure for table 'spn_news_topics'
#

CREATE TABLE spn_news_topics (
   news_topics_id int(11) unsigned NOT NULL auto_increment,
   news_topics_title varchar(255) NOT NULL,
   news_topics_image varchar(255),
   news_topics_description varchar(255),
   PRIMARY KEY (news_topics_id)
);


# --------------------------------------------------------
#
# Table structure for table 'spn_pages'
#

CREATE TABLE spn_pages (
   page_id int(11) unsigned NOT NULL auto_increment,
   page_title varchar(255) NOT NULL,
   page_enabled tinyint(11) unsigned DEFAULT '1' NOT NULL,
   page_text text NOT NULL,
   page_auto_br tinyint(1) unsigned DEFAULT '1' NOT NULL,
   page_show_in_block tinyint(1) unsigned DEFAULT '1' NOT NULL,
   PRIMARY KEY (page_id),
   KEY page_enabled (page_enabled),
   KEY page_show_in_block (page_show_in_block)
);


# --------------------------------------------------------
#
# Table structure for table 'spn_pms'
#

CREATE TABLE spn_pms (
   pms_id int(10) unsigned NOT NULL auto_increment,
   pms_from varchar(45) NOT NULL,
   pms_to varchar(45) NOT NULL,
   pms_subject varchar(255) NOT NULL,
   pms_message text NOT NULL,
   pms_readed tinyint(1) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (pms_id)
);

# --------------------------------------------------------
#
# Table structure for table 'spn_polls'
#

CREATE TABLE spn_polls (
   polls_id int(11) unsigned NOT NULL auto_increment,
   polls_title varchar(255) NOT NULL,
   polls_date int(11) unsigned DEFAULT '0' NOT NULL,
   polls_votes int(11) unsigned DEFAULT '0' NOT NULL,
   polls_comments_counter int(11) unsigned DEFAULT '0' NOT NULL,
   polls_news_id int(11) unsigned DEFAULT '0' NOT NULL,
   polls_allow_comments tinyint(1) unsigned DEFAULT '1' NOT NULL,
   polls_type_answers tinyint(1) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (polls_id),
   KEY polls_news_id (polls_news_id)
);

#
# Dumping data for table 'spn_polls'
#


# --------------------------------------------------------
#
# Table structure for table 'spn_polls_check'
#

CREATE TABLE spn_polls_check (
   polls_check_ip varchar(20) NOT NULL,
   polls_check_poll_id int(11) unsigned DEFAULT '0' NOT NULL,
   KEY polls_check_ip (polls_check_ip),
   KEY polls_check_poll_id (polls_check_poll_id)
);

#
# Dumping data for table 'spn_polls_check'
#


# --------------------------------------------------------
#
# Table structure for table 'spn_polls_comments'
#

CREATE TABLE spn_polls_comments (
   polls_comments_id int(11) unsigned NOT NULL auto_increment,
   polls_comments_poll_id int(11) DEFAULT '0' NOT NULL,
   polls_comments_date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
   polls_comments_admin int(2) unsigned DEFAULT '0' NOT NULL,
   polls_comments_author varchar(255) NOT NULL,
   polls_comments_author_ip varchar(85) NOT NULL,
   polls_comments_text text NOT NULL,
   polls_comments_pid int(10) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (polls_comments_id),
   KEY polls_comments_poll_id (polls_comments_poll_id)
);

# --------------------------------------------------------
#
# Table structure for table 'spn_polls_data'
#

CREATE TABLE spn_polls_data (
   polls_data_id int(11) unsigned DEFAULT '0' NOT NULL,
   polls_data_option_text char(50) NOT NULL,
   polls_data_option_votes int(11) unsigned DEFAULT '0' NOT NULL,
   polls_data_option_id int(11) unsigned DEFAULT '0' NOT NULL,
   KEY polls_data_id (polls_data_id),
   KEY polls_data_option_id (polls_data_option_id)
);


# --------------------------------------------------------
#
# Table structure for table 'spn_rate'
#

CREATE TABLE spn_rate (
   rate_uid varchar(255) NOT NULL,
   rate_ip varchar(45) NOT NULL,
   rate_modname varchar(45) NOT NULL,
   rate_story_id int(10) unsigned DEFAULT '0' NOT NULL
);


# --------------------------------------------------------
#
# Table structure for table 'spn_referrer'
#

CREATE TABLE spn_referrer (
   referrer_url varchar(255) NOT NULL,
   referrer_hits int(11) unsigned DEFAULT '1' NOT NULL,
   PRIMARY KEY (referrer_url)
);

#
# Dumping data for table 'spn_referrer'
#


# --------------------------------------------------------
#
# Table structure for table 'spn_session'
#

CREATE TABLE spn_session (
   session_ip varchar(16) NOT NULL,
   session_time int(11) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (session_ip)
);


# --------------------------------------------------------
#
# Table structure for table 'spn_users'
#

CREATE TABLE spn_users (
   user_id int(11) NOT NULL auto_increment,
   username varchar(25) NOT NULL,
   user_email varchar(255) NOT NULL,
   user_website varchar(255) NOT NULL,
   user_avatar varchar(255) NOT NULL,
   user_regdate varchar(20) NOT NULL,
   user_icq varchar(15),
   user_from varchar(100),
   user_interests varchar(150) NOT NULL,
   user_viewemail tinyint(2),
   user_password varchar(40) NOT NULL,
   comments int(11) DEFAULT '0' NOT NULL,
   user_mail_notify tinyint(1) DEFAULT '0',
   user_session_time int(11) DEFAULT '0' NOT NULL,
   user_session_page smallint(5) DEFAULT '0' NOT NULL,
   user_lastvisit int(11) DEFAULT '0' NOT NULL,
   user_newpasswd varchar(32),
   last_ip varchar(15) DEFAULT '0' NOT NULL,
   banned int(1) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (user_id),
   KEY uid (user_id),
   KEY uname (username),
   KEY user_session_time (user_session_time)
);

# --------------------------------------------------------
#
# Table structure for table 'spn_users_temp'
#

CREATE TABLE spn_users_temp (
   user_id int(10) NOT NULL auto_increment,
   username varchar(25) NOT NULL,
   user_email varchar(255) NOT NULL,
   user_password varchar(40) NOT NULL,
   user_regdate varchar(20) NOT NULL,
   check_num varchar(50) NOT NULL,
   time varchar(14) NOT NULL,
   PRIMARY KEY (user_id)
);
