/* Simple AJAX Code-Kit (SACK) v1.6.1 */
/* Copyright 2005 Gregory Wild-Smith */
/* www.twilightuniverse.com */
/* Software licenced under a modified X11 licence,
 see documentation or authors website for more details */

function box_div()
{
	this.divname = '';
	this.divobj  = '';
}

box_div.prototype.move_div = function()
{
	try
	{
		this.divobj = document.getElementById( this.divname );
	}
	catch(e)
	{
		return;
	}
	
	//----------------------------------
	// Figure width and height
	//----------------------------------
	
	var my_width  = 0;
	var my_height = 0;
	
	if ( typeof( window.innerWidth ) == 'number' )
	{
		//----------------------------------
		// Non IE
		//----------------------------------
	  
		my_width  = window.innerWidth;
		my_height = window.innerHeight;
	}
	else if ( document.documentElement && ( document.documentElement.clientWidth || document.documentElement.clientHeight ) )
	{
		//----------------------------------
		// IE 6+
		//----------------------------------
		
		my_width  = document.documentElement.clientWidth;
		my_height = document.documentElement.clientHeight;
	}
	else if ( document.body && ( document.body.clientWidth || document.body.clientHeight ) )
	{
		//----------------------------------
		// Old IE
		//----------------------------------
		
		my_width  = document.body.clientWidth;
		my_height = document.body.clientHeight;
	}
	
	//----------------------------------
	// Show...
	//----------------------------------
	
	this.divobj.style.position = 'absolute';
	this.divobj.style.display  = 'block';
	this.divobj.style.zIndex   = 99;
	
	//----------------------------------
	// Get div height && width
	//----------------------------------
	
	var divheight = parseInt( this.divobj.style.Height );
	var divwidth  = parseInt( this.divobj.style.Width );
	
	divheight = divheight ? divheight : 200;
	divwidth  = divwidth  ? divwidth  : 200;
	
	//----------------------------------
	// Get current scroll offset
	//----------------------------------
	
	var scrolly = this.getYscroll();
	var scrollx = this.getXscroll();
	
	//----------------------------------
	// Finalize...
	//----------------------------------
	
	var setX = ( my_width  - divwidth  )/ 2 + scrollx;
	var setY = ( my_height - divheight )/ 2 + scrolly;
	
	setX = ( setX < 0 ) ? 0 : setX;
	setY = ( setY < 0 ) ? 0 : setY;
	
	this.divobj.style.left = setX + "px";
	this.divobj.style.top  = setY + "px";
}

box_div.prototype.hide_div = function()
{
	try
	{
		if ( ! this.divobj )
		{
			return;
		}
		else
		{
			this.divobj.style.display  = 'none';
		}
	}
	catch(e)
	{
		return;
	}
}

box_div.prototype.getYscroll = function()
{
	var scrollY = 0;
	
	if ( document.documentElement && document.documentElement.scrollTop )
	{
		scrollY = document.documentElement.scrollTop;
	}
	else if ( document.body && document.body.scrollTop )
	{
		scrollY = document.body.scrollTop;
	}
	else if ( window.pageYOffset )
	{
		scrollY = window.pageYOffset;
	}
	else if ( window.scrollY )
	{
		scrollY = window.scrollY;
	}
	
	return scrollY;
}

box_div.prototype.getXscroll = function()
{
	var scrollX = 0;
	
	if ( document.documentElement && document.documentElement.scrollLeft )
	{
		scrollX = document.documentElement.scrollLeft;
	}
	else if ( document.body && document.body.scrollLeft )
	{
		scrollX = document.body.scrollLeft;
	}
	else if ( window.pageXOffset )
	{
		scrollX = window.pageXOffset;
	}
	else if ( window.scrollX )
	{
		scrollX = window.scrollX;
	}
	
	return scrollX;
}

var centerdiv;
function messbox(title,message,buttons)
{
	var btn='';
	for (var i in buttons)
	{
		if (buttons[i]=='close')
		{
			btn=btn+'<input style="border: 1px solid;"  type=button onclick="messbox_close()"  value='+i+'>&nbsp;';
		}
		else
		{
			btn=btn+'<input style="border: 1px solid;" type=button onclick="location.href=\''+buttons[i]+'\'"  value='+i+'>&nbsp;';
		}
	}
	document.getElementById( 'message-layer-text' ).innerHTML = message+'<br><br>'+btn;
	document.getElementById( 'message-layer-title' ).innerHTML = title;
	centerdiv         = new box_div();
	centerdiv.divname = 'message-layer';
	centerdiv.move_div();
}
function messbox_close()
{
	centerdiv.hide_div();
}



